/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class Translator {
    HashMap<String, Integer> mNameOfConstraint2Index = new HashMap();
    ArrayList<NamedAtom> mIndex2AtomOfConstraint = new ArrayList();
    int mPushPopLevel = 0;

    public void declareConstraint(NamedAtom atom) throws SMTLIBException {
        String name = this.getName(atom);
        if (this.mNameOfConstraint2Index.containsKey(name)) {
            throw new SMTLIBException("This name already exists.");
        }
        int numberOfConstraints = this.mIndex2AtomOfConstraint.size();
        this.mNameOfConstraint2Index.put(name, numberOfConstraints);
        this.mIndex2AtomOfConstraint.add(atom);
    }

    public Term translate2Constraint(int index) {
        return this.getTerm(this.mIndex2AtomOfConstraint.get(index));
    }

    public NamedAtom translate2Atom(int index) {
        return this.mIndex2AtomOfConstraint.get(index);
    }

    public Integer translate2Index(Term term) {
        return this.mNameOfConstraint2Index.get(Translator.getName(term));
    }

    public int translate2Index(NamedAtom atom) {
        return this.mNameOfConstraint2Index.get(this.getName(atom));
    }

    public BitSet translateToBitSet(Term[] constraints) {
        BitSet constraintsAsBits = new BitSet(this.getNumberOfConstraints());
        for (int i = 0; i < constraints.length; ++i) {
            Integer translation = this.translate2Index(constraints[i]);
            if (this.translate2Index(constraints[i]) == null) continue;
            constraintsAsBits.set(translation);
        }
        return constraintsAsBits;
    }

    public Term[] translateToTerms(BitSet constraints) {
        Term[] constraintsAsTerms = new Term[constraints.cardinality()];
        int i = 0;
        int j = constraints.nextSetBit(0);
        while (j >= 0) {
            constraintsAsTerms[i] = this.translate2Constraint(j);
            ++i;
            j = constraints.nextSetBit(j + 1);
        }
        return constraintsAsTerms;
    }

    public int getNumberOfConstraints() {
        return this.mIndex2AtomOfConstraint.size();
    }

    public ArrayList<NamedAtom> getIndex2AtomOfConstraint() {
        return this.mIndex2AtomOfConstraint;
    }

    private Term getTerm(NamedAtom atom) {
        return atom.getSMTFormula(null);
    }

    private String getName(NamedAtom atom) {
        return Translator.getName(atom.getSMTFormula(null));
    }

    public static String getName(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName();
        }
        if (term instanceof AnnotatedTerm) {
            return Translator.getName(((AnnotatedTerm)term).getAnnotations());
        }
        throw new SMTLIBException("Unknown type of term.");
    }

    private static String getName(Annotation ... annotation) throws SMTLIBException {
        String name = null;
        for (int i = 0; i < annotation.length; ++i) {
            if (!annotation[i].getKey().equals(":named")) continue;
            name = (String)annotation[i].getValue();
        }
        if (name == null) {
            throw new SMTLIBException("No name for the constraint has been found.");
        }
        return name;
    }
}

