/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Translator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;

public class UnexploredMap {
    DPLLEngine mEngine;
    Translator mTranslator;
    boolean mMapModifiedSinceLastSolve;
    BitSet mImpliedCrits;
    BitSet mMaximalUnexploredSubset;
    BitSet mLastWorkingSet;

    public UnexploredMap(DPLLEngine engine, Translator translator) {
        this.mEngine = engine;
        this.mTranslator = translator;
        this.mMapModifiedSinceLastSolve = true;
    }

    public void messWithActivityOfAtoms(Random rnd) {
        this.mEngine.messWithActivityOfAtoms(rnd);
    }

    public void BlockUp(BitSet unsatSet) {
        this.mMapModifiedSinceLastSolve = true;
        ArrayList<Literal> clause = new ArrayList<Literal>();
        int i = unsatSet.nextSetBit(0);
        while (i >= 0) {
            clause.add(this.mTranslator.translate2Atom(i).negate());
            i = unsatSet.nextSetBit(i + 1);
        }
        this.mEngine.addClause(new Clause(clause.toArray(new Literal[clause.size()]), this.mEngine.getAssertionStackLevel()));
    }

    public void BlockDown(BitSet satSet) {
        this.mMapModifiedSinceLastSolve = true;
        ArrayList<NamedAtom> clause = new ArrayList<NamedAtom>();
        BitSet notInSatSet = (BitSet)satSet.clone();
        notInSatSet.flip(0, this.mTranslator.getNumberOfConstraints());
        int i = notInSatSet.nextSetBit(0);
        while (i >= 0) {
            clause.add(this.mTranslator.translate2Atom(i));
            i = notInSatSet.nextSetBit(i + 1);
        }
        this.mEngine.addClause(new Clause(clause.toArray(new Literal[clause.size()]), this.mEngine.getAssertionStackLevel()));
    }

    public BitSet findMaximalUnexploredSubsetOf(BitSet workingSet) {
        if (this.mMapModifiedSinceLastSolve || !workingSet.equals(this.mLastWorkingSet)) {
            this.findMaximalUnexploredSubsetAndImpliedCrits(workingSet);
        }
        return this.mMaximalUnexploredSubset;
    }

    public BitSet findImpliedCritsOf(BitSet workingSet) {
        if (this.mMapModifiedSinceLastSolve || !workingSet.equals(this.mLastWorkingSet)) {
            this.findMaximalUnexploredSubsetAndImpliedCrits(workingSet);
        }
        return this.mImpliedCrits;
    }

    private boolean findMaximalUnexploredSubsetAndImpliedCrits(BitSet workingSet) {
        this.mMapModifiedSinceLastSolve = false;
        this.mLastWorkingSet = (BitSet)workingSet.clone();
        BitSet notInWorkingSet = (BitSet)workingSet.clone();
        notInWorkingSet.flip(0, this.mTranslator.getNumberOfConstraints());
        this.mEngine.push();
        int i = notInWorkingSet.nextSetBit(0);
        while (i >= 0) {
            Literal[] unitClause = new Literal[]{this.mTranslator.translate2Atom(i).negate()};
            this.mEngine.addClause(new Clause(unitClause, this.mEngine.getAssertionStackLevel()));
            i = notInWorkingSet.nextSetBit(i + 1);
        }
        if (this.mEngine.solve()) {
            if (this.mEngine.isTerminationRequested()) {
                this.mMaximalUnexploredSubset = new BitSet();
                this.mImpliedCrits = new BitSet();
                this.mEngine.pop(1);
                return false;
            }
            this.mMaximalUnexploredSubset = this.collectAtomsWithCriteria(workingSet, this::isSetToTrue);
            this.mImpliedCrits = this.collectAtomsWithCriteria(this.mMaximalUnexploredSubset, this::isDecidedInLevelZero);
            this.mEngine.pop(1);
            return true;
        }
        this.mMaximalUnexploredSubset = new BitSet();
        this.mImpliedCrits = new BitSet();
        this.mEngine.pop(1);
        return false;
    }

    private BitSet collectAtomsWithCriteria(BitSet workingSet, Function<Integer, Boolean> criteria) {
        BitSet model = new BitSet(this.mTranslator.getNumberOfConstraints());
        int i = workingSet.nextSetBit(0);
        while (i >= 0) {
            if (criteria.apply(i).booleanValue()) {
                model.set(i);
            }
            i = workingSet.nextSetBit(i + 1);
        }
        return model;
    }

    private boolean isSetToTrue(int atomNumber) {
        return this.mTranslator.translate2Atom(atomNumber).getDecideStatus().getSign() == 1;
    }

    private boolean isDecidedInLevelZero(int atomNumber) {
        return this.mTranslator.translate2Atom(atomNumber).getDecideLevel() == 0;
    }

    private boolean mMaximalUnexploredSubsetIsMSS() {
        SimpleList<Clause> clauses = this.mEngine.getClauses();
        int maxIndex = this.mTranslator.getNumberOfConstraints();
        int i = this.mMaximalUnexploredSubset.nextClearBit(0);
        while (i >= 0 && i < maxIndex) {
            NamedAtom atomToTest = this.mTranslator.translate2Atom(i);
            if (!this.thereIsAClauseThatImpliesTheGivenAtomNegatedButNoOtherLiteral(clauses, atomToTest)) {
                return false;
            }
            i = this.mMaximalUnexploredSubset.nextClearBit(i + 1);
        }
        return true;
    }

    private boolean thereIsAClauseThatImpliesTheGivenAtomNegatedButNoOtherLiteral(SimpleList<Clause> clauses, NamedAtom atomToTest) {
        for (Clause clause : clauses) {
            if (!clause.contains(atomToTest.negate()) || this.thereIsALiteralWithAnAtomDifferentFromTheGivenThatSatisfiesTheClause(clause, atomToTest)) continue;
            return true;
        }
        return false;
    }

    private boolean thereIsALiteralWithAnAtomDifferentFromTheGivenThatSatisfiesTheClause(Clause clause, NamedAtom givenAtom) {
        for (int i = 0; i < clause.getSize(); ++i) {
            NamedAtom atomOfClause;
            if (!(clause.getLiteral(i).getSign() == 1 ? (atomOfClause = (NamedAtom)clause.getLiteral(i)) != givenAtom && this.mMaximalUnexploredSubset.get(this.mTranslator.translate2Index(atomOfClause)) : (atomOfClause = (NamedAtom)clause.getLiteral(i).getAtom()) != givenAtom && !this.mMaximalUnexploredSubset.get(this.mTranslator.translate2Index(atomOfClause)))) continue;
            return true;
        }
        return false;
    }
}

