/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.math.BigInteger;

public class BigIntegerOption
extends Option {
    private BigInteger mValue;
    private BigInteger mDefaultValue;

    public BigIntegerOption(BigInteger defaultValue, boolean onlineModifiable, String description) {
        super(onlineModifiable, description);
        this.mValue = this.mDefaultValue = defaultValue;
    }

    BigIntegerOption(BigIntegerOption other) {
        super(other.isOnlineModifiable(), other.getDescription());
        this.mValue = other.mValue;
        this.mDefaultValue = other.mDefaultValue;
    }

    @Override
    public Option copy() {
        return new BigIntegerOption(this);
    }

    @Override
    public void set(Object value) {
        if (value instanceof BigInteger) {
            this.mValue = (BigInteger)value;
        } else if (value instanceof String) {
            try {
                this.mValue = new BigInteger((String)value);
            }
            catch (NumberFormatException enfe) {
                throw new SMTLIBException(enfe.getMessage());
            }
        } else {
            throw new SMTLIBException("Not a number: " + value);
        }
    }

    public final BigInteger getValue() {
        return this.mValue;
    }

    @Override
    public Object get() {
        return this.mValue;
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

