/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;

public class BooleanOption
extends Option {
    private boolean mValue;
    private boolean mDefaultValue;

    public BooleanOption(boolean defaultValue, boolean onlineModifiable, String description) {
        super(onlineModifiable, description);
        this.mValue = this.mDefaultValue = defaultValue;
    }

    public BooleanOption(BooleanOption other) {
        super(other.isOnlineModifiable(), other.getDescription());
        this.mValue = other.mValue;
        this.mDefaultValue = other.mDefaultValue;
    }

    @Override
    public Option copy() {
        return new BooleanOption(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object value) {
        if (value instanceof Boolean) {
            this.mValue = (Boolean)value;
            return;
        } else {
            if (!(value instanceof String)) throw new SMTLIBException("Not a Boolean value: " + value);
            String str = (String)value;
            if ("true".equalsIgnoreCase(str)) {
                this.mValue = true;
                return;
            } else {
                if (!"false".equalsIgnoreCase(str)) throw new SMTLIBException("Not a Boolean value: " + value);
                this.mValue = false;
            }
        }
    }

    public final boolean getValue() {
        return this.mValue;
    }

    @Override
    public Object get() {
        return this.mValue;
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

