/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;

public class DoubleOption
extends Option {
    double mValue;
    double mDefaultValue;

    public DoubleOption(double defaultValue, boolean onlineModifiable, String description) {
        super(onlineModifiable, description);
        this.mValue = this.mDefaultValue = defaultValue;
    }

    public DoubleOption(DoubleOption other) {
        super(other.isOnlineModifiable(), other.getDescription());
        this.mValue = other.mValue;
        this.mDefaultValue = other.mDefaultValue;
    }

    @Override
    public Option copy() {
        return new DoubleOption(this);
    }

    @Override
    public void set(Object value) {
        if (value instanceof Number) {
            this.mValue = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            try {
                this.mValue = Double.parseDouble((String)value);
            }
            catch (NumberFormatException nfe) {
                throw new SMTLIBException(nfe.getMessage());
            }
        } else {
            throw new SMTLIBException("Not a number: " + value);
        }
    }

    @Override
    public Object get() {
        return this.mValue;
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

