/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;

public class EnumOption<E extends Enum<E>>
extends Option {
    private E mValue;
    private E mDefaultValue;
    private final Class<E> mClass;

    public EnumOption(E defaultValue, boolean onlineModifiable, Class<E> cls, String description) {
        super(onlineModifiable, description);
        this.mDefaultValue = defaultValue;
        this.mValue = this.mDefaultValue;
        this.mClass = cls;
    }

    EnumOption(EnumOption<E> other) {
        super(other.isOnlineModifiable(), other.getDescription());
        this.mValue = other.mValue;
        this.mDefaultValue = other.mDefaultValue;
        this.mClass = other.mClass;
    }

    @Override
    public Option copy() {
        return new EnumOption<E>(this);
    }

    @Override
    public void set(Object value) {
        if (value instanceof String) {
            this.mValue = Enum.valueOf(this.mClass, ((String)value).toUpperCase());
        } else if (this.mClass.isInstance(value)) {
            this.mValue = (Enum)value;
        } else {
            this.throwException(value);
        }
    }

    private final void throwException(Object value) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("Illegal value: ").append(value);
        sb.append(". Only ");
        String sep = "";
        for (Enum val : (Enum[])this.mClass.getEnumConstants()) {
            sb.append(sep).append(val.name());
            sep = ", ";
        }
        sb.append(" allowed!");
        throw new SMTLIBException(sb.toString());
    }

    public final E getValue() {
        return this.mValue;
    }

    @Override
    public Object get() {
        return ((Enum)this.mValue).name();
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return ((Enum)this.mDefaultValue).name();
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

