/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.math.BigInteger;

public class LongOption
extends Option {
    private long mValue;
    private long mDefaultValue;

    public LongOption(long defaultValue, boolean onlineModifiable, String description) {
        super(onlineModifiable, description);
        this.mValue = this.mDefaultValue = defaultValue;
    }

    LongOption(LongOption other) {
        super(other.isOnlineModifiable(), other.getDescription());
        this.mValue = other.mValue;
        this.mDefaultValue = other.mDefaultValue;
    }

    @Override
    public Option copy() {
        return new LongOption(this);
    }

    @Override
    public void set(Object value) {
        if (value instanceof Number) {
            this.mValue = ((Number)value).longValue();
        } else if (value instanceof String) {
            try {
                this.mValue = Long.parseLong((String)value);
            }
            catch (NumberFormatException enfe) {
                throw new SMTLIBException(enfe.getMessage());
            }
        } else {
            throw new SMTLIBException("Not a number: " + value);
        }
    }

    public final long getValue() {
        return this.mValue;
    }

    @Override
    public Object get() {
        return BigInteger.valueOf(this.mValue);
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return BigInteger.valueOf(this.mDefaultValue);
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

