/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.ChannelOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.FrontEndOptions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.LoggerOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.SolverOptions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.VerbosityOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class OptionMap {
    private static final String DIAG_OUTPUT_CHANNEL_DESC = "Where to print diagnostic output to.  Use \"stdout\" for standard output and \"stderr\" for standard error.";
    private final LinkedHashMap<String, Option> mOptions;
    private final LinkedHashMap<String, String> mAliases;
    private final SolverOptions mSolverOptions;
    private final FrontEndOptions mFrontEndOptions;
    private final LogProxy mLogger;
    private boolean mOnline;

    public OptionMap(LogProxy logger) {
        this(logger, false);
    }

    public OptionMap(LogProxy logger, boolean activeFrontEnd) {
        this.mOptions = new LinkedHashMap();
        this.mAliases = new LinkedHashMap();
        this.mSolverOptions = new SolverOptions(this, logger);
        this.mLogger = logger;
        this.addOption(":diagnostic-output-channel", new LoggerOption(DIAG_OUTPUT_CHANNEL_DESC, logger));
        this.mOnline = false;
        this.mFrontEndOptions = new FrontEndOptions(this, activeFrontEnd);
    }

    private OptionMap(LogProxy logger, LinkedHashMap<String, Option> options, LinkedHashMap<String, String> aliases) {
        this.mOptions = options;
        this.mAliases = aliases;
        this.mSolverOptions = new SolverOptions(this);
        this.mFrontEndOptions = new FrontEndOptions(this);
        this.mLogger = logger;
        this.mOnline = false;
    }

    public void started() {
        for (Option o : this.mOptions.values()) {
            o.started();
        }
    }

    public void setOnline() {
        this.mOnline = true;
    }

    public final LogProxy getLogProxy() {
        return this.mLogger;
    }

    public final SolverOptions getSolverOptions() {
        return this.mSolverOptions;
    }

    public final FrontEndOptions getFrontEndOptions() {
        return this.mFrontEndOptions;
    }

    public void addOption(String name, Option option) {
        this.mOptions.put(name, option);
    }

    public void addAlias(String name, String alias) {
        this.mAliases.put(name, alias);
    }

    public Object get(String option) {
        Option o;
        if (this.mAliases.containsKey(option)) {
            option = this.mAliases.get(option);
        }
        if ((o = this.mOptions.get(option)) == null) {
            throw new UnsupportedOperationException();
        }
        return o.get();
    }

    public void set(String option, Object value) {
        Option o;
        if (this.mAliases.containsKey(option)) {
            option = this.mAliases.get(option);
        }
        if ((o = this.mOptions.get(option)) == null) {
            throw new UnsupportedOperationException();
        }
        if (this.mOnline && !o.isOnlineModifiable()) {
            throw new SMTLIBException("Option " + option + " can only be changed before setting the logic");
        }
        o.set(value);
    }

    public String[] getInfo() {
        String[] res = new String[this.mOptions.size() + this.mAliases.size()];
        int pos = 0;
        for (String opt : this.mOptions.keySet()) {
            res[pos++] = opt;
        }
        for (String opt : this.mAliases.keySet()) {
            res[pos++] = opt;
        }
        return res;
    }

    public Object[] getInfo(String option, boolean isSMTLIB25) {
        Option o;
        if (this.mAliases.containsKey(option)) {
            option = this.mAliases.get(option);
        }
        if ((o = this.mOptions.get(option)) == null) {
            throw new UnsupportedOperationException();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(":description");
        result.add(new QuotedObject(o.getDescription(), isSMTLIB25));
        result.add(":default");
        result.add(o.defaultValue());
        if (o.isOnlineModifiable()) {
            result.add(":online-modifiable");
        }
        return result.toArray();
    }

    public void reset() {
        this.mOnline = false;
        for (Option o : this.mOptions.values()) {
            o.reset();
        }
    }

    public OptionMap copy(CopyMode mode) {
        LinkedHashMap<String, Option> options = new LinkedHashMap<String, Option>();
        for (Map.Entry<String, Option> me : this.mOptions.entrySet()) {
            Option cpy = me.getValue().copy();
            switch (mode) {
                case CURRENT_VALUE: {
                    break;
                }
                case RESET_EXCEPT_CHANNELS: {
                    if (cpy instanceof VerbosityOption || cpy instanceof ChannelOption) break;
                }
                default: {
                    cpy.reset();
                }
            }
            options.put(me.getKey(), cpy);
        }
        return new OptionMap(this.mLogger, options, new LinkedHashMap<String, String>(this.mAliases));
    }

    public Option getOption(String key) {
        return this.mOptions.get(key);
    }

    public static enum CopyMode {
        CURRENT_VALUE,
        RESET_TO_DEFAULT,
        RESET_EXCEPT_CHANNELS;

    }
}

