/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.BooleanOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.EnumOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.LongOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.VerbosityOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.Transformations;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;

public class SolverOptions {
    private final LongOption mTimeout;
    private final BooleanOption mProduceProofs;
    private final LongOption mRandomSeed;
    private final BooleanOption mInterpolantCheckMode;
    private final BooleanOption mProduceInterpolants;
    private final BooleanOption mModelCheckMode;
    private final EnumOption<Transformations.AvailableTransformations> mProofTrans;
    private final BooleanOption mModelsPartial;
    private final EnumOption<SMTInterpol.CheckType> mCheckType;
    private final BooleanOption mSimpIps;
    private final BooleanOption mProofCheckMode;
    private final EnumOption<SMTInterpol.CheckType> mSimpCheckType;
    private final EnumOption<SMTInterpol.ProofMode> mProofLevel;
    private final EnumOption<QuantifierTheory.InstantiationMethod> mInstantiationMethod;
    private final OptionMap mOptions;

    SolverOptions(OptionMap options, LogProxy logger) {
        this.mTimeout = new LongOption(0L, true, "Soft timeout in milliseconds for individual check-sat calls.  Values <= 0 deactivate the timeout.");
        this.mProduceProofs = new BooleanOption(false, false, "Produce proofs for unsatisfiable formulas.");
        this.mRandomSeed = new LongOption(11350294L, true, "Seed for the internal pseudo-random number generator.");
        this.mInterpolantCheckMode = new BooleanOption(false, false, "Check generated interpolants.");
        this.mProduceInterpolants = new BooleanOption(false, false, "Enable interpolant production.");
        this.mModelCheckMode = new BooleanOption(false, true, "Check satisfiable formulas against the produced model.");
        this.mProofTrans = new EnumOption<Transformations.AvailableTransformations>(Transformations.AvailableTransformations.NONE, true, Transformations.AvailableTransformations.class, "Algorithm used to transform the resolution proof tree.");
        this.mModelsPartial = new BooleanOption(false, true, "Don't totalize models.");
        this.mCheckType = new EnumOption<SMTInterpol.CheckType>(SMTInterpol.CheckType.FULL, true, SMTInterpol.CheckType.class, "Strength of check used in check-sat command.");
        this.mSimpIps = new BooleanOption(false, true, "Apply strong context simplification to generated interpolants.");
        this.mProofCheckMode = new BooleanOption(false, false, "Check the produced proof for unsatisfiable formulas.");
        this.mSimpCheckType = new EnumOption<SMTInterpol.CheckType>(SMTInterpol.CheckType.QUICK, true, SMTInterpol.CheckType.class, "Strength of checks used by the strong context simplifier used in the simplify command");
        this.mInstantiationMethod = new EnumOption<QuantifierTheory.InstantiationMethod>(QuantifierTheory.InstantiationMethod.E_MATCHING_CONFLICT, false, QuantifierTheory.InstantiationMethod.class, "Quantifier Theory: Method to instantiate quantified formulas.");
        this.mProofLevel = new EnumOption<SMTInterpol.ProofMode>(SMTInterpol.ProofMode.NONE, false, SMTInterpol.ProofMode.class, "Proof level.");
        options.addOption(":verbosity", new VerbosityOption(logger));
        options.addOption(":timeout", this.mTimeout);
        options.addOption(":random-seed", this.mRandomSeed);
        options.addOption(":produce-assertions", new BooleanOption(false, false, "Store asserted formulas for later retrieval."));
        options.addAlias(":interactive-mode", ":produce-assertions");
        options.addOption(":produce-models", new BooleanOption(false, true, "Produce models for satisfiable formulas"));
        options.addOption(":models-partial", this.mModelsPartial);
        options.addOption(":model-check-mode", this.mModelCheckMode);
        options.addOption(":produce-assignments", new BooleanOption(false, false, "Produce assignments of named Boolean terms for satisfiable formulas"));
        options.addOption(":produce-proofs", this.mProduceProofs);
        options.addOption(":proof-transformation", this.mProofTrans);
        options.addOption(":proof-check-mode", this.mProofCheckMode);
        options.addOption(":proof-level", this.mProofLevel);
        options.addOption(":produce-interpolants", this.mProduceInterpolants);
        options.addOption(":interpolant-check-mode", this.mInterpolantCheckMode);
        options.addOption(":simplify-interpolants", this.mSimpIps);
        options.addOption(":produce-unsat-cores", new BooleanOption(false, false, "Enable production of unsatisfiable cores."));
        options.addOption(":unsat-core-check-mode", new BooleanOption(false, false, "Check generated unsat cores"));
        options.addOption(":produce-unsat-assumptions", new BooleanOption(false, false, "Enable production of unsatisfiable assumptions."));
        options.addOption(":unsat-assumptions-check-mode", new BooleanOption(false, false, "Check generated unsat assumptions"));
        options.addOption(":check-type", this.mCheckType);
        options.addOption(":epr", new BooleanOption(false, false, "Assume formula is in EPR fragment. This give an error if the formula is outside EPR."));
        options.addOption(":instantiation-method", this.mInstantiationMethod);
        options.addOption(":unknown-term-dawgs", new BooleanOption(true, false, "Quantifier Theory: Use fourth instance value UNKNOWN_TERM as default in literal dawgs."));
        options.addOption(":propagate-unknown-terms", new BooleanOption(false, false, "Quantifier Theory: Allow propagation on atoms with non-existing term."));
        options.addOption(":propagate-unknown-aux", new BooleanOption(false, false, "Quantifier Theory: Allow propagation on atoms with non-existing @AUX applications."));
        options.addOption(":simplify-check-type", this.mSimpCheckType);
        options.addOption(":simplify-repeatedly", new BooleanOption(true, true, "Simplify until the fixpoint is reached."));
        options.addOption(":global-declarations", new BooleanOption(false, false, "Make all declared and defined symbols global.  Global symbols survive pop operations."));
        this.mOptions = options;
    }

    SolverOptions(OptionMap options) {
        this.mTimeout = (LongOption)options.getOption(":timeout");
        this.mProduceProofs = (BooleanOption)options.getOption(":produce-proofs");
        this.mRandomSeed = (LongOption)options.getOption(":random-seed");
        this.mInterpolantCheckMode = (BooleanOption)options.getOption(":interpolant-check-mode");
        this.mProduceInterpolants = (BooleanOption)options.getOption(":produce-interpolants");
        this.mModelCheckMode = (BooleanOption)options.getOption(":model-check-mode");
        this.mProofTrans = (EnumOption)options.getOption(":proof-transformation");
        this.mModelsPartial = (BooleanOption)options.getOption(":models-partial");
        this.mCheckType = (EnumOption)options.getOption(":check-type");
        this.mSimpIps = (BooleanOption)options.getOption(":simplify-interpolants");
        this.mProofCheckMode = (BooleanOption)options.getOption(":proof-check-mode");
        this.mSimpCheckType = (EnumOption)options.getOption(":simplify-check-type");
        this.mProofLevel = (EnumOption)options.getOption(":proof-level");
        this.mInstantiationMethod = (EnumOption)options.getOption(":instantiation-method");
        this.mOptions = options;
    }

    public final SMTInterpol.CheckType getCheckType() {
        return this.mCheckType.getValue();
    }

    public final void setCheckType(SMTInterpol.CheckType newCheckType) {
        this.mCheckType.set((Object)newCheckType);
    }

    public final boolean isInterpolantCheckModeActive() {
        return this.mInterpolantCheckMode.getValue();
    }

    public final boolean isModelCheckModeActive() {
        return this.mModelCheckMode.getValue();
    }

    public final boolean isModelsPartial() {
        return this.mModelsPartial.getValue();
    }

    public final boolean isProduceInterpolants() {
        return this.mProduceInterpolants.getValue();
    }

    public final boolean isProduceProofs() {
        return this.mProduceProofs.getValue();
    }

    public final boolean isProofCheckModeActive() {
        return this.mProofCheckMode.getValue();
    }

    public final SMTInterpol.ProofMode getProofMode() {
        SMTInterpol.ProofMode level = this.mProofLevel.getValue();
        if (level == SMTInterpol.ProofMode.NONE) {
            if (this.isProduceProofs() || this.isProofCheckModeActive()) {
                level = SMTInterpol.ProofMode.LOWLEVEL;
            } else if (this.isProduceInterpolants() || ((Boolean)this.mOptions.get(":produce-unsat-cores")).booleanValue()) {
                level = SMTInterpol.ProofMode.CLAUSES;
            }
        }
        return level;
    }

    public final Transformations.AvailableTransformations getProofTransformation() {
        return this.mProofTrans.getValue();
    }

    public final long getRandomSeed() {
        return this.mRandomSeed.getValue();
    }

    public final boolean isSimplifyInterpolants() {
        return this.mSimpIps.getValue();
    }

    public final long getTimeout() {
        return this.mTimeout.getValue();
    }

    public SMTInterpol.CheckType getSimplifierCheckType() {
        return this.mSimpCheckType.getValue();
    }

    public QuantifierTheory.InstantiationMethod getInstantiationMethod() {
        return this.mInstantiationMethod.getValue();
    }
}

