/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.math.BigInteger;

public class VerbosityOption
extends Option {
    private int mDefaultLvl;
    private final LogProxy mLogger;

    public VerbosityOption(LogProxy logger) {
        super(true, "How much output to produce on the diagnostic output channel.  The bigger the number the more output will be produces.  0 turns off diagnostic output.");
        this.mLogger = logger;
        this.mDefaultLvl = this.mLogger.getLoglevel();
    }

    @Override
    public Option copy() {
        return this;
    }

    @Override
    public void set(Object value) {
        int lvl;
        if (value instanceof Number) {
            lvl = ((Number)value).intValue();
        } else if (value instanceof String) {
            try {
                lvl = Integer.parseInt((String)value);
            }
            catch (NumberFormatException enfe) {
                throw new SMTLIBException("Not a valid number: " + value);
            }
        } else {
            throw new SMTLIBException("Not a valid number: " + value);
        }
        if (lvl < 0) {
            lvl = 0;
        } else if (lvl > 6) {
            lvl = 6;
        }
        this.mLogger.setLoglevel(lvl);
    }

    @Override
    public Object get() {
        return BigInteger.valueOf(this.mLogger.getLoglevel());
    }

    @Override
    public void reset() {
        this.mLogger.setLoglevel(this.mDefaultLvl);
    }

    @Override
    public Object defaultValue() {
        return BigInteger.valueOf(this.mDefaultLvl);
    }

    @Override
    public void started() {
        this.mDefaultLvl = this.mLogger.getLoglevel();
    }
}

