/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Theory;

public class CongRewriteFunctionFactory
extends FunctionSymbolFactory {
    public CongRewriteFunctionFactory() {
        super(".cong");
    }

    public static FunctionSymbol getFunctionFromIndex(String[] indices, Sort[] paramSorts, Sort resultSort) {
        Sort origResultSort;
        String[] origIndices;
        if (paramSorts.length == 0 || indices == null) {
            return null;
        }
        Theory theory = paramSorts[0].getTheory();
        SortSymbol eqProofSort = paramSorts[0].getSortSymbol();
        if (!eqProofSort.isIntern() || !eqProofSort.getName().equals(".EqProof")) {
            return null;
        }
        if (indices.length > 1) {
            origIndices = new String[indices.length - 1];
            System.arraycopy(indices, 0, origIndices, 1, indices.length - 1);
        } else {
            origIndices = null;
        }
        Sort[] origParamSorts = new Sort[paramSorts.length];
        for (int i = 0; i < paramSorts.length; ++i) {
            if (paramSorts[i].getSortSymbol() != eqProofSort) {
                return null;
            }
            origParamSorts[i] = paramSorts[i].getArguments()[0];
        }
        if (resultSort == null) {
            origResultSort = null;
        } else {
            if (resultSort.getSortSymbol() != eqProofSort) {
                return null;
            }
            origResultSort = resultSort.getArguments()[0];
        }
        return theory.getFunctionWithResult(indices[0], origIndices, origResultSort, origParamSorts);
    }

    @Override
    public int getFlags(String[] indices, Sort[] paramSorts, Sort resultSort) {
        FunctionSymbol func = CongRewriteFunctionFactory.getFunctionFromIndex(indices, paramSorts, resultSort);
        if (func != null) {
            return (func.isLeftAssoc() ? 2 : 0) | (func.isRightAssoc() ? 4 : 0) | (func.isReturnOverload() ? 16 : 0) | 1;
        }
        return 1;
    }

    @Override
    public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
        FunctionSymbol origFunc = CongRewriteFunctionFactory.getFunctionFromIndex(indices, paramSorts, resultSort);
        if (origFunc == null) {
            return null;
        }
        SortSymbol eqProofSort = paramSorts[0].getSortSymbol();
        return eqProofSort.getSort(null, origFunc.getReturnSort());
    }
}

