/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;

public class MinimalProofChecker
extends NonRecursive {
    HashSet<Term> mAssertions;
    Script mSkript;
    LogProxy mLogger;
    ProofRules mProofRules;
    HashMap<Term, ProofLiteral[]> mCacheConv;
    HashMap<FunctionSymbol, LambdaTerm> mFunctionDefinitions;
    Stack<ProofLiteral[]> mStackResults = new Stack();
    int mNumOracles;
    int mNumAxioms;
    int mNumResolutions;
    int mNumAssertions;
    int mNumDefineFun;

    public MinimalProofChecker(Script script, LogProxy logger) {
        this.mSkript = script;
        this.mLogger = logger;
        this.mProofRules = new ProofRules(script.getTheory());
        FormulaUnLet unletter = new FormulaUnLet();
        Term[] assertions = this.mSkript.getAssertions();
        this.mAssertions = new HashSet(assertions.length);
        for (Term ass : assertions) {
            this.mAssertions.add(unletter.transform(ass));
        }
    }

    public boolean check(Term proof) {
        this.mNumDefineFun = 0;
        this.mNumAssertions = 0;
        this.mNumAxioms = 0;
        this.mNumResolutions = 0;
        this.mNumOracles = 0;
        FormulaUnLet unletter = new FormulaUnLet();
        ProofLiteral[] result = this.getProvedClause(unletter.unlet(proof));
        if (result != null && result.length > 0) {
            this.reportError("The proof did not yield a contradiction but %s", Arrays.asList(result));
            return false;
        }
        return true;
    }

    public int getNumberOfHoles() {
        return this.mNumOracles;
    }

    public int getNumberOfResolutions() {
        return this.mNumResolutions;
    }

    public int getNumberOfAxioms() {
        return this.mNumAxioms;
    }

    public int getNumberOfAssertions() {
        return this.mNumAssertions;
    }

    public int getNumberOfDefineFun() {
        return this.mNumDefineFun;
    }

    public ProofLiteral[] getProvedClause(Term proof) {
        return this.getProvedClause(null, proof);
    }

    public ProofLiteral[] getProvedClause(Map<FunctionSymbol, LambdaTerm> funcDefs, Term proof) {
        this.mCacheConv = new HashMap();
        this.mFunctionDefinitions = new HashMap();
        if (funcDefs != null) {
            for (Map.Entry<FunctionSymbol, LambdaTerm> funcDef : funcDefs.entrySet()) {
                FunctionSymbol func = funcDef.getKey();
                LambdaTerm def = funcDef.getValue();
                if (!(func.isIntern() || func.getDefinition() == null || func.getDefinition() == def.getSubterm() && Arrays.equals(func.getDefinitionVars(), def.getVariables()))) {
                    throw new AssertionError((Object)"Inconsistent function definition.");
                }
                this.mFunctionDefinitions.put(func, def);
            }
        }
        this.run(new ProofWalker(proof));
        assert (this.mStackResults.size() == 1);
        this.mCacheConv = null;
        return this.stackPop();
    }

    private void reportError(String msg, Object ... params) {
        this.mLogger.error(msg, params);
    }

    private void reportWarning(String msg, Object ... params) {
        this.mLogger.warn(msg, params);
    }

    void walk(Term proofTerm) {
        while (proofTerm instanceof AnnotatedTerm && !ProofRules.isAxiom(proofTerm) && !ProofRules.isDefineFun(proofTerm)) {
            proofTerm = ((AnnotatedTerm)proofTerm).getSubterm();
        }
        if (this.mCacheConv.containsKey(proofTerm)) {
            this.stackPush(this.mCacheConv.get(proofTerm), proofTerm);
            return;
        }
        if (ProofRules.isDefineFun(proofTerm)) {
            new DefineFunWalker((AnnotatedTerm)proofTerm).enqueue(this);
        } else if (ProofRules.isAxiom(proofTerm)) {
            this.stackPush(this.computeAxiom(proofTerm), proofTerm);
        } else if (ProofRules.isProofRule("res", proofTerm)) {
            new ResolutionWalker((ApplicationTerm)proofTerm).enqueue(this);
        } else {
            this.stackPush(this.checkAssert(proofTerm), proofTerm);
        }
    }

    ProofLiteral[] walkResolution(ApplicationTerm resApp, ProofLiteral[] posClause, ProofLiteral[] negClause) {
        ++this.mNumResolutions;
        HashSet<ProofLiteral> allDisjuncts = new HashSet<ProofLiteral>();
        Term pivot = resApp.getParameters()[0];
        ProofLiteral posPivot = new ProofLiteral(pivot, true);
        ProofLiteral negPivot = new ProofLiteral(pivot, false);
        boolean pivotFound = false;
        for (ProofLiteral lit : posClause) {
            if (lit.equals(posPivot)) {
                pivotFound = true;
                continue;
            }
            allDisjuncts.add(lit);
        }
        if (!pivotFound) {
            this.reportWarning("Could not find pivot %s in %s", posPivot, Arrays.asList(posClause));
        }
        pivotFound = false;
        for (ProofLiteral lit : negClause) {
            if (lit.equals(negPivot)) {
                pivotFound = true;
                continue;
            }
            allDisjuncts.add(lit);
        }
        if (!pivotFound) {
            this.reportWarning("Could not find pivot %s in %s", negPivot, Arrays.asList(negClause));
        }
        return allDisjuncts.toArray(new ProofLiteral[allDisjuncts.size()]);
    }

    void stackPush(ProofLiteral[] pushClause, Term keyTerm) {
        this.mCacheConv.put(keyTerm, pushClause);
        this.mStackResults.push(pushClause);
    }

    ProofLiteral[] stackPop() {
        return this.mStackResults.pop();
    }

    public ProofLiteral[] computeAxiom(Term axiom) {
        ++this.mNumAxioms;
        Theory theory = axiom.getTheory();
        assert (ProofRules.isAxiom(axiom));
        Annotation[] annots = ((AnnotatedTerm)axiom).getAnnotations();
        switch (annots[0].getKey()) {
            case ":oracle": {
                ++this.mNumOracles;
                --this.mNumAxioms;
                this.reportWarning("Used oracle: %s", axiom);
                ProofLiteral[] lits = ProofRules.proofLiteralsFromAnnotation((Object[])annots[0].getValue());
                LinkedHashSet<ProofLiteral> clause = new LinkedHashSet<ProofLiteral>(Arrays.asList(lits));
                return clause.toArray(new ProofLiteral[clause.size()]);
            }
            case ":true+": {
                return new ProofLiteral[]{new ProofLiteral(theory.term("true", new Term[0]), true)};
            }
            case ":false-": {
                return new ProofLiteral[]{new ProofLiteral(theory.term("false", new Term[0]), false)};
            }
            case ":not+": {
                assert (annots.length == 1);
                ApplicationTerm notTerm = (ApplicationTerm)annots[0].getValue();
                if (!notTerm.getFunction().isIntern() || !notTerm.getFunction().getName().equals("not")) {
                    this.reportError("Expected not application", new Object[0]);
                    return this.getTrueClause(notTerm.getTheory());
                }
                return new ProofLiteral[]{new ProofLiteral(notTerm, true), new ProofLiteral(notTerm.getParameters()[0], true)};
            }
            case ":not-": {
                assert (annots.length == 1);
                ApplicationTerm notTerm = (ApplicationTerm)annots[0].getValue();
                if (!notTerm.getFunction().isIntern() || !notTerm.getFunction().getName().equals("not")) {
                    this.reportError("Expected not application", new Object[0]);
                    return this.getTrueClause(notTerm.getTheory());
                }
                return new ProofLiteral[]{new ProofLiteral(notTerm, false), new ProofLiteral(notTerm.getParameters()[0], false)};
            }
            case ":or+": {
                assert (annots.length == 2);
                ApplicationTerm orTerm = (ApplicationTerm)annots[0].getValue();
                if (!orTerm.getFunction().isIntern() || !orTerm.getFunction().getName().equals("or")) {
                    this.reportError("Expected or application", new Object[0]);
                    return this.getTrueClause(orTerm.getTheory());
                }
                Term[] params = orTerm.getParameters();
                assert (annots[1].getKey().equals(":pos"));
                int pos = (Integer)annots[1].getValue();
                assert (pos >= 0 && pos < params.length);
                return new ProofLiteral[]{new ProofLiteral(orTerm, true), new ProofLiteral(params[pos], false)};
            }
            case ":or-": {
                assert (annots.length == 1);
                ApplicationTerm orTerm = (ApplicationTerm)annots[0].getValue();
                if (!orTerm.getFunction().isIntern() || !orTerm.getFunction().getName().equals("or")) {
                    this.reportError("Expected or application", new Object[0]);
                    return this.getTrueClause(orTerm.getTheory());
                }
                Term[] params = orTerm.getParameters();
                HashSet<ProofLiteral> clause = new HashSet<ProofLiteral>();
                clause.add(new ProofLiteral(orTerm, false));
                for (Term param : params) {
                    clause.add(new ProofLiteral(param, true));
                }
                return clause.toArray(new ProofLiteral[clause.size()]);
            }
            case ":and+": {
                assert (annots.length == 1);
                ApplicationTerm andTerm = (ApplicationTerm)annots[0].getValue();
                if (!andTerm.getFunction().isIntern() || !andTerm.getFunction().getName().equals("and")) {
                    this.reportError("Expected and application", new Object[0]);
                    return this.getTrueClause(andTerm.getTheory());
                }
                Term[] params = andTerm.getParameters();
                HashSet<ProofLiteral> clause = new HashSet<ProofLiteral>();
                clause.add(new ProofLiteral(andTerm, true));
                for (Term param : params) {
                    clause.add(new ProofLiteral(param, false));
                }
                return clause.toArray(new ProofLiteral[clause.size()]);
            }
            case ":and-": {
                assert (annots.length == 2);
                ApplicationTerm andTerm = (ApplicationTerm)annots[0].getValue();
                if (!andTerm.getFunction().isIntern() || !andTerm.getFunction().getName().equals("and")) {
                    this.reportError("Expected and application", new Object[0]);
                    return this.getTrueClause(andTerm.getTheory());
                }
                Term[] params = andTerm.getParameters();
                assert (annots[1].getKey().equals(":pos"));
                int pos = (Integer)annots[1].getValue();
                assert (pos >= 0 && pos < params.length);
                return new ProofLiteral[]{new ProofLiteral(andTerm, false), new ProofLiteral(params[pos], true)};
            }
            case ":=>+": {
                assert (annots.length == 2);
                ApplicationTerm impTerm = (ApplicationTerm)annots[0].getValue();
                if (!impTerm.getFunction().isIntern() || !impTerm.getFunction().getName().equals("=>")) {
                    this.reportError("Expected => application", new Object[0]);
                    return this.getTrueClause(impTerm.getTheory());
                }
                Term[] params = impTerm.getParameters();
                assert (annots[1].getKey().equals(":pos"));
                int pos = (Integer)annots[1].getValue();
                assert (pos >= 0 && pos < params.length);
                return new ProofLiteral[]{new ProofLiteral(impTerm, true), new ProofLiteral(params[pos], pos < params.length - 1)};
            }
            case ":=>-": {
                assert (annots.length == 1);
                ApplicationTerm impTerm = (ApplicationTerm)annots[0].getValue();
                if (!impTerm.getFunction().isIntern() || !impTerm.getFunction().getName().equals("=>")) {
                    this.reportError("Expected => application", new Object[0]);
                    return this.getTrueClause(impTerm.getTheory());
                }
                Term[] params = impTerm.getParameters();
                HashSet<ProofLiteral> clause = new HashSet<ProofLiteral>();
                clause.add(new ProofLiteral(impTerm, false));
                for (int i = 0; i < params.length; ++i) {
                    clause.add(new ProofLiteral(params[i], i == params.length - 1));
                }
                return clause.toArray(new ProofLiteral[clause.size()]);
            }
            case ":=+1": {
                assert (annots.length == 1);
                ApplicationTerm iffTerm = (ApplicationTerm)annots[0].getValue();
                if (!iffTerm.getFunction().isIntern() || !iffTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(iffTerm.getTheory());
                }
                Term[] params = iffTerm.getParameters();
                if (params.length != 2 || params[0].getSort().getName() != "Bool") {
                    return this.reportViolatedSideCondition(axiom);
                }
                return new ProofLiteral[]{new ProofLiteral(iffTerm, true), new ProofLiteral(params[0], true), new ProofLiteral(params[1], true)};
            }
            case ":=+2": {
                assert (annots.length == 1);
                ApplicationTerm iffTerm = (ApplicationTerm)annots[0].getValue();
                if (!iffTerm.getFunction().isIntern() || !iffTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(iffTerm.getTheory());
                }
                Term[] params = iffTerm.getParameters();
                if (params.length != 2 || params[0].getSort().getName() != "Bool") {
                    return this.reportViolatedSideCondition(axiom);
                }
                return new ProofLiteral[]{new ProofLiteral(iffTerm, true), new ProofLiteral(params[0], false), new ProofLiteral(params[1], false)};
            }
            case ":=-1": {
                assert (annots.length == 1);
                ApplicationTerm iffTerm = (ApplicationTerm)annots[0].getValue();
                if (!iffTerm.getFunction().isIntern() || !iffTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(iffTerm.getTheory());
                }
                Term[] params = iffTerm.getParameters();
                if (params.length != 2 || params[0].getSort().getName() != "Bool") {
                    return this.reportViolatedSideCondition(axiom);
                }
                return new ProofLiteral[]{new ProofLiteral(iffTerm, false), new ProofLiteral(params[0], true), new ProofLiteral(params[1], false)};
            }
            case ":=-2": {
                assert (annots.length == 1);
                ApplicationTerm iffTerm = (ApplicationTerm)annots[0].getValue();
                if (!iffTerm.getFunction().isIntern() || !iffTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(iffTerm.getTheory());
                }
                Term[] params = iffTerm.getParameters();
                if (params.length != 2 || params[0].getSort().getName() != "Bool") {
                    return this.reportViolatedSideCondition(axiom);
                }
                return new ProofLiteral[]{new ProofLiteral(iffTerm, false), new ProofLiteral(params[0], false), new ProofLiteral(params[1], true)};
            }
            case ":xor+": {
                assert (annots.length == 1);
                Term[][] xorLists = (Term[][])annots[0].getValue();
                assert (xorLists.length == 3);
                if (!ProofRules.checkXorParams(xorLists)) {
                    return this.reportViolatedSideCondition(axiom);
                }
                ProofLiteral[] clause = new ProofLiteral[3];
                for (int i = 0; i < 3; ++i) {
                    Term term;
                    Term term2 = term = xorLists[i].length == 1 ? xorLists[i][0] : theory.term("xor", xorLists[i]);
                    assert (term != null);
                    clause[i] = new ProofLiteral(term, i < 2);
                }
                return clause;
            }
            case ":xor-": {
                assert (annots.length == 1);
                Term[][] xorLists = (Term[][])annots[0].getValue();
                assert (xorLists.length == 3);
                if (!ProofRules.checkXorParams(xorLists)) {
                    return this.reportViolatedSideCondition(axiom);
                }
                ProofLiteral[] clause = new ProofLiteral[3];
                for (int i = 0; i < 3; ++i) {
                    Term term;
                    Term term3 = term = xorLists[i].length == 1 ? xorLists[i][0] : theory.term("xor", xorLists[i]);
                    assert (term != null);
                    clause[i] = new ProofLiteral(term, false);
                }
                return clause;
            }
            case ":=+": {
                assert (annots.length == 1);
                ApplicationTerm eqTerm = (ApplicationTerm)annots[0].getValue();
                if (!eqTerm.getFunction().isIntern() || !eqTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(eqTerm.getTheory());
                }
                Term[] params = eqTerm.getParameters();
                ProofLiteral[] clause = new ProofLiteral[params.length];
                clause[0] = new ProofLiteral(eqTerm, true);
                for (int i = 0; i < params.length - 1; ++i) {
                    clause[i + 1] = new ProofLiteral(theory.term("=", params[i], params[i + 1]), false);
                }
                return clause;
            }
            case ":=-": {
                assert (annots.length == 2);
                ApplicationTerm eqTerm = (ApplicationTerm)annots[0].getValue();
                if (!eqTerm.getFunction().isIntern() || !eqTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(eqTerm.getTheory());
                }
                Term[] params = eqTerm.getParameters();
                assert (annots[1].getKey().equals(":pos"));
                Integer[] positions = (Integer[])annots[1].getValue();
                assert (positions.length == 2);
                int pos0 = positions[0];
                int pos1 = positions[1];
                assert (0 <= pos0 && pos0 < params.length && 0 <= pos1 && pos1 < params.length);
                return new ProofLiteral[]{new ProofLiteral(eqTerm, false), new ProofLiteral(theory.term("=", params[pos0], params[pos1]), true)};
            }
            case ":distinct+": {
                assert (annots.length == 1);
                ApplicationTerm distinctTerm = (ApplicationTerm)annots[0].getValue();
                if (!distinctTerm.getFunction().isIntern() || !distinctTerm.getFunction().getName().equals("distinct")) {
                    this.reportError("Expected distinct application", new Object[0]);
                    return this.getTrueClause(distinctTerm.getTheory());
                }
                Term[] params = distinctTerm.getParameters();
                int len = params.length;
                ProofLiteral[] clause = new ProofLiteral[1 + len * (len - 1) / 2];
                clause[0] = new ProofLiteral(distinctTerm, true);
                int pos = 1;
                for (int i = 0; i < len - 1; ++i) {
                    for (int j = i + 1; j < len; ++j) {
                        clause[pos++] = new ProofLiteral(theory.term("=", params[i], params[j]), true);
                    }
                }
                assert (pos == clause.length);
                return clause;
            }
            case ":distinct-": {
                assert (annots.length == 2);
                ApplicationTerm distinctTerm = (ApplicationTerm)annots[0].getValue();
                if (!distinctTerm.getFunction().isIntern() || !distinctTerm.getFunction().getName().equals("distinct")) {
                    this.reportError("Expected distinct application", new Object[0]);
                    return this.getTrueClause(distinctTerm.getTheory());
                }
                Term[] params = distinctTerm.getParameters();
                assert (annots[1].getKey().equals(":pos"));
                Integer[] positions = (Integer[])annots[1].getValue();
                assert (positions.length == 2);
                int pos0 = positions[0];
                int pos1 = positions[1];
                assert (0 <= pos0 && pos0 < params.length && 0 <= pos1 && pos1 < params.length);
                return new ProofLiteral[]{new ProofLiteral(distinctTerm, false), new ProofLiteral(theory.term("=", params[pos0], params[pos1]), false)};
            }
            case ":ite1": {
                assert (annots.length == 1);
                ApplicationTerm iteTerm = (ApplicationTerm)annots[0].getValue();
                if (!iteTerm.getFunction().isIntern() || !iteTerm.getFunction().getName().equals("ite")) {
                    this.reportError("Expected ite application", new Object[0]);
                    return this.getTrueClause(iteTerm.getTheory());
                }
                Term[] params = iteTerm.getParameters();
                assert (params.length == 3);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", iteTerm, params[1]), true), new ProofLiteral(params[0], false)};
            }
            case ":ite2": {
                assert (annots.length == 1);
                ApplicationTerm iteTerm = (ApplicationTerm)annots[0].getValue();
                if (!iteTerm.getFunction().isIntern() || !iteTerm.getFunction().getName().equals("ite")) {
                    this.reportError("Expected ite application", new Object[0]);
                    return this.getTrueClause(iteTerm.getTheory());
                }
                Term[] params = iteTerm.getParameters();
                assert (params.length == 3);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", iteTerm, params[2]), true), new ProofLiteral(params[0], true)};
            }
            case ":del!": {
                assert (annots.length == 1);
                Object[] params = (Object[])annots[0].getValue();
                assert (params.length == 2);
                Term subterm = (Term)params[0];
                Annotation[] subAnnots = ProofRules.convertSExprToAnnotation((Object[])params[1]);
                Term annotTerm = theory.annotatedTerm(subAnnots, subterm);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", annotTerm, subterm), true)};
            }
            case ":refl": {
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 1);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", params[0], params[0]), true)};
            }
            case ":symm": {
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 2);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", params), true), new ProofLiteral(theory.term("=", params[1], params[0]), false)};
            }
            case ":trans": {
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length > 2);
                int len = params.length;
                ProofLiteral[] clause = new ProofLiteral[len];
                clause[0] = new ProofLiteral(theory.term("=", params[0], params[len - 1]), true);
                for (int i = 0; i < len - 1; ++i) {
                    clause[i + 1] = new ProofLiteral(theory.term("=", params[i], params[i + 1]), false);
                }
                return clause;
            }
            case ":cong": {
                assert (annots.length == 1);
                Object[] congArgs = (Object[])annots[0].getValue();
                assert (congArgs.length == 3);
                FunctionSymbol func = (FunctionSymbol)congArgs[0];
                Term[] params0 = (Term[])congArgs[1];
                Term[] params1 = (Term[])congArgs[2];
                assert (params0.length == params1.length);
                Term app0 = theory.term(func, params0);
                Term app1 = theory.term(func, params1);
                ProofLiteral[] clause = new ProofLiteral[params0.length + 1];
                clause[0] = new ProofLiteral(theory.term("=", app0, app1), true);
                for (int i = 0; i < params0.length; ++i) {
                    clause[i + 1] = new ProofLiteral(theory.term("=", params0[i], params1[i]), false);
                }
                return clause;
            }
            case ":expand": {
                Term rhs;
                assert (annots.length == 1);
                Object[] expandArgs = (Object[])annots[0].getValue();
                assert (expandArgs.length == 2);
                FunctionSymbol func = (FunctionSymbol)expandArgs[0];
                Term[] params = (Term[])expandArgs[1];
                Term app = theory.term(func, params);
                if (this.mFunctionDefinitions.containsKey(func)) {
                    LambdaTerm lambda = this.mFunctionDefinitions.get(func);
                    rhs = theory.let(lambda.getVariables(), params, lambda.getSubterm());
                    rhs = new FormulaUnLet().unlet(rhs);
                } else if (func.getDefinition() != null) {
                    rhs = theory.let(func.getDefinitionVars(), params, func.getDefinition());
                    rhs = new FormulaUnLet().unlet(rhs);
                } else if (func.isLeftAssoc() && params.length > 2) {
                    rhs = params[0];
                    for (int i = 1; i < params.length; ++i) {
                        rhs = theory.term(func, rhs, params[i]);
                    }
                } else if (func.isRightAssoc() && params.length > 2) {
                    rhs = params[params.length - 1];
                    for (int i = params.length - 2; i >= 0; --i) {
                        rhs = theory.term(func, params[i], rhs);
                    }
                } else if (func.isChainable() && params.length > 2) {
                    Term[] chain = new Term[params.length - 1];
                    for (int i = 0; i < chain.length; ++i) {
                        chain[i] = theory.term(func, params[i], params[i + 1]);
                    }
                    rhs = theory.term("and", chain);
                } else {
                    throw new AssertionError();
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", app, rhs), true)};
            }
            case ":forall+": 
            case ":exists-": {
                assert (annots.length == 1);
                boolean isForall = annots[0].getKey().equals(":forall+");
                QuantifiedFormula quant = (QuantifiedFormula)annots[0].getValue();
                if (quant.getQuantifier() != (isForall ? 1 : 0)) {
                    this.reportError("Quantifier of wrong type", new Object[0]);
                    return this.getTrueClause(theory);
                }
                TermVariable[] termVars = quant.getVariables();
                Term[] skolemTerms = new ProofRules(theory).getSkolemVars(termVars, quant.getSubformula(), isForall);
                Term letted = theory.let(termVars, skolemTerms, quant.getSubformula());
                return new ProofLiteral[]{new ProofLiteral(quant, isForall), new ProofLiteral(new FormulaUnLet().unlet(letted), !isForall)};
            }
            case ":forall-": 
            case ":exists+": {
                assert (annots.length == 2);
                boolean isForall = annots[0].getKey().equals(":forall-");
                QuantifiedFormula quant = (QuantifiedFormula)annots[0].getValue();
                if (quant.getQuantifier() != (isForall ? 1 : 0)) {
                    this.reportError("Quantifier of wrong type", new Object[0]);
                    return this.getTrueClause(theory);
                }
                TermVariable[] termVars = quant.getVariables();
                assert (annots[1].getKey() == ":values");
                Term[] values = (Term[])annots[1].getValue();
                Term letted = theory.let(termVars, values, quant.getSubformula());
                return new ProofLiteral[]{new ProofLiteral(quant, !isForall), new ProofLiteral(new FormulaUnLet().unlet(letted), isForall)};
            }
            case ":>def": {
                if (!theory.getLogic().isArithmetic()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                if (params.length != 2) {
                    throw new AssertionError();
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", theory.term(">", params), theory.term("<", params[1], params[0])), true)};
            }
            case ":>=def": {
                if (!theory.getLogic().isArithmetic()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                if (params.length != 2) {
                    throw new AssertionError();
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", theory.term(">=", params), theory.term("<=", params[1], params[0])), true)};
            }
            case ":trichotomy": {
                if (!theory.getLogic().isArithmetic()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                if (params.length != 2) {
                    throw new AssertionError();
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("<", params), true), new ProofLiteral(theory.term("=", params), true), new ProofLiteral(theory.term("<", params[1], params[0]), true)};
            }
            case ":total": {
                if (!theory.getLogic().isArithmetic()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length == 2);
                return new ProofLiteral[]{new ProofLiteral(theory.term("<=", params[0], params[1]), true), new ProofLiteral(theory.term("<", params[1], params[0]), true)};
            }
            case ":total-int": {
                if (!theory.getLogic().hasIntegers()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Object[] params = (Object[])annots[0].getValue();
                assert (params.length == 2);
                Term x = (Term)params[0];
                BigInteger c = (BigInteger)params[1];
                if (!x.getSort().getName().equals("Int")) {
                    return this.reportViolatedSideCondition(axiom);
                }
                Rational cAsRational = Rational.valueOf(c, BigInteger.ONE);
                Term cTerm = cAsRational.toTerm(x.getSort());
                Term cPlusOne = cAsRational.add(Rational.ONE).toTerm(x.getSort());
                return new ProofLiteral[]{new ProofLiteral(theory.term("<=", x, cTerm), true), new ProofLiteral(theory.term("<=", cPlusOne, x), true)};
            }
            case ":farkas": {
                if (!theory.getLogic().isArithmetic()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] ineqs = (Term[])annots[0].getValue();
                assert (annots.length == 2);
                assert (annots[1].getKey() == ":coeffs");
                BigInteger[] coeffs = (BigInteger[])annots[1].getValue();
                if (!ProofRules.checkFarkas(ineqs, coeffs)) {
                    return this.reportViolatedSideCondition(axiom);
                }
                HashSet<ProofLiteral> clause = new HashSet<ProofLiteral>();
                for (int i = 0; i < ineqs.length; ++i) {
                    clause.add(new ProofLiteral(ineqs[i], false));
                }
                return clause.toArray(new ProofLiteral[clause.size()]);
            }
            case ":poly+": {
                if (!theory.getLogic().isArithmetic()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length == 2);
                if (!ProofRules.checkPolyAdd(params[0], params[1])) {
                    return this.reportViolatedSideCondition(axiom);
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", params[0], params[1]), true)};
            }
            case ":poly*": {
                if (!theory.getLogic().isArithmetic()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length == 2);
                if (!ProofRules.checkPolyMul(params[0], params[1])) {
                    return this.reportViolatedSideCondition(axiom);
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", params[0], params[1]), true)};
            }
            case ":to_real-def": {
                if (!theory.getLogic().isIRA()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length == 1);
                Term lhs = theory.term("to_real", params[0]);
                Term rhs = ProofRules.computePolyToReal(params[0]);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", lhs, rhs), true)};
            }
            case ":/def": {
                if (!theory.getLogic().hasReals()) {
                    this.reportError("Proof requires real arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length >= 2);
                Term divide = theory.term("/", params);
                Term[] mulParams = new Term[params.length];
                System.arraycopy(params, 1, mulParams, 0, params.length - 1);
                mulParams[params.length - 1] = divide;
                Term lhs = theory.term("*", mulParams);
                LinkedHashSet<ProofLiteral> clause = new LinkedHashSet<ProofLiteral>();
                clause.add(new ProofLiteral(theory.term("=", lhs, params[0]), true));
                for (int i = 1; i < params.length; ++i) {
                    clause.add(new ProofLiteral(theory.term("=", params[i], Rational.ZERO.toTerm(params[i].getSort())), true));
                }
                return clause.toArray(new ProofLiteral[clause.size()]);
            }
            case ":-def": {
                if (!theory.getLogic().isArithmetic()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length >= 1);
                Term lhs = theory.term("-", params);
                Term rhs = ProofRules.computePolyMinus(lhs);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", lhs, rhs), true)};
            }
            case ":divisible-def": {
                if (!theory.getLogic().hasIntegers()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 2);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 1);
                assert (annots[1].getKey() == ":divisor");
                BigInteger divisor = (BigInteger)annots[1].getValue();
                Term arg = params[0];
                if (divisor.signum() <= 0 || !arg.getSort().getName().equals("Int")) {
                    return this.reportViolatedSideCondition(axiom);
                }
                Term divisorTerm = Rational.valueOf(divisor, BigInteger.ONE).toTerm(arg.getSort());
                Term divisibleTerm = theory.term("divisible", new String[]{divisor.toString()}, null, arg);
                Term divTerm = theory.term("div", arg, divisorTerm);
                Term mulDivTerm = theory.term("*", divisorTerm, divTerm);
                Term equalTerm = theory.term("=", arg, mulDivTerm);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", divisibleTerm, equalTerm), true)};
            }
            case ":to_int-low": {
                if (!theory.getLogic().isIRA()) {
                    this.reportError("Proof requires integer and real arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length == 1);
                Term arg = params[0];
                Term toRealToInt = theory.term("to_real", theory.term("to_int", arg));
                return new ProofLiteral[]{new ProofLiteral(theory.term("<=", toRealToInt, arg), true)};
            }
            case ":to_int-high": {
                if (!theory.getLogic().isIRA()) {
                    this.reportError("Proof requires integer and real arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length == 1);
                Term arg = params[0];
                Term toRealToInt = theory.term("to_real", theory.term("to_int", arg));
                Term toRealPlusOne = theory.term("+", toRealToInt, Rational.ONE.toTerm(arg.getSort()));
                return new ProofLiteral[]{new ProofLiteral(theory.term("<", arg, toRealPlusOne), true)};
            }
            case ":div-low": {
                if (!theory.getLogic().hasIntegers()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length == 2);
                Term arg = params[0];
                Term divisor = params[1];
                Term divTerm = theory.term("div", arg, divisor);
                Term mulDivTerm = theory.term("*", divisor, divTerm);
                Term zero = Rational.ZERO.toTerm(divisor.getSort());
                return new ProofLiteral[]{new ProofLiteral(theory.term("<=", mulDivTerm, arg), true), new ProofLiteral(theory.term("=", divisor, zero), true)};
            }
            case ":div-high": {
                if (!theory.getLogic().hasIntegers()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length == 2);
                Term arg = params[0];
                Term divisor = params[1];
                Term divTerm = theory.term("div", arg, divisor);
                Term mulDivTerm = theory.term("*", divisor, divTerm);
                Term mulDivTermPlus = theory.term("+", mulDivTerm, theory.term("abs", divisor));
                Term zero = Rational.ZERO.toTerm(divisor.getSort());
                return new ProofLiteral[]{new ProofLiteral(theory.term("<", arg, mulDivTermPlus), true), new ProofLiteral(theory.term("=", divisor, zero), true)};
            }
            case ":mod-def": {
                if (!theory.getLogic().hasIntegers()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] params = (Term[])annots[0].getValue();
                assert (annots.length == 1);
                assert (params.length == 2);
                Term arg = params[0];
                Term divisor = params[1];
                Term divTerm = theory.term("div", arg, divisor);
                Term mulDivTerm = theory.term("*", divisor, divTerm);
                Term modTerm = theory.term("mod", arg, divisor);
                Term modDef = theory.term("+", mulDivTerm, modTerm);
                Term zero = Rational.ZERO.toTerm(divisor.getSort());
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", modDef, arg), true), new ProofLiteral(theory.term("=", divisor, zero), true)};
            }
            case ":selectstore1": {
                if (!theory.getLogic().isArray()) {
                    this.reportError("Proof requires array theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 3);
                Term store = theory.term("store", params[0], params[1], params[2]);
                Term selectStore = theory.term("select", store, params[1]);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", selectStore, params[2]), true)};
            }
            case ":selectstore2": {
                if (!theory.getLogic().isArray()) {
                    this.reportError("Proof requires array theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 4);
                Term store = theory.term("store", params[0], params[1], params[2]);
                Term selectStore = theory.term("select", store, params[3]);
                Term select = theory.term("select", params[0], params[3]);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", selectStore, select), true), new ProofLiteral(theory.term("=", params[1], params[3]), true)};
            }
            case ":extdiff": {
                if (!theory.getLogic().isArray()) {
                    this.reportError("Proof requires array theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 2);
                Term diff = theory.term("@diff", params[0], params[1]);
                Term select0 = theory.term("select", params[0], diff);
                Term select1 = theory.term("select", params[1], diff);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", params[0], params[1]), true), new ProofLiteral(theory.term("=", select0, select1), false)};
            }
            case ":const": {
                if (!theory.getLogic().isArray()) {
                    this.reportError("Proof requires array theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 2);
                Term value = params[0];
                Term index = params[1];
                Sort arraySort = theory.getSort("Array", index.getSort(), value.getSort());
                Term constArray = theory.term("const", null, arraySort, value);
                Term select = theory.term("select", constArray, index);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", select, value), true)};
            }
            case ":dt-project": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 1);
                ApplicationTerm selConsTerm = (ApplicationTerm)params[0];
                FunctionSymbol selector = selConsTerm.getFunction();
                assert (selector.isSelector());
                ApplicationTerm consTerm = (ApplicationTerm)selConsTerm.getParameters()[0];
                if (!consTerm.getFunction().isConstructor()) {
                    return this.reportViolatedSideCondition(axiom);
                }
                DataType dataType = (DataType)consTerm.getSort().getSortSymbol();
                DataType.Constructor cons = dataType.getConstructor(consTerm.getFunction().getName());
                int selectPos = cons.getSelectorIndex(selector.getName());
                Term consArg = consTerm.getParameters()[selectPos];
                Term provedEq = theory.term("=", selConsTerm, consArg);
                return new ProofLiteral[]{new ProofLiteral(provedEq, true)};
            }
            case ":dt-cons": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 1);
                ApplicationTerm isConsTerm = (ApplicationTerm)params[0];
                if (!isConsTerm.getFunction().getName().equals("is")) {
                    return this.reportViolatedSideCondition(axiom);
                }
                Term dataTerm = isConsTerm.getParameters()[0];
                DataType dataType = (DataType)dataTerm.getSort().getSortSymbol();
                DataType.Constructor cons = dataType.getConstructor(isConsTerm.getFunction().getIndices()[0]);
                String[] selectors = cons.getSelectors();
                Term[] selectTerms = new Term[selectors.length];
                for (int i = 0; i < selectors.length; ++i) {
                    selectTerms[i] = theory.term(selectors[i], dataTerm);
                }
                Term consTerm = theory.term(cons.getName(), null, cons.needsReturnOverload() ? dataTerm.getSort() : null, selectTerms);
                Term provedEq = theory.term("=", consTerm, dataTerm);
                return new ProofLiteral[]{new ProofLiteral(isConsTerm, false), new ProofLiteral(provedEq, true)};
            }
            case ":dt-test+": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 1);
                ApplicationTerm consTerm = (ApplicationTerm)params[0];
                FunctionSymbol consFunc = consTerm.getFunction();
                if (!consFunc.isConstructor()) {
                    return this.reportViolatedSideCondition(axiom);
                }
                Term isTerm = theory.term("is", new String[]{consFunc.getName()}, null, consTerm);
                return new ProofLiteral[]{new ProofLiteral(isTerm, true)};
            }
            case ":dt-test-": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Object[] params = (Object[])annots[0].getValue();
                assert (params.length == 2);
                String otherCons = (String)params[0];
                ApplicationTerm consTerm = (ApplicationTerm)params[1];
                FunctionSymbol consFunc = consTerm.getFunction();
                if (!consFunc.isConstructor() || consFunc.getName().equals(otherCons)) {
                    return this.reportViolatedSideCondition(axiom);
                }
                Term isTerm = theory.term("is", new String[]{otherCons}, null, consTerm);
                return new ProofLiteral[]{new ProofLiteral(isTerm, false)};
            }
            case ":dt-exhaust": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 1);
                Term data = params[0];
                DataType dataType = (DataType)data.getSort().getSortSymbol();
                DataType.Constructor[] constrs = dataType.getConstructors();
                ProofLiteral[] lits = new ProofLiteral[constrs.length];
                for (int i = 0; i < lits.length; ++i) {
                    Term tester = theory.term("is", new String[]{constrs[i].getName()}, null, data);
                    lits[i] = new ProofLiteral(tester, true);
                }
                return lits;
            }
            case ":dt-acyclic": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Object[] params = (Object[])annots[0].getValue();
                assert (params.length == 2);
                Term consTerm = (Term)params[0];
                int[] positions = (int[])params[1];
                if (positions.length == 0) {
                    return this.reportViolatedSideCondition(axiom);
                }
                Term subTerm = consTerm;
                for (int pos : positions) {
                    ApplicationTerm parent = (ApplicationTerm)subTerm;
                    if (!parent.getFunction().isConstructor()) {
                        return this.reportViolatedSideCondition(axiom);
                    }
                    subTerm = parent.getParameters()[pos];
                }
                Term provedIneq = theory.term("=", consTerm, subTerm);
                return new ProofLiteral[]{new ProofLiteral(provedIneq, false)};
            }
            case ":dt-match": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annots.length == 1);
                Term[] params = (Term[])annots[0].getValue();
                assert (params.length == 1);
                if (!(params[0] instanceof MatchTerm)) {
                    return this.reportViolatedSideCondition(axiom);
                }
                MatchTerm matchTerm = (MatchTerm)params[0];
                Term iteTerm = MinimalProofChecker.buildIteForMatch(matchTerm);
                Term provedEq = theory.term("=", matchTerm, iteTerm);
                return new ProofLiteral[]{new ProofLiteral(provedEq, true)};
            }
        }
        this.reportError("Unknown axiom %s", axiom);
        return this.getTrueClause(axiom.getTheory());
    }

    private ProofLiteral[] reportViolatedSideCondition(Term axiom) {
        StringBuilder sb = new StringBuilder();
        sb.append("Side-condition violated in ");
        ProofRules.printProof(sb, axiom);
        this.reportError(sb.toString(), new Object[0]);
        return this.getTrueClause(axiom.getTheory());
    }

    private ProofLiteral[] getTrueClause(Theory theory) {
        return new ProofLiteral[]{new ProofLiteral(theory.mTrue, true)};
    }

    private static Term buildLetForMatch(DataType.Constructor constr, TermVariable[] vars, Term dataTerm, Term caseTerm) {
        Theory theory = dataTerm.getTheory();
        Term[] selectTerms = new Term[vars.length];
        if (constr == null) {
            assert (vars.length == 1);
            selectTerms[0] = dataTerm;
        } else {
            assert (constr.getSelectors().length == vars.length);
            for (int i = 0; i < vars.length; ++i) {
                selectTerms[i] = theory.term(constr.getSelectors()[i], dataTerm);
            }
        }
        return new FormulaUnLet().unlet(theory.let(vars, selectTerms, caseTerm));
    }

    public static Term buildIteForMatch(MatchTerm matchTerm) {
        Theory theory = matchTerm.getTheory();
        Term dataTerm = matchTerm.getDataTerm();
        Term[] cases = matchTerm.getCases();
        TermVariable[][] vars = matchTerm.getVariables();
        DataType.Constructor[] constrs = matchTerm.getConstructors();
        Term iteTerm = MinimalProofChecker.buildLetForMatch(constrs[constrs.length - 1], vars[constrs.length - 1], dataTerm, cases[constrs.length - 1]);
        for (int i = constrs.length - 2; i >= 0; --i) {
            Term caseTerm = MinimalProofChecker.buildLetForMatch(constrs[i], vars[i], dataTerm, cases[i]);
            if (constrs[i] == null) {
                iteTerm = caseTerm;
                continue;
            }
            Term condTerm = theory.term("is", new String[]{constrs[i].getName()}, null, dataTerm);
            iteTerm = theory.term("ite", condTerm, caseTerm, iteTerm);
        }
        return iteTerm;
    }

    public ProofLiteral[] checkAssert(Term axiom) {
        ++this.mNumAssertions;
        ApplicationTerm appTerm = (ApplicationTerm)axiom;
        Term[] params = appTerm.getParameters();
        assert (appTerm.getFunction().getName() == "..assume");
        assert (params.length == 1);
        if (!this.mAssertions.contains(params[0])) {
            this.reportError("Unknown assumption: %s", params[0]);
            return this.getTrueClause(axiom.getTheory());
        }
        return new ProofLiteral[]{new ProofLiteral(params[0], true)};
    }

    static class ResolutionWalker
    implements NonRecursive.Walker {
        final ApplicationTerm mTerm;

        public ResolutionWalker(ApplicationTerm term) {
            this.mTerm = term;
        }

        public void enqueue(MinimalProofChecker engine) {
            Term[] params = this.mTerm.getParameters();
            engine.enqueueWalker(this);
            engine.enqueueWalker(new ProofWalker(params[2]));
            engine.enqueueWalker(new ProofWalker(params[1]));
        }

        @Override
        public void walk(NonRecursive engine) {
            MinimalProofChecker checker = (MinimalProofChecker)engine;
            ProofLiteral[] negClause = checker.stackPop();
            ProofLiteral[] posClause = checker.stackPop();
            checker.stackPush(checker.walkResolution(this.mTerm, posClause, negClause), this.mTerm);
        }
    }

    static class DefineFunWalker
    implements NonRecursive.Walker {
        final AnnotatedTerm mProof;

        public DefineFunWalker(AnnotatedTerm term) {
            this.mProof = term;
        }

        public void enqueue(MinimalProofChecker engine) {
            ++engine.mNumDefineFun;
            Object[] annotValues = (Object[])this.mProof.getAnnotations()[0].getValue();
            FunctionSymbol func = (FunctionSymbol)annotValues[0];
            LambdaTerm def = (LambdaTerm)annotValues[1];
            if (!(func.isIntern() || func.getDefinition() == null || func.getDefinition() == def.getSubterm() && Arrays.equals(func.getDefinitionVars(), def.getVariables()))) {
                throw new AssertionError((Object)"Inconsistent function definition.");
            }
            if (engine.mFunctionDefinitions.containsKey(func)) {
                throw new AssertionError((Object)"Double function definition.");
            }
            engine.mFunctionDefinitions.put(func, def);
            engine.enqueueWalker(this);
            engine.enqueueWalker(new ProofWalker(this.mProof.getSubterm()));
        }

        @Override
        public void walk(NonRecursive parent) {
            MinimalProofChecker engine = (MinimalProofChecker)parent;
            Object[] annotValues = (Object[])this.mProof.getAnnotations()[0].getValue();
            FunctionSymbol func = (FunctionSymbol)annotValues[0];
            engine.mFunctionDefinitions.remove(func);
        }
    }

    static class ProofWalker
    implements NonRecursive.Walker {
        final Term mTerm;

        public ProofWalker(Term term) {
            assert (term.getSort().getName().equals("..Proof"));
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            ((MinimalProofChecker)engine).walk(this.mTerm);
        }
    }
}

