/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class OccurrenceCounter {
    private final Deque<Clause> mTodo = new ArrayDeque<Clause>();
    private Map<Clause, Integer> mCounts;

    private boolean incCounter(Clause cls) {
        Integer oldVal = this.mCounts.get(cls);
        int newVal = oldVal == null ? 1 : oldVal + 1;
        return this.mCounts.put(cls, newVal) == null;
    }

    public Map<Clause, Integer> count(Clause unsat) {
        assert (unsat.getSize() == 0);
        this.mCounts = new HashMap<Clause, Integer>();
        this.mTodo.push(unsat);
        this.run();
        return this.mCounts;
    }

    private void run() {
        while (!this.mTodo.isEmpty()) {
            ProofNode pn;
            Clause cls = this.mTodo.pop();
            if (!this.incCounter(cls) || (pn = cls.getProof()).isLeaf()) continue;
            ResolutionNode rn = (ResolutionNode)pn;
            ResolutionNode.Antecedent[] antes = rn.getAntecedents();
            for (int i = antes.length - 1; i >= 0; --i) {
                this.mTodo.push(antes[i].mAntecedent);
            }
            this.mTodo.push(rn.getPrimary());
        }
    }
}

