/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Polynomial {
    private final Map<Map<Term, Integer>, Rational> mSummands = new LinkedHashMap<Map<Term, Integer>, Rational>();

    public Polynomial() {
    }

    public Polynomial(Term term) {
        this();
        Term[] subterms = term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("+") ? ((ApplicationTerm)term).getParameters() : new Term[]{term};
        for (Term subterm : subterms) {
            Rational coefficient = Rational.ONE;
            Term[] factors = subterm instanceof ApplicationTerm && ((ApplicationTerm)subterm).getFunction().getName() == "*" ? ((ApplicationTerm)subterm).getParameters() : new Term[]{subterm};
            Map<Object, Object> monomial = new LinkedHashMap();
            for (Term f : factors) {
                Integer old;
                Rational constant = Polynomial.parseConstant(f);
                if (constant != null) {
                    coefficient = coefficient.mul(constant);
                    continue;
                }
                if (f instanceof ApplicationTerm && ((ApplicationTerm)f).getFunction().getName() == "to_real") {
                    f = ((ApplicationTerm)f).getParameters()[0];
                }
                monomial.put(f, (old = (Integer)monomial.get(f)) == null ? 1 : old + 1);
            }
            if (monomial.isEmpty()) {
                monomial = Collections.emptyMap();
            } else if (monomial.size() == 1) {
                Map.Entry entry = monomial.entrySet().iterator().next();
                monomial = Collections.singletonMap((Term)entry.getKey(), (Integer)entry.getValue());
            }
            Rational old = this.mSummands.get(monomial);
            this.mSummands.put(monomial, old == null ? coefficient : old.add(coefficient));
        }
    }

    public static boolean isToReal(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("to_real");
    }

    private static Rational convertConstantTerm(ConstantTerm term) {
        Rational constant;
        Object value = term.getValue();
        if (value instanceof BigInteger) {
            constant = Rational.valueOf((BigInteger)value, BigInteger.ONE);
        } else if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            if (decimal.scale() <= 0) {
                BigInteger num = decimal.toBigInteger();
                constant = Rational.valueOf(num, BigInteger.ONE);
            } else {
                BigInteger num = decimal.unscaledValue();
                BigInteger denom = BigInteger.TEN.pow(decimal.scale());
                constant = Rational.valueOf(num, denom);
            }
        } else if (value instanceof Rational) {
            constant = (Rational)value;
        } else {
            return null;
        }
        return constant;
    }

    private static Rational parseConstantWithoutFraction(Term term) {
        boolean isNegated = false;
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("-") && ((ApplicationTerm)term).getParameters().length == 1) {
            term = ((ApplicationTerm)term).getParameters()[0];
            isNegated = true;
        }
        if (Polynomial.isToReal(term)) {
            term = ((ApplicationTerm)term).getParameters()[0];
        }
        if (term instanceof ConstantTerm) {
            Rational value = Polynomial.convertConstantTerm((ConstantTerm)term);
            if (isNegated && value != null) {
                value = value.negate();
            }
            return value;
        }
        return null;
    }

    public static Rational parseConstant(Term term) {
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("/")) {
            Term[] params = ((ApplicationTerm)term).getParameters();
            Rational numerator = Polynomial.parseConstantWithoutFraction(params[0]);
            Rational denominator = Polynomial.parseConstantWithoutFraction(params[1]);
            if (numerator == null || denominator == null || denominator.signum() <= 0 || !numerator.isIntegral() || !denominator.isIntegral()) {
                return null;
            }
            return numerator.div(denominator);
        }
        return Polynomial.parseConstantWithoutFraction(term);
    }

    public void mul(Rational factor) {
        if (factor == Rational.ZERO) {
            this.mSummands.clear();
            return;
        }
        for (Map.Entry<Map<Term, Integer>, Rational> entry : this.mSummands.entrySet()) {
            entry.setValue(entry.getValue().mul(factor));
        }
    }

    public Map<Term, Integer> mulMonomials(Map<Term, Integer> monom1, Map<Term, Integer> monom2) {
        LinkedHashMap<Term, Integer> result = new LinkedHashMap<Term, Integer>();
        result.putAll(monom1);
        Iterator<Map.Entry<Term, Integer>> iterator = monom2.entrySet().iterator();
        while (iterator.hasNext()) {
            Integer old;
            Map.Entry<Term, Integer> entry;
            result.put(entry.getKey(), (old = (Integer)result.get((entry = iterator.next()).getKey())) == null ? entry.getValue() : old + entry.getValue());
        }
        return result;
    }

    public void mul(Polynomial other) {
        if (other.isConstant()) {
            this.mul(other.getConstant());
            return;
        }
        if (this.isConstant()) {
            Rational constant = this.getConstant();
            this.mSummands.clear();
            this.add(constant, other);
            return;
        }
        Polynomial newPolynomial = new Polynomial();
        for (Map.Entry<Map<Term, Integer>, Rational> term1 : other.mSummands.entrySet()) {
            for (Map.Entry<Map<Term, Integer>, Rational> term2 : this.mSummands.entrySet()) {
                Map<Term, Integer> newMonomial = this.mulMonomials(term1.getKey(), term2.getKey());
                newPolynomial.add(term1.getValue().mul(term2.getValue()), newMonomial);
            }
        }
        this.mSummands.clear();
        this.mSummands.putAll(newPolynomial.mSummands);
    }

    public void add(Rational factor, Map<Term, Integer> monomial) {
        Rational newCoeff;
        Rational oldCoeff = this.mSummands.get(monomial);
        Rational rational = newCoeff = oldCoeff == null ? factor : oldCoeff.add(factor);
        if (newCoeff == Rational.ZERO) {
            this.mSummands.remove(monomial);
        } else {
            this.mSummands.put(monomial, newCoeff);
        }
    }

    public void add(Rational constant) {
        this.add(constant, Collections.emptyMap());
    }

    public void add(Rational factor, Polynomial other) {
        for (Map.Entry<Map<Term, Integer>, Rational> entry : other.mSummands.entrySet()) {
            this.add(factor.mul(entry.getValue()), entry.getKey());
        }
    }

    public void add(Rational factor, Term other) {
        this.add(factor, new Polynomial(other));
    }

    public boolean isConstant() {
        return this.mSummands.isEmpty() || this.mSummands.size() == 1 && this.mSummands.keySet().iterator().next().isEmpty();
    }

    public Rational getConstant() {
        Rational coeff = this.mSummands.get(Collections.emptyMap());
        return coeff == null ? Rational.ZERO : coeff;
    }

    public boolean isZero() {
        return this.mSummands.isEmpty();
    }

    public Rational getGcd() {
        Rational gcd = Rational.ZERO;
        for (Map.Entry<Map<Term, Integer>, Rational> term : this.mSummands.entrySet()) {
            if (term.getKey().isEmpty()) continue;
            gcd = gcd.gcd(term.getValue().abs());
        }
        return gcd;
    }

    public Map<Map<Term, Integer>, Rational> getSummands() {
        return this.mSummands;
    }

    public Term toTerm(Sort sort) {
        assert (sort.isNumericSort());
        if (this.mSummands.isEmpty()) {
            return Rational.ZERO.toTerm(sort);
        }
        Theory t = sort.getTheory();
        int size = this.mSummands.size();
        Term[] sum = new Term[size];
        int i = 0;
        for (Map.Entry<Map<Term, Integer>, Rational> term : this.mSummands.entrySet()) {
            Map<Term, Integer> monomial = term.getKey();
            ArrayList<Term> factors = new ArrayList<Term>();
            factors.add(term.getValue().toTerm(sort));
            for (Map.Entry<Term, Integer> f : monomial.entrySet()) {
                int power = f.getValue();
                assert (power > 0);
                for (int j = 0; j < power; ++j) {
                    factors.add(f.getKey());
                }
            }
            if (factors.size() == 1) {
                sum[i++] = (Term)factors.get(0);
                continue;
            }
            sum[i++] = t.term("*", factors.toArray(new Term[factors.size()]));
        }
        return size == 1 ? sum[0] : t.term("+", sum);
    }

    public String toString() {
        if (this.mSummands.isEmpty()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        String comma = "";
        for (Map.Entry<Map<Term, Integer>, Rational> monomial : this.mSummands.entrySet()) {
            sb.append(comma);
            sb.append(monomial.getValue());
            for (Map.Entry<Term, Integer> entry : monomial.getKey().entrySet()) {
                int power = entry.getValue();
                assert (power > 0);
                String repr = " * " + entry.getKey();
                for (int i = 0; i < entry.getValue(); ++i) {
                    sb.append(repr);
                }
            }
            comma = " + ";
        }
        return sb.toString();
    }

    public boolean isAllIntSummands() {
        for (Map<Term, Integer> monomial : this.mSummands.keySet()) {
            for (Term t : monomial.keySet()) {
                if (t.getSort().getName().equals("Int")) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Polynomial)) {
            return false;
        }
        Polynomial o = (Polynomial)other;
        return this.mSummands.equals(o.mSummands);
    }

    public int hashCode() {
        return this.mSummands.hashCode();
    }
}

