/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.Polynomial;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;

public class ProofRules {
    public static final String RES = "res";
    public static final String ASSUME = "assume";
    public static final String AXIOM = "axiom";
    public static final String ORACLE = "oracle";
    public static final String FALSEE = "false-";
    public static final String TRUEI = "true+";
    public static final String NOTI = "not+";
    public static final String NOTE = "not-";
    public static final String ORI = "or+";
    public static final String ORE = "or-";
    public static final String ANDI = "and+";
    public static final String ANDE = "and-";
    public static final String IMPI = "=>+";
    public static final String IMPE = "=>-";
    public static final String IFFI1 = "=+1";
    public static final String IFFI2 = "=+2";
    public static final String IFFE1 = "=-1";
    public static final String IFFE2 = "=-2";
    public static final String XORI = "xor+";
    public static final String XORE = "xor-";
    public static final String FORALLI = "forall+";
    public static final String FORALLE = "forall-";
    public static final String EXISTSI = "exists+";
    public static final String EXISTSE = "exists-";
    public static final String EQI = "=+";
    public static final String EQE = "=-";
    public static final String DISTINCTI = "distinct+";
    public static final String DISTINCTE = "distinct-";
    public static final String ITE1 = "ite1";
    public static final String ITE2 = "ite2";
    public static final String REFL = "refl";
    public static final String SYMM = "symm";
    public static final String TRANS = "trans";
    public static final String CONG = "cong";
    public static final String EXPAND = "expand";
    public static final String DELANNOT = "del!";
    public static final String DIVISIBLEDEF = "divisible-def";
    public static final String GTDEF = ">def";
    public static final String GEQDEF = ">=def";
    public static final String TRICHOTOMY = "trichotomy";
    public static final String TOTAL = "total";
    public static final String TOTALINT = "total-int";
    public static final String FARKAS = "farkas";
    public static final String TOINTHIGH = "to_int-high";
    public static final String TOINTLOW = "to_int-low";
    public static final String MINUSDEF = "-def";
    public static final String DIVIDEDEF = "/def";
    public static final String POLYADD = "poly+";
    public static final String POLYMUL = "poly*";
    public static final String TOREALDEF = "to_real-def";
    public static final String DIVLOW = "div-low";
    public static final String DIVHIGH = "div-high";
    public static final String MODDEF = "mod-def";
    public static final String SELECTSTORE1 = "selectstore1";
    public static final String SELECTSTORE2 = "selectstore2";
    public static final String EXTDIFF = "extdiff";
    public static final String CONST = "const";
    public static final String DT_PROJECT = "dt-project";
    public static final String DT_CONS = "dt-cons";
    public static final String DT_TESTI = "dt-test+";
    public static final String DT_TESTE = "dt-test-";
    public static final String DT_EXHAUST = "dt-exhaust";
    public static final String DT_ACYCLIC = "dt-acyclic";
    public static final String DT_MATCH = "dt-match";
    public static final String PROOF = "Proof";
    public static final String CHOOSE = "choose";
    public static final String PREFIX = "..";
    public static final String ANNOT_VALUES = ":values";
    public static final String ANNOT_COEFFS = ":coeffs";
    public static final String ANNOT_DIVISOR = ":divisor";
    public static final String ANNOT_POS = ":pos";
    public static final String ANNOT_UNIT = ":unit";
    public static final String ANNOT_DEFINE_FUN = ":define-fun";
    public static final String ANNOT_DECLARE_FUN = ":declare-fun";
    private final Theory mTheory;
    private final Term mAxiom;

    public ProofRules(Theory theory) {
        this.mTheory = theory;
        this.setupTheory();
        this.mAxiom = theory.term("..axiom", new Term[0]);
    }

    private void setupTheory() {
        if (this.mTheory.getDeclaredSorts().containsKey("..Proof")) {
            return;
        }
        if (this.mTheory.getLogic().isArray() && !this.mTheory.getFunctionFactories().containsKey("@diff")) {
            Sort[] vars = this.mTheory.createSortVariables("Index", "Elem");
            Sort array = this.mTheory.getSort("Array", vars);
            this.mTheory.declareInternalPolymorphicFunction("@diff", vars, new Sort[]{array, array}, vars[0], 64);
        }
        this.mTheory.declareInternalSort("..Proof", 0, 0);
        Sort proofSort = this.mTheory.getSort("..Proof", new Sort[0]);
        Sort boolSort = this.mTheory.getBooleanSort();
        Sort[] generic = this.mTheory.createSortVariables("X");
        Sort[] bool1 = new Sort[]{boolSort};
        Sort[] sort0 = new Sort[]{};
        this.mTheory.declareInternalFunction("..res", new Sort[]{boolSort, proofSort, proofSort}, proofSort, 0);
        this.mTheory.declareInternalFunction("..axiom", sort0, proofSort, 0);
        this.mTheory.declareInternalFunction("..assume", bool1, proofSort, 0);
        this.mTheory.declareInternalPolymorphicFunction("..choose", generic, bool1, generic[0], 16);
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    private static boolean isKeyword(Object obj) {
        return obj instanceof String && ((String)obj).charAt(0) == ':';
    }

    static Annotation[] convertSExprToAnnotation(Object[] objects) {
        ArrayList<Annotation> annots = new ArrayList<Annotation>();
        for (int i = 0; i < objects.length; ++i) {
            assert (ProofRules.isKeyword(objects[i]));
            String keyword = (String)objects[i];
            Object value = null;
            if (i + 1 < objects.length && !ProofRules.isKeyword(objects[i + 1])) {
                value = objects[++i];
            }
            annots.add(new Annotation(keyword, value));
        }
        return annots.toArray(new Annotation[annots.size()]);
    }

    static Object[] convertAnnotationsToSExpr(Annotation[] annots) {
        ArrayList<Object> sexpr = new ArrayList<Object>();
        for (Annotation a : annots) {
            sexpr.add(a.getKey());
            if (a.getValue() == null) continue;
            sexpr.add(a.getValue());
        }
        return sexpr.toArray(new Object[sexpr.size()]);
    }

    public Term resolutionRule(Term pivot, Term proofPos, Term proofNeg) {
        return this.mTheory.term("..res", pivot, proofPos, proofNeg);
    }

    public Term asserted(Term t) {
        return this.mTheory.term("..assume", t);
    }

    public static Object[] convertProofLiteralsToAnnotation(ProofLiteral[] literals) {
        Object[] clause = new Object[2 * literals.length];
        for (int i = 0; i < literals.length; ++i) {
            clause[2 * i] = literals[i].getPolarity() ? "+" : "-";
            clause[2 * i + 1] = literals[i].getAtom();
        }
        return clause;
    }

    public static ProofLiteral[] proofLiteralsFromAnnotation(Object[] literals) {
        assert (literals.length % 2 == 0);
        ProofLiteral[] clause = new ProofLiteral[literals.length / 2];
        for (int i = 0; i < clause.length; ++i) {
            assert (literals[2 * i] == "+" || literals[2 * i] == "-");
            clause[i] = new ProofLiteral((Term)literals[2 * i + 1], literals[2 * i] == "+");
        }
        return clause;
    }

    public Term oracle(ProofLiteral[] literals, Annotation[] annots) {
        Object[] clause = ProofRules.convertProofLiteralsToAnnotation(literals);
        return this.mTheory.annotatedTerm(this.annotate(":oracle", clause, annots), this.mAxiom);
    }

    public Term choose(TermVariable tv, Term formula) {
        FunctionSymbol choose = this.mTheory.getFunctionWithResult("..choose", null, tv.getSort(), formula.getSort());
        return this.mTheory.term(choose, this.mTheory.lambda(new TermVariable[]{tv}, formula));
    }

    public Term[] getSkolemVars(TermVariable[] termVars, Term subterm, boolean isForall) {
        Term[] skolemTerms = new Term[termVars.length];
        FormulaUnLet unletter = new FormulaUnLet();
        for (int i = 0; i < skolemTerms.length; ++i) {
            Term subform = subterm;
            if (i + 1 < skolemTerms.length) {
                TermVariable[] remainingVars = new TermVariable[skolemTerms.length - i - 1];
                System.arraycopy(termVars, i + 1, remainingVars, 0, remainingVars.length);
                Term term = subform = isForall ? this.mTheory.forall(remainingVars, subform) : this.mTheory.exists(remainingVars, subform);
            }
            if (isForall) {
                subform = this.mTheory.term("not", subform);
            }
            if (i > 0) {
                TermVariable[] precedingVars = new TermVariable[i];
                Term[] precedingSkolems = new Term[i];
                System.arraycopy(termVars, 0, precedingVars, 0, i);
                System.arraycopy(skolemTerms, 0, precedingSkolems, 0, i);
                subform = unletter.unlet(this.mTheory.let(precedingVars, precedingSkolems, subform));
            }
            skolemTerms[i] = this.choose(termVars[i], subform);
        }
        return skolemTerms;
    }

    private Annotation[] annotate(String rule, Object value, Annotation ... moreAnnots) {
        Annotation[] annots = new Annotation[moreAnnots.length + 1];
        annots[0] = new Annotation(rule, value);
        System.arraycopy(moreAnnots, 0, annots, 1, moreAnnots.length);
        return annots;
    }

    public Term trueIntro() {
        return this.mTheory.annotatedTerm(this.annotate(":true+", null, new Annotation[0]), this.mAxiom);
    }

    public Term falseElim() {
        return this.mTheory.annotatedTerm(this.annotate(":false-", null, new Annotation[0]), this.mAxiom);
    }

    public Term notIntro(Term notTerm) {
        assert (notTerm instanceof TermVariable || ((ApplicationTerm)notTerm).getFunction().getName() == "not");
        return this.mTheory.annotatedTerm(this.annotate(":not+", notTerm, new Annotation[0]), this.mAxiom);
    }

    public Term notElim(Term notTerm) {
        assert (notTerm instanceof TermVariable || ((ApplicationTerm)notTerm).getFunction().getName() == "not");
        return this.mTheory.annotatedTerm(this.annotate(":not-", notTerm, new Annotation[0]), this.mAxiom);
    }

    public Term orIntro(int pos, Term orTerm) {
        assert (orTerm instanceof TermVariable || ((ApplicationTerm)orTerm).getFunction().getName() == "or");
        return this.mTheory.annotatedTerm(this.annotate(":or+", orTerm, new Annotation(ANNOT_POS, pos)), this.mAxiom);
    }

    public Term orElim(Term orTerm) {
        assert (orTerm instanceof TermVariable || ((ApplicationTerm)orTerm).getFunction().getName() == "or");
        return this.mTheory.annotatedTerm(this.annotate(":or-", orTerm, new Annotation[0]), this.mAxiom);
    }

    public Term andIntro(Term andTerm) {
        assert (andTerm instanceof TermVariable || ((ApplicationTerm)andTerm).getFunction().getName() == "and");
        return this.mTheory.annotatedTerm(this.annotate(":and+", andTerm, new Annotation[0]), this.mAxiom);
    }

    public Term andElim(int pos, Term andTerm) {
        assert (andTerm instanceof TermVariable || ((ApplicationTerm)andTerm).getFunction().getName() == "and");
        return this.mTheory.annotatedTerm(this.annotate(":and-", andTerm, new Annotation(ANNOT_POS, pos)), this.mAxiom);
    }

    public Term impIntro(int pos, Term impTerm) {
        assert (impTerm instanceof TermVariable || ((ApplicationTerm)impTerm).getFunction().getName() == "=>");
        return this.mTheory.annotatedTerm(this.annotate(":=>+", impTerm, new Annotation(ANNOT_POS, pos)), this.mAxiom);
    }

    public Term impElim(Term impTerm) {
        assert (impTerm instanceof TermVariable || ((ApplicationTerm)impTerm).getFunction().getName() == "=>");
        return this.mTheory.annotatedTerm(this.annotate(":=>-", impTerm, new Annotation[0]), this.mAxiom);
    }

    public Term iffIntro1(Term iffTerm) {
        assert (iffTerm instanceof TermVariable || ((ApplicationTerm)iffTerm).getFunction().getName() == "=" && ((ApplicationTerm)iffTerm).getParameters().length == 2 && ((ApplicationTerm)iffTerm).getParameters()[0].getSort().getName() == "Bool");
        return this.mTheory.annotatedTerm(this.annotate(":=+1", iffTerm, new Annotation[0]), this.mAxiom);
    }

    public Term iffIntro2(Term iffTerm) {
        assert (iffTerm instanceof TermVariable || ((ApplicationTerm)iffTerm).getFunction().getName() == "=" && ((ApplicationTerm)iffTerm).getParameters().length == 2 && ((ApplicationTerm)iffTerm).getParameters()[0].getSort().getName() == "Bool");
        return this.mTheory.annotatedTerm(this.annotate(":=+2", iffTerm, new Annotation[0]), this.mAxiom);
    }

    public Term iffElim1(Term iffTerm) {
        assert (iffTerm instanceof TermVariable || ((ApplicationTerm)iffTerm).getFunction().getName() == "=" && ((ApplicationTerm)iffTerm).getParameters().length == 2 && ((ApplicationTerm)iffTerm).getParameters()[0].getSort().getName() == "Bool");
        return this.mTheory.annotatedTerm(this.annotate(":=-1", iffTerm, new Annotation[0]), this.mAxiom);
    }

    public Term iffElim2(Term iffTerm) {
        assert (iffTerm instanceof TermVariable || ((ApplicationTerm)iffTerm).getFunction().getName() == "=" && ((ApplicationTerm)iffTerm).getParameters().length == 2 && ((ApplicationTerm)iffTerm).getParameters()[0].getSort().getName() == "Bool");
        return this.mTheory.annotatedTerm(this.annotate(":=-2", iffTerm, new Annotation[0]), this.mAxiom);
    }

    private Term xorAxiom(String name, Term[] ... xorArgs) {
        assert (ProofRules.checkXorParams(xorArgs));
        return this.mTheory.annotatedTerm(new Annotation[]{new Annotation(name, xorArgs)}, this.mAxiom);
    }

    public Term xorIntro(Term[] xorArgs1, Term[] xorArgs2, Term[] xorArgs3) {
        return this.xorAxiom(":xor+", xorArgs1, xorArgs2, xorArgs3);
    }

    public Term xorElim(Term[] xorArgs1, Term[] xorArgs2, Term[] xorArgs3) {
        return this.xorAxiom(":xor-", xorArgs1, xorArgs2, xorArgs3);
    }

    public Term forallIntro(QuantifiedFormula forallTerm) {
        assert (forallTerm.getQuantifier() == 1);
        return this.mTheory.annotatedTerm(this.annotate(":forall+", forallTerm, new Annotation[0]), this.mAxiom);
    }

    public Term forallElim(Term[] subst, QuantifiedFormula forallTerm) {
        assert (forallTerm.getQuantifier() == 1);
        return this.mTheory.annotatedTerm(this.annotate(":forall-", forallTerm, new Annotation(ANNOT_VALUES, subst)), this.mAxiom);
    }

    public Term existsIntro(Term[] subst, QuantifiedFormula existsTerm) {
        assert (existsTerm.getQuantifier() == 0);
        return this.mTheory.annotatedTerm(this.annotate(":exists+", existsTerm, new Annotation(ANNOT_VALUES, subst)), this.mAxiom);
    }

    public Term existsElim(QuantifiedFormula existsTerm) {
        assert (existsTerm.getQuantifier() == 0);
        return this.mTheory.annotatedTerm(this.annotate(":exists-", existsTerm, new Annotation[0]), this.mAxiom);
    }

    public Term equalsIntro(Term eqTerm) {
        assert (((ApplicationTerm)eqTerm).getFunction().getName() == "=");
        return this.mTheory.annotatedTerm(this.annotate(":=+", eqTerm, new Annotation[0]), this.mAxiom);
    }

    public Term equalsElim(int pos1, int pos2, Term eqTerm) {
        assert (((ApplicationTerm)eqTerm).getFunction().getName() == "=");
        assert (0 <= pos1 && pos1 < ((ApplicationTerm)eqTerm).getParameters().length);
        assert (0 <= pos2 && pos2 < ((ApplicationTerm)eqTerm).getParameters().length);
        return this.mTheory.annotatedTerm(this.annotate(":=-", eqTerm, new Annotation(ANNOT_POS, new Integer[]{pos1, pos2})), this.mAxiom);
    }

    public Term distinctIntro(Term disTerm) {
        assert (((ApplicationTerm)disTerm).getFunction().getName() == "distinct");
        return this.mTheory.annotatedTerm(this.annotate(":distinct+", disTerm, new Annotation[0]), this.mAxiom);
    }

    public Term distinctElim(int pos1, int pos2, Term disTerm) {
        assert (((ApplicationTerm)disTerm).getFunction().getName() == "distinct");
        assert (0 <= pos1 && pos1 < ((ApplicationTerm)disTerm).getParameters().length);
        assert (0 <= pos2 && pos2 < ((ApplicationTerm)disTerm).getParameters().length);
        return this.mTheory.annotatedTerm(this.annotate(":distinct-", disTerm, new Annotation(ANNOT_POS, new Integer[]{pos1, pos2})), this.mAxiom);
    }

    public Term refl(Term term) {
        return this.mTheory.annotatedTerm(this.annotate(":refl", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public Term symm(Term term1, Term term2) {
        return this.mTheory.annotatedTerm(this.annotate(":symm", new Term[]{term1, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term trans(Term ... terms) {
        assert (terms.length > 2);
        return this.mTheory.annotatedTerm(this.annotate(":trans", terms, new Annotation[0]), this.mAxiom);
    }

    public Term cong(FunctionSymbol func, Term[] params1, Term[] params2) {
        assert (params1.length == params2.length);
        Annotation[] annot = new Annotation[]{new Annotation(":cong", new Object[]{func, params1, params2})};
        return this.mTheory.annotatedTerm(annot, this.mAxiom);
    }

    public Term cong(Term term1, Term term2) {
        ApplicationTerm app1 = (ApplicationTerm)term1;
        ApplicationTerm app2 = (ApplicationTerm)term2;
        assert (app1.getFunction() == app2.getFunction());
        return this.cong(app1.getFunction(), app1.getParameters(), app2.getParameters());
    }

    public Term expand(Term term) {
        Annotation[] annot = new Annotation[]{new Annotation(":expand", new Object[]{((ApplicationTerm)term).getFunction(), ((ApplicationTerm)term).getParameters()})};
        return this.mTheory.annotatedTerm(annot, this.mAxiom);
    }

    public Term ite1(Term iteTerm) {
        assert (iteTerm instanceof TermVariable || ((ApplicationTerm)iteTerm).getFunction().getName() == "ite");
        return this.mTheory.annotatedTerm(this.annotate(":ite1", iteTerm, new Annotation[0]), this.mAxiom);
    }

    public Term ite2(Term iteTerm) {
        assert (iteTerm instanceof TermVariable || ((ApplicationTerm)iteTerm).getFunction().getName() == "ite");
        return this.mTheory.annotatedTerm(this.annotate(":ite2", iteTerm, new Annotation[0]), this.mAxiom);
    }

    public Term delAnnot(Term annotTerm) {
        Term subterm = ((AnnotatedTerm)annotTerm).getSubterm();
        Object[] subAnnots = ProofRules.convertAnnotationsToSExpr(((AnnotatedTerm)annotTerm).getAnnotations());
        return this.mTheory.annotatedTerm(this.annotate(":del!", new Object[]{subterm, subAnnots}, new Annotation[0]), this.mAxiom);
    }

    public Term divisible(BigInteger divisor, Term lhs) {
        assert (divisor.signum() > 0);
        assert (lhs.getSort().getName().equals("Int"));
        return this.mTheory.annotatedTerm(this.annotate(":divisible-def", new Term[]{lhs}, new Annotation(ANNOT_DIVISOR, divisor)), this.mAxiom);
    }

    public Term gtDef(Term greaterTerm) {
        assert (((ApplicationTerm)greaterTerm).getFunction().getName() == ">");
        return this.mTheory.annotatedTerm(this.annotate(":>def", ((ApplicationTerm)greaterTerm).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term geqDef(Term greaterTerm) {
        assert (((ApplicationTerm)greaterTerm).getFunction().getName() == ">=");
        return this.mTheory.annotatedTerm(this.annotate(":>=def", ((ApplicationTerm)greaterTerm).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term trichotomy(Term lhs, Term rhs) {
        return this.mTheory.annotatedTerm(this.annotate(":trichotomy", new Term[]{lhs, rhs}, new Annotation[0]), this.mAxiom);
    }

    public Term total(Term lhs, Term rhs) {
        return this.mTheory.annotatedTerm(this.annotate(":total", new Term[]{lhs, rhs}, new Annotation[0]), this.mAxiom);
    }

    public Term totalInt(Term x, BigInteger c) {
        return this.mTheory.annotatedTerm(this.annotate(":total-int", new Object[]{x, c}, new Annotation[0]), this.mAxiom);
    }

    public Term farkas(Term[] inequalities, BigInteger[] coefficients) {
        return this.mTheory.annotatedTerm(this.annotate(":farkas", inequalities, new Annotation(ANNOT_COEFFS, coefficients)), this.mAxiom);
    }

    public Term polyAdd(Term plusTerm, Term result) {
        return this.mTheory.annotatedTerm(this.annotate(":poly+", new Term[]{plusTerm, result}, new Annotation[0]), this.mAxiom);
    }

    public Term polyMul(Term mulTerm, Term result) {
        return this.mTheory.annotatedTerm(this.annotate(":poly*", new Term[]{mulTerm, result}, new Annotation[0]), this.mAxiom);
    }

    public Term toRealDef(Term toRealTerm) {
        assert (ProofRules.isApplication("to_real", toRealTerm));
        return this.mTheory.annotatedTerm(this.annotate(":to_real-def", ((ApplicationTerm)toRealTerm).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term divideDef(Term divTerm) {
        assert (ProofRules.isApplication("/", divTerm));
        return this.mTheory.annotatedTerm(this.annotate(":/def", ((ApplicationTerm)divTerm).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term minusDef(Term minusTerm) {
        assert (ProofRules.isApplication("-", minusTerm));
        return this.mTheory.annotatedTerm(this.annotate(":-def", ((ApplicationTerm)minusTerm).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term toIntLow(Term arg) {
        assert (arg.getSort().getSortSymbol().getName().equals("Real"));
        return this.mTheory.annotatedTerm(this.annotate(":to_int-low", new Term[]{arg}, new Annotation[0]), this.mAxiom);
    }

    public Term toIntHigh(Term arg) {
        assert (arg.getSort().getSortSymbol().getName().equals("Real"));
        return this.mTheory.annotatedTerm(this.annotate(":to_int-high", new Term[]{arg}, new Annotation[0]), this.mAxiom);
    }

    public Term divLow(Term arg, Term divisor) {
        assert (arg.getSort().getSortSymbol().getName().equals("Int"));
        assert (divisor.getSort() == arg.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":div-low", new Term[]{arg, divisor}, new Annotation[0]), this.mAxiom);
    }

    public Term divHigh(Term arg, Term divisor) {
        assert (arg.getSort().getSortSymbol().getName().equals("Int"));
        assert (divisor.getSort() == arg.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":div-high", new Term[]{arg, divisor}, new Annotation[0]), this.mAxiom);
    }

    public Term modDef(Term arg, Term divisor) {
        assert (arg.getSort().getSortSymbol().getName().equals("Int"));
        assert (divisor.getSort() == arg.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":mod-def", new Term[]{arg, divisor}, new Annotation[0]), this.mAxiom);
    }

    public Term selectStore1(Term array, Term index, Term value) {
        assert (array.getSort().getSortSymbol().getName().equals("Array"));
        assert (array.getSort().getArguments()[0] == index.getSort());
        assert (array.getSort().getArguments()[1] == value.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":selectstore1", new Term[]{array, index, value}, new Annotation[0]), this.mAxiom);
    }

    public Term selectStore2(Term array, Term index, Term value, Term index2) {
        assert (array.getSort().getSortSymbol().getName().equals("Array"));
        assert (array.getSort().getArguments()[0] == index.getSort());
        assert (array.getSort().getArguments()[1] == value.getSort());
        assert (array.getSort().getArguments()[0] == index2.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":selectstore2", new Term[]{array, index, value, index2}, new Annotation[0]), this.mAxiom);
    }

    public Term extDiff(Term array1, Term array2) {
        assert (array1.getSort() == array2.getSort());
        assert (array1.getSort().getSortSymbol().getName().equals("Array"));
        return this.mTheory.annotatedTerm(this.annotate(":extdiff", new Term[]{array1, array2}, new Annotation[0]), this.mAxiom);
    }

    public Term constArray(Term constValue, Term index) {
        return this.mTheory.annotatedTerm(this.annotate(":const", new Term[]{constValue, index}, new Annotation[0]), this.mAxiom);
    }

    public Term defineFun(FunctionSymbol func, Term definition, Term subProof) {
        return this.mTheory.annotatedTerm(new Annotation[]{new Annotation(ANNOT_DEFINE_FUN, new Object[]{func, definition})}, subProof);
    }

    public Term declareFun(FunctionSymbol func, Term subProof) {
        return this.mTheory.annotatedTerm(new Annotation[]{new Annotation(ANNOT_DECLARE_FUN, new Object[]{func})}, subProof);
    }

    public Term dtProject(Term selConsTerm) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-project", new Term[]{selConsTerm}, new Annotation[0]), this.mAxiom);
    }

    public Term dtCons(Term isConsTerm) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-cons", new Term[]{isConsTerm}, new Annotation[0]), this.mAxiom);
    }

    public Term dtTestI(Term consTerm) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-test+", new Term[]{consTerm}, new Annotation[0]), this.mAxiom);
    }

    public Term dtTestE(String otherConstructor, Term consTerm) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-test-", new Object[]{otherConstructor, consTerm}, new Annotation[0]), this.mAxiom);
    }

    public Term dtExhaust(Term term) {
        assert (term.getSort().getSortSymbol() instanceof DataType);
        return this.mTheory.annotatedTerm(this.annotate(":dt-exhaust", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public Term dtAcyclic(Term consTerm, int[] positions) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-acyclic", new Object[]{consTerm, positions}, new Annotation[0]), this.mAxiom);
    }

    public Term dtMatch(Term matchTerm) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-match", new Term[]{matchTerm}, new Annotation[0]), this.mAxiom);
    }

    public static void printProof(Appendable appender, Term proof) {
        new PrintProof().append(appender, proof);
    }

    private static boolean isApplication(String funcName, Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol func = ((ApplicationTerm)term).getFunction();
            return func.isIntern() && func.getName().equals(funcName);
        }
        return false;
    }

    public static boolean checkPolyAdd(Term plusTerm, Term result) {
        if (!ProofRules.isApplication("+", plusTerm)) {
            return false;
        }
        Polynomial poly = new Polynomial();
        for (Term t : ((ApplicationTerm)plusTerm).getParameters()) {
            poly.add(Rational.ONE, t);
        }
        poly.add(Rational.MONE, result);
        return poly.isZero();
    }

    public static boolean checkPolyMul(Term mulTerm, Term result) {
        if (!ProofRules.isApplication("*", mulTerm)) {
            return false;
        }
        Polynomial poly = new Polynomial();
        poly.add(Rational.ONE);
        for (Term t : ((ApplicationTerm)mulTerm).getParameters()) {
            poly.mul(new Polynomial(t));
        }
        poly.add(Rational.MONE, result);
        return poly.isZero();
    }

    private static Term computeFactorToReal(Term factor) {
        if (factor instanceof ConstantTerm && ((ConstantTerm)factor).getValue() instanceof Rational) {
            return ((Rational)((ConstantTerm)factor).getValue()).toTerm(factor.getTheory().getSort("Real", new Sort[0]));
        }
        return factor.getTheory().term("to_real", factor);
    }

    private static Term computeMonomialToReal(Term monomial) {
        if (ProofRules.isApplication("*", monomial)) {
            Term[] oldParams = ((ApplicationTerm)monomial).getParameters();
            Term[] newParams = new Term[oldParams.length];
            for (int i = 0; i < oldParams.length; ++i) {
                newParams[i] = ProofRules.computeFactorToReal(oldParams[i]);
            }
            return monomial.getTheory().term("*", newParams);
        }
        return ProofRules.computeFactorToReal(monomial);
    }

    public static Term computePolyToReal(Term poly) {
        if (ProofRules.isApplication("+", poly)) {
            Term[] oldParams = ((ApplicationTerm)poly).getParameters();
            Term[] newParams = new Term[oldParams.length];
            for (int i = 0; i < oldParams.length; ++i) {
                newParams[i] = ProofRules.computeMonomialToReal(oldParams[i]);
            }
            return poly.getTheory().term("+", newParams);
        }
        return ProofRules.computeMonomialToReal(poly);
    }

    public static Term computePolyMinus(Term minusTerm) {
        assert (ProofRules.isApplication("-", minusTerm));
        Theory theory = minusTerm.getTheory();
        Term[] params = ((ApplicationTerm)minusTerm).getParameters();
        Term minusOne = Rational.MONE.toTerm(minusTerm.getSort());
        if (params.length == 1) {
            return theory.term("*", minusOne, params[0]);
        }
        Term[] rhsParams = new Term[params.length];
        rhsParams[0] = params[0];
        for (int i = 1; i < params.length; ++i) {
            rhsParams[i] = theory.term("*", minusOne, params[i]);
        }
        return theory.term("+", rhsParams);
    }

    public static boolean checkFarkas(Term[] inequalities, BigInteger[] coefficients) {
        if (inequalities.length != coefficients.length) {
            return false;
        }
        Polynomial sum = new Polynomial();
        boolean strict = false;
        for (int i = 0; i < inequalities.length; ++i) {
            if (coefficients[i].signum() != 1) {
                return false;
            }
            if (!(ProofRules.isApplication("<", inequalities[i]) || ProofRules.isApplication("<=", inequalities[i]) || ProofRules.isApplication("=", inequalities[i]))) {
                return false;
            }
            ApplicationTerm appTerm = (ApplicationTerm)inequalities[i];
            Term[] params = appTerm.getParameters();
            if (params.length != 2) {
                return false;
            }
            if (appTerm.getFunction().getName() == "<") {
                strict = true;
            }
            Rational coeff = Rational.valueOf(coefficients[i], BigInteger.ONE);
            sum.add(coeff, params[0]);
            sum.add(coeff.negate(), params[1]);
        }
        boolean okay = sum.isConstant() && sum.getConstant().signum() >= (strict ? 0 : 1);
        return okay;
    }

    public static boolean checkXorParams(Term[][] xorArgs) {
        assert (xorArgs.length == 3);
        HashSet<Term> xorSum = new HashSet<Term>();
        Term[][] termArray = xorArgs;
        int n = termArray.length;
        for (int i = 0; i < n; ++i) {
            Term[] args;
            for (Term arg : args = termArray[i]) {
                if (xorSum.contains(arg)) {
                    xorSum.remove(arg);
                    continue;
                }
                xorSum.add(arg);
            }
        }
        return xorSum.isEmpty();
    }

    public static boolean checkConstructorPath(Term consTerm, int[] positions) {
        if (positions.length == 0) {
            return false;
        }
        for (int pos : positions) {
            ApplicationTerm term = (ApplicationTerm)consTerm;
            if (!term.getFunction().isConstructor() || pos < 0 || pos >= term.getParameters().length) {
                return false;
            }
            consTerm = term.getParameters()[pos];
        }
        return true;
    }

    public static boolean isAxiom(Term proof) {
        return proof instanceof AnnotatedTerm && ProofRules.isApplication("..axiom", ((AnnotatedTerm)proof).getSubterm());
    }

    public static boolean isOracle(Term proof) {
        return ProofRules.isAxiom(proof) && ((AnnotatedTerm)proof).getAnnotations()[0].getKey().equals(":oracle");
    }

    public static boolean isProofRule(String rule, Term proof) {
        return proof instanceof ApplicationTerm && ((ApplicationTerm)proof).getFunction().getName().equals(PREFIX + rule);
    }

    public static boolean isDefineFun(Term proof) {
        return proof instanceof AnnotatedTerm && ((AnnotatedTerm)proof).getAnnotations()[0].getKey() == ANNOT_DEFINE_FUN;
    }

    public static boolean isDeclareFun(Term proof) {
        return proof instanceof AnnotatedTerm && ((AnnotatedTerm)proof).getAnnotations()[0].getKey() == ANNOT_DECLARE_FUN;
    }

    public static boolean isProof(Term proof) {
        return proof.getSort().isInternal() && proof.getSort().getName().equals("..Proof");
    }

    public static class PrintProof
    extends PrintTerm {
        @Override
        public void walkTerm(Term proof) {
            if (proof instanceof AnnotatedTerm) {
                AnnotatedTerm annotTerm = (AnnotatedTerm)proof;
                Annotation[] annots = annotTerm.getAnnotations();
                if (annots.length == 1 && annots[0].getKey() == ProofRules.ANNOT_DEFINE_FUN) {
                    Object[] annotVal = (Object[])annots[0].getValue();
                    assert (annotVal.length == 2);
                    FunctionSymbol func = (FunctionSymbol)annotVal[0];
                    LambdaTerm definition = (LambdaTerm)annotVal[1];
                    this.mTodo.add(")");
                    this.mTodo.add(annotTerm.getSubterm());
                    this.mTodo.add(" ");
                    this.mTodo.add(")");
                    this.mTodo.add(definition.getSubterm());
                    this.mTodo.add(") ");
                    TermVariable[] vars = definition.getVariables();
                    for (int i = vars.length - 1; i >= 0; --i) {
                        this.mTodo.add(")");
                        this.mTodo.add(vars[i].getSort());
                        this.mTodo.add(" ");
                        this.mTodo.add(vars[i]);
                        this.mTodo.add(i == 0 ? "(" : " (");
                    }
                    this.mTodo.add(" (");
                    this.mTodo.add(func.getApplicationString());
                    this.mTodo.add("((" + annots[0].getKey().substring(1) + " ");
                    return;
                }
                if (annots.length == 1 && annots[0].getKey() == ProofRules.ANNOT_DECLARE_FUN) {
                    Object[] annotVal = (Object[])annots[0].getValue();
                    assert (annotVal.length == 1);
                    FunctionSymbol func = (FunctionSymbol)annotVal[0];
                    this.mTodo.add(")");
                    this.mTodo.add(annotTerm.getSubterm());
                    this.mTodo.add(" ");
                    this.mTodo.add(")");
                    this.mTodo.add(func.getReturnSort());
                    this.mTodo.add(") ");
                    Sort[] paramSorts = func.getParameterSorts();
                    for (int i = paramSorts.length - 1; i >= 0; --i) {
                        this.mTodo.add(paramSorts[i]);
                        if (i <= 0) continue;
                        this.mTodo.add(" ");
                    }
                    this.mTodo.add(" (");
                    this.mTodo.add(func.getApplicationString());
                    this.mTodo.add("((" + annots[0].getKey().substring(1) + " ");
                    return;
                }
                if (annotTerm.getSubterm() instanceof ApplicationTerm && ((ApplicationTerm)annotTerm.getSubterm()).getFunction().getName() == "..axiom") {
                    switch (annots[0].getKey()) {
                        case ":oracle": {
                            assert (annots.length >= 1);
                            Object[] clause = (Object[])annots[0].getValue();
                            this.mTodo.add(")");
                            for (int i = annots.length - 1; i >= 1; --i) {
                                if (annots[i].getValue() != null) {
                                    this.mTodo.add(annots[i].getValue());
                                    this.mTodo.add(" ");
                                }
                                this.mTodo.add(annots[i].getKey());
                                this.mTodo.add(" ");
                            }
                            this.mTodo.add(clause);
                            this.mTodo.add("(" + annots[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":true+": 
                        case ":false-": {
                            assert (annots.length == 1);
                            assert (annots[0].getValue() == null);
                            this.mTodo.add(annots[0].getKey().substring(1));
                            return;
                        }
                        case ":not+": 
                        case ":not-": 
                        case ":or-": 
                        case ":and+": 
                        case ":=>-": 
                        case ":=+1": 
                        case ":=+2": 
                        case ":=-1": 
                        case ":=-2": 
                        case ":ite1": 
                        case ":ite2": 
                        case ":=+": 
                        case ":distinct+": {
                            assert (annots.length == 1);
                            Term param = (Term)annots[0].getValue();
                            this.mTodo.add(")");
                            this.mTodo.add(param);
                            this.mTodo.add("(" + annots[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":refl": 
                        case ":symm": 
                        case ":trans": 
                        case ":>def": 
                        case ":>=def": 
                        case ":trichotomy": 
                        case ":total": 
                        case ":poly+": 
                        case ":poly*": 
                        case ":/def": 
                        case ":-def": 
                        case ":to_real-def": 
                        case ":to_int-low": 
                        case ":to_int-high": 
                        case ":div-low": 
                        case ":div-high": 
                        case ":mod-def": 
                        case ":selectstore1": 
                        case ":selectstore2": 
                        case ":extdiff": 
                        case ":const": 
                        case ":dt-project": 
                        case ":dt-cons": 
                        case ":dt-test+": 
                        case ":dt-exhaust": 
                        case ":dt-match": {
                            assert (annots.length == 1);
                            Term[] params = (Term[])annots[0].getValue();
                            this.mTodo.add(")");
                            for (int i = params.length - 1; i >= 0; --i) {
                                this.mTodo.add(params[i]);
                                this.mTodo.add(" ");
                            }
                            this.mTodo.add("(" + annots[0].getKey().substring(1));
                            return;
                        }
                        case ":or+": 
                        case ":and-": 
                        case ":=>+": {
                            Term param = (Term)annots[0].getValue();
                            assert (annots.length == 2);
                            assert (annots[1].getKey() == ProofRules.ANNOT_POS);
                            this.mTodo.add(")");
                            this.mTodo.add(param);
                            this.mTodo.add(" ");
                            this.mTodo.add(annots[1].getValue());
                            this.mTodo.add("(" + annots[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":=-": 
                        case ":distinct-": {
                            Term param = (Term)annots[0].getValue();
                            assert (annots.length == 2);
                            assert (annots[1].getKey() == ProofRules.ANNOT_POS);
                            Integer[] positions = (Integer[])annots[1].getValue();
                            this.mTodo.add(")");
                            this.mTodo.add(param);
                            this.mTodo.add(" ");
                            this.mTodo.add(positions[0] + " " + positions[1]);
                            this.mTodo.add("(" + annots[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":cong": {
                            int i;
                            assert (annots.length == 1);
                            Object[] congArgs = (Object[])annots[0].getValue();
                            assert (congArgs.length == 3);
                            FunctionSymbol func = (FunctionSymbol)congArgs[0];
                            Term[] params1 = (Term[])congArgs[1];
                            Term[] params2 = (Term[])congArgs[2];
                            this.mTodo.add("))");
                            for (i = params2.length - 1; i >= 0; --i) {
                                this.mTodo.add(params2[i]);
                                this.mTodo.add(" ");
                            }
                            this.mTodo.add(func.getApplicationString());
                            this.mTodo.add(") (");
                            for (i = params1.length - 1; i >= 0; --i) {
                                this.mTodo.add(params1[i]);
                                this.mTodo.add(" ");
                            }
                            this.mTodo.add(func.getApplicationString());
                            this.mTodo.add("(" + annots[0].getKey().substring(1) + " (");
                            return;
                        }
                        case ":xor+": 
                        case ":xor-": {
                            assert (annots.length == 1);
                            Term[][] xorLists = (Term[][])annots[0].getValue();
                            assert (xorLists.length == 3);
                            this.mTodo.add(")");
                            for (int i = 2; i >= 0; --i) {
                                this.mTodo.add(")");
                                for (int j = xorLists[i].length - 1; j >= 0; --j) {
                                    this.mTodo.add(xorLists[i][j]);
                                    if (j <= 0) continue;
                                    this.mTodo.add(" ");
                                }
                                this.mTodo.add(" (");
                            }
                            this.mTodo.add("(" + annots[0].getKey().substring(1));
                            return;
                        }
                        case ":expand": {
                            assert (annots.length == 1);
                            Object[] expandParams = (Object[])annots[0].getValue();
                            assert (expandParams.length == 2);
                            FunctionSymbol func = (FunctionSymbol)expandParams[0];
                            Term[] params = (Term[])expandParams[1];
                            this.mTodo.add(")");
                            if (params.length > 0) {
                                this.mTodo.add(")");
                                for (int i = params.length - 1; i >= 0; --i) {
                                    this.mTodo.add(params[i]);
                                    this.mTodo.add(" ");
                                }
                                this.mTodo.add(func.getApplicationString());
                                this.mTodo.add("(");
                            } else {
                                this.mTodo.add(func.getApplicationString());
                            }
                            this.mTodo.add("(" + annots[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":forall-": 
                        case ":exists+": {
                            assert (annots.length == 2);
                            Term quant = (Term)annots[0].getValue();
                            assert (annots[1].getKey() == ProofRules.ANNOT_VALUES);
                            Term[] values = (Term[])annots[1].getValue();
                            this.mTodo.add(")");
                            this.mTodo.add(quant);
                            this.mTodo.add(") ");
                            for (int i = values.length - 1; i >= 0; --i) {
                                this.mTodo.add(values[i]);
                                if (i <= 0) continue;
                                this.mTodo.add(" ");
                            }
                            this.mTodo.add("(" + annots[0].getKey().substring(1) + " (");
                            return;
                        }
                        case ":forall+": 
                        case ":exists-": {
                            assert (annots.length == 1);
                            Term quant = (Term)annots[0].getValue();
                            this.mTodo.add(")");
                            this.mTodo.add(quant);
                            this.mTodo.add("(" + annots[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":del!": {
                            this.mTodo.add("))");
                            assert (annots.length == 1);
                            Object[] params = (Object[])annots[0].getValue();
                            assert (params.length == 2);
                            Term subterm = (Term)params[0];
                            Object[] subAnnots = (Object[])params[1];
                            for (int i = subAnnots.length - 1; i >= 0; --i) {
                                this.mTodo.addLast(subAnnots[i]);
                                this.mTodo.addLast(" ");
                            }
                            this.mTodo.addLast(subterm);
                            this.mTodo.add("(del! (! ");
                            return;
                        }
                        case ":divisible-def": {
                            assert (annots.length == 2);
                            Term[] params = (Term[])annots[0].getValue();
                            assert (params.length == 1);
                            assert (annots[1].getKey() == ProofRules.ANNOT_DIVISOR);
                            this.mTodo.add(")");
                            this.mTodo.add(annots[1].getValue());
                            this.mTodo.add(" ");
                            for (int i = params.length - 1; i >= 0; --i) {
                                this.mTodo.add(params[i]);
                                this.mTodo.add(" ");
                            }
                            this.mTodo.add("(" + annots[0].getKey().substring(1));
                            return;
                        }
                        case ":total-int": {
                            Object[] params = (Object[])annots[0].getValue();
                            BigInteger c = (BigInteger)params[1];
                            Term x = (Term)params[0];
                            assert (annots.length == 1);
                            this.mTodo.add(")");
                            if (c.signum() < 0) {
                                this.mTodo.add("(- " + c.abs().toString() + ")");
                            } else {
                                this.mTodo.add(c);
                            }
                            this.mTodo.add(" ");
                            this.mTodo.add(x);
                            this.mTodo.add("(" + annots[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":farkas": {
                            Term[] params = (Term[])annots[0].getValue();
                            assert (annots.length == 2);
                            assert (annots[1].getKey() == ProofRules.ANNOT_COEFFS);
                            BigInteger[] coeffs = (BigInteger[])annots[1].getValue();
                            assert (params.length == coeffs.length);
                            this.mTodo.add(")");
                            for (int i = params.length - 1; i >= 0; --i) {
                                this.mTodo.add(params[i]);
                                this.mTodo.add(" ");
                                this.mTodo.add(coeffs[i]);
                                this.mTodo.add(" ");
                            }
                            this.mTodo.add("(" + annots[0].getKey().substring(1));
                            return;
                        }
                        case ":dt-test-": {
                            assert (annots.length == 1);
                            Object[] params = (Object[])annots[0].getValue();
                            assert (params.length == 2);
                            this.mTodo.add(")");
                            this.mTodo.add(params[1]);
                            this.mTodo.add(" ");
                            this.mTodo.add(params[0]);
                            this.mTodo.add("(dt-test- ");
                            return;
                        }
                        case ":dt-acyclic": {
                            assert (annots.length == 1);
                            Object[] params = (Object[])annots[0].getValue();
                            assert (params.length == 2);
                            int[] positions = (int[])params[1];
                            assert (positions.length > 0);
                            this.mTodo.add("))");
                            for (int i = positions.length - 1; i >= 1; --i) {
                                this.mTodo.add(" " + positions[i]);
                            }
                            this.mTodo.add(" (" + positions[0]);
                            this.mTodo.add(params[0]);
                            this.mTodo.add("(dt-acyclic ");
                            return;
                        }
                    }
                }
            }
            if (proof instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)proof;
                Term[] params = appTerm.getParameters();
                switch (appTerm.getFunction().getName()) {
                    case "..res": {
                        assert (params.length == 3);
                        this.mTodo.add(")");
                        for (int i = params.length - 1; i >= 0; --i) {
                            this.mTodo.add(params[i]);
                            this.mTodo.add(" ");
                        }
                        this.mTodo.add("(res");
                        return;
                    }
                    case "..choose": {
                        assert (params.length == 1);
                        LambdaTerm lambda = (LambdaTerm)params[0];
                        assert (lambda.getVariables().length == 1);
                        this.mTodo.add(")");
                        this.mTodo.add(lambda.getSubterm());
                        this.mTodo.add(") ");
                        this.mTodo.add(lambda.getVariables()[0].getSort());
                        this.mTodo.add(" ");
                        this.mTodo.add(lambda.getVariables()[0]);
                        this.mTodo.add("(choose (");
                        return;
                    }
                    case "..assume": {
                        assert (params.length == 1);
                        this.mTodo.add(")");
                        this.mTodo.add(params[0]);
                        this.mTodo.add("(assume ");
                        return;
                    }
                }
            }
            if (proof instanceof LetTerm) {
                int i;
                LetTerm let = (LetTerm)proof;
                TermVariable[] vars = let.getVariables();
                Term[] values = let.getValues();
                boolean hasLetProof = false;
                boolean hasLetTerm = false;
                for (int i2 = 0; i2 < vars.length; ++i2) {
                    if (ProofRules.isProof(values[i2])) {
                        hasLetProof = true;
                        continue;
                    }
                    hasLetTerm = true;
                }
                if (hasLetTerm) {
                    this.mTodo.addLast(")");
                }
                if (hasLetProof) {
                    this.mTodo.addLast(")");
                }
                this.mTodo.addLast(let.getSubTerm());
                if (hasLetProof) {
                    String sep = ")) ";
                    for (i = values.length - 1; i >= 0; --i) {
                        if (!ProofRules.isProof(values[i])) continue;
                        this.mTodo.addLast(sep);
                        this.mTodo.addLast(values[i]);
                        this.mTodo.addLast("(" + vars[i].toString() + " ");
                        sep = ") ";
                    }
                    this.mTodo.addLast("(let-proof (");
                }
                if (hasLetTerm) {
                    String sep = ")) ";
                    for (i = values.length - 1; i >= 0; --i) {
                        if (ProofRules.isProof(values[i])) continue;
                        this.mTodo.addLast(sep);
                        this.mTodo.addLast(values[i]);
                        this.mTodo.addLast("(" + vars[i].toString() + " ");
                        sep = ") ";
                    }
                    this.mTodo.addLast("(let (");
                }
                return;
            }
            super.walkTerm(proof);
        }
    }
}

