/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.CongRewriteFunctionFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.MinimalProofChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.Polynomial;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProofSimplifier
extends TermTransformer {
    Script mSkript;
    ProofRules mProofRules;
    LogProxy mLogger;
    private final MinimalProofChecker mChecker;
    private HashMap<FunctionSymbol, LambdaTerm> mAuxDefs;
    private static final String ANNOT_PROVES_CLAUSE = ":proves";
    private static final String ANNOT_PROVED_EQ = ":provedEq";

    public ProofSimplifier(Script script) {
        this.mSkript = script;
        this.mProofRules = new ProofRules(script.getTheory());
        this.mLogger = new DefaultLogger();
        this.mChecker = new MinimalProofChecker(this.mSkript, new DefaultLogger());
    }

    private Term annotateProvedClause(Term proof, Annotation annot, ProofLiteral[] clause) {
        Object[] clauseAnnot = new Object[clause.length * 2];
        for (int i = 0; i < clause.length; ++i) {
            clauseAnnot[2 * i] = clause[i].getPolarity() ? "+" : "-";
            clauseAnnot[2 * i + 1] = clause[i].getAtom();
        }
        return this.mSkript.annotate(proof, new Annotation(ANNOT_PROVES_CLAUSE, clauseAnnot), annot);
    }

    private Term annotateProved(Term provedTerm, Term proof) {
        return this.mSkript.annotate(proof, new Annotation(ANNOT_PROVED_EQ, provedTerm));
    }

    private Term provedTerm(AnnotatedTerm annotatedTerm) {
        assert (annotatedTerm.getAnnotations()[0].getKey() == ANNOT_PROVED_EQ);
        return (Term)annotatedTerm.getAnnotations()[0].getValue();
    }

    private Term stripAnnotation(Term term) {
        if (term instanceof AnnotatedTerm && ((AnnotatedTerm)term).getAnnotations()[0].getKey() == ANNOT_PROVED_EQ) {
            return ((AnnotatedTerm)term).getSubterm();
        }
        return term;
    }

    private Term subproof(AnnotatedTerm annotatedTerm) {
        assert (annotatedTerm.getAnnotations()[0].getKey() == ANNOT_PROVED_EQ);
        return annotatedTerm.getSubterm();
    }

    private boolean checkProof(Term proof, ProofLiteral[] expectedLits) {
        ProofLiteral[] actual = this.mChecker.getProvedClause(this.mAuxDefs, proof);
        HashSet<ProofLiteral> expectedSet = new HashSet<ProofLiteral>();
        expectedSet.addAll(Arrays.asList(expectedLits));
        assert (expectedSet.size() == actual.length);
        for (ProofLiteral lit : actual) {
            assert (expectedSet.contains(lit));
        }
        return true;
    }

    private Term removeNot(Term proof, Term candidateTerm, boolean positive) {
        while (this.isApplication("not", candidateTerm)) {
            proof = this.mProofRules.resolutionRule(candidateTerm, positive ? proof : this.mProofRules.notIntro(candidateTerm), positive ? this.mProofRules.notElim(candidateTerm) : proof);
            candidateTerm = ((ApplicationTerm)candidateTerm).getParameters()[0];
            positive = !positive;
        }
        return proof;
    }

    private Term convertTermITE(ProofLiteral[] clause) {
        int lastPos = clause.length - 1;
        assert (clause[lastPos].getPolarity() && this.isApplication("=", clause[lastPos].getAtom()));
        ApplicationTerm iteEquality = (ApplicationTerm)clause[lastPos].getAtom();
        Term iteTerm = iteEquality.getParameters()[0];
        Term goal = iteEquality.getParameters()[1];
        ArrayList<Term> intermediates = new ArrayList<Term>();
        ArrayList<Term> proofs = new ArrayList<Term>();
        HashMap<Term, ProofLiteral> conditionLits = new HashMap<Term, ProofLiteral>();
        for (int i = 0; i < clause.length - 1; ++i) {
            conditionLits.put(clause[i].getAtom(), clause[i]);
        }
        while (iteTerm != goal) {
            assert (this.isApplication("ite", iteTerm));
            intermediates.add(iteTerm);
            Term[] iteParams = ((ApplicationTerm)iteTerm).getParameters();
            Term condition = iteParams[0];
            boolean conditionPositive = true;
            while (this.isApplication("not", condition)) {
                condition = ((ApplicationTerm)condition).getParameters()[0];
                conditionPositive = !conditionPositive;
            }
            ProofLiteral clauseLit = (ProofLiteral)conditionLits.get(condition);
            if (conditionPositive == clauseLit.getPolarity()) {
                proofs.add(this.removeNot(this.mProofRules.ite2(iteTerm), iteParams[0], true));
                iteTerm = iteParams[2];
                continue;
            }
            proofs.add(this.removeNot(this.mProofRules.ite1(iteTerm), iteParams[0], false));
            iteTerm = iteParams[1];
        }
        assert (iteTerm == goal);
        if (proofs.size() > 1) {
            Theory t = goal.getTheory();
            intermediates.add(goal);
            Term proof = this.mProofRules.trans(intermediates.toArray(new Term[intermediates.size()]));
            for (int i = 0; i < proofs.size(); ++i) {
                Term eqTerm = t.term("=", (Term)intermediates.get(i), (Term)intermediates.get(i + 1));
                proof = this.mProofRules.resolutionRule(eqTerm, (Term)proofs.get(i), proof);
            }
            return proof;
        }
        assert (proofs.size() == 1);
        return (Term)proofs.get(0);
    }

    private boolean checkIteinIteBound(SMTAffineTerm sum, ApplicationTerm possibleIteTerm, Rational factor) {
        assert (this.isApplication("ite", possibleIteTerm));
        Term[] iteArgs = possibleIteTerm.getParameters();
        boolean zeroSeen = false;
        HashSet<Term> visited = new HashSet<Term>();
        ArrayDeque<Term> toCheck = new ArrayDeque<Term>();
        toCheck.add(iteArgs[2]);
        toCheck.add(iteArgs[1]);
        while (!toCheck.isEmpty()) {
            Term candidate = (Term)toCheck.removeLast();
            if (!visited.add(candidate)) continue;
            if (this.isApplication("ite", candidate)) {
                iteArgs = ((ApplicationTerm)candidate).getParameters();
                toCheck.addLast(iteArgs[1]);
                toCheck.addLast(iteArgs[2]);
                continue;
            }
            SMTAffineTerm sumWithCandidate = new SMTAffineTerm(candidate);
            sumWithCandidate.add(Rational.MONE, possibleIteTerm);
            sumWithCandidate.mul(factor);
            sumWithCandidate.add(sum);
            if (!sumWithCandidate.isConstant() || sumWithCandidate.getConstant().signum() > 0) {
                return false;
            }
            if (sumWithCandidate.getConstant().signum() != 0) continue;
            zeroSeen = true;
        }
        return zeroSeen;
    }

    private ApplicationTerm findAndCheckIteinIteBound(SMTAffineTerm sum) {
        for (Map.Entry<Term, Rational> entry : sum.getSummands().entrySet()) {
            ApplicationTerm iteTerm;
            if (!this.isApplication("ite", entry.getKey()) || entry.getValue().abs() != Rational.ONE || !this.checkIteinIteBound(sum, iteTerm = (ApplicationTerm)entry.getKey(), entry.getValue())) continue;
            return iteTerm;
        }
        throw new AssertionError();
    }

    private Term proveIteEqualsLeafs(ApplicationTerm iteTerm, Set<Term> allLeafs) {
        assert (this.isApplication("ite", iteTerm));
        Theory theory = iteTerm.getTheory();
        Term[] iteArgs = iteTerm.getParameters();
        ArrayDeque<Term> todo = new ArrayDeque<Term>();
        ArrayDeque<ApplicationTerm> subIteTerms = new ArrayDeque<ApplicationTerm>();
        HashSet<Term> visited = new HashSet<Term>();
        Term proof = this.res(iteArgs[0], this.mProofRules.ite2(iteTerm), this.mProofRules.ite1(iteTerm));
        todo.add(iteArgs[2]);
        todo.add(iteArgs[1]);
        while (!todo.isEmpty()) {
            Term candidate = (Term)todo.removeLast();
            if (visited.contains(candidate)) continue;
            if (this.isApplication("ite", candidate)) {
                ApplicationTerm subIteTerm = (ApplicationTerm)candidate;
                iteArgs = subIteTerm.getParameters();
                if (!visited.contains(iteArgs[1]) || !visited.contains(iteArgs[2])) {
                    todo.addLast(candidate);
                    todo.addLast(iteArgs[1]);
                    todo.addLast(iteArgs[2]);
                    continue;
                }
                subIteTerms.addFirst(subIteTerm);
                visited.add(candidate);
                continue;
            }
            allLeafs.add(candidate);
            visited.add(candidate);
        }
        for (ApplicationTerm subIteTerm : subIteTerms) {
            iteArgs = subIteTerm.getParameters();
            Term subProof = this.res(iteArgs[0], this.mProofRules.ite2(subIteTerm), this.mProofRules.ite1(subIteTerm));
            for (int i = 1; i < 3; ++i) {
                Term eq2 = theory.term("=", subIteTerm, iteArgs[i]);
                subProof = this.res(eq2, subProof, this.mProofRules.trans(iteTerm, subIteTerm, iteArgs[i]));
            }
            Term eq1 = theory.term("=", iteTerm, subIteTerm);
            proof = this.res(eq1, proof, subProof);
        }
        return proof;
    }

    private Term convertTermITEBound(ProofLiteral[] clause) {
        assert (clause.length == 1 && clause[0].getPolarity() && this.isApplication("<=", clause[0].getAtom()));
        Theory theory = clause[0].getAtom().getTheory();
        Term[] leqArgs = ((ApplicationTerm)clause[0].getAtom()).getParameters();
        assert (leqArgs.length == 2 && this.isZero(leqArgs[1]));
        SMTAffineTerm sum = new SMTAffineTerm(leqArgs[0]);
        ApplicationTerm iteTerm = this.findAndCheckIteinIteBound(sum);
        LinkedHashSet<Term> allLeafs = new LinkedHashSet<Term>();
        LinkedHashSet<Term> neededRefls = new LinkedHashSet<Term>();
        Term proof = this.proveIteEqualsLeafs(iteTerm, allLeafs);
        Sort sort = iteTerm.getSort();
        FunctionSymbol lt = theory.getFunctionWithResult("<", null, null, sort, sort);
        int itePos = -1;
        Term[] sumArgs = null;
        boolean isNegated = false;
        if (this.isApplication("+", leqArgs[0])) {
            sumArgs = ((ApplicationTerm)leqArgs[0]).getParameters();
            for (int i = 0; i < sumArgs.length; ++i) {
                Term[] mulArgs;
                if (sumArgs[i] == iteTerm) {
                    itePos = i;
                    break;
                }
                if (!this.isApplication("*", sumArgs[i]) || (mulArgs = ((ApplicationTerm)sumArgs[i]).getParameters()).length != 2 || mulArgs[1] != iteTerm) continue;
                itePos = i;
                isNegated = true;
                break;
            }
            assert (itePos >= 0);
        } else if (leqArgs[0] != iteTerm) {
            isNegated = true;
        }
        for (Term leaf : allLeafs) {
            Term eq = theory.term("=", iteTerm, leaf);
            Polynomial newSum = new Polynomial(leaf);
            Term newLeaf = leaf;
            if (isNegated) {
                ApplicationTerm mulIte = (ApplicationTerm)(itePos >= 0 ? sumArgs[itePos] : leqArgs[0]);
                Term[] mulArgs = mulIte.getParameters();
                Term[] newMulArgs = (Term[])mulArgs.clone();
                newMulArgs[1] = leaf;
                proof = this.res(eq, proof, this.mProofRules.cong(mulIte.getFunction(), mulArgs, newMulArgs));
                Term rhs = theory.term(mulIte.getFunction(), newMulArgs);
                neededRefls.add(mulArgs[0]);
                newSum.mul(new Polynomial(newMulArgs[0]));
                newLeaf = newSum.toTerm(leaf.getSort());
                if (rhs != newLeaf) {
                    proof = this.res(theory.term("=", mulIte, rhs), proof, this.res(theory.term("=", rhs, newLeaf), this.mProofRules.polyMul(rhs, newLeaf), this.mProofRules.trans(mulIte, rhs, newLeaf)));
                }
                eq = theory.term("=", mulIte, newLeaf);
            }
            if (itePos >= 0) {
                FunctionSymbol plus = ((ApplicationTerm)leqArgs[0]).getFunction();
                Term[] newSumArgs = (Term[])sumArgs.clone();
                newSumArgs[itePos] = newLeaf;
                Term rhs = theory.term(plus, newSumArgs);
                proof = this.res(eq, proof, this.mProofRules.cong(plus, sumArgs, newSumArgs));
                newSum = new Polynomial();
                for (int i = 0; i < newSumArgs.length; ++i) {
                    newSum.add(Rational.ONE, newSumArgs[i]);
                    if (i == itePos) continue;
                    neededRefls.add(newSumArgs[i]);
                }
                newLeaf = newSum.toTerm(leaf.getSort());
                if (rhs != newLeaf) {
                    proof = this.res(theory.term("=", leqArgs[0], rhs), proof, this.res(theory.term("=", rhs, newLeaf), this.mProofRules.polyAdd(rhs, newLeaf), this.mProofRules.trans(leqArgs[0], rhs, newLeaf)));
                }
                eq = theory.term("=", leqArgs[0], newLeaf);
            }
            Term[] oldArgs = new Term[]{leqArgs[1], leqArgs[0]};
            Term[] newArgs = new Term[]{leqArgs[1], newLeaf};
            proof = this.res(eq, proof, this.mProofRules.cong(lt, oldArgs, newArgs));
            neededRefls.add(leqArgs[1]);
            Term oldLt = theory.term(lt, oldArgs);
            Term newLt = theory.term(lt, newArgs);
            Term ltEqual = theory.term("=", oldLt, newLt);
            proof = this.res(ltEqual, proof, this.mProofRules.iffElim2(ltEqual));
            proof = this.res(newLt, proof, this.mProofRules.farkas(new Term[]{newLt}, new BigInteger[]{BigInteger.ONE}));
        }
        proof = this.res(theory.term(lt, leqArgs[1], leqArgs[0]), this.mProofRules.total(leqArgs[0], leqArgs[1]), proof);
        for (Term t : neededRefls) {
            proof = this.res(theory.term("=", t, t), this.mProofRules.refl(t), proof);
        }
        return proof;
    }

    private Term convertTautQuantSkolemize(ProofLiteral[] clause, Term[] skolemFuns, boolean isForall) {
        assert (clause.length == 2);
        QuantifiedFormula qf = (QuantifiedFormula)clause[0].getAtom();
        assert (isForall == clause[0].getPolarity());
        assert (qf.getQuantifier() == (isForall ? 1 : 0));
        Theory theory = qf.getTheory();
        TermVariable[] vars = qf.getVariables();
        Sort[] varSorts = new Sort[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            varSorts[i] = vars[i].getSort();
        }
        theory.push();
        FunctionSymbol qFunc = theory.declareInternalFunction("@quantbody", varSorts, qf.getFreeVars(), qf.getSubformula(), 64);
        Term[] chooseTerms = this.mProofRules.getSkolemVars(vars, qf.getSubformula(), isForall);
        FormulaUnLet unletter = new FormulaUnLet();
        Term subChoose = unletter.unlet(this.mSkript.let(vars, chooseTerms, qf.getSubformula()));
        Term quantChoose = theory.term(qFunc, chooseTerms);
        Term quantSkolem = theory.term(qFunc, skolemFuns);
        Term subSkolem = unletter.unlet(this.mSkript.let(vars, skolemFuns, qf.getSubformula()));
        Term transProof = this.res(theory.term("=", quantSkolem, subSkolem), this.mProofRules.expand(quantSkolem), this.res(theory.term("=", subSkolem, quantSkolem), this.mProofRules.symm(subSkolem, quantSkolem), this.res(theory.term("=", quantSkolem, quantChoose), this.mProofRules.cong(qFunc, skolemFuns, chooseTerms), this.res(theory.term("=", quantChoose, subChoose), this.mProofRules.expand(quantChoose), this.mProofRules.trans(subSkolem, quantSkolem, quantChoose, subChoose)))));
        for (int i = 0; i < chooseTerms.length; ++i) {
            transProof = this.res(theory.term("=", skolemFuns[i], chooseTerms[i]), this.mProofRules.expand(skolemFuns[i]), transProof);
        }
        Term skolemEquivalence = theory.term("=", subSkolem, subChoose);
        Term proof = isForall ? this.res(subChoose, this.mProofRules.iffElim2(skolemEquivalence), this.mProofRules.forallIntro(qf)) : this.res(subChoose, this.mProofRules.existsElim(qf), this.mProofRules.iffElim1(skolemEquivalence));
        proof = this.res(skolemEquivalence, transProof, proof);
        proof = this.mProofRules.defineFun(qFunc, theory.lambda(vars, qf.getSubformula()), proof);
        theory.pop();
        return this.removeNot(proof, subSkolem, !isForall);
    }

    private Term convertTautForallElim(ProofLiteral[] clause, Term[] subst) {
        assert (clause.length == 2 && !clause[0].getPolarity());
        Term forall = clause[0].getAtom();
        QuantifiedFormula qf = (QuantifiedFormula)forall;
        assert (qf.getQuantifier() == 1);
        TermVariable[] universalVars = qf.getVariables();
        assert (universalVars.length == subst.length);
        Term proof = this.mProofRules.forallElim(subst, qf);
        FormulaUnLet unletter = new FormulaUnLet();
        Term result = unletter.unlet(this.mSkript.let(universalVars, subst, qf.getSubformula()));
        proof = this.removeNot(proof, result, true);
        return proof;
    }

    private Term convertTautExistsIntro(ProofLiteral[] clause, Term[] subst) {
        assert (clause.length == 2 && clause[0].getPolarity());
        QuantifiedFormula qf = (QuantifiedFormula)clause[0].getAtom();
        assert (qf.getQuantifier() == 0);
        TermVariable[] universalVars = qf.getVariables();
        assert (universalVars.length == subst.length);
        Term proof = this.mProofRules.existsIntro(subst, qf);
        FormulaUnLet unletter = new FormulaUnLet();
        Term result = unletter.unlet(this.mSkript.let(universalVars, subst, qf.getSubformula()));
        proof = this.removeNot(proof, result, false);
        return proof;
    }

    private Term convertTautIte1Helper(Term iteAtom, Term iteTrueCase, boolean polarity) {
        Term iteTrueCaseEq = iteAtom.getTheory().term("=", iteAtom, iteTrueCase);
        Term proof = this.mProofRules.resolutionRule(iteTrueCaseEq, this.mProofRules.ite1(iteAtom), polarity ? this.mProofRules.iffElim1(iteTrueCaseEq) : this.mProofRules.iffElim2(iteTrueCaseEq));
        return this.removeNot(proof, iteTrueCase, !polarity);
    }

    private Term convertTautIte2Helper(Term iteAtom, Term iteFalseCase, boolean polarity) {
        Term iteFalseCaseEq = iteAtom.getTheory().term("=", iteAtom, iteFalseCase);
        Term proof = this.mProofRules.resolutionRule(iteFalseCaseEq, this.mProofRules.ite2(iteAtom), polarity ? this.mProofRules.iffElim1(iteFalseCaseEq) : this.mProofRules.iffElim2(iteFalseCaseEq));
        return this.removeNot(proof, iteFalseCase, !polarity);
    }

    private Term convertTautExcludedMiddle(String name, ProofLiteral[] clause) {
        Term proof;
        Term atomTerm;
        assert (clause.length == 2);
        boolean isEqTrue = name == ":excludedMiddle1";
        Term equality = clause[0].getAtom();
        assert (clause[0].getPolarity() && this.isApplication("=", equality));
        Term[] eqArgs = ((ApplicationTerm)equality).getParameters();
        boolean isAuxLiteral = this.isAuxApplication(eqArgs[0]);
        Term term = atomTerm = isAuxLiteral ? this.expandAux((ApplicationTerm)eqArgs[0]) : eqArgs[0];
        assert (eqArgs.length == 2 && this.isApplication(isEqTrue ? "true" : "false", eqArgs[1]));
        Term term2 = proof = isEqTrue ? this.mProofRules.resolutionRule(eqArgs[1], this.mProofRules.trueIntro(), this.mProofRules.iffIntro2(equality)) : this.mProofRules.resolutionRule(eqArgs[1], this.mProofRules.iffIntro1(equality), this.mProofRules.falseElim());
        if (isAuxLiteral) {
            Term expandAuxEq = this.mSkript.term("=", eqArgs[0], atomTerm);
            Term expandAuxProof = this.mProofRules.expand(eqArgs[0]);
            proof = isEqTrue ? this.res(eqArgs[0], this.res(expandAuxEq, expandAuxProof, this.mProofRules.iffElim1(expandAuxEq)), proof) : this.res(eqArgs[0], proof, this.res(expandAuxEq, expandAuxProof, this.mProofRules.iffElim2(expandAuxEq)));
        }
        proof = this.removeNot(proof, atomTerm, !isEqTrue);
        return proof;
    }

    private boolean isSkolem(Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol func = ((ApplicationTerm)term).getFunction();
            return func.isIntern() && func.getName().startsWith("@skolem");
        }
        return false;
    }

    private boolean isAuxApplication(Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol func = ((ApplicationTerm)term).getFunction();
            return func.isIntern() && func.getName().startsWith("@AUX");
        }
        return false;
    }

    private int findArgPosition(ProofLiteral searchTerm, Term[] mainParams, boolean forImplication) {
        for (int i = 0; i < mainParams.length; ++i) {
            Term mainParam = mainParams[i];
            boolean positive = true;
            while (this.isApplication("not", mainParam)) {
                mainParam = ((ApplicationTerm)mainParam).getParameters()[0];
                positive = !positive;
            }
            if (forImplication && i == mainParams.length - 1) {
                boolean bl = positive = !positive;
            }
            if (mainParam != searchTerm.getAtom() || positive != searchTerm.getPolarity()) continue;
            return i;
        }
        throw new AssertionError();
    }

    private Term convertTautElimIntro(String ruleName, ProofLiteral[] clause) {
        Term proof;
        ApplicationTerm mainAtom;
        boolean isAuxDefEq;
        boolean isElim = ruleName.contains("-");
        ApplicationTerm firstAtom = (ApplicationTerm)clause[0].getAtom();
        boolean bl = isAuxDefEq = clause[0].getPolarity() && this.isApplication("=", firstAtom);
        if (isAuxDefEq) {
            assert (this.isApplication(isElim ? "false" : "true", firstAtom.getParameters()[1]));
            mainAtom = (ApplicationTerm)this.expandAuxDef(firstAtom);
        } else {
            assert (isElim != clause[0].getPolarity());
            mainAtom = firstAtom;
        }
        assert (ruleName.startsWith(":" + mainAtom.getFunction().getName()));
        Term[] mainParams = mainAtom.getParameters();
        switch (ruleName) {
            case ":or+": {
                assert (clause.length == 2);
                int pos = this.findArgPosition(clause[1].negate(), mainParams, false);
                proof = this.mProofRules.orIntro(pos, mainAtom);
                proof = this.removeNot(proof, mainParams[pos], false);
                break;
            }
            case ":or-": {
                proof = this.mProofRules.orElim(mainAtom);
                for (int i = 0; i < mainParams.length; ++i) {
                    proof = this.removeNot(proof, mainParams[i], true);
                }
                break;
            }
            case ":and+": {
                proof = this.mProofRules.andIntro(mainAtom);
                for (int i = 0; i < mainParams.length; ++i) {
                    proof = this.removeNot(proof, mainParams[i], false);
                }
                break;
            }
            case ":and-": {
                assert (clause.length == 2);
                int pos = this.findArgPosition(clause[1], mainParams, false);
                proof = this.mProofRules.andElim(pos, mainAtom);
                proof = this.removeNot(proof, mainParams[pos], true);
                break;
            }
            case ":=>+": {
                assert (clause.length == 2);
                int lastPos = mainParams.length - 1;
                int pos = this.findArgPosition(clause[1], mainParams, true);
                proof = this.mProofRules.impIntro(pos, mainAtom);
                proof = this.removeNot(proof, mainParams[pos], pos != lastPos);
                break;
            }
            case ":=>-": {
                proof = this.mProofRules.impElim(mainAtom);
                for (int i = 0; i < mainParams.length; ++i) {
                    proof = this.removeNot(proof, mainParams[i], i == mainParams.length - 1);
                }
                break;
            }
            case ":xor+1": {
                proof = this.mProofRules.xorIntro(mainParams, new Term[]{mainParams[0]}, new Term[]{mainParams[1]});
                proof = this.removeNot(proof, mainParams[0], true);
                proof = this.removeNot(proof, mainParams[1], false);
                break;
            }
            case ":xor+2": {
                proof = this.mProofRules.xorIntro(mainParams, new Term[]{mainParams[1]}, new Term[]{mainParams[0]});
                proof = this.removeNot(proof, mainParams[0], false);
                proof = this.removeNot(proof, mainParams[1], true);
                break;
            }
            case ":xor-1": {
                proof = this.mProofRules.xorIntro(new Term[]{mainParams[0]}, new Term[]{mainParams[1]}, mainParams);
                proof = this.removeNot(proof, mainParams[0], true);
                proof = this.removeNot(proof, mainParams[1], true);
                break;
            }
            case ":xor-2": {
                proof = this.mProofRules.xorElim(mainParams, new Term[]{mainParams[0]}, new Term[]{mainParams[1]});
                proof = this.removeNot(proof, mainParams[0], false);
                proof = this.removeNot(proof, mainParams[1], false);
                break;
            }
            case ":ite+1": {
                proof = this.removeNot(this.convertTautIte1Helper(mainAtom, mainParams[1], true), mainParams[0], false);
                break;
            }
            case ":ite+2": {
                proof = this.removeNot(this.convertTautIte2Helper(mainAtom, mainParams[2], true), mainParams[0], true);
                break;
            }
            case ":ite+red": {
                proof = this.mProofRules.resolutionRule(mainParams[0], this.convertTautIte2Helper(mainAtom, mainParams[2], true), this.convertTautIte1Helper(mainAtom, mainParams[1], true));
                break;
            }
            case ":ite-1": {
                proof = this.removeNot(this.convertTautIte1Helper(mainAtom, mainParams[1], false), mainParams[0], false);
                break;
            }
            case ":ite-2": {
                proof = this.removeNot(this.convertTautIte2Helper(mainAtom, mainParams[2], false), mainParams[0], true);
                break;
            }
            case ":ite-red": {
                proof = this.mProofRules.resolutionRule(mainParams[0], this.convertTautIte2Helper(mainAtom, mainParams[2], false), this.convertTautIte1Helper(mainAtom, mainParams[1], false));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (isAuxDefEq) {
            Term expandEq = this.mSkript.term("=", firstAtom, mainAtom);
            if (isElim) {
                proof = this.mProofRules.resolutionRule(mainAtom, this.proveAuxElim(firstAtom, mainAtom), proof);
            } else {
                proof = this.mProofRules.resolutionRule(mainAtom, proof, this.mProofRules.iffElim1(expandEq));
                proof = this.mProofRules.resolutionRule(expandEq, this.proveAuxExpand(firstAtom, mainAtom), proof);
            }
        }
        return proof;
    }

    private Term convertTautStore(ProofLiteral[] clause) {
        assert (clause.length == 1 && clause[0].getPolarity());
        Term eqlit = clause[0].getAtom();
        assert (this.isApplication("=", eqlit));
        Term[] sides = ((ApplicationTerm)eqlit).getParameters();
        assert (this.isApplication("select", sides[0]));
        ApplicationTerm select = (ApplicationTerm)sides[0];
        Term store = select.getParameters()[0];
        assert (this.isApplication("store", store));
        Term[] storeArgs = ((ApplicationTerm)store).getParameters();
        assert (storeArgs[1] == select.getParameters()[1] && storeArgs[2] == sides[1]);
        return this.mProofRules.selectStore1(storeArgs[0], storeArgs[1], storeArgs[2]);
    }

    private Term convertTautDiff(ProofLiteral[] clause) {
        assert (clause.length == 2 && clause[0].getPolarity());
        Term arrEq = clause[0].getAtom();
        assert (this.isApplication("=", arrEq));
        Term[] arrays = ((ApplicationTerm)arrEq).getParameters();
        return this.mProofRules.extDiff(arrays[0], arrays[1]);
    }

    private Term convertTautLowHigh(String ruleName, ProofLiteral[] clause) {
        Term atom = clause[0].getAtom();
        Theory theory = atom.getTheory();
        boolean isToInt = ruleName.startsWith(":toInt");
        boolean isHigh = ruleName.endsWith("High");
        assert (clause[0].getPolarity() != isHigh);
        assert (this.isApplication("<=", atom));
        Term[] leArgs = ((ApplicationTerm)atom).getParameters();
        SMTAffineTerm lhs = new SMTAffineTerm(leArgs[0]);
        assert (this.isZero(leArgs[1]));
        assert (leArgs[0].getSort().getName() == (isToInt ? "Real" : "Int"));
        String func = isToInt ? "to_int" : "div";
        for (Term candidate : lhs.getSummands().keySet()) {
            Term realAtom;
            Term proof;
            Term axiomTerm;
            SMTAffineTerm summand;
            Rational d;
            if (!this.isApplication(func, candidate)) continue;
            Term[] args = ((ApplicationTerm)candidate).getParameters();
            if (isToInt) {
                d = Rational.ONE;
                summand = new SMTAffineTerm(candidate);
            } else {
                SMTAffineTerm arg1 = new SMTAffineTerm(args[1]);
                assert (arg1.isConstant());
                d = arg1.getConstant();
                assert (!d.equals(Rational.ZERO));
                summand = new SMTAffineTerm(candidate);
                summand.mul(d);
            }
            SMTAffineTerm expected = new SMTAffineTerm(args[0]);
            expected.negate();
            expected.add(summand);
            if (isHigh) {
                expected.add(d.abs());
            }
            if (!lhs.equals(expected)) continue;
            switch (ruleName) {
                case ":toIntLow": {
                    axiomTerm = theory.term("<=", theory.term("to_real", candidate), args[0]);
                    proof = this.mProofRules.toIntLow(args[0]);
                    break;
                }
                case ":toIntHigh": {
                    axiomTerm = theory.term("<", args[0], theory.term("+", theory.term("to_real", candidate), Rational.ONE.toTerm(args[0].getSort())));
                    proof = this.mProofRules.toIntHigh(args[0]);
                    break;
                }
                case ":divLow": {
                    axiomTerm = theory.term("<=", theory.term("*", args[1], candidate), args[0]);
                    proof = this.mProofRules.divLow(args[0], args[1]);
                    Term zero = Rational.ZERO.toTerm(args[1].getSort());
                    proof = this.res(theory.term("=", args[1], zero), proof, this.proveTrivialDisequality(args[1], zero));
                    break;
                }
                case ":divHigh": {
                    axiomTerm = theory.term("<", args[0], theory.term("+", theory.term("*", args[1], candidate), theory.term("abs", args[1])));
                    proof = this.mProofRules.divHigh(args[0], args[1]);
                    Term zero = Rational.ZERO.toTerm(args[1].getSort());
                    proof = this.res(theory.term("=", args[1], zero), proof, this.proveTrivialDisequality(args[1], zero));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Term term = realAtom = isHigh ? atom : theory.term("<", leArgs[1], leArgs[0]);
            if (ruleName.equals(":divHigh")) {
                Term realAbsD = theory.term("abs", args[1]);
                Term absD = d.abs().toTerm(args[1].getSort());
                Term absDivisor = theory.term("=", realAbsD, absD);
                proof = this.res(axiomTerm, proof, this.mProofRules.farkas(new Term[]{realAtom, axiomTerm, absDivisor}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE, BigInteger.ONE}));
                proof = this.res(theory.term("=", realAbsD, absD), this.proveAbsConstant(d, args[0].getSort()), proof);
            } else {
                proof = this.res(axiomTerm, proof, this.mProofRules.farkas(new Term[]{realAtom, axiomTerm}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE}));
            }
            if (!isHigh) {
                proof = this.res(realAtom, this.mProofRules.total(leArgs[0], leArgs[1]), proof);
            }
            return proof;
        }
        throw new AssertionError();
    }

    private Term convertTautDtMatch(String rule, ProofLiteral[] clause) {
        int caseNr;
        Term tester;
        MatchTerm matchTerm;
        boolean negated;
        boolean isMatchCase = rule.equals(":matchCase");
        boolean boolCase = clause[0].getAtom() instanceof MatchTerm;
        ApplicationTerm isTerm = null;
        if (boolCase) {
            assert (clause.length >= 2);
            negated = !clause[0].getPolarity();
            matchTerm = (MatchTerm)clause[0].getAtom();
            if (isMatchCase) {
                assert (!clause[1].getPolarity());
                tester = clause[1].getAtom();
                assert (this.isApplication("is", tester));
                isTerm = (ApplicationTerm)tester;
            }
        } else {
            assert (clause.length >= 1);
            negated = false;
            if (isMatchCase) {
                assert (!clause[0].getPolarity());
                tester = clause[0].getAtom();
                assert (this.isApplication("is", tester));
                isTerm = (ApplicationTerm)tester;
            }
            assert (clause[clause.length - 1].getPolarity());
            assert (this.isApplication("=", clause[clause.length - 1].getAtom()));
            ApplicationTerm eqTerm = (ApplicationTerm)clause[clause.length - 1].getAtom();
            assert (eqTerm.getParameters().length == 2);
            matchTerm = (MatchTerm)eqTerm.getParameters()[0];
        }
        DataType.Constructor[] constrs = matchTerm.getConstructors();
        for (caseNr = 0; caseNr < constrs.length && !(isMatchCase ? constrs[caseNr].getName().equals(isTerm.getFunction().getIndices()[0]) : constrs[caseNr] == null); ++caseNr) {
        }
        Theory theory = matchTerm.getTheory();
        Term dataTerm = matchTerm.getDataTerm();
        Term iteTerm = MinimalProofChecker.buildIteForMatch(matchTerm);
        ArrayList<Term> eqSequence = new ArrayList<Term>();
        eqSequence.add(matchTerm);
        for (int i = 0; i < caseNr; ++i) {
            assert (this.isApplication("ite", iteTerm));
            eqSequence.add(iteTerm);
            iteTerm = ((ApplicationTerm)iteTerm).getParameters()[2];
        }
        if (isMatchCase && caseNr < constrs.length - 1) {
            assert (this.isApplication("ite", iteTerm));
            eqSequence.add(iteTerm);
            iteTerm = ((ApplicationTerm)iteTerm).getParameters()[1];
        }
        eqSequence.add(iteTerm);
        Term proof = this.mProofRules.trans(eqSequence.toArray(new Term[eqSequence.size()]));
        proof = this.res(theory.term("=", matchTerm, (Term)eqSequence.get(1)), this.mProofRules.dtMatch(matchTerm), proof);
        DataType.Constructor cons = constrs[caseNr];
        Term consTerm = null;
        if (isMatchCase) {
            Term[] selectTerms = new Term[cons.getSelectors().length];
            for (int i = 0; i < selectTerms.length; ++i) {
                selectTerms[i] = theory.term(cons.getSelectors()[i], dataTerm);
            }
            consTerm = theory.term(cons.getName(), null, cons.needsReturnOverload() ? dataTerm.getSort() : null, selectTerms);
        }
        for (int i = 0; i < caseNr; ++i) {
            proof = this.res(theory.term("=", (Term)eqSequence.get(i + 1), (Term)eqSequence.get(i + 2)), this.mProofRules.ite2((Term)eqSequence.get(i + 1)), proof);
            if (!isMatchCase) continue;
            String[] index = new String[]{constrs[i].getName()};
            Term isConsData = theory.term("is", index, null, dataTerm);
            Term isConsCons = theory.term("is", index, null, consTerm);
            Term isConsEq = theory.term("=", isConsCons, isConsData);
            proof = this.res(isConsData, proof, this.mProofRules.iffElim1(isConsEq));
            proof = this.res(isConsEq, this.mProofRules.cong(isConsCons, isConsData), proof);
            proof = this.res(isConsCons, proof, this.mProofRules.dtTestE(constrs[i].getName(), consTerm));
        }
        if (isMatchCase && caseNr > 0) {
            Term isConsCons = theory.term("is", new String[]{cons.getName()}, null, dataTerm);
            proof = this.res(theory.term("=", consTerm, dataTerm), this.mProofRules.dtCons(isConsCons), proof);
        }
        if (isMatchCase && caseNr < constrs.length - 1) {
            proof = this.res(theory.term("=", (Term)eqSequence.get(caseNr + 1), (Term)eqSequence.get(caseNr + 2)), this.mProofRules.ite1((Term)eqSequence.get(caseNr + 1)), proof);
        }
        if (boolCase) {
            Term matchEq = theory.term("=", matchTerm, iteTerm);
            proof = this.res(matchEq, proof, negated ? this.mProofRules.iffElim2(matchEq) : this.mProofRules.iffElim1(matchEq));
            proof = this.removeNot(proof, iteTerm, negated);
        }
        return proof;
    }

    private Term convertTautology(ProofLiteral[] clause, Annotation annot) {
        String ruleName = annot.getKey();
        Term proof = null;
        switch (ruleName) {
            case ":true+": {
                assert (clause.length == 1 && clause[0].getPolarity() && this.isApplication("true", clause[0].getAtom()));
                proof = this.mProofRules.trueIntro();
                break;
            }
            case ":false-": {
                assert (clause.length == 1 && !clause[0].getPolarity() && this.isApplication("false", clause[0].getAtom()));
                proof = this.mProofRules.falseElim();
                break;
            }
            case ":or+": 
            case ":or-": 
            case ":and+": 
            case ":and-": 
            case ":=>+": 
            case ":=>-": 
            case ":xor+1": 
            case ":xor+2": 
            case ":xor-1": 
            case ":xor-2": 
            case ":ite+1": 
            case ":ite+2": 
            case ":ite+red": 
            case ":ite-1": 
            case ":ite-2": 
            case ":ite-red": {
                proof = this.convertTautElimIntro(ruleName, clause);
                break;
            }
            case ":=+1": {
                assert (clause.length == 3);
                Term eqTerm = clause[0].getAtom();
                assert (clause[0].getPolarity() && this.isApplication("=", eqTerm));
                Term[] eqParams = ((ApplicationTerm)eqTerm).getParameters();
                assert (eqParams.length == 2);
                proof = this.mProofRules.iffIntro1(eqTerm);
                assert (clause[1].getPolarity() && eqParams[0] == clause[1].getAtom());
                proof = this.removeNot(proof, eqParams[0], true);
                assert (clause[2].getPolarity() && eqParams[1] == clause[2].getAtom());
                proof = this.removeNot(proof, eqParams[1], true);
                break;
            }
            case ":=+2": {
                assert (clause.length == 3);
                Term eqTerm = clause[0].getAtom();
                assert (clause[0].getPolarity() && this.isApplication("=", eqTerm));
                Term[] eqParams = ((ApplicationTerm)eqTerm).getParameters();
                assert (eqParams.length == 2);
                proof = this.mProofRules.iffIntro2(eqTerm);
                assert (!clause[1].getPolarity() && eqParams[0] == clause[1].getAtom());
                proof = this.removeNot(proof, eqParams[0], false);
                assert (!clause[2].getPolarity() && eqParams[1] == clause[2].getAtom());
                proof = this.removeNot(proof, eqParams[0], false);
                break;
            }
            case ":=-1": {
                assert (clause.length == 3);
                Term eqTerm = clause[0].getAtom();
                assert (!clause[0].getPolarity() && this.isApplication("=", eqTerm));
                Term[] eqParams = ((ApplicationTerm)eqTerm).getParameters();
                assert (eqParams.length == 2);
                proof = this.mProofRules.iffElim1(eqTerm);
                assert (clause[1].getPolarity() && eqParams[0] == clause[1].getAtom());
                proof = this.removeNot(proof, eqParams[0], true);
                assert (!clause[2].getPolarity() && eqParams[1] == clause[2].getAtom());
                proof = this.removeNot(proof, eqParams[1], false);
                break;
            }
            case ":=-2": {
                assert (clause.length == 3);
                Term eqTerm = clause[0].getAtom();
                assert (!clause[0].getPolarity() && this.isApplication("=", eqTerm));
                Term[] eqParams = ((ApplicationTerm)eqTerm).getParameters();
                assert (eqParams.length == 2);
                proof = this.mProofRules.iffElim2(eqTerm);
                assert (!clause[1].getPolarity() && eqParams[0] == clause[1].getAtom());
                proof = this.removeNot(proof, eqParams[0], false);
                assert (clause[2].getPolarity() && eqParams[1] == clause[2].getAtom());
                proof = this.removeNot(proof, eqParams[1], true);
                break;
            }
            case ":exists-": 
            case ":forall+": {
                proof = this.convertTautQuantSkolemize(clause, (Term[])annot.getValue(), ruleName.equals(":forall+"));
                break;
            }
            case ":exists+": {
                proof = this.convertTautExistsIntro(clause, (Term[])annot.getValue());
                break;
            }
            case ":forall-": {
                proof = this.convertTautForallElim(clause, (Term[])annot.getValue());
                break;
            }
            case ":termITE": {
                proof = this.convertTermITE(clause);
                break;
            }
            case ":termITEBound": {
                proof = this.convertTermITEBound(clause);
                break;
            }
            case ":trueNotFalse": {
                Theory t = clause[0].getAtom().getTheory();
                proof = this.mProofRules.resolutionRule(t.mTrue, this.mProofRules.trueIntro(), this.mProofRules.resolutionRule(t.mFalse, this.mProofRules.iffElim2(t.term("=", t.mTrue, t.mFalse)), this.mProofRules.falseElim()));
                break;
            }
            case ":excludedMiddle1": 
            case ":excludedMiddle2": {
                proof = this.convertTautExcludedMiddle(ruleName, clause);
                break;
            }
            case ":divHigh": 
            case ":divLow": 
            case ":toIntHigh": 
            case ":toIntLow": {
                proof = this.convertTautLowHigh(ruleName, clause);
                break;
            }
            case ":store": {
                proof = this.convertTautStore(clause);
                break;
            }
            case ":diff": {
                proof = this.convertTautDiff(clause);
                break;
            }
            case ":matchCase": 
            case ":matchDefault": {
                proof = this.convertTautDtMatch(ruleName, clause);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Tautology");
            }
        }
        assert (this.checkProof(proof, clause));
        return proof;
    }

    private Term convertTrans(Term[] newParams) {
        Term[] intermediateTerms = new Term[newParams.length + 1];
        Term lastTerm = null;
        for (int i = 0; i < newParams.length; ++i) {
            ApplicationTerm provedEq = (ApplicationTerm)this.provedTerm((AnnotatedTerm)newParams[i]);
            assert (this.isApplication("=", provedEq));
            assert (provedEq.getParameters().length == 2);
            assert (i == 0 || lastTerm == provedEq.getParameters()[0]);
            intermediateTerms[i] = provedEq.getParameters()[0];
            lastTerm = provedEq.getParameters()[1];
        }
        intermediateTerms[newParams.length] = lastTerm;
        Term clause = this.mProofRules.trans(intermediateTerms);
        for (int i = 0; i < newParams.length; ++i) {
            ApplicationTerm provedEq = (ApplicationTerm)this.provedTerm((AnnotatedTerm)newParams[i]);
            Term subproof = this.subproof((AnnotatedTerm)newParams[i]);
            clause = this.mProofRules.resolutionRule(provedEq, subproof, clause);
        }
        Term provedTerm = clause.getTheory().term("=", intermediateTerms[0], intermediateTerms[newParams.length]);
        return this.annotateProved(provedTerm, clause);
    }

    private Term convertCong(FunctionSymbol congSymb, Term[] newParams) {
        Sort resultSort = congSymb.isReturnOverload() ? congSymb.getReturnSort() : null;
        FunctionSymbol func = CongRewriteFunctionFactory.getFunctionFromIndex(congSymb.getIndices(), congSymb.getParameterSorts(), resultSort);
        ApplicationTerm leftEquality = (ApplicationTerm)this.provedTerm((AnnotatedTerm)newParams[0]);
        Theory t = newParams[0].getTheory();
        assert (this.isApplication("=", leftEquality));
        Term[] oldFuncParams = new Term[newParams.length];
        Term[] newFuncParams = new Term[newParams.length];
        Term[] newLit = new Term[newParams.length];
        Term[] newLitProof = new Term[newParams.length];
        for (int i = 0; i < newFuncParams.length; ++i) {
            ApplicationTerm provedEquality = (ApplicationTerm)this.provedTerm((AnnotatedTerm)newParams[i]);
            newLit[i] = provedEquality;
            newLitProof[i] = this.subproof((AnnotatedTerm)newParams[i]);
            oldFuncParams[i] = provedEquality.getParameters()[0];
            newFuncParams[i] = provedEquality.getParameters()[1];
        }
        Term oldFunc = t.term(func, oldFuncParams);
        Term newFunc = t.term(func, newFuncParams);
        Term congEquality = t.term("=", oldFunc, newFunc);
        Term proof = this.mProofRules.cong(func, oldFuncParams, newFuncParams);
        HashSet<Term> eliminated = new HashSet<Term>();
        for (int i = 0; i < newFuncParams.length; ++i) {
            if (eliminated.contains(newLit[i])) continue;
            proof = this.mProofRules.resolutionRule(newLit[i], newLitProof[i], proof);
            eliminated.add(newLit[i]);
        }
        return this.annotateProved(congEquality, proof);
    }

    private Term convertMatch(Term[] newParams) {
        AnnotatedTerm dataRewrite = (AnnotatedTerm)newParams[0];
        Theory theory = dataRewrite.getTheory();
        ApplicationTerm dataEquality = (ApplicationTerm)this.provedTerm(dataRewrite);
        assert (dataEquality.getFunction().getName().equals("="));
        Term oldData = dataEquality.getParameters()[0];
        Term newData = dataEquality.getParameters()[1];
        DataType dataType = (DataType)oldData.getSort().getSortSymbol();
        Term[] oldMatchCases = new Term[newParams.length - 1];
        Term[] newMatchCases = new Term[newParams.length - 1];
        TermVariable[][] caseVars = new TermVariable[newParams.length - 1][];
        DataType.Constructor[] constructors = new DataType.Constructor[newParams.length - 1];
        Term[] rewriteProofs = new Term[newParams.length - 1];
        for (int i = 1; i < newParams.length; ++i) {
            AnnotatedTerm caseRewrite = (AnnotatedTerm)newParams[i];
            AnnotatedTerm rewrite = (AnnotatedTerm)caseRewrite.getSubterm();
            ApplicationTerm caseEquality = (ApplicationTerm)this.provedTerm(rewrite);
            assert (caseRewrite.getAnnotations()[0].getKey() == ":vars");
            caseVars[i - 1] = (TermVariable[])caseRewrite.getAnnotations()[0].getValue();
            assert (caseRewrite.getAnnotations()[1].getKey() == ":constructor");
            String constructorName = (String)caseRewrite.getAnnotations()[1].getValue();
            oldMatchCases[i - 1] = caseEquality.getParameters()[0];
            newMatchCases[i - 1] = caseEquality.getParameters()[1];
            constructors[i - 1] = constructorName == null ? null : dataType.findConstructor(constructorName);
            rewriteProofs[i - 1] = this.subproof(rewrite);
        }
        MatchTerm oldOldMatch = (MatchTerm)theory.match(oldData, caseVars, oldMatchCases, constructors);
        MatchTerm oldMatch = (MatchTerm)theory.match(newData, caseVars, oldMatchCases, constructors);
        MatchTerm newMatch = (MatchTerm)theory.match(newData, caseVars, newMatchCases, constructors);
        Term oldMatchEqualityProof = null;
        if (oldData != newData) {
            theory.push();
            TermVariable dataVar = theory.createFreshTermVariable("match", oldData.getSort());
            TermVariable[] bodyVars = new TermVariable[]{dataVar};
            Term bodyDef = theory.match(dataVar, caseVars, oldMatchCases, constructors);
            FunctionSymbol bodyFunc = theory.declareInternalFunction("@matchbody", new Sort[]{oldData.getSort()}, bodyVars, bodyDef, 64);
            Term oldBody = theory.term(bodyFunc, oldData);
            Term newBody = theory.term(bodyFunc, newData);
            Term oldOldMatchBodyEq = this.res(theory.term("=", oldBody, oldOldMatch), this.mProofRules.expand(oldBody), this.mProofRules.symm(oldOldMatch, oldBody));
            Term oldNewBodyEq = this.res(theory.term("=", oldData, newData), this.subproof(dataRewrite), this.mProofRules.cong(oldBody, newBody));
            oldMatchEqualityProof = this.res(theory.term("=", oldOldMatch, oldBody), oldOldMatchBodyEq, this.res(theory.term("=", oldBody, newBody), oldNewBodyEq, this.res(theory.term("=", newBody, oldMatch), this.mProofRules.expand(newBody), this.mProofRules.trans(oldOldMatch, oldBody, newBody, oldMatch))));
            oldMatchEqualityProof = this.mProofRules.defineFun(bodyFunc, theory.lambda(bodyVars, bodyDef), oldMatchEqualityProof);
            theory.pop();
        }
        Term oldIte = MinimalProofChecker.buildIteForMatch(oldMatch);
        Term newIte = MinimalProofChecker.buildIteForMatch(newMatch);
        Term iteEqualsProof = null;
        boolean needReflData = false;
        Term oldSub = oldIte;
        Term newSub = newIte;
        for (int i = 0; i < constructors.length; ++i) {
            Term[] selectors;
            Term newCase;
            Term oldCase;
            if (constructors[i] == null || i == newParams.length - 1) {
                oldCase = oldSub;
                newCase = newSub;
            } else {
                assert (((ApplicationTerm)oldSub).getFunction().getName().equals("ite"));
                assert (((ApplicationTerm)newSub).getFunction().getName().equals("ite"));
                oldCase = ((ApplicationTerm)oldSub).getParameters()[1];
                newCase = ((ApplicationTerm)newSub).getParameters()[1];
                iteEqualsProof = this.res(theory.term("=", oldSub, newSub), this.mProofRules.cong(oldSub, newSub), iteEqualsProof);
                Term oldCond = ((ApplicationTerm)oldSub).getParameters()[0];
                Term newCond = ((ApplicationTerm)newSub).getParameters()[0];
                iteEqualsProof = this.res(theory.term("=", oldCond, newCond), this.mProofRules.cong(oldCond, newCond), iteEqualsProof);
                needReflData = true;
            }
            if (constructors[i] == null) {
                selectors = new Term[]{newData};
            } else {
                selectors = new Term[constructors[i].getSelectors().length];
                for (int j = 0; j < selectors.length; ++j) {
                    selectors[j] = theory.term(constructors[i].getSelectors()[j], newData);
                }
            }
            iteEqualsProof = this.res(theory.term("=", oldCase, newCase), theory.let(caseVars[i], selectors, rewriteProofs[i]), iteEqualsProof);
            if (constructors[i] == null) break;
            if (i >= newParams.length - 1) continue;
            oldSub = ((ApplicationTerm)oldSub).getParameters()[2];
            newSub = ((ApplicationTerm)newSub).getParameters()[2];
        }
        iteEqualsProof = new FormulaUnLet().unlet(iteEqualsProof);
        if (needReflData) {
            iteEqualsProof = this.res(theory.term("=", newData, newData), this.mProofRules.refl(newData), iteEqualsProof);
        }
        Term iteEquality = theory.term("=", oldIte, newIte);
        Term proof = this.res(iteEquality, iteEqualsProof, this.mProofRules.trans(oldMatch, oldIte, newIte, newMatch));
        proof = this.res(theory.term("=", oldMatch, oldIte), this.mProofRules.dtMatch(oldMatch), proof);
        proof = this.res(theory.term("=", newMatch, newIte), this.mProofRules.dtMatch(newMatch), this.res(theory.term("=", newIte, newMatch), this.mProofRules.symm(newIte, newMatch), proof));
        if (oldData != newData) {
            proof = this.res(theory.term("=", oldOldMatch, oldMatch), oldMatchEqualityProof, this.res(theory.term("=", oldMatch, newMatch), proof, this.mProofRules.trans(oldOldMatch, oldMatch, newMatch)));
        }
        return this.annotateProved(theory.term("=", oldOldMatch, newMatch), proof);
    }

    private Term convertRewriteIntern(Term lhs, Term rhs) {
        Term[] lhsParams;
        Term[] rhsArgs;
        ApplicationTerm rhsApp;
        Term atom;
        Theory theory = lhs.getTheory();
        if (rhs == lhs) {
            return this.mProofRules.refl(lhs);
        }
        if (this.isApplication("not", rhs) && this.isApplication("=", atom = ((ApplicationTerm)rhs).getParameters()[0]) && this.isApplication("false", (rhsApp = (ApplicationTerm)atom).getParameters()[1]) && lhs == rhsApp.getParameters()[0]) {
            Term rhsLit = theory.term("not", rhsApp);
            Term lhsEqRhsLit = theory.term("=", lhs, rhsLit);
            Term falseTerm = rhsApp.getParameters()[1];
            Term proofLhsEqRhsLit = this.proveIff(lhsEqRhsLit, this.mProofRules.resolutionRule(rhsApp, this.mProofRules.notIntro(rhsLit), this.mProofRules.iffElim2(rhsApp)), this.mProofRules.resolutionRule(rhsApp, this.mProofRules.iffIntro1(rhsApp), this.mProofRules.notElim(rhsLit)));
            proofLhsEqRhsLit = this.mProofRules.resolutionRule(falseTerm, proofLhsEqRhsLit, this.mProofRules.falseElim());
            return proofLhsEqRhsLit;
        }
        if (this.isApplication("=", rhs) && (rhsArgs = ((ApplicationTerm)rhs).getParameters()).length == 2 && this.isApplication("true", rhsArgs[1]) && (lhs == rhsArgs[0] || this.isAuxApplication(rhsArgs[0]))) {
            Term equality1 = theory.term("=", rhsArgs[0], rhs);
            Term proof = this.res(rhsArgs[1], this.mProofRules.trueIntro(), this.proveIff(equality1, this.mProofRules.iffIntro2(rhs), this.mProofRules.iffElim1(rhs)));
            if (lhs != rhsArgs[0]) {
                Term transitivity = this.mProofRules.trans(lhs, rhsArgs[0], rhs);
                proof = this.mProofRules.resolutionRule(equality1, proof, transitivity);
                proof = this.res(theory.term("=", lhs, rhsArgs[0]), this.res(theory.term("=", rhsArgs[0], lhs), this.mProofRules.expand(rhsArgs[0]), this.mProofRules.symm(lhs, rhsArgs[0])), proof);
            }
            return proof;
        }
        if (this.isApplication("<=", lhs)) {
            lhsParams = ((ApplicationTerm)lhs).getParameters();
            assert (this.isZero(lhsParams[1]));
            return this.proveRewriteWithLeq(lhs, rhs, true);
        }
        if (this.isApplication("=", lhs)) {
            lhsParams = ((ApplicationTerm)lhs).getParameters();
            assert (lhsParams.length == 2);
            if (this.isApplication("false", rhs)) {
                Term proofNotLhs = this.proveTrivialDisequality(lhsParams[0], lhsParams[1]);
                return this.proveIffFalse(theory.term("=", lhs, rhs), proofNotLhs);
            }
            if (this.isApplication("true", rhs)) {
                assert (lhsParams[0] == lhsParams[1]);
                return this.proveIffTrue(theory.term("=", lhs, rhs), this.mProofRules.refl(lhsParams[0]));
            }
            assert (this.isApplication("=", rhs));
            Term[] rhsParams = ((ApplicationTerm)rhs).getParameters();
            assert (rhsParams.length == 2);
            Term equality = theory.term("=", lhs, rhs);
            if (lhsParams[1] == rhsParams[0] && lhsParams[0] == rhsParams[1]) {
                return this.proveIff(equality, this.mProofRules.symm(rhsParams[0], rhsParams[1]), this.mProofRules.symm(lhsParams[0], lhsParams[1]));
            }
            assert (lhsParams[0].getSort().isNumericSort());
            return this.proveRewriteWithLinEq(lhs, rhs);
        }
        throw new AssertionError();
    }

    private Term convertRewriteLeq(String rewriteRule, Term rewrite, Term lhs, Term rhs) {
        boolean isTrue;
        assert (this.isApplication("<=", lhs));
        Term[] params = ((ApplicationTerm)lhs).getParameters();
        assert (params.length == 2 && this.isZero(params[1]));
        Rational param0 = this.parseConstant(params[0]);
        boolean bl = isTrue = rewriteRule == ":leqTrue";
        if (isTrue) {
            assert (param0.signum() <= 0 && this.isApplication("true", rhs));
            Term falseLhs = lhs.getTheory().term("<", params[1], params[0]);
            return this.proveIffTrue(rewrite, this.mProofRules.resolutionRule(falseLhs, this.mProofRules.total(params[0], params[1]), this.mProofRules.farkas(new Term[]{falseLhs}, new BigInteger[]{BigInteger.ONE})));
        }
        assert (param0.signum() > 0 && this.isApplication("false", rhs));
        return this.proveIffFalse(rewrite, this.mProofRules.farkas(new Term[]{lhs}, new BigInteger[]{BigInteger.ONE}));
    }

    private Term convertRewriteNot(Term rewrite, Term lhs, Term rhs) {
        assert (this.isApplication("not", lhs));
        Term lhsAtom = ((ApplicationTerm)lhs).getParameters()[0];
        if (this.isApplication("false", lhsAtom)) {
            assert (this.isApplication("true", rhs));
            return this.proveIffTrue(rewrite, this.mProofRules.resolutionRule(lhsAtom, this.mProofRules.notIntro(lhs), this.mProofRules.falseElim()));
        }
        if (this.isApplication("true", lhsAtom)) {
            assert (this.isApplication("false", rhs));
            return this.proveIffFalse(rewrite, this.mProofRules.resolutionRule(lhsAtom, this.mProofRules.trueIntro(), this.mProofRules.notElim(lhs)));
        }
        if (this.isApplication("not", lhsAtom)) {
            assert (rhs == ((ApplicationTerm)lhsAtom).getParameters()[0]);
            return this.proveIff(rewrite, this.mProofRules.resolutionRule(lhsAtom, this.mProofRules.notIntro(lhsAtom), this.mProofRules.notElim(lhs)), this.mProofRules.resolutionRule(lhsAtom, this.mProofRules.notIntro(lhs), this.mProofRules.notElim(lhsAtom)));
        }
        throw new AssertionError();
    }

    private Term convertRewriteTrueNotFalse(Term lhs, Term rhs) {
        Theory t = lhs.getTheory();
        assert (this.isApplication("=", lhs) && this.isApplication("false", rhs));
        Term[] lhsParams = ((ApplicationTerm)lhs).getParameters();
        int trueIdx = -1;
        int falseIdx = -1;
        for (int i = 0; i < lhsParams.length; ++i) {
            Term term = lhsParams[i];
            if (this.isApplication("true", term)) {
                trueIdx = i;
            }
            if (!this.isApplication("false", term)) continue;
            falseIdx = i;
        }
        assert (trueIdx >= 0 && falseIdx >= 0);
        Term trueEqFalse = t.term("=", lhsParams[trueIdx], lhsParams[falseIdx]);
        Term clause = this.mProofRules.resolutionRule(trueEqFalse, this.mProofRules.equalsElim(trueIdx, falseIdx, lhs), this.mProofRules.iffElim2(trueEqFalse));
        clause = this.mProofRules.resolutionRule(lhs, this.mProofRules.iffIntro1(t.term("=", lhs, rhs)), clause);
        clause = this.mProofRules.resolutionRule(lhsParams[falseIdx], this.mProofRules.resolutionRule(lhsParams[trueIdx], this.mProofRules.trueIntro(), clause), this.mProofRules.falseElim());
        return clause;
    }

    private Term convertRewriteEqTrueFalse(String rewriteRule, Term lhs, Term rhs) {
        Object equality;
        boolean trueCase = rewriteRule.equals(":eqTrue");
        assert (this.isApplication("=", lhs));
        int trueFalseIdx = -1;
        Term[] params = ((ApplicationTerm)lhs).getParameters();
        LinkedHashMap<Term, Integer> args = new LinkedHashMap<Term, Integer>();
        for (int i = 0; i < params.length; ++i) {
            Term t;
            if (this.isApplication(trueCase ? "true" : "false", t = params[i])) {
                trueFalseIdx = i;
                continue;
            }
            if (args.containsKey(t)) continue;
            args.put(t, i);
        }
        assert (trueFalseIdx >= 0);
        Theory theo = lhs.getTheory();
        Term rewrite = theo.term("=", lhs, rhs);
        Term proofRhs = null;
        Term rhsAtom = null;
        if (args.size() > 1 || !trueCase) {
            assert (this.isApplication("not", rhs));
            rhsAtom = ((ApplicationTerm)rhs).getParameters()[0];
            proofRhs = this.mProofRules.notIntro(rhs);
            if (args.size() > 1) {
                assert (this.isApplication("or", rhsAtom));
                proofRhs = this.res(rhsAtom, proofRhs, this.mProofRules.orElim(rhsAtom));
            }
        }
        Term proofLhs = params.length > 2 ? this.mProofRules.equalsIntro(lhs) : null;
        for (int i = 0; i < params.length - 1; ++i) {
            equality = theo.term("=", params[i], params[i + 1]);
            Term iffIntro = trueCase ? this.mProofRules.iffIntro2((Term)equality) : this.mProofRules.iffIntro1((Term)equality);
            proofLhs = this.res((Term)equality, iffIntro, proofLhs);
        }
        int orPos = 0;
        equality = args.values().iterator();
        while (equality.hasNext()) {
            Term orArg;
            int pos = (Integer)equality.next();
            Term arg = params[pos];
            Term notArg = theo.term("not", arg);
            Term term = orArg = trueCase ? notArg : arg;
            if (args.size() > 1) {
                if (trueCase) {
                    proofRhs = this.res(notArg, proofRhs, this.mProofRules.notElim(notArg));
                    proofLhs = this.res(arg, this.mProofRules.notIntro(notArg), proofLhs);
                }
                proofLhs = this.res(orArg, proofLhs, this.mProofRules.orIntro(orPos++, rhsAtom));
            }
            Term argTrueFalse = theo.term("=", arg, params[trueFalseIdx]);
            Term term2 = proofRhs = trueCase ? this.res(arg, this.mProofRules.iffElim1(argTrueFalse), proofRhs) : this.res(arg, proofRhs, this.mProofRules.iffElim2(argTrueFalse));
            Term equalsElim = params.length > 2 ? this.mProofRules.equalsElim(pos, trueFalseIdx, lhs) : (trueFalseIdx == 1 ? null : this.mProofRules.symm(params[1], params[0]));
            proofRhs = this.res(argTrueFalse, equalsElim, proofRhs);
        }
        if (args.size() > 1 || !trueCase) {
            proofLhs = this.res(rhsAtom, proofLhs, this.mProofRules.notElim(rhs));
        }
        Term proof = this.proveIff(rewrite, proofRhs, proofLhs);
        return trueCase ? this.res(params[trueFalseIdx], this.mProofRules.trueIntro(), proof) : this.res(params[trueFalseIdx], proof, this.mProofRules.falseElim());
    }

    private Term convertRewriteToXor(String rule, Term rewrite, Term lhs, Term rhs) {
        Term iffIntro2;
        Term iffIntro1;
        assert (this.isApplication(rule == ":eqToXor" ? "=" : "distinct", lhs));
        Term xorTerm = rhs;
        if (rule == ":eqToXor") {
            xorTerm = this.negate(xorTerm);
        }
        assert (this.isApplication("xor", xorTerm));
        Term[] eqParams = ((ApplicationTerm)lhs).getParameters();
        Term[] xorParams = ((ApplicationTerm)xorTerm).getParameters();
        assert (xorParams.length == 2 && eqParams.length == 2);
        assert (xorParams[0] == eqParams[0] && xorParams[1] == eqParams[1]);
        Term eqLhs = rewrite.getTheory().term("=", eqParams[0], eqParams[1]);
        Term proofEqToNotXor = this.mProofRules.resolutionRule(eqParams[0], this.mProofRules.resolutionRule(eqParams[1], this.mProofRules.xorIntro(new Term[]{xorParams[0]}, new Term[]{xorParams[1]}, xorParams), this.mProofRules.iffElim1(eqLhs)), this.mProofRules.resolutionRule(eqParams[1], this.mProofRules.iffElim2(eqLhs), this.mProofRules.xorElim(new Term[]{xorParams[0]}, new Term[]{xorParams[1]}, xorParams)));
        Term proofNotXorToEq = this.mProofRules.resolutionRule(eqParams[0], this.mProofRules.resolutionRule(eqParams[1], this.mProofRules.iffIntro1(eqLhs), this.mProofRules.xorIntro(xorParams, new Term[]{xorParams[0]}, new Term[]{xorParams[1]})), this.mProofRules.resolutionRule(eqParams[1], this.mProofRules.xorIntro(xorParams, new Term[]{xorParams[1]}, new Term[]{xorParams[0]}), this.mProofRules.iffIntro2(eqLhs)));
        if (rule == ":eqToXor") {
            iffIntro1 = this.mProofRules.resolutionRule(rhs, this.mProofRules.iffIntro1(rewrite), this.mProofRules.notElim(rhs));
            iffIntro2 = this.mProofRules.resolutionRule(rhs, this.mProofRules.notIntro(rhs), this.mProofRules.iffIntro2(rewrite));
        } else {
            iffIntro1 = this.mProofRules.resolutionRule(lhs, this.mProofRules.distinctIntro(lhs), this.mProofRules.iffIntro2(rewrite));
            iffIntro2 = this.mProofRules.resolutionRule(lhs, this.mProofRules.iffIntro1(rewrite), this.mProofRules.distinctElim(0, 1, lhs));
        }
        return this.mProofRules.resolutionRule(eqLhs, this.mProofRules.resolutionRule(xorTerm, proofNotXorToEq, iffIntro1), this.mProofRules.resolutionRule(xorTerm, iffIntro2, proofEqToNotXor));
    }

    private Term convertRewriteXorNot(Term rewrite, Term lhs, Term rhs) {
        Term proof2;
        Theory theory = rewrite.getTheory();
        boolean rhsNegated = false;
        Term rhsAtom = rhs;
        if (this.isApplication("not", rhs)) {
            rhsNegated = !rhsNegated;
            rhsAtom = ((ApplicationTerm)rhs).getParameters()[0];
        }
        assert (this.isApplication("xor", lhs) && this.isApplication("xor", rhsAtom));
        Term[] lhsArgs = ((ApplicationTerm)lhs).getParameters();
        Term[] rhsArgs = ((ApplicationTerm)rhsAtom).getParameters();
        ArrayList<Term> pairs = new ArrayList<Term>();
        assert (lhsArgs.length == rhsArgs.length);
        Term[] xorAllArgs = null;
        Term xorAll = null;
        Term proofXorAll = null;
        boolean xorAllNegated = false;
        for (int i = 0; i < lhsArgs.length; ++i) {
            Term lhsArg = lhsArgs[i];
            Term rhsArg = rhsArgs[i];
            if (this.isApplication("not", lhsArg)) {
                boolean xorAllNextNegated;
                Term proofStep;
                Term proofXor;
                Term arg = lhsArg;
                int numNegations = 0;
                while (this.isApplication("not", arg)) {
                    arg = ((ApplicationTerm)arg).getParameters()[0];
                    ++numNegations;
                }
                assert (arg == rhsArg);
                Term proofLhsNeg = null;
                Term proofLhsPos = null;
                arg = rhsArg;
                for (int ctr = 0; ctr < numNegations; ++ctr) {
                    Term notArg = this.mSkript.term("not", arg);
                    Term nextProofLhsPos = this.res(arg, this.mProofRules.notIntro(notArg), proofLhsNeg);
                    proofLhsNeg = this.res(arg, proofLhsPos, this.mProofRules.notElim(notArg));
                    proofLhsPos = nextProofLhsPos;
                    arg = notArg;
                }
                Term[] xorArgs = new Term[]{lhsArg, rhsArg};
                Term xorTerm = theory.term("xor", xorArgs);
                pairs.add(lhsArg);
                pairs.add(rhsArg);
                Term[] xorAllNextArgs = pairs.toArray(new Term[pairs.size()]);
                Term xorAllNext = theory.term("xor", xorAllNextArgs);
                if (numNegations % 2 == 0) {
                    proofXor = this.mProofRules.resolutionRule(rhsArg, this.mProofRules.resolutionRule(lhsArg, this.mProofRules.xorIntro(new Term[]{lhsArg}, new Term[]{rhsArg}, xorArgs), proofLhsNeg), this.mProofRules.resolutionRule(lhsArg, proofLhsPos, this.mProofRules.xorElim(new Term[]{lhsArg}, new Term[]{rhsArg}, xorArgs)));
                    if (xorAll == null) {
                        proofStep = proofXor;
                    } else {
                        proofStep = xorAllNegated ? this.mProofRules.xorIntro(xorArgs, xorAllNextArgs, xorAllArgs) : this.mProofRules.xorIntro(xorArgs, xorAllArgs, xorAllNextArgs);
                        proofStep = this.mProofRules.resolutionRule(xorTerm, proofStep, proofXor);
                    }
                    xorAllNextNegated = xorAllNegated;
                } else {
                    proofXor = this.mProofRules.resolutionRule(rhsArg, this.mProofRules.resolutionRule(lhsArg, proofLhsPos, this.mProofRules.xorIntro(xorArgs, new Term[]{rhsArg}, new Term[]{lhsArg})), this.mProofRules.resolutionRule(lhsArg, this.mProofRules.xorIntro(xorArgs, new Term[]{lhsArg}, new Term[]{rhsArg}), proofLhsNeg));
                    if (xorAll == null) {
                        proofStep = proofXor;
                    } else {
                        proofStep = xorAllNegated ? this.mProofRules.xorElim(xorAllNextArgs, xorAllArgs, xorArgs) : this.mProofRules.xorIntro(xorAllNextArgs, xorAllArgs, xorArgs);
                        proofStep = this.mProofRules.resolutionRule(xorTerm, proofXor, proofStep);
                    }
                    xorAllNextNegated = !xorAllNegated;
                }
                proofXorAll = this.res(xorAll, xorAllNegated ? proofXorAll : proofStep, xorAllNegated ? proofStep : proofXorAll);
                xorAllArgs = xorAllNextArgs;
                xorAll = xorAllNext;
                xorAllNegated = xorAllNextNegated;
                continue;
            }
            assert (lhsArg == rhsArg);
        }
        assert (pairs.size() > 0);
        assert (rhsNegated == xorAllNegated);
        Term proof1 = this.mProofRules.xorIntro(lhsArgs, rhsNegated ? rhsArgs : xorAllArgs, rhsNegated ? xorAllArgs : rhsArgs);
        Term term = proof2 = rhsNegated ? this.mProofRules.xorElim(rhsArgs, xorAllArgs, lhsArgs) : this.mProofRules.xorIntro(rhsArgs, xorAllArgs, lhsArgs);
        if (rhsNegated) {
            proof1 = this.mProofRules.resolutionRule(rhsAtom, proof1, this.mProofRules.notElim(rhs));
            proof2 = this.mProofRules.resolutionRule(rhsAtom, this.mProofRules.notIntro(rhs), proof2);
        }
        Term proof = this.mProofRules.resolutionRule(lhs, this.mProofRules.resolutionRule(rhs, this.mProofRules.iffIntro1(rewrite), proof1), this.mProofRules.resolutionRule(rhs, proof2, this.mProofRules.iffIntro2(rewrite)));
        return this.mProofRules.resolutionRule(xorAll, xorAllNegated ? proofXorAll : proof, xorAllNegated ? proof : proofXorAll);
    }

    private Term convertRewriteXorConst(String rewriteRule, Term rewrite, Term lhs, Term rhs) {
        assert (this.isApplication("xor", lhs));
        boolean isTrue = rewriteRule == ":xorTrue";
        Term[] xorArgs = ((ApplicationTerm)lhs).getParameters();
        int constIdx = this.isApplication(isTrue ? "true" : "false", xorArgs[0]) ? 0 : 1;
        Term[] constArg = new Term[]{xorArgs[constIdx]};
        Term[] otherArg = new Term[]{xorArgs[1 - constIdx]};
        if (isTrue) {
            assert (this.isApplication("true", xorArgs[constIdx]) && rhs == this.mSkript.term("not", xorArgs[1 - constIdx]));
            Term proof = this.proveIff(rewrite, this.mProofRules.resolutionRule(xorArgs[1 - constIdx], this.mProofRules.notIntro(rhs), this.mProofRules.xorElim(otherArg, xorArgs, constArg)), this.mProofRules.resolutionRule(xorArgs[1 - constIdx], this.mProofRules.xorIntro(otherArg, xorArgs, constArg), this.mProofRules.notElim(rhs)));
            return this.mProofRules.resolutionRule(xorArgs[constIdx], this.mProofRules.trueIntro(), proof);
        }
        assert (this.isApplication("false", xorArgs[constIdx]) && rhs == xorArgs[1 - constIdx]);
        Term proof = this.proveIff(rewrite, this.mProofRules.xorIntro(otherArg, constArg, xorArgs), this.mProofRules.xorIntro(xorArgs, constArg, otherArg));
        return this.mProofRules.resolutionRule(xorArgs[constIdx], proof, this.mProofRules.falseElim());
    }

    private Term convertRewriteXorSame(Term rewrite, Term lhs, Term rhs) {
        assert (this.isApplication("xor", lhs));
        Term[] lhsArgs = ((ApplicationTerm)lhs).getParameters();
        assert (lhsArgs.length == 2 && lhsArgs[0] == lhsArgs[1] && this.isApplication("false", rhs));
        return this.proveIffFalse(rewrite, this.mProofRules.xorElim(lhsArgs, lhsArgs, lhsArgs));
    }

    private Term convertRewriteEqSimp(String rewriteRule, Term lhs, Term rhs) {
        assert (this.isApplication("=", lhs));
        Theory theory = lhs.getTheory();
        Term[] lhsParams = ((ApplicationTerm)lhs).getParameters();
        LinkedHashMap<Term, Integer> lhsTerms = new LinkedHashMap<Term, Integer>();
        for (int i = 0; i < lhsParams.length; ++i) {
            lhsTerms.put(lhsParams[i], i);
        }
        if (lhsTerms.size() == 1) {
            assert (rewriteRule.equals(":eqSame") && this.isApplication("true", rhs));
            Term proof = this.mProofRules.refl(lhsParams[0]);
            if (lhsParams.length > 2) {
                proof = this.res(theory.term("=", lhsParams[0], lhsParams[0]), proof, this.mProofRules.equalsIntro(lhs));
            }
            return this.proveIffTrue(theory.term("=", lhs, rhs), proof);
        }
        assert (rewriteRule.equals(":eqSimp"));
        assert (this.isApplication("=", rhs));
        Term[] rhsParams = ((ApplicationTerm)rhs).getParameters();
        assert (rhsParams.length == lhsTerms.size());
        LinkedHashMap<Term, Integer> rhsTerms = new LinkedHashMap<Term, Integer>();
        for (int i = 0; i < rhsParams.length; ++i) {
            rhsTerms.put(rhsParams[i], i);
        }
        Term proofLhsToRhs = this.mProofRules.equalsIntro(rhs);
        HashSet<Term> seen = new HashSet<Term>();
        for (int i = 0; i < rhsParams.length - 1; ++i) {
            Term eq = theory.term("=", rhsParams[i], rhsParams[i + 1]);
            if (!seen.add(eq)) continue;
            proofLhsToRhs = this.mProofRules.resolutionRule(eq, this.mProofRules.equalsElim((Integer)lhsTerms.get(rhsParams[i]), (Integer)lhsTerms.get(rhsParams[i + 1]), lhs), proofLhsToRhs);
        }
        seen.clear();
        Term proofRhsToLhs = this.mProofRules.equalsIntro(lhs);
        for (int i = 0; i < lhsParams.length - 1; ++i) {
            Term eq = theory.term("=", lhsParams[i], lhsParams[i + 1]);
            if (!seen.add(eq)) continue;
            proofRhsToLhs = this.mProofRules.resolutionRule(eq, this.mProofRules.equalsElim((Integer)rhsTerms.get(lhsParams[i]), (Integer)rhsTerms.get(lhsParams[i + 1]), rhs), proofRhsToLhs);
        }
        return this.proveIff(theory.term("=", lhs, rhs), proofLhsToRhs, proofRhsToLhs);
    }

    private Term convertRewriteEqBinary(Term rewrite, Term lhs, Term rhs) {
        Theory theory = lhs.getTheory();
        assert (this.isApplication("=", lhs));
        Term[] lhsParams = ((ApplicationTerm)lhs).getParameters();
        assert (lhsParams.length >= 3);
        assert (this.isApplication("not", rhs));
        Term rhsAtom = ((ApplicationTerm)rhs).getParameters()[0];
        assert (this.isApplication("or", rhsAtom));
        Term[] rhsParams = ((ApplicationTerm)rhsAtom).getParameters();
        assert (lhsParams.length == rhsParams.length + 1);
        Term proof1 = this.mProofRules.resolutionRule(rhs, this.mProofRules.iffIntro1(rewrite), this.mProofRules.notElim(rhs));
        Term proof2 = this.mProofRules.resolutionRule(rhs, this.mProofRules.notIntro(rhs), this.mProofRules.iffIntro2(rewrite));
        proof2 = this.mProofRules.resolutionRule(rhsAtom, proof2, this.mProofRules.orElim(rhsAtom));
        proof2 = this.mProofRules.resolutionRule(lhs, this.mProofRules.equalsIntro(lhs), proof2);
        for (int i = 0; i < rhsParams.length; ++i) {
            Term eqi = theory.term("=", lhsParams[i], lhsParams[i + 1]);
            assert (rhsParams[i] == theory.term("not", eqi));
            proof2 = this.mProofRules.resolutionRule(rhsParams[i], proof2, this.mProofRules.notElim(rhsParams[i]));
            proof2 = this.mProofRules.resolutionRule(eqi, this.mProofRules.resolutionRule(rhsParams[i], this.mProofRules.notIntro(rhsParams[i]), this.mProofRules.resolutionRule(rhsAtom, this.mProofRules.orIntro(i, rhsAtom), this.mProofRules.resolutionRule(lhs, proof1, this.mProofRules.equalsElim(i, i + 1, lhs)))), proof2);
        }
        return proof2;
    }

    private Term convertRewriteDistinct(String rewriteRule, Term rewrite, Term lhs, Term rhs) {
        Theory theory = lhs.getTheory();
        assert (this.isApplication("distinct", lhs));
        Term[] args = ((ApplicationTerm)lhs).getParameters();
        switch (rewriteRule) {
            case ":distinctBool": {
                assert (args.length > 2 && args[0].getSort().getName() == "Bool" && this.isApplication("false", rhs));
                Term eq01 = theory.term("=", args[0], args[1]);
                Term eq02 = theory.term("=", args[0], args[2]);
                Term eq12 = theory.term("=", args[1], args[2]);
                Term proof01 = this.mProofRules.distinctElim(0, 1, lhs);
                Term proof02 = this.mProofRules.distinctElim(0, 2, lhs);
                Term proof12 = this.mProofRules.distinctElim(1, 2, lhs);
                Term proof = this.mProofRules.resolutionRule(args[0], this.mProofRules.resolutionRule(args[1], this.mProofRules.iffIntro1(eq01), this.mProofRules.resolutionRule(args[2], this.mProofRules.iffIntro1(eq02), this.mProofRules.iffIntro2(eq12))), this.mProofRules.resolutionRule(args[1], this.mProofRules.resolutionRule(args[2], this.mProofRules.iffIntro1(eq12), this.mProofRules.iffIntro2(eq02)), this.mProofRules.iffIntro2(eq01)));
                proof = this.mProofRules.resolutionRule(eq01, this.mProofRules.resolutionRule(eq02, this.mProofRules.resolutionRule(eq12, proof, proof12), proof02), proof01);
                proof = this.proveIffFalse(rewrite, proof);
                return proof;
            }
            case ":distinctSame": {
                assert (this.isApplication("false", rhs));
                HashMap<Term, Integer> seen = new HashMap<Term, Integer>();
                for (int i = 0; i < args.length; ++i) {
                    Integer otherIdx = seen.put(args[i], i);
                    if (otherIdx == null) continue;
                    Term eq = theory.term("=", args[i], args[i]);
                    return this.proveIffFalse(rewrite, this.res(eq, this.mProofRules.refl(args[i]), this.mProofRules.distinctElim(otherIdx, i, lhs)));
                }
                throw new AssertionError();
            }
            case ":distinctBinary": {
                Term rhsAtom = this.negate(rhs);
                if (args.length == 2) {
                    assert (rhsAtom == this.mSkript.term("=", args[0], args[1]));
                    Term proof1 = this.mProofRules.resolutionRule(rhsAtom, this.mProofRules.distinctIntro(lhs), this.mProofRules.notElim(rhs));
                    Term proof2 = this.mProofRules.resolutionRule(rhsAtom, this.mProofRules.notIntro(rhs), this.mProofRules.distinctElim(0, 1, lhs));
                    return this.mProofRules.resolutionRule(lhs, this.mProofRules.resolutionRule(rhs, this.mProofRules.iffIntro1(rewrite), proof1), this.mProofRules.resolutionRule(rhs, proof2, this.mProofRules.iffIntro2(rewrite)));
                }
                assert (this.isApplication("or", rhsAtom));
                Term[] rhsArgs = ((ApplicationTerm)rhsAtom).getParameters();
                Term proof1 = this.mProofRules.distinctIntro(lhs);
                Term proof2 = this.mProofRules.resolutionRule(rhsAtom, this.mProofRules.notIntro(rhs), this.mProofRules.orElim(rhsAtom));
                int offset = 0;
                for (int i = 0; i < args.length - 1; ++i) {
                    for (int j = i + 1; j < args.length; ++j) {
                        assert (offset < rhsArgs.length && rhsArgs[offset] == this.mSkript.term("=", args[i], args[j]));
                        proof1 = this.mProofRules.resolutionRule(rhsArgs[offset], proof1, this.mProofRules.orIntro(offset, rhsAtom));
                        proof2 = this.mProofRules.resolutionRule(rhsArgs[offset], proof2, this.mProofRules.distinctElim(i, j, lhs));
                        ++offset;
                    }
                }
                proof1 = this.mProofRules.resolutionRule(rhsAtom, proof1, this.mProofRules.notElim(rhs));
                assert (offset == rhsArgs.length);
                return this.proveIff(rewrite, proof2, proof1);
            }
        }
        throw new AssertionError();
    }

    private Term convertRewriteOrSimp(Term rewriteStmt, Term lhs, Term rhs) {
        int i;
        assert (this.isApplication("or", lhs));
        LinkedHashMap<Term, Integer> args = new LinkedHashMap<Term, Integer>();
        Term[] lhsParams = ((ApplicationTerm)lhs).getParameters();
        Term falseTerm = null;
        for (int i2 = 0; i2 < lhsParams.length; ++i2) {
            if (this.isApplication("false", lhsParams[i2])) {
                falseTerm = lhsParams[i2];
                continue;
            }
            args.put(lhsParams[i2], i2);
        }
        Term proofRhs = this.mProofRules.orElim(lhs);
        if (falseTerm != null && rhs != falseTerm) {
            proofRhs = this.mProofRules.resolutionRule(falseTerm, proofRhs, this.mProofRules.falseElim());
        }
        Term proofLhs = null;
        if (this.isApplication("false", rhs)) {
            proofLhs = this.mProofRules.falseElim();
        } else if (args.size() > 1) {
            assert (this.isApplication("or", rhs));
            Term[] rhsParams = ((ApplicationTerm)rhs).getParameters();
            for (i = 0; i < rhsParams.length; ++i) {
                proofRhs = this.mProofRules.resolutionRule(rhsParams[i], proofRhs, this.mProofRules.orIntro(i, rhs));
            }
            proofLhs = this.mProofRules.orElim(rhs);
        }
        Iterator iterator = args.values().iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (proofLhs == null) {
                proofLhs = this.mProofRules.orIntro(i, lhs);
                continue;
            }
            proofLhs = this.mProofRules.resolutionRule(lhsParams[i], proofLhs, this.mProofRules.orIntro(i, lhs));
        }
        return this.proveIff(rewriteStmt, proofRhs, proofLhs);
    }

    private Term convertRewriteOrTaut(Term rewrite, Term lhs, Term rhs) {
        assert (this.isApplication("or", lhs) && this.isApplication("true", rhs));
        Term proof = this.mProofRules.iffIntro2(rewrite);
        HashMap<Term, Integer> seen = new HashMap<Term, Integer>();
        Term[] lhsParams = ((ApplicationTerm)lhs).getParameters();
        for (int i = 0; i < lhsParams.length; ++i) {
            if (this.isApplication("true", lhsParams[i])) {
                proof = this.mProofRules.resolutionRule(lhs, this.mProofRules.orIntro(i, lhs), proof);
                break;
            }
            Integer otherIdx = (Integer)seen.get(this.negate(lhsParams[i]));
            if (otherIdx != null) {
                int posIdx;
                int negIdx;
                if (this.isApplication("not", lhsParams[i])) {
                    negIdx = i;
                    posIdx = otherIdx;
                } else {
                    negIdx = otherIdx;
                    posIdx = i;
                }
                Term orProof = this.mProofRules.resolutionRule(lhsParams[posIdx], this.mProofRules.resolutionRule(lhsParams[negIdx], this.mProofRules.notIntro(lhsParams[negIdx]), this.mProofRules.orIntro(negIdx, lhs)), this.mProofRules.orIntro(posIdx, lhs));
                proof = this.mProofRules.resolutionRule(lhs, orProof, proof);
                break;
            }
            seen.put(lhsParams[i], i);
        }
        return this.mProofRules.resolutionRule(rhs, this.mProofRules.trueIntro(), proof);
    }

    private Term convertRewriteCanonicalSum(Term lhs, Term rhs) {
        Theory theory = lhs.getTheory();
        if (lhs instanceof ConstantTerm) {
            return this.proveTrivialEquality(lhs, rhs);
        }
        ApplicationTerm lhsApp = (ApplicationTerm)lhs;
        Term[] lhsArgs = lhsApp.getParameters();
        switch (lhsApp.getFunction().getName()) {
            case "+": {
                return this.mProofRules.polyAdd(lhs, rhs);
            }
            case "*": {
                return this.mProofRules.polyMul(lhs, rhs);
            }
            case "to_real": {
                Term expected = ProofRules.computePolyToReal(lhsArgs[0]);
                if (rhs == expected) {
                    return this.mProofRules.toRealDef(lhs);
                }
                return this.res(theory.term("=", lhs, expected), this.mProofRules.toRealDef(lhs), this.res(theory.term("=", expected, rhs), this.mProofRules.polyAdd(expected, rhs), this.mProofRules.trans(lhs, expected, rhs)));
            }
            case "-": {
                Term minusToPlus = ProofRules.computePolyMinus(lhs);
                if (minusToPlus == rhs) {
                    return this.mProofRules.minusDef(lhs);
                }
                if (lhsArgs.length == 1) {
                    Term proof = this.res(theory.term("=", lhs, minusToPlus), this.mProofRules.minusDef(lhs), this.mProofRules.trans(lhs, minusToPlus, rhs));
                    return this.res(theory.term("=", minusToPlus, rhs), this.mProofRules.polyMul(minusToPlus, rhs), proof);
                }
                Term[] expectedArgs = new Term[lhsArgs.length];
                expectedArgs[0] = lhsArgs[0];
                for (int i = 1; i < lhsArgs.length; ++i) {
                    SMTAffineTerm affineTerm = new SMTAffineTerm();
                    affineTerm.add(Rational.MONE, lhsArgs[i]);
                    expectedArgs[i] = affineTerm.toTerm(lhsArgs[i].getSort());
                }
                Term expectedPlus = theory.term("+", expectedArgs);
                Term proof = expectedPlus != rhs ? this.res(theory.term("=", expectedPlus, rhs), this.mProofRules.polyAdd(expectedPlus, rhs), this.mProofRules.trans(lhs, minusToPlus, expectedPlus, rhs)) : this.mProofRules.trans(lhs, minusToPlus, expectedPlus);
                proof = this.res(theory.term("=", lhs, minusToPlus), this.mProofRules.minusDef(lhs), proof);
                proof = this.res(theory.term("=", minusToPlus, expectedPlus), this.mProofRules.cong(minusToPlus, expectedPlus), proof);
                HashSet<Term> seenEqs = new HashSet<Term>();
                Term[] minusToPlusArgs = ((ApplicationTerm)minusToPlus).getParameters();
                for (int i = 0; i < minusToPlusArgs.length; ++i) {
                    Term eq = theory.term("=", minusToPlusArgs[i], expectedArgs[i]);
                    if (!seenEqs.add(eq)) continue;
                    Term proofEq = minusToPlusArgs[i] == expectedArgs[i] ? this.mProofRules.refl(minusToPlusArgs[i]) : this.mProofRules.polyMul(minusToPlusArgs[i], expectedArgs[i]);
                    proof = this.res(eq, proofEq, proof);
                }
                return proof;
            }
            case "/": {
                Term proofDivDef = this.mProofRules.divideDef(lhs);
                Sort sort = lhs.getSort();
                Term zero = Rational.ZERO.toTerm(sort);
                Term[] mulTermArgs = new Term[lhsArgs.length];
                Rational multiplier = Rational.ONE;
                for (int i = 1; i < lhsArgs.length; ++i) {
                    Term eqZero = theory.term("=", lhsArgs[i], zero);
                    proofDivDef = this.res(eqZero, proofDivDef, this.proveTrivialDisequality(lhsArgs[i], zero));
                    multiplier = multiplier.mul(this.parseConstant(lhsArgs[i]));
                    mulTermArgs[i - 1] = lhsArgs[i];
                }
                mulTermArgs[mulTermArgs.length - 1] = lhs;
                Term mulTerm = theory.term("*", mulTermArgs);
                if (mulTermArgs.length > 2) {
                    Term mulShortTerm = theory.term("*", multiplier.toTerm(sort), lhs);
                    proofDivDef = this.res(theory.term("=", mulShortTerm, mulTerm), this.res(theory.term("=", mulTerm, mulShortTerm), this.mProofRules.polyMul(mulTerm, mulShortTerm), this.mProofRules.symm(mulShortTerm, mulTerm)), this.mProofRules.trans(mulShortTerm, mulTerm, lhsArgs[0]));
                    mulTerm = mulShortTerm;
                }
                return this.res(theory.term("=", mulTerm, lhsArgs[0]), proofDivDef, this.proveEqWithMultiplier(new Term[]{mulTerm, lhsArgs[0]}, new Term[]{lhs, rhs}, multiplier.inverse()));
            }
        }
        throw new AssertionError();
    }

    private Term convertRewriteToInt(Term lhs, Term rhs) {
        assert (this.isApplication("to_int", lhs));
        Term arg = ((ApplicationTerm)lhs).getParameters()[0];
        Rational argConst = this.parseConstant(arg);
        Rational rhsConst = this.parseConstant(rhs);
        assert (argConst != null && rhsConst != null && rhsConst.equals(argConst.floor()));
        Theory theory = lhs.getTheory();
        Term diffLhsRhs = theory.term("+", lhs, rhsConst.negate().toTerm(rhs.getSort()));
        Term lt = theory.term("<", lhs, rhs);
        Term gt = theory.term("<", rhs, lhs);
        Term leqDiffm1 = theory.term("<=", diffLhsRhs, Rational.MONE.toTerm(rhs.getSort()));
        Term geqDiff0 = theory.term("<=", Rational.ZERO.toTerm(rhs.getSort()), diffLhsRhs);
        Term leqDiff0 = theory.term("<=", diffLhsRhs, Rational.ZERO.toTerm(rhs.getSort()));
        Term geqDiff1 = theory.term("<=", Rational.ONE.toTerm(rhs.getSort()), diffLhsRhs);
        Term proof = this.mProofRules.trichotomy(lhs, rhs);
        Term one = Rational.ONE.toTerm(arg.getSort());
        Term toIntLowLeq = theory.term("<=", theory.term("to_real", lhs), arg);
        Term toIntHighLt = theory.term("<", arg, theory.term("+", theory.term("to_real", lhs), one));
        BigInteger[] coeffs = new BigInteger[]{BigInteger.ONE, BigInteger.ONE};
        proof = this.res(gt, proof, this.mProofRules.farkas(new Term[]{gt, leqDiff0}, coeffs));
        proof = this.res(leqDiff0, this.mProofRules.totalInt(diffLhsRhs, BigInteger.ZERO), proof);
        proof = this.res(geqDiff1, proof, this.mProofRules.farkas(new Term[]{toIntLowLeq, geqDiff1}, coeffs));
        proof = this.res(lt, proof, this.mProofRules.farkas(new Term[]{lt, geqDiff0}, coeffs));
        proof = this.res(geqDiff0, this.mProofRules.totalInt(diffLhsRhs, BigInteger.ONE.negate()), proof);
        proof = this.res(leqDiffm1, proof, this.mProofRules.farkas(new Term[]{toIntHighLt, leqDiffm1}, coeffs));
        proof = this.res(toIntLowLeq, this.mProofRules.toIntLow(arg), proof);
        proof = this.res(toIntHighLt, this.mProofRules.toIntHigh(arg), proof);
        return proof;
    }

    private Term convertRewriteStoreOverStore(Term lhs, Term rhs) {
        assert (this.isApplication("store", lhs));
        Term[] outerArgs = ((ApplicationTerm)lhs).getParameters();
        Term innerStore = outerArgs[0];
        Term index = outerArgs[1];
        Term valueW = outerArgs[2];
        assert (this.isApplication("store", innerStore));
        Term[] innerArgs = ((ApplicationTerm)innerStore).getParameters();
        Term array = innerArgs[0];
        Term innerIndex = innerArgs[1];
        Term proofEq = this.proveTrivialEquality(index, innerIndex);
        assert (proofEq != null);
        assert (rhs == this.mSkript.term("store", array, index, valueW));
        Theory theory = lhs.getTheory();
        Term diff = theory.term("@diff", lhs, rhs);
        Term selectLhsDiff = theory.term("select", lhs, diff);
        Term selectInnerDiff = theory.term("select", innerStore, diff);
        Term selectArrayDiff = theory.term("select", array, diff);
        Term selectRhsDiff = theory.term("select", rhs, diff);
        Term selectLhsI = theory.term("select", lhs, index);
        Term selectRhsI = theory.term("select", rhs, index);
        Term proof1 = this.mProofRules.trans(selectLhsDiff, selectLhsI, valueW, selectRhsI, selectRhsDiff);
        proof1 = this.res(theory.term("=", selectLhsDiff, selectLhsI), this.mProofRules.cong(selectLhsDiff, selectLhsI), proof1);
        proof1 = this.res(theory.term("=", lhs, lhs), this.mProofRules.refl(lhs), proof1);
        proof1 = this.res(theory.term("=", diff, index), this.mProofRules.symm(diff, index), proof1);
        proof1 = this.res(theory.term("=", selectLhsI, valueW), this.mProofRules.selectStore1(innerStore, index, valueW), proof1);
        proof1 = this.res(theory.term("=", valueW, selectRhsI), this.mProofRules.symm(valueW, selectRhsI), proof1);
        proof1 = this.res(theory.term("=", selectRhsI, valueW), this.mProofRules.selectStore1(array, index, valueW), proof1);
        proof1 = this.res(theory.term("=", selectRhsI, selectRhsDiff), this.mProofRules.cong(selectRhsI, selectRhsDiff), proof1);
        proof1 = this.res(theory.term("=", rhs, rhs), this.mProofRules.refl(rhs), proof1);
        Term proof2 = this.mProofRules.trans(selectLhsDiff, selectInnerDiff, selectArrayDiff, selectRhsDiff);
        proof2 = this.res(theory.term("=", selectLhsDiff, selectInnerDiff), this.mProofRules.selectStore2(innerStore, index, valueW, diff), proof2);
        proof2 = this.res(theory.term("=", selectInnerDiff, selectArrayDiff), this.mProofRules.selectStore2(array, innerIndex, innerArgs[2], diff), proof2);
        if (innerIndex != index) {
            proof2 = this.res(theory.term("=", innerIndex, diff), proof2, this.mProofRules.trans(index, innerIndex, diff));
            proof2 = this.res(theory.term("=", index, innerIndex), proofEq, proof2);
        }
        proof2 = this.res(theory.term("=", selectArrayDiff, selectRhsDiff), this.mProofRules.symm(selectArrayDiff, selectRhsDiff), proof2);
        proof2 = this.res(theory.term("=", selectRhsDiff, selectArrayDiff), this.mProofRules.selectStore2(array, index, valueW, diff), proof2);
        Term proof = this.res(theory.term("=", index, diff), proof2, proof1);
        proof = this.res(theory.term("=", selectLhsDiff, selectRhsDiff), proof, this.mProofRules.extDiff(lhs, rhs));
        return proof;
    }

    private Term convertRewriteSelectOverStore(Term lhs, Term rhs) {
        Theory theory = lhs.getTheory();
        assert (this.isApplication("select", lhs));
        Term[] selectArgs = ((ApplicationTerm)lhs).getParameters();
        Term store = selectArgs[0];
        assert (this.isApplication("store", store));
        Term[] storeArgs = ((ApplicationTerm)store).getParameters();
        Term array = storeArgs[0];
        Term indexI = storeArgs[1];
        Term value = storeArgs[2];
        Term indexJ = selectArgs[1];
        Term proofEqualJI = this.proveTrivialEquality(indexJ, indexI);
        if (proofEqualJI != null) {
            assert (rhs == storeArgs[2]);
            Term selectStoreI = theory.term("select", store, indexI);
            Term proof = this.mProofRules.trans(lhs, selectStoreI, value);
            proof = this.res(theory.term("=", lhs, selectStoreI), this.mProofRules.cong(lhs, selectStoreI), proof);
            proof = this.res(theory.term("=", store, store), this.mProofRules.refl(store), proof);
            proof = this.res(theory.term("=", indexJ, indexI), proofEqualJI, proof);
            proof = this.res(theory.term("=", selectStoreI, value), this.mProofRules.selectStore1(array, indexI, value), proof);
            return proof;
        }
        Term proofNotEqual = this.proveTrivialDisequality(indexI, indexJ);
        assert (proofNotEqual != null);
        return this.res(theory.term("=", indexI, indexJ), this.mProofRules.selectStore2(array, indexI, value, indexJ), proofNotEqual);
    }

    private Term convertRewriteAuxIntro(Term rewrite, Term lhs, Term rhs) {
        Term symmEq = this.mSkript.term("=", rhs, lhs);
        return this.res(symmEq, this.mProofRules.expand(rhs), this.mProofRules.symm(lhs, rhs));
    }

    private Term convertRewriteStore(Term rewrite, Term lhs, Term rhs) {
        Theory theory = lhs.getTheory();
        assert (this.isApplication("=", lhs));
        Term[] lhsArgs = ((ApplicationTerm)lhs).getParameters();
        int storeIdx = this.isApplication("store", lhsArgs[0]) && ((ApplicationTerm)lhsArgs[0]).getParameters()[0] == lhsArgs[1] ? 0 : 1;
        Term store = lhsArgs[storeIdx];
        Term[] storeArgs = ((ApplicationTerm)store).getParameters();
        Term array = storeArgs[0];
        Term index = storeArgs[1];
        Term value = storeArgs[2];
        assert (this.isApplication("store", store) && array == lhsArgs[1 - storeIdx]);
        Term diff = theory.term("@diff", store, array);
        Term selectArrayDiff = theory.term("select", array, diff);
        Term selectStoreDiff = theory.term("select", store, diff);
        Term selectArrayI = theory.term("select", array, index);
        Term selectStoreI = theory.term("select", store, index);
        Term proofRhs = this.res(theory.term("=", selectArrayI, selectStoreI), this.res(theory.term("=", index, index), this.mProofRules.refl(index), this.mProofRules.cong(selectArrayI, selectStoreI)), this.mProofRules.trans(selectArrayI, selectStoreI, value));
        Term proofLhs = this.mProofRules.trans(selectStoreDiff, selectStoreI, value, selectArrayI, selectArrayDiff);
        proofLhs = this.res(theory.term("=", selectStoreDiff, selectStoreI), this.mProofRules.cong(selectStoreDiff, selectStoreI), proofLhs);
        proofLhs = this.res(theory.term("=", diff, index), this.mProofRules.symm(diff, index), proofLhs);
        proofLhs = this.res(theory.term("=", store, store), this.mProofRules.refl(store), proofLhs);
        proofLhs = this.res(theory.term("=", value, selectArrayI), this.mProofRules.symm(value, selectArrayI), proofLhs);
        proofLhs = this.res(theory.term("=", selectArrayI, selectArrayDiff), this.mProofRules.cong(selectArrayI, selectArrayDiff), proofLhs);
        proofLhs = this.res(theory.term("=", array, array), this.mProofRules.refl(array), proofLhs);
        proofLhs = this.res(theory.term("=", index, diff), this.mProofRules.selectStore2(array, index, value, diff), proofLhs);
        proofLhs = this.res(theory.term("=", selectStoreDiff, selectArrayDiff), proofLhs, this.mProofRules.extDiff(store, array));
        if (storeIdx == 0) {
            proofRhs = this.res(theory.term("=", array, store), this.mProofRules.symm(array, store), proofRhs);
        } else {
            proofLhs = this.res(theory.term("=", store, array), proofLhs, this.mProofRules.symm(array, store));
        }
        Term proof = this.proveIff(rewrite, proofRhs, proofLhs);
        proof = this.res(theory.term("=", selectStoreI, value), this.mProofRules.selectStore1(array, index, value), proof);
        return proof;
    }

    private Term convertRewriteToLeq0(String rewriteRule, Term lhs, Term rhs) {
        Term rhsAtom;
        boolean isNegated;
        switch (rewriteRule) {
            case ":leqToLeq0": {
                assert (this.isApplication("<=", lhs));
                isNegated = false;
                break;
            }
            case ":ltToLeq0": {
                assert (this.isApplication("<", lhs));
                isNegated = true;
                break;
            }
            case ":geqToLeq0": {
                assert (this.isApplication(">=", lhs));
                isNegated = false;
                break;
            }
            case ":gtToLeq0": {
                assert (this.isApplication(">", lhs));
                isNegated = true;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Term term = rhsAtom = isNegated ? this.negate(rhs) : rhs;
        assert (this.isApplication("<=", rhsAtom));
        return this.proveRewriteWithLeq(lhs, rhs, false);
    }

    private Term convertRewriteIte(String rewriteRule, Term rewriteStmt, Term ite, Term rhs) {
        assert (this.isApplication("ite", ite));
        Term[] args = ((ApplicationTerm)ite).getParameters();
        Term cond = args[0];
        Term t1 = args[1];
        Term t2 = args[2];
        switch (rewriteRule) {
            case ":iteTrue": {
                return this.mProofRules.resolutionRule(cond, this.mProofRules.trueIntro(), this.mProofRules.ite1(ite));
            }
            case ":iteFalse": {
                return this.mProofRules.resolutionRule(cond, this.mProofRules.ite2(ite), this.mProofRules.falseElim());
            }
            case ":iteSame": {
                return this.mProofRules.resolutionRule(cond, this.mProofRules.ite2(ite), this.mProofRules.ite1(ite));
            }
            case ":iteBool1": {
                assert (this.isApplication("true", t1) && this.isApplication("false", t2) && rhs == cond);
                Term iteFalse = this.mSkript.term("=", ite, t2);
                Term proofRhs = this.mProofRules.resolutionRule(iteFalse, this.mProofRules.ite2(ite), this.mProofRules.iffElim2(iteFalse));
                proofRhs = this.mProofRules.resolutionRule(t2, proofRhs, this.mProofRules.falseElim());
                Term iteTrue = this.mSkript.term("=", ite, t1);
                Term proofLhs = this.mProofRules.resolutionRule(iteTrue, this.mProofRules.ite1(ite), this.mProofRules.iffElim1(iteTrue));
                proofLhs = this.mProofRules.resolutionRule(t1, this.mProofRules.trueIntro(), proofLhs);
                return this.proveIff(rewriteStmt, proofRhs, proofLhs);
            }
            case ":iteBool2": {
                assert (this.isApplication("false", t1) && this.isApplication("true", t2) && rhs == this.mSkript.term("not", cond));
                Term iteFalse = this.mSkript.term("=", ite, t1);
                Term proofRhs = this.mProofRules.resolutionRule(iteFalse, this.mProofRules.ite1(ite), this.mProofRules.iffElim2(iteFalse));
                proofRhs = this.mProofRules.resolutionRule(t1, proofRhs, this.mProofRules.falseElim());
                proofRhs = this.mProofRules.resolutionRule(cond, this.mProofRules.notIntro(rhs), proofRhs);
                Term iteTrue = this.mSkript.term("=", ite, t2);
                Term proofLhs = this.mProofRules.resolutionRule(iteTrue, this.mProofRules.ite2(ite), this.mProofRules.iffElim1(iteTrue));
                proofLhs = this.mProofRules.resolutionRule(t2, this.mProofRules.trueIntro(), proofLhs);
                proofLhs = this.mProofRules.resolutionRule(cond, proofLhs, this.mProofRules.notElim(rhs));
                return this.proveIff(rewriteStmt, proofRhs, proofLhs);
            }
            case ":iteBool3": {
                assert (this.isApplication("true", t1) && rhs == this.mSkript.term("or", cond, t2));
                Term iteTrue = this.mSkript.term("=", ite, t1);
                Term iteT2 = this.mSkript.term("=", ite, t2);
                Term proofRhs = this.mProofRules.resolutionRule(cond, this.mProofRules.resolutionRule(t2, this.mProofRules.resolutionRule(iteT2, this.mProofRules.ite2(ite), this.mProofRules.iffElim2(iteT2)), this.mProofRules.orIntro(1, rhs)), this.mProofRules.orIntro(0, rhs));
                Term proofLhs = this.mProofRules.resolutionRule(cond, this.mProofRules.resolutionRule(t2, this.mProofRules.orElim(rhs), this.mProofRules.resolutionRule(iteT2, this.mProofRules.ite2(ite), this.mProofRules.iffElim1(iteT2))), this.mProofRules.resolutionRule(iteTrue, this.mProofRules.ite1(ite), this.mProofRules.iffElim1(iteTrue)));
                proofLhs = this.mProofRules.resolutionRule(t1, this.mProofRules.trueIntro(), proofLhs);
                return this.proveIff(rewriteStmt, proofRhs, proofLhs);
            }
            case ":iteBool4": {
                assert (this.isApplication("false", t1) && rhs == this.mSkript.term("not", this.mSkript.term("or", cond, this.mSkript.term("not", t2))));
                Term notRhs = ((ApplicationTerm)rhs).getParameters()[0];
                Term notT2 = ((ApplicationTerm)notRhs).getParameters()[1];
                Term iteFalse = this.mSkript.term("=", ite, t1);
                Term iteT2 = this.mSkript.term("=", ite, t2);
                Term proofRhs = this.mProofRules.resolutionRule(cond, this.mProofRules.resolutionRule(notT2, this.mProofRules.orElim(notRhs), this.mProofRules.resolutionRule(t2, this.mProofRules.resolutionRule(iteT2, this.mProofRules.ite2(ite), this.mProofRules.iffElim2(iteT2)), this.mProofRules.notElim(notT2))), this.mProofRules.resolutionRule(iteFalse, this.mProofRules.ite1(ite), this.mProofRules.iffElim2(iteFalse)));
                proofRhs = this.mProofRules.resolutionRule(t1, proofRhs, this.mProofRules.falseElim());
                proofRhs = this.mProofRules.resolutionRule(notRhs, this.mProofRules.notIntro(rhs), proofRhs);
                Term proofLhs = this.mProofRules.resolutionRule(cond, this.mProofRules.resolutionRule(t2, this.mProofRules.resolutionRule(notT2, this.mProofRules.notIntro(notT2), this.mProofRules.orIntro(1, notRhs)), this.mProofRules.resolutionRule(iteT2, this.mProofRules.ite2(ite), this.mProofRules.iffElim1(iteT2))), this.mProofRules.orIntro(0, notRhs));
                proofLhs = this.mProofRules.resolutionRule(notRhs, proofLhs, this.mProofRules.notElim(rhs));
                return this.proveIff(rewriteStmt, proofRhs, proofLhs);
            }
            case ":iteBool5": {
                Term notCond = this.mSkript.term("not", cond);
                assert (this.isApplication("true", t2) && rhs == this.mSkript.term("or", notCond, t1));
                Term iteT1 = this.mSkript.term("=", ite, t1);
                Term iteTrue = this.mSkript.term("=", ite, t2);
                Term proofRhs = this.mProofRules.resolutionRule(cond, this.mProofRules.resolutionRule(notCond, this.mProofRules.notIntro(notCond), this.mProofRules.orIntro(0, rhs)), this.mProofRules.resolutionRule(t1, this.mProofRules.resolutionRule(iteT1, this.mProofRules.ite1(ite), this.mProofRules.iffElim2(iteT1)), this.mProofRules.orIntro(1, rhs)));
                Term proofLhs = this.mProofRules.resolutionRule(cond, this.mProofRules.resolutionRule(iteTrue, this.mProofRules.ite2(ite), this.mProofRules.iffElim1(iteTrue)), this.mProofRules.resolutionRule(t1, this.mProofRules.resolutionRule(notCond, this.mProofRules.orElim(rhs), this.mProofRules.notElim(notCond)), this.mProofRules.resolutionRule(iteT1, this.mProofRules.ite1(ite), this.mProofRules.iffElim1(iteT1))));
                proofLhs = this.mProofRules.resolutionRule(t2, this.mProofRules.trueIntro(), proofLhs);
                return this.proveIff(rewriteStmt, proofRhs, proofLhs);
            }
            case ":iteBool6": {
                assert (this.isApplication("false", t2) && rhs == this.mSkript.term("not", this.mSkript.term("or", this.mSkript.term("not", cond), this.mSkript.term("not", t1))));
                Term notRhs = ((ApplicationTerm)rhs).getParameters()[0];
                Term notT1 = ((ApplicationTerm)notRhs).getParameters()[1];
                Term notCond = ((ApplicationTerm)notRhs).getParameters()[0];
                Term iteT1 = this.mSkript.term("=", ite, t1);
                Term iteFalse = this.mSkript.term("=", ite, t2);
                Term proofRhs = this.mProofRules.resolutionRule(cond, this.mProofRules.resolutionRule(iteFalse, this.mProofRules.ite2(ite), this.mProofRules.iffElim2(iteFalse)), this.mProofRules.resolutionRule(notCond, this.mProofRules.resolutionRule(notT1, this.mProofRules.orElim(notRhs), this.mProofRules.resolutionRule(t1, this.mProofRules.resolutionRule(iteT1, this.mProofRules.ite1(ite), this.mProofRules.iffElim2(iteT1)), this.mProofRules.notElim(notT1))), this.mProofRules.notElim(notCond)));
                proofRhs = this.mProofRules.resolutionRule(t2, proofRhs, this.mProofRules.falseElim());
                proofRhs = this.mProofRules.resolutionRule(notRhs, this.mProofRules.notIntro(rhs), proofRhs);
                Term proofLhs = this.mProofRules.resolutionRule(notCond, this.mProofRules.resolutionRule(cond, this.mProofRules.notIntro(notCond), this.mProofRules.resolutionRule(t1, this.mProofRules.resolutionRule(notT1, this.mProofRules.notIntro(notT1), this.mProofRules.orIntro(1, notRhs)), this.mProofRules.resolutionRule(iteT1, this.mProofRules.ite1(ite), this.mProofRules.iffElim1(iteT1)))), this.mProofRules.orIntro(0, notRhs));
                proofLhs = this.mProofRules.resolutionRule(notRhs, proofLhs, this.mProofRules.notElim(rhs));
                return this.proveIff(rewriteStmt, proofRhs, proofLhs);
            }
        }
        throw new AssertionError();
    }

    private Term convertRewriteConstDiff(Term rewriteStmt, Term lhs, Term rhs) {
        assert (this.isApplication("=", lhs) && this.isApplication("false", rhs));
        Term[] lhsParams = ((ApplicationTerm)lhs).getParameters();
        assert (lhsParams[0].getSort().isNumericSort());
        int lastConstantIdx = -1;
        Rational lastConstant = null;
        for (int i = 0; i < lhsParams.length; ++i) {
            Rational value = this.parseConstant(lhsParams[i]);
            if (value == null) continue;
            if (lastConstantIdx < 0) {
                lastConstantIdx = i;
                lastConstant = value;
                continue;
            }
            if (lastConstant.equals(value)) continue;
            Term proof = this.proveTrivialDisequality(lhsParams[lastConstantIdx], lhsParams[i]);
            if (lhsParams.length > 2) {
                proof = this.mProofRules.resolutionRule(lhs.getTheory().term("=", lhsParams[lastConstantIdx], lhsParams[i]), this.mProofRules.equalsElim(lastConstantIdx, i, lhs), proof);
            }
            proof = this.proveIffFalse(rewriteStmt, proof);
            return proof;
        }
        throw new AssertionError();
    }

    private Term proveDivWithFarkas(Term divTerm, Term divResult) {
        Theory theory = divTerm.getTheory();
        Sort sort = divTerm.getSort();
        assert (this.isApplication("div", divTerm));
        Term[] divArgs = ((ApplicationTerm)divTerm).getParameters();
        assert (divArgs.length == 2);
        Rational divisor = this.parseConstant(divArgs[1]);
        assert (divisor != null && divisor.isIntegral());
        Polynomial poly = new Polynomial();
        poly.add(Rational.MONE, divResult);
        poly.add(divisor.inverse(), divArgs[0]);
        assert (poly.isConstant());
        Rational remainder = poly.getConstant();
        assert (remainder.abs().compareTo(Rational.ONE) < 0);
        assert (remainder.signum() * divisor.signum() != -1);
        Term zero = Rational.ZERO.toTerm(sort);
        Term absDivArg = theory.term("abs", divArgs[1]);
        Term absDivisor = divisor.abs().toTerm(sort);
        Term origDivLow = theory.term("<=", theory.term("*", divArgs[1], divTerm), divArgs[0]);
        Term origDivHigh = theory.term("<", divArgs[0], theory.term("+", theory.term("*", divArgs[1], divTerm), absDivArg));
        SMTAffineTerm diffAffine = new SMTAffineTerm(divTerm);
        diffAffine.add(Rational.MONE, divResult);
        Term diffLhsRhs = diffAffine.toTerm(sort);
        Term proof = this.mProofRules.trichotomy(divTerm, divResult);
        Term ltLhsRhs = theory.term("<", divTerm, divResult);
        Term gtLhsRhs = theory.term("<", divResult, divTerm);
        BigInteger[] oneone = new BigInteger[]{BigInteger.ONE, BigInteger.ONE};
        if (divisor.signum() < 0 || remainder.signum() != 0) {
            Term leqLhsRhs = theory.term("<=", diffLhsRhs, zero);
            Term geqLhsRhsOne = theory.term("<=", Rational.ONE.toTerm(sort), diffLhsRhs);
            proof = this.res(gtLhsRhs, proof, this.mProofRules.farkas(new Term[]{gtLhsRhs, leqLhsRhs}, oneone));
            proof = this.res(leqLhsRhs, this.mProofRules.totalInt(diffLhsRhs, BigInteger.ZERO), proof);
            gtLhsRhs = geqLhsRhsOne;
        }
        if (divisor.signum() > 0 || remainder.signum() != 0) {
            Term geqLhsRhs = theory.term("<=", zero, diffLhsRhs);
            Term leqLhsRhsOne = theory.term("<=", diffLhsRhs, Rational.MONE.toTerm(sort));
            proof = this.res(ltLhsRhs, proof, this.mProofRules.farkas(new Term[]{ltLhsRhs, geqLhsRhs}, oneone));
            proof = this.res(geqLhsRhs, this.mProofRules.totalInt(diffLhsRhs, BigInteger.ONE.negate()), proof);
            ltLhsRhs = leqLhsRhsOne;
        }
        Term lhsRhsLow = divisor.signum() > 0 ? gtLhsRhs : ltLhsRhs;
        Term lhsRhsHigh = divisor.signum() > 0 ? ltLhsRhs : gtLhsRhs;
        BigInteger[] coeffs = new BigInteger[]{BigInteger.ONE, divisor.abs().numerator()};
        BigInteger[] coeffs3 = new BigInteger[]{BigInteger.ONE, divisor.abs().numerator(), BigInteger.ONE};
        Term eqAbs = theory.term("=", absDivArg, absDivisor);
        proof = this.res(lhsRhsLow, proof, this.mProofRules.farkas(new Term[]{origDivLow, lhsRhsLow}, coeffs));
        proof = this.res(lhsRhsHigh, proof, this.mProofRules.farkas(new Term[]{origDivHigh, lhsRhsHigh, eqAbs}, coeffs3));
        proof = this.res(eqAbs, this.proveAbsConstant(divisor, sort), proof);
        proof = this.res(origDivHigh, this.mProofRules.divHigh(divArgs[0], divArgs[1]), proof);
        proof = this.res(origDivLow, this.mProofRules.divLow(divArgs[0], divArgs[1]), proof);
        return proof;
    }

    private Term convertRewriteDiv(String ruleName, Term lhs, Term rhs) {
        assert (this.isApplication("div", lhs));
        Term[] divArgs = ((ApplicationTerm)lhs).getParameters();
        assert (divArgs.length == 2);
        Rational divisor = this.parseConstant(divArgs[1]);
        assert (divisor != null && divisor.isIntegral());
        Theory theory = lhs.getTheory();
        Term zero = Rational.ZERO.toTerm(lhs.getSort());
        return this.res(theory.term("=", divArgs[1], zero), this.proveDivWithFarkas(lhs, rhs), this.proveTrivialDisequality(divArgs[1], zero));
    }

    private Term convertRewriteModulo(String ruleName, Term lhs, Term rhs) {
        Term divResult;
        assert (this.isApplication("mod", lhs));
        Term[] modArgs = ((ApplicationTerm)lhs).getParameters();
        assert (modArgs.length == 2);
        Term divTerm = lhs.getTheory().term("div", modArgs);
        Rational divisor = this.parseConstant(modArgs[1]);
        assert (divisor != null && divisor != Rational.ZERO);
        Theory theory = lhs.getTheory();
        Sort sort = lhs.getSort();
        Term proof = this.mProofRules.modDef(modArgs[0], modArgs[1]);
        Term zero = Rational.ZERO.toTerm(sort);
        Term divPlusMod = theory.term("+", theory.term("*", modArgs[1], divTerm), lhs);
        Term modDefEq = theory.term("=", divPlusMod, modArgs[0]);
        SMTAffineTerm affine = new SMTAffineTerm(modArgs[0]);
        affine.add(divisor.negate(), divTerm);
        switch (ruleName) {
            case ":modulo1": {
                assert (divisor.equals(Rational.ONE) && this.isZero(rhs));
                divResult = modArgs[0];
                break;
            }
            case ":modulo-1": {
                assert (divisor.equals(Rational.MONE) && this.isZero(rhs));
                SMTAffineTerm negX = new SMTAffineTerm(modArgs[0]);
                negX.negate();
                divResult = negX.toTerm(sort);
                break;
            }
            case ":moduloConst": {
                Rational dividend = this.parseConstant(modArgs[0]);
                Rational quotient = dividend.div(divisor.abs()).floor();
                if (divisor.signum() < 0) {
                    quotient = quotient.negate();
                }
                divResult = quotient.toTerm(sort);
                break;
            }
            case ":modulo": {
                assert (new SMTAffineTerm(rhs).equals(affine));
                divResult = divTerm;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Term middle = divResult == divTerm ? rhs : affine.toTerm(sort);
        proof = this.res(modDefEq, proof, this.proveEqWithMultiplier(new Term[]{divPlusMod, modArgs[0]}, new Term[]{lhs, middle}, Rational.ONE));
        if (divResult != divTerm) {
            Term proof2 = this.res(theory.term("=", divTerm, divResult), this.proveDivWithFarkas(divTerm, divResult), this.proveEqWithMultiplier(new Term[]{divTerm, divResult}, new Term[]{middle, rhs}, divisor.negate()));
            proof = this.res(theory.term("=", lhs, middle), proof, this.res(theory.term("=", middle, rhs), proof2, this.mProofRules.trans(lhs, middle, rhs)));
        }
        proof = this.res(theory.term("=", modArgs[1], zero), proof, this.proveTrivialDisequality(modArgs[1], zero));
        return proof;
    }

    private Term convertRewriteDivisible(String ruleName, Term lhs, Term rhs) {
        Term proof2;
        assert (this.isApplication("divisible", lhs));
        BigInteger divisor = new BigInteger(((ApplicationTerm)lhs).getFunction().getIndices()[0]);
        Term arg = ((ApplicationTerm)lhs).getParameters()[0];
        Term proof = this.mProofRules.divisible(divisor, arg);
        if (this.isApplication("=", rhs)) {
            return proof;
        }
        Theory theory = lhs.getTheory();
        Rational divisorRat = Rational.valueOf(divisor, BigInteger.ONE);
        Term divisorTerm = divisorRat.toTerm(arg.getSort());
        Term divTerm = theory.term("div", arg, divisorTerm);
        Term mulDivTerm = theory.term("*", divisorTerm, divTerm);
        Term equalTerm = theory.term("=", arg, mulDivTerm);
        Term eqRhs = theory.term("=", equalTerm, rhs);
        if (this.isApplication("false", rhs)) {
            assert (this.isApplication("false", rhs));
            proof2 = this.res(rhs, this.res(equalTerm, this.mProofRules.iffIntro1(eqRhs), this.proveTrivialDisequality(arg, mulDivTerm)), this.mProofRules.falseElim());
        } else {
            assert (this.isApplication("true", rhs));
            Term trueTerm = rhs;
            Polynomial divResultPoly = new Polynomial(arg);
            divResultPoly.mul(divisorRat.inverse());
            assert (divResultPoly.getGcd().isIntegral() && divResultPoly.getConstant().isIntegral());
            Term divResult = divResultPoly.toTerm(arg.getSort());
            Term zero = Rational.ZERO.toTerm(arg.getSort());
            Term proofEquality = this.res(theory.term("=", divTerm, divResult), this.proveDivWithFarkas(divTerm, divResult), this.proveEqWithMultiplier(new Term[]{divTerm, divResult}, new Term[]{arg, mulDivTerm}, divisorRat.negate()));
            proofEquality = this.res(theory.term("=", divisorTerm, zero), proofEquality, this.proveTrivialDisequality(divisorTerm, zero));
            proof2 = this.res(trueTerm, this.mProofRules.trueIntro(), this.res(equalTerm, proofEquality, this.mProofRules.iffIntro2(eqRhs)));
        }
        return this.res(eqRhs, proof2, this.res(theory.term("=", lhs, equalTerm), proof, this.mProofRules.trans(lhs, equalTerm, rhs)));
    }

    private Term convertRewrite(Term lhs, Term rhs, Annotation annot) {
        Term subProof;
        Term rewriteStmt = lhs.getTheory().term("=", lhs, rhs);
        String rewriteRule = annot.getKey();
        assert (this.isApplication("=", rewriteStmt));
        switch (rewriteRule) {
            case ":expand": 
            case ":expandDef": {
                subProof = this.mProofRules.expand(lhs);
                break;
            }
            case ":intern": {
                subProof = this.convertRewriteIntern(lhs, rhs);
                break;
            }
            case ":notSimp": {
                subProof = this.convertRewriteNot(rewriteStmt, lhs, rhs);
                break;
            }
            case ":trueNotFalse": {
                subProof = this.convertRewriteTrueNotFalse(lhs, rhs);
                break;
            }
            case ":eqTrue": 
            case ":eqFalse": {
                subProof = this.convertRewriteEqTrueFalse(rewriteRule, lhs, rhs);
                break;
            }
            case ":eqSimp": 
            case ":eqSame": {
                subProof = this.convertRewriteEqSimp(rewriteRule, lhs, rhs);
                break;
            }
            case ":eqBinary": {
                subProof = this.convertRewriteEqBinary(rewriteStmt, lhs, rhs);
                break;
            }
            case ":eqToXor": 
            case ":distinctToXor": {
                subProof = this.convertRewriteToXor(rewriteRule, rewriteStmt, lhs, rhs);
                break;
            }
            case ":xorTrue": 
            case ":xorFalse": {
                subProof = this.convertRewriteXorConst(rewriteRule, rewriteStmt, lhs, rhs);
                break;
            }
            case ":xorNot": {
                subProof = this.convertRewriteXorNot(rewriteStmt, lhs, rhs);
                break;
            }
            case ":xorSame": {
                subProof = this.convertRewriteXorSame(rewriteStmt, lhs, rhs);
                break;
            }
            case ":orSimp": {
                subProof = this.convertRewriteOrSimp(rewriteStmt, lhs, rhs);
                break;
            }
            case ":orTaut": {
                subProof = this.convertRewriteOrTaut(rewriteStmt, lhs, rhs);
                break;
            }
            case ":distinctBool": 
            case ":distinctSame": 
            case ":distinctBinary": {
                subProof = this.convertRewriteDistinct(rewriteRule, rewriteStmt, lhs, rhs);
                break;
            }
            case ":leqTrue": 
            case ":leqFalse": {
                subProof = this.convertRewriteLeq(rewriteRule, rewriteStmt, lhs, rhs);
                break;
            }
            case ":leqToLeq0": 
            case ":ltToLeq0": 
            case ":geqToLeq0": 
            case ":gtToLeq0": {
                subProof = this.convertRewriteToLeq0(rewriteRule, lhs, rhs);
                break;
            }
            case ":iteTrue": 
            case ":iteFalse": 
            case ":iteSame": 
            case ":iteBool1": 
            case ":iteBool2": 
            case ":iteBool3": 
            case ":iteBool4": 
            case ":iteBool5": 
            case ":iteBool6": {
                subProof = this.convertRewriteIte(rewriteRule, rewriteStmt, lhs, rhs);
                break;
            }
            case ":constDiff": {
                subProof = this.convertRewriteConstDiff(rewriteStmt, lhs, rhs);
                break;
            }
            case ":strip": {
                subProof = this.mProofRules.delAnnot(lhs);
                break;
            }
            case ":canonicalSum": {
                subProof = this.convertRewriteCanonicalSum(lhs, rhs);
                break;
            }
            case ":toInt": {
                subProof = this.convertRewriteToInt(lhs, rhs);
                break;
            }
            case ":div1": 
            case ":div-1": 
            case ":divConst": {
                subProof = this.convertRewriteDiv(rewriteRule, lhs, rhs);
                break;
            }
            case ":modulo1": 
            case ":modulo-1": 
            case ":moduloConst": 
            case ":modulo": {
                subProof = this.convertRewriteModulo(rewriteRule, lhs, rhs);
                break;
            }
            case ":divisible": {
                subProof = this.convertRewriteDivisible(rewriteRule, lhs, rhs);
                break;
            }
            case ":storeOverStore": {
                subProof = this.convertRewriteStoreOverStore(lhs, rhs);
                break;
            }
            case ":selectOverStore": {
                subProof = this.convertRewriteSelectOverStore(lhs, rhs);
                break;
            }
            case ":storeRewrite": {
                subProof = this.convertRewriteStore(rewriteStmt, lhs, rhs);
                break;
            }
            case ":auxIntro": {
                subProof = this.convertRewriteAuxIntro(rewriteStmt, lhs, rhs);
                break;
            }
            default: {
                subProof = this.mProofRules.oracle(this.termToProofLiterals(rewriteStmt), new Annotation[]{annot});
            }
        }
        assert (this.checkProof(subProof, this.termToProofLiterals(rewriteStmt)));
        return this.annotateProved(rewriteStmt, subProof);
    }

    private Term convertLALemma(ProofLiteral[] clause, Term[] coefficients) {
        assert (clause.length == coefficients.length);
        Theory theory = this.mSkript.getTheory();
        BigInteger[] coeffs = new BigInteger[coefficients.length];
        Term[] atoms = new Term[clause.length];
        Term[] realAtoms = new Term[clause.length];
        Term[] realAtomProofs = new Term[clause.length];
        for (int i = 0; i < clause.length; ++i) {
            Term realAtomProof;
            Term realAtom;
            Rational coeff = this.parseConstant(coefficients[i]);
            assert (coeff.isIntegral() && coeff != Rational.ZERO);
            coeffs[i] = coeff.numerator().abs();
            boolean isNegated = !clause[i].getPolarity();
            Term atom = clause[i].getAtom();
            Term[] atomParams = ((ApplicationTerm)atom).getParameters();
            if (this.isApplication("=", atom)) {
                assert (isNegated);
                if (coeff.signum() > 0) {
                    realAtom = theory.term("=", atomParams[0], atomParams[1]);
                    realAtomProof = null;
                } else {
                    realAtom = theory.term("=", atomParams[1], atomParams[0]);
                    realAtomProof = this.mProofRules.symm(atomParams[1], atomParams[0]);
                }
            } else if (isNegated) {
                assert (coeff.signum() > 0);
                realAtom = atom;
                realAtomProof = null;
            } else {
                assert (coeff.signum() < 0);
                if (this.isApplication("<=", atom)) {
                    Sort sort = atomParams[0].getSort();
                    if (sort.getName().equals("Int")) {
                        assert (this.isZero(atomParams[1]));
                        realAtom = theory.term("<=", Rational.ONE.toTerm(sort), atomParams[0]);
                        realAtomProof = this.mProofRules.totalInt(atomParams[0], BigInteger.ZERO);
                    } else {
                        realAtom = theory.term("<", atomParams[1], atomParams[0]);
                        realAtomProof = this.mProofRules.total(atomParams[0], atomParams[1]);
                    }
                } else {
                    realAtom = theory.term("<=", atomParams[1], atomParams[0]);
                    realAtomProof = this.mProofRules.total(atomParams[1], atomParams[0]);
                }
            }
            realAtoms[i] = realAtom;
            realAtomProofs[i] = realAtomProof;
            atoms[i] = atom;
        }
        Term proof = this.mProofRules.farkas(realAtoms, coeffs);
        for (int i = 0; i < atoms.length; ++i) {
            proof = this.res(realAtoms[i], realAtomProofs[i], proof);
        }
        return proof;
    }

    private Term convertTrichotomy(ProofLiteral[] clause) {
        assert (clause.length == 3);
        Theory theory = clause[0].getAtom().getTheory();
        Term eq = null;
        Term lt = null;
        Term gt = null;
        for (ProofLiteral lit : clause) {
            boolean isPositive = lit.getPolarity();
            Term atom = lit.getAtom();
            assert (this.isZero(((ApplicationTerm)atom).getParameters()[1]));
            if (this.isApplication("=", atom)) {
                assert (isPositive && eq == null);
                eq = atom;
                continue;
            }
            if (this.isApplication("<=", atom) || this.isApplication("<", atom)) {
                if (isPositive) {
                    assert (lt == null);
                    lt = atom;
                    continue;
                }
                assert (gt == null);
                gt = atom;
                continue;
            }
            throw new AssertionError();
        }
        Term[] sides = ((ApplicationTerm)eq).getParameters();
        Term proof = this.mProofRules.trichotomy(sides[0], sides[1]);
        Term realGt = theory.term("<", sides[1], sides[0]);
        proof = this.mProofRules.resolutionRule(realGt, proof, this.mProofRules.farkas(new Term[]{realGt, gt}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE}));
        if (this.isApplication("<=", lt)) {
            Term[] ltSides = ((ApplicationTerm)lt).getParameters();
            assert (this.isZero(ltSides[1]));
            Term one = Rational.ONE.toTerm(ltSides[0].getSort());
            Term realLt = theory.term("<", sides[0], sides[1]);
            Term realLeq = theory.term("<=", one, ltSides[0]);
            proof = this.mProofRules.resolutionRule(realLt, proof, this.mProofRules.resolutionRule(realLeq, this.mProofRules.totalInt(ltSides[0], BigInteger.ZERO), this.mProofRules.farkas(new Term[]{realLeq, realLt}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE})));
        }
        return proof;
    }

    private Term convertEQLemma(ProofLiteral[] clause) {
        assert (clause.length == 2);
        int posNr = clause[0].getPolarity() ? 0 : 1;
        int negNr = 1 - posNr;
        assert (clause[1].getPolarity() == (posNr == 1));
        assert (this.isApplication("=", clause[0].getAtom()) && this.isApplication("=", clause[1].getAtom()));
        Term[] negAtomArgs = ((ApplicationTerm)clause[negNr].getAtom()).getParameters();
        Term[] posAtomArgs = ((ApplicationTerm)clause[posNr].getAtom()).getParameters();
        SMTAffineTerm negDiff = new SMTAffineTerm(negAtomArgs[0]);
        negDiff.add(Rational.MONE, negAtomArgs[1]);
        SMTAffineTerm posDiff = new SMTAffineTerm(posAtomArgs[0]);
        posDiff.add(Rational.MONE, posAtomArgs[1]);
        Rational multiplier = posDiff.getGcd().div(negDiff.getGcd());
        negDiff.mul(multiplier);
        if (!negDiff.equals(posDiff)) {
            negDiff.negate();
            multiplier = multiplier.negate();
        }
        assert (negDiff.equals(posDiff));
        Term proof = this.proveEqWithMultiplier(negAtomArgs, posAtomArgs, multiplier);
        return proof;
    }

    private void collectEqualities(ProofLiteral[] clause, HashMap<SymmetricPair<Term>, Term> equalities, HashMap<SymmetricPair<Term>, Term> disequalities) {
        for (ProofLiteral literal : clause) {
            Term atom = literal.getAtom();
            assert (this.isApplication("=", atom));
            Term[] sides = ((ApplicationTerm)atom).getParameters();
            assert (sides.length == 2);
            if (literal.getPolarity()) {
                disequalities.put(new SymmetricPair<Term>(sides[0], sides[1]), atom);
                continue;
            }
            equalities.put(new SymmetricPair<Term>(sides[0], sides[1]), atom);
        }
    }

    private Term convertCCLemma(ProofLiteral[] clause, String lemmaType, Term[] mainPath) {
        Term proof;
        assert (mainPath.length >= 2) : "Main path too short in CC lemma";
        Theory theory = mainPath[0].getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        assert (allDisequalities.size() <= 1);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        if (mainPath.length == 2) {
            assert (lemmaType == ":cong") : "Transitivity lemma must have at least three steps";
            assert (mainPath[0] instanceof ApplicationTerm && mainPath[1] instanceof ApplicationTerm);
            ApplicationTerm lhs = (ApplicationTerm)mainPath[0];
            ApplicationTerm rhs = (ApplicationTerm)mainPath[1];
            proof = this.mProofRules.cong(lhs, rhs);
            assert (lhs.getFunction() == rhs.getFunction() && lhs.getParameters().length == rhs.getParameters().length);
            Term[] lhsParams = lhs.getParameters();
            Term[] rhsParams = rhs.getParameters();
            assert (lhsParams.length == rhsParams.length);
            for (int i = 0; i < lhsParams.length; ++i) {
                neededEqualities.add(theory.term("=", lhsParams[i], rhsParams[i]));
            }
        } else {
            assert (lemmaType == ":trans") : "Congruence lemma must have a main path of length 2";
            proof = this.mProofRules.trans(mainPath);
            for (int i = 0; i < mainPath.length - 1; ++i) {
                neededEqualities.add(theory.term("=", mainPath[i], mainPath[i + 1]));
            }
        }
        Term mainPathEquality = theory.term("=", mainPath[0], mainPath[mainPath.length - 1]);
        Set<Term> neededDisequalities = Collections.singleton(mainPathEquality);
        proof = this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
        return proof;
    }

    private Term proveSelectConst(Term value, Term array, Term weakIdx, Set<SymmetricPair<Term>> allEqualities, Set<Term> neededEqualities) {
        Term[] args;
        Theory theory = value.getTheory();
        if (this.isApplication("select", value) && (args = ((ApplicationTerm)value).getParameters())[0] == array) {
            if (args[1] == weakIdx) {
                return this.mProofRules.refl(value);
            }
            if (allEqualities.contains(new SymmetricPair<Term>(weakIdx, args[1]))) {
                neededEqualities.add(theory.term("=", array, array));
                neededEqualities.add(theory.term("=", weakIdx, args[1]));
                return this.mProofRules.cong(theory.term("select", array, weakIdx), value);
            }
        }
        if (this.isApplication("const", array) && ((ApplicationTerm)array).getParameters()[0] == value) {
            return this.mProofRules.constArray(value, weakIdx);
        }
        return null;
    }

    private Term proveSelectPathTrans(Term arrayLeft, Term value1, Term value2, Term arrayRight, Term weakIdx, Term proofLeft, Term proofRight, Set<Term> neededEqualities) {
        Theory theory = arrayLeft.getTheory();
        Term selectLeft = theory.term("select", arrayLeft, weakIdx);
        Term selectRight = theory.term("select", arrayRight, weakIdx);
        LinkedHashSet<Term> transChain = new LinkedHashSet<Term>();
        transChain.add(selectLeft);
        transChain.add(value1);
        transChain.add(value2);
        transChain.add(selectRight);
        Term proof = null;
        if (transChain.size() > 2) {
            proof = this.mProofRules.trans(transChain.toArray(new Term[transChain.size()]));
        }
        if (selectLeft != value1) {
            proof = this.res(theory.term("=", selectLeft, value1), proofLeft, proof);
        }
        if (value1 != value2) {
            neededEqualities.add(theory.term("=", value1, value2));
        }
        if (selectRight != value2) {
            proof = this.res(theory.term("=", value2, selectRight), this.mProofRules.symm(value2, selectRight), proof);
            proof = this.res(theory.term("=", selectRight, value2), proofRight, proof);
        }
        return proof;
    }

    private Term proveSelectPath(Term arrayLeft, Term arrayRight, Term weakIdx, Set<SymmetricPair<Term>> allEqualities, Set<Term> neededEqualities) {
        Term eq1;
        Term value;
        Term eq2;
        for (SymmetricPair<Term> candidateEquality : allEqualities) {
            Term first = candidateEquality.getFirst();
            Term second = candidateEquality.getSecond();
            Term eq12 = this.proveSelectConst(first, arrayLeft, weakIdx, allEqualities, neededEqualities);
            Term eq22 = this.proveSelectConst(second, arrayRight, weakIdx, allEqualities, neededEqualities);
            if (eq12 != null && eq22 != null) {
                return this.proveSelectPathTrans(arrayLeft, first, second, arrayRight, weakIdx, eq12, eq22, neededEqualities);
            }
            eq12 = this.proveSelectConst(second, arrayLeft, weakIdx, allEqualities, neededEqualities);
            eq22 = this.proveSelectConst(first, arrayRight, weakIdx, allEqualities, neededEqualities);
            if (eq12 == null || eq22 == null) continue;
            return this.proveSelectPathTrans(arrayLeft, second, first, arrayRight, weakIdx, eq12, eq22, neededEqualities);
        }
        if (this.isApplication("const", arrayLeft) && (eq2 = this.proveSelectConst(value = ((ApplicationTerm)arrayLeft).getParameters()[0], arrayRight, weakIdx, allEqualities, neededEqualities)) != null) {
            return this.proveSelectPathTrans(arrayLeft, value, value, arrayRight, weakIdx, this.mProofRules.constArray(value, weakIdx), eq2, neededEqualities);
        }
        if (this.isApplication("const", arrayRight) && (eq1 = this.proveSelectConst(value = ((ApplicationTerm)arrayRight).getParameters()[0], arrayLeft, weakIdx, allEqualities, neededEqualities)) != null) {
            return this.proveSelectPathTrans(arrayLeft, value, value, arrayRight, weakIdx, eq1, this.mProofRules.constArray(value, weakIdx), neededEqualities);
        }
        return null;
    }

    private Term proveStoreStep(Term arrayLeft, Term arrayRight, Term weakIdx, Set<SymmetricPair<Term>> disequalities, Set<Term> neededDisequalities) {
        Term storeIdx;
        Term[] storeArgs;
        if (this.isApplication("store", arrayLeft) && (storeArgs = ((ApplicationTerm)arrayLeft).getParameters())[0] == arrayRight && (disequalities.contains(new SymmetricPair<Term>(weakIdx, storeIdx = ((ApplicationTerm)arrayLeft).getParameters()[1])) || this.proveTrivialDisequality(weakIdx, storeIdx) != null)) {
            Term storeVal = ((ApplicationTerm)arrayLeft).getParameters()[2];
            Theory theory = arrayLeft.getTheory();
            neededDisequalities.add(theory.term("=", storeIdx, weakIdx));
            return this.mProofRules.selectStore2(arrayRight, storeIdx, storeVal, weakIdx);
        }
        return null;
    }

    private Term proveSelectOverPathStep(Term arrayLeft, Term arrayRight, Term weakIdx, Term selectLeft, Term selectRight, Set<SymmetricPair<Term>> equalities, Set<SymmetricPair<Term>> disequalities, Set<Term> neededEqualities, Set<Term> neededDisequalities) {
        Theory theory = arrayLeft.getTheory();
        if (equalities.contains(new SymmetricPair<Term>(arrayLeft, arrayRight))) {
            neededEqualities.add(theory.term("=", arrayLeft, arrayRight));
            neededEqualities.add(theory.term("=", weakIdx, weakIdx));
            return this.mProofRules.cong(selectLeft, selectRight);
        }
        Term proof = this.proveStoreStep(arrayLeft, arrayRight, weakIdx, disequalities, neededDisequalities);
        if (proof != null) {
            return proof;
        }
        proof = this.proveStoreStep(arrayRight, arrayLeft, weakIdx, disequalities, neededDisequalities);
        if (proof != null) {
            return this.res(theory.term("=", selectRight, selectLeft), proof, this.mProofRules.symm(selectLeft, selectRight));
        }
        return this.proveSelectPath(arrayLeft, arrayRight, weakIdx, equalities, neededEqualities);
    }

    private Term proveSelectOverPath(Term weakIdx, Term[] path, Set<SymmetricPair<Term>> equalities, Set<SymmetricPair<Term>> disequalities, Set<Term> neededEqualities, Set<Term> neededDisequalities) {
        assert (path.length >= 1);
        Theory theory = path[0].getTheory();
        Term[] selectChain = new Term[path.length];
        for (int i = 0; i < path.length; ++i) {
            selectChain[i] = theory.term("select", path[i], weakIdx);
        }
        if (selectChain.length == 1) {
            return this.mProofRules.refl(selectChain[0]);
        }
        Term proof = selectChain.length > 2 ? this.mProofRules.trans(selectChain) : null;
        for (int i = 0; i < path.length - 1; ++i) {
            Term subproof = this.proveSelectOverPathStep(path[i], path[i + 1], weakIdx, selectChain[i], selectChain[i + 1], equalities, disequalities, neededEqualities, neededDisequalities);
            proof = this.res(theory.term("=", selectChain[i], selectChain[i + 1]), subproof, proof);
        }
        return proof;
    }

    private Term convertArraySelectConstWeakEqLemma(ProofLiteral[] clause, Object[] ccAnnotation) {
        int goalOrder;
        assert (ccAnnotation.length >= 3);
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        Term goalEquality = (Term)ccAnnotation[0];
        assert (this.isApplication("=", goalEquality));
        Term[] goalTerms = ((ApplicationTerm)goalEquality).getParameters();
        assert (goalTerms.length == 2);
        assert (ccAnnotation.length == 3);
        assert (ccAnnotation[1] == ":weakpath");
        Object[] weakItems = (Object[])ccAnnotation[2];
        assert (weakItems.length == 2);
        Term mainIdx = (Term)weakItems[0];
        Term[] mainPath = (Term[])weakItems[1];
        Term proof = this.proveSelectOverPath(mainIdx, mainPath, allEqualities.keySet(), allDisequalities.keySet(), neededEqualities, neededDisequalities);
        Term firstTerm = theory.term("select", mainPath[0], mainIdx);
        Term lastTerm = theory.term("select", mainPath[mainPath.length - 1], mainIdx);
        assert (this.isApplication("const", mainPath[mainPath.length - 1]));
        Term constParam = ((ApplicationTerm)mainPath[mainPath.length - 1]).getParameters()[0];
        int n = goalOrder = goalTerms[1] == constParam ? 0 : 1;
        assert (goalTerms[goalOrder] == this.mSkript.term("select", mainPath[0], mainIdx));
        assert (goalTerms[1 - goalOrder] == constParam);
        proof = this.res(theory.term("=", firstTerm, lastTerm), proof, this.mProofRules.trans(firstTerm, lastTerm, constParam));
        proof = this.res(theory.term("=", lastTerm, constParam), this.mProofRules.constArray(constParam, mainIdx), proof);
        neededDisequalities.add(theory.term("=", firstTerm, constParam));
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private Term convertArraySelectWeakEqLemma(ProofLiteral[] clause, Object[] ccAnnotation) {
        Term goalIdx;
        assert (ccAnnotation.length >= 3);
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        Term goalEquality = (Term)ccAnnotation[0];
        assert (this.isApplication("=", goalEquality));
        Term[] goalTerms = ((ApplicationTerm)goalEquality).getParameters();
        assert (goalTerms.length == 2);
        assert (ccAnnotation.length == 3);
        assert (ccAnnotation[1] == ":weakpath");
        Object[] weakItems = (Object[])ccAnnotation[2];
        assert (weakItems.length == 2);
        Term mainIdx = (Term)weakItems[0];
        Term[] mainPath = (Term[])weakItems[1];
        Term proof = this.proveSelectOverPath(mainIdx, mainPath, allEqualities.keySet(), allDisequalities.keySet(), neededEqualities, neededDisequalities);
        assert (this.isApplication("select", goalTerms[0]) && this.isApplication("select", goalTerms[1]));
        int goalOrder = ((ApplicationTerm)goalTerms[0]).getParameters()[0] == mainPath[0] ? 0 : 1;
        Term goal1 = goalTerms[goalOrder];
        Term goal2 = goalTerms[1 - goalOrder];
        Term firstTerm = theory.term("select", mainPath[0], mainIdx);
        Term lastTerm = theory.term("select", mainPath[mainPath.length - 1], mainIdx);
        if (goal1 != firstTerm) {
            assert (mainPath[0] == ((ApplicationTerm)goal1).getParameters()[0]);
            goalIdx = ((ApplicationTerm)goal1).getParameters()[1];
            proof = this.res(theory.term("=", firstTerm, lastTerm), proof, this.mProofRules.trans(goal1, firstTerm, lastTerm));
            proof = this.res(theory.term("=", goal1, firstTerm), this.mProofRules.cong(goal1, firstTerm), proof);
            neededEqualities.add(theory.term("=", goalIdx, mainIdx));
            neededEqualities.add(theory.term("=", mainPath[0], mainPath[0]));
        }
        if (goal2 != lastTerm) {
            assert (mainPath[mainPath.length - 1] == ((ApplicationTerm)goal2).getParameters()[0]);
            goalIdx = ((ApplicationTerm)goal2).getParameters()[1];
            proof = this.res(theory.term("=", goal1, lastTerm), proof, this.mProofRules.trans(goal1, lastTerm, goal2));
            proof = this.res(theory.term("=", lastTerm, goal2), this.mProofRules.cong(lastTerm, goal2), proof);
            neededEqualities.add(theory.term("=", mainIdx, goalIdx));
            neededEqualities.add(theory.term("=", mainPath[mainPath.length - 1], mainPath[mainPath.length - 1]));
        }
        neededDisequalities.add(theory.term("=", goal1, goal2));
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private Term convertArrayWeakEqExtLemma(ProofLiteral[] clause, Object[] ccAnnotation) {
        int i;
        assert (ccAnnotation.length >= 3);
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        Term goalEquality = (Term)ccAnnotation[0];
        assert (this.isApplication("=", goalEquality));
        Term[] goalTerms = ((ApplicationTerm)goalEquality).getParameters();
        assert (goalTerms.length == 2);
        assert (ccAnnotation.length % 2 == 1);
        assert (ccAnnotation[1] == ":subpath");
        Term[] mainPath = (Term[])ccAnnotation[2];
        Term arrayLeft = mainPath[0];
        Term arrayRight = mainPath[mainPath.length - 1];
        Term diffTerm = theory.term("@diff", arrayLeft, arrayRight);
        Term[] mainSelectChain = new Term[mainPath.length];
        for (int i2 = 0; i2 < mainPath.length; ++i2) {
            mainSelectChain[i2] = theory.term("select", mainPath[i2], diffTerm);
        }
        Term selectLeftDiff = mainSelectChain[0];
        Term selectRightDiff = mainSelectChain[mainPath.length - 1];
        HashSet<SymmetricPair<Term>> weakDisequalities = new HashSet<SymmetricPair<Term>>();
        HashSet<Term> neededWeakDisequalities = new HashSet<Term>();
        for (int i3 = 3; i3 < ccAnnotation.length; i3 += 2) {
            assert (ccAnnotation[i3] == ":weakpath");
            Object[] weakItems = (Object[])ccAnnotation[i3 + 1];
            Term idx = (Term)weakItems[0];
            weakDisequalities.add(new SymmetricPair<Term>(idx, diffTerm));
        }
        Term mainChainProof = mainPath.length > 2 ? this.mProofRules.trans(mainSelectChain) : null;
        for (i = 0; i < mainPath.length - 1; ++i) {
            Term proofSelectEq;
            SymmetricPair<Term> pair = new SymmetricPair<Term>(mainPath[i], mainPath[i + 1]);
            if (allEqualities.containsKey(pair)) {
                neededEqualities.add(theory.term("=", mainPath[i], mainPath[i + 1]));
                neededEqualities.add(theory.term("=", diffTerm, diffTerm));
                proofSelectEq = this.mProofRules.cong(mainSelectChain[i], mainSelectChain[i + 1]);
            } else {
                proofSelectEq = this.proveStoreStep(mainPath[i], mainPath[i + 1], diffTerm, weakDisequalities, neededWeakDisequalities);
                if (proofSelectEq == null) {
                    proofSelectEq = this.proveStoreStep(mainPath[i + 1], mainPath[i], diffTerm, weakDisequalities, neededWeakDisequalities);
                    proofSelectEq = this.res(theory.term("=", mainSelectChain[i + 1], mainSelectChain[i]), proofSelectEq, this.mProofRules.symm(mainSelectChain[i], mainSelectChain[i + 1]));
                }
            }
            mainChainProof = this.res(theory.term("=", mainSelectChain[i], mainSelectChain[i + 1]), proofSelectEq, mainChainProof);
        }
        for (i = 3; i < ccAnnotation.length; i += 2) {
            assert (ccAnnotation[i] == ":weakpath");
            Object[] weakItems = (Object[])ccAnnotation[i + 1];
            Term idx = (Term)weakItems[0];
            Term[] weakPath = (Term[])weakItems[1];
            assert (arrayLeft == weakPath[0] && arrayRight == weakPath[weakPath.length - 1]);
            Term indexDiseq = theory.term("=", idx, diffTerm);
            boolean changed = neededWeakDisequalities.remove(indexDiseq);
            assert (changed);
            Term selectLeftIdx = theory.term("select", arrayLeft, idx);
            Term selectRightIdx = theory.term("select", arrayRight, idx);
            Term subproof = this.proveSelectOverPath(idx, weakPath, allEqualities.keySet(), allDisequalities.keySet(), neededEqualities, neededDisequalities);
            subproof = this.res(theory.term("=", selectLeftIdx, selectRightIdx), subproof, this.mProofRules.trans(selectLeftDiff, selectLeftIdx, selectRightIdx, selectRightDiff));
            subproof = this.res(theory.term("=", selectLeftDiff, selectLeftIdx), this.mProofRules.cong(selectLeftDiff, selectLeftIdx), subproof);
            subproof = this.res(theory.term("=", selectRightIdx, selectRightDiff), this.mProofRules.cong(selectRightIdx, selectRightDiff), subproof);
            neededEqualities.add(theory.term("=", arrayLeft, arrayLeft));
            neededEqualities.add(theory.term("=", arrayRight, arrayRight));
            subproof = this.res(theory.term("=", diffTerm, idx), this.mProofRules.symm(diffTerm, idx), subproof);
            mainChainProof = this.res(indexDiseq, mainChainProof, subproof);
        }
        assert (neededWeakDisequalities.isEmpty());
        Term proof = this.mProofRules.extDiff(arrayLeft, arrayRight);
        proof = this.res(theory.term("=", selectLeftDiff, selectRightDiff), mainChainProof, proof);
        neededDisequalities.add(theory.term("=", arrayLeft, arrayRight));
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private Term convertDTProject(ProofLiteral[] clause, Object[] ccAnnotation) {
        assert (ccAnnotation.length == 3);
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        ApplicationTerm goalEquality = (ApplicationTerm)ccAnnotation[0];
        assert (this.isApplication("=", goalEquality));
        assert (ccAnnotation[1].equals(":cons"));
        ApplicationTerm consTerm = (ApplicationTerm)ccAnnotation[2];
        FunctionSymbol consFunc = consTerm.getFunction();
        assert (consFunc.isConstructor());
        Term[] goalTerms = goalEquality.getParameters();
        assert (goalTerms.length == 2);
        assert (goalTerms[0] instanceof ApplicationTerm);
        ApplicationTerm selectTerm = (ApplicationTerm)goalTerms[0];
        FunctionSymbol selector = selectTerm.getFunction();
        assert (selector.isSelector());
        Term selectArg = selectTerm.getParameters()[0];
        Term selectConsTerm = theory.term(selector, consTerm);
        DataType.Constructor cons = ((DataType)consTerm.getSort().getSortSymbol()).getConstructor(consFunc.getName());
        int selectPos = cons.getSelectorIndex(selector.getName());
        Term consArg = consTerm.getParameters()[selectPos];
        Term proof = this.mProofRules.dtProject(selectConsTerm);
        neededDisequalities.add(theory.term("=", selectTerm, consArg));
        if (selectTerm != selectConsTerm) {
            neededEqualities.add(theory.term("=", selectArg, consTerm));
            proof = this.res(theory.term("=", selectConsTerm, consArg), proof, this.mProofRules.trans(selectTerm, selectConsTerm, consArg));
            proof = this.res(theory.term("=", selectTerm, selectConsTerm), this.mProofRules.cong(selectTerm, selectConsTerm), proof);
        }
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private Term convertDTTester(ProofLiteral[] clause, Object[] ccAnnotation) {
        Term proof;
        assert (ccAnnotation.length == 3);
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        Term goalEquality = (Term)ccAnnotation[0];
        assert (this.isApplication("=", goalEquality));
        assert (ccAnnotation[1].equals(":cons"));
        ApplicationTerm consTerm = (ApplicationTerm)ccAnnotation[2];
        FunctionSymbol consFunc = consTerm.getFunction();
        assert (consFunc.isConstructor());
        Term[] goalTerms = ((ApplicationTerm)goalEquality).getParameters();
        assert (goalTerms.length == 2);
        assert (goalTerms[0] instanceof ApplicationTerm);
        ApplicationTerm testerTerm = (ApplicationTerm)goalTerms[0];
        FunctionSymbol tester = testerTerm.getFunction();
        assert (tester.getName().equals("is"));
        Term testerArg = testerTerm.getParameters()[0];
        Term testConsTerm = theory.term(tester, consTerm);
        Term trueFalseTerm = goalTerms[1];
        String otherCons = tester.getIndices()[0];
        boolean isSameCons = consFunc.getName().equals(otherCons);
        assert (trueFalseTerm == (isSameCons ? theory.mTrue : theory.mFalse));
        Term testConsEquality = theory.term("=", testConsTerm, trueFalseTerm);
        if (isSameCons) {
            proof = this.mProofRules.dtTestI(consTerm);
            proof = this.res(testConsTerm, proof, this.res(trueFalseTerm, this.mProofRules.trueIntro(), this.mProofRules.iffIntro2(testConsEquality)));
        } else {
            proof = this.mProofRules.dtTestE(otherCons, consTerm);
            proof = this.res(testConsTerm, this.res(trueFalseTerm, this.mProofRules.iffIntro1(testConsEquality), this.mProofRules.falseElim()), proof);
        }
        neededDisequalities.add(theory.term("=", testerTerm, trueFalseTerm));
        if (testerTerm != testConsTerm) {
            neededEqualities.add(theory.term("=", testerArg, consTerm));
            proof = this.res(theory.term("=", testConsTerm, trueFalseTerm), proof, this.mProofRules.trans(testerTerm, testConsTerm, trueFalseTerm));
            proof = this.res(theory.term("=", testerTerm, testConsTerm), this.mProofRules.cong(testerTerm, testConsTerm), proof);
        }
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private Term convertDTConstructor(ProofLiteral[] clause, Object[] ccAnnotation) {
        assert (ccAnnotation.length == 1);
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        ApplicationTerm goalEquality = (ApplicationTerm)ccAnnotation[0];
        assert (this.isApplication("=", goalEquality));
        Term[] goalTerms = goalEquality.getParameters();
        assert (goalTerms.length == 2);
        ApplicationTerm consTerm = (ApplicationTerm)goalTerms[1];
        Term dataTerm = goalTerms[0];
        DataType dataType = (DataType)dataTerm.getSort().getSortSymbol();
        DataType.Constructor cons = dataType.getConstructor(consTerm.getFunction().getName());
        Term testerTerm = theory.term("is", new String[]{cons.getName()}, null, dataTerm);
        Term testerTrueTerm = theory.term("=", testerTerm, theory.mTrue);
        neededEqualities.add(testerTrueTerm);
        neededDisequalities.add(theory.term("=", consTerm, dataTerm));
        Term proof = this.res(testerTerm, this.res(theory.mTrue, this.mProofRules.trueIntro(), this.mProofRules.iffElim1(testerTrueTerm)), this.mProofRules.dtCons(testerTerm));
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private Term convertDTCases(ProofLiteral[] clause, Object[] ccAnnotation) {
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        assert (ccAnnotation.length > 0);
        ApplicationTerm firstTester = (ApplicationTerm)ccAnnotation[0];
        assert (this.isApplication("is", firstTester));
        Term firstData = firstTester.getParameters()[0];
        Term proof = this.mProofRules.dtExhaust(firstData);
        for (int i = 0; i < ccAnnotation.length; ++i) {
            Term tester = (Term)ccAnnotation[i];
            assert (this.isApplication("is", tester));
            FunctionSymbol testerFunc = ((ApplicationTerm)tester).getFunction();
            Term arg = ((ApplicationTerm)ccAnnotation[i]).getParameters()[0];
            Term testerEq = theory.term("=", tester, theory.mFalse);
            Term subproof = this.res(theory.mFalse, this.mProofRules.iffElim2(testerEq), this.mProofRules.falseElim());
            neededEqualities.add(testerEq);
            Term testerFirst = theory.term(testerFunc, firstData);
            if (tester != testerFirst) {
                Term dataEq = theory.term("=", firstData, arg);
                Term testerFirstEq = theory.term("=", testerFirst, tester);
                neededEqualities.add(dataEq);
                subproof = this.res(testerFirstEq, this.mProofRules.cong(testerFirst, tester), this.res(tester, this.mProofRules.iffElim2(testerFirstEq), subproof));
            }
            proof = this.res(testerFirst, proof, subproof);
        }
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private Term convertDTUnique(ProofLiteral[] clause, Object[] ccAnnotation) {
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        assert (ccAnnotation.length == 2);
        ApplicationTerm firstTester = (ApplicationTerm)ccAnnotation[0];
        assert (this.isApplication("is", firstTester));
        Term firstData = firstTester.getParameters()[0];
        ApplicationTerm secondTester = (ApplicationTerm)ccAnnotation[1];
        assert (this.isApplication("is", secondTester));
        Term secondData = secondTester.getParameters()[0];
        assert (firstData.getSort() == secondData.getSort());
        DataType dataType = (DataType)firstData.getSort().getSortSymbol();
        DataType.Constructor firstCons = dataType.getConstructor(firstTester.getFunction().getIndices()[0]);
        String[] selectors = firstCons.getSelectors();
        Term[] selectTerms = new Term[selectors.length];
        for (int i = 0; i < selectors.length; ++i) {
            selectTerms[i] = theory.term(selectors[i], firstData);
        }
        Term consTerm = theory.term(firstCons.getName(), null, firstCons.needsReturnOverload() ? firstData.getSort() : null, selectTerms);
        Term consEq = theory.term("=", consTerm, firstData);
        Term testConsTerm = theory.term(secondTester.getFunction(), consTerm);
        Term proof = this.res(consEq, this.mProofRules.dtCons(firstTester), this.mProofRules.trans(consTerm, firstData, secondData));
        neededEqualities.add(theory.term("=", firstData, secondData));
        proof = this.res(theory.term("=", consTerm, secondData), proof, this.mProofRules.cong(testConsTerm, secondTester));
        Term secondConsTestEq = theory.term("=", testConsTerm, secondTester);
        proof = this.res(secondConsTestEq, proof, this.mProofRules.iffElim1(secondConsTestEq));
        proof = this.res(testConsTerm, proof, this.mProofRules.dtTestE(secondTester.getFunction().getIndices()[0], consTerm));
        Term firstTesterEq = theory.term("=", firstTester, theory.mTrue);
        neededEqualities.add(firstTesterEq);
        proof = this.res(firstTester, this.mProofRules.iffElim1(firstTesterEq), proof);
        Term secondTesterEq = theory.term("=", secondTester, theory.mTrue);
        neededEqualities.add(secondTesterEq);
        proof = this.res(secondTester, this.mProofRules.iffElim1(secondTesterEq), proof);
        proof = this.res(theory.mTrue, this.mProofRules.trueIntro(), proof);
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private Term convertDTInjective(ProofLiteral[] clause, Object[] ccAnnotation) {
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        assert (ccAnnotation.length == 4);
        ApplicationTerm goalEquality = (ApplicationTerm)ccAnnotation[0];
        assert (ccAnnotation[1].equals(":cons"));
        ApplicationTerm consTerm1 = (ApplicationTerm)ccAnnotation[2];
        ApplicationTerm consTerm2 = (ApplicationTerm)ccAnnotation[3];
        assert (consTerm1.getFunction() == consTerm2.getFunction());
        assert (consTerm1.getFunction().isConstructor());
        Term[] consArgs1 = consTerm1.getParameters();
        Term[] consArgs2 = consTerm2.getParameters();
        Term mainEq1 = goalEquality.getParameters()[0];
        Term mainEq2 = goalEquality.getParameters()[1];
        int pos = 0;
        while (consArgs1[pos] != mainEq1 || consArgs2[pos] != mainEq2) {
            ++pos;
        }
        DataType dataType = (DataType)consTerm1.getSort().getSortSymbol();
        DataType.Constructor cons = dataType.findConstructor(consTerm1.getFunction().getName());
        String selector = cons.getSelectors()[pos];
        Term sel1 = theory.term(selector, consTerm1);
        Term sel2 = theory.term(selector, consTerm2);
        Term proof = this.mProofRules.trans(mainEq1, sel1, sel2, mainEq2);
        neededDisequalities.add(goalEquality);
        proof = this.res(theory.term("=", mainEq1, sel1), this.res(theory.term("=", sel1, mainEq1), this.mProofRules.dtProject(sel1), this.mProofRules.symm(mainEq1, sel1)), proof);
        proof = this.res(theory.term("=", sel2, mainEq2), this.mProofRules.dtProject(sel2), proof);
        proof = this.res(theory.term("=", sel1, sel2), this.mProofRules.cong(sel1, sel2), proof);
        neededEqualities.add(theory.term("=", consTerm1, consTerm2));
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private Term convertDTDisjoint(ProofLiteral[] clause, Object[] ccAnnotation) {
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        assert (ccAnnotation.length == 3);
        assert (ccAnnotation[0].equals(":cons"));
        ApplicationTerm consTerm1 = (ApplicationTerm)ccAnnotation[1];
        ApplicationTerm consTerm2 = (ApplicationTerm)ccAnnotation[2];
        assert (consTerm1.getFunction() != consTerm2.getFunction());
        assert (consTerm1.getFunction().isConstructor());
        assert (consTerm2.getFunction().isConstructor());
        Term isCons11 = theory.term("is", new String[]{consTerm1.getFunction().getName()}, null, consTerm1);
        Term isCons12 = theory.term("is", new String[]{consTerm1.getFunction().getName()}, null, consTerm2);
        Term isConsEq = theory.term("=", isCons11, isCons12);
        Term proof = this.mProofRules.cong(isCons11, isCons12);
        neededEqualities.add(theory.term("=", consTerm1, consTerm2));
        proof = this.res(isConsEq, proof, this.mProofRules.iffElim2(isConsEq));
        proof = this.res(isCons11, this.mProofRules.dtTestI(consTerm1), proof);
        proof = this.res(isCons12, proof, this.mProofRules.dtTestE(consTerm1.getFunction().getName(), consTerm2));
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private int checkAndFindConsArg(Term consTerm, Term argTerm) {
        if (!(consTerm instanceof ApplicationTerm)) {
            return -1;
        }
        ApplicationTerm appTerm = (ApplicationTerm)consTerm;
        if (!appTerm.getFunction().isConstructor()) {
            return -1;
        }
        Term[] consArgs = appTerm.getParameters();
        for (int i = 0; i < consArgs.length; ++i) {
            if (consArgs[i] != argTerm) continue;
            return i;
        }
        return -1;
    }

    private Term convertDTCycle(ProofLiteral[] clause, Object[] ccAnnotation) {
        Theory theory = clause[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> allEqualities = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> allDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(clause, allEqualities, allDisequalities);
        HashSet<Term> neededEqualities = new HashSet<Term>();
        HashSet<Term> neededDisequalities = new HashSet<Term>();
        assert (ccAnnotation.length == 2);
        assert (ccAnnotation[0].equals(":cycle"));
        Term[] cycle = (Term[])ccAnnotation[1];
        assert (cycle.length >= 3);
        assert (cycle.length % 2 == 1);
        assert (cycle[0] == cycle[cycle.length - 1]);
        Term runningTerm = cycle[0];
        Term proof = this.mProofRules.refl(runningTerm);
        int[] argSequence = new int[(cycle.length - 1) / 2];
        for (int i = cycle.length - 3; i >= 0; i -= 2) {
            Term consTerm;
            block17: {
                consTerm = cycle[i + 1];
                Term selectTerm = cycle[i + 2];
                int pos = this.checkAndFindConsArg(consTerm, selectTerm);
                if (pos >= 0) {
                    if (runningTerm == selectTerm) {
                        runningTerm = consTerm;
                        proof = this.mProofRules.refl(runningTerm);
                    } else {
                        Term[] consArgs = (Term[])((ApplicationTerm)consTerm).getParameters().clone();
                        consArgs[pos] = runningTerm;
                        for (int argnr = 0; argnr < consArgs.length; ++argnr) {
                            if (argnr == pos) continue;
                            neededEqualities.add(theory.term("=", consArgs[argnr], consArgs[argnr]));
                        }
                        Term newRunningTerm = theory.term(((ApplicationTerm)consTerm).getFunction(), consArgs);
                        proof = this.res(theory.term("=", runningTerm, selectTerm), proof, this.mProofRules.cong(newRunningTerm, consTerm));
                        runningTerm = newRunningTerm;
                    }
                    argSequence[i / 2] = pos;
                } else {
                    DataType.Constructor[] constrs;
                    ApplicationTerm appTerm = (ApplicationTerm)selectTerm;
                    assert (appTerm.getFunction().isSelector());
                    assert (consTerm.getSort() == appTerm.getParameters()[0].getSort());
                    DataType dataType = (DataType)consTerm.getSort().getSortSymbol();
                    for (DataType.Constructor c : constrs = dataType.getConstructors()) {
                        String[] selectors = c.getSelectors();
                        for (pos = 0; pos < selectors.length; ++pos) {
                            if (!selectors[pos].equals(appTerm.getFunction().getName())) continue;
                            Term[] consArgs = new Term[selectors.length];
                            Term[] runningArgs = new Term[selectors.length];
                            for (int argnr = 0; argnr < consArgs.length; ++argnr) {
                                consArgs[argnr] = theory.term(selectors[argnr], consTerm);
                                if (argnr != pos) {
                                    runningArgs[argnr] = consArgs[argnr];
                                    neededEqualities.add(theory.term("=", consArgs[argnr], consArgs[argnr]));
                                    continue;
                                }
                                runningArgs[argnr] = runningTerm;
                            }
                            Term newConsTerm = theory.term(c.getName(), null, c.needsReturnOverload() ? consTerm.getSort() : null, consArgs);
                            Term newRunningTerm = theory.term(c.getName(), null, c.needsReturnOverload() ? consTerm.getSort() : null, runningArgs);
                            Term isConsTerm = theory.term("is", new String[]{c.getName()}, null, consTerm);
                            proof = this.res(theory.term("=", runningTerm, selectTerm), proof, this.mProofRules.cong(newRunningTerm, newConsTerm));
                            proof = this.res(theory.term("=", newRunningTerm, newConsTerm), proof, this.mProofRules.trans(newRunningTerm, newConsTerm, consTerm));
                            Term isConsEq = theory.term("=", isConsTerm, theory.mTrue);
                            proof = this.res(theory.term("=", newConsTerm, consTerm), this.mProofRules.dtCons(isConsTerm), proof);
                            proof = this.res(isConsTerm, this.res(theory.mTrue, this.mProofRules.trueIntro(), this.mProofRules.iffElim1(isConsEq)), proof);
                            neededEqualities.add(isConsEq);
                            runningTerm = newRunningTerm;
                            argSequence[i / 2] = pos;
                            break block17;
                        }
                    }
                    throw new AssertionError();
                }
            }
            Term eqterm = cycle[i];
            if (eqterm == consTerm) continue;
            proof = this.res(theory.term("=", runningTerm, consTerm), proof, this.mProofRules.trans(runningTerm, consTerm, eqterm));
            neededEqualities.add(theory.term("=", consTerm, eqterm));
        }
        proof = this.res(theory.term("=", runningTerm, cycle[0]), proof, this.mProofRules.dtAcyclic(runningTerm, argSequence));
        return this.resolveNeededEqualities(proof, allEqualities, allDisequalities, neededEqualities, neededDisequalities);
    }

    private void convertInstLemma(ProofLiteral[] clause, Object[] quantAnnotation) {
        assert (!clause[0].getPolarity());
        Term firstAtom = clause[0].getAtom();
        assert (firstAtom instanceof QuantifiedFormula && ((QuantifiedFormula)firstAtom).getQuantifier() == 1);
        assert (quantAnnotation.length == 5 && quantAnnotation[0] == ":subs" && (quantAnnotation[2] == ":conflict" || quantAnnotation[2] == ":e-matching" || quantAnnotation[2] == ":enumeration") && quantAnnotation[3] == ":subproof");
        Term[] subst = (Term[])quantAnnotation[1];
        AnnotatedTerm annotSubproof = (AnnotatedTerm)this.getConverted();
        Term provedEq = this.provedTerm(annotSubproof);
        Term subproof = this.stripAnnotation(annotSubproof);
        assert (this.isApplication("=", provedEq));
        Term[] provedEqSides = ((ApplicationTerm)provedEq).getParameters();
        QuantifiedFormula forall = (QuantifiedFormula)firstAtom;
        AnnotatedTerm substitute = this.substituteInQuantInst(subst, forall);
        assert (this.provedTerm(substitute) == provedEqSides[0]);
        Term proof = this.stripAnnotation(substitute);
        proof = this.mProofRules.resolutionRule(provedEqSides[0], proof, this.mProofRules.iffElim2(provedEq));
        proof = this.mProofRules.resolutionRule(provedEq, subproof, proof);
        Term[] result = new Term[]{provedEqSides[1]};
        if (this.isApplication("false", provedEqSides[1])) {
            result = new Term[]{};
            proof = this.mProofRules.resolutionRule(provedEqSides[1], proof, this.mProofRules.falseElim());
        } else if (this.isApplication("or", provedEqSides[1])) {
            result = ((ApplicationTerm)provedEqSides[1]).getParameters();
            proof = this.mProofRules.resolutionRule(provedEqSides[1], proof, this.mProofRules.orElim(provedEqSides[1]));
        }
        for (int i = 0; i < result.length; ++i) {
            proof = this.removeNot(proof, result[i], true);
        }
        this.setResult(proof);
    }

    private Term convertQuant(Term[] newParams) {
        Theory theory = this.mSkript.getTheory();
        AnnotatedTerm annotatedTerm = (AnnotatedTerm)newParams[0];
        Annotation varAnnot = annotatedTerm.getAnnotations()[0];
        assert (annotatedTerm.getAnnotations().length == 1 && (varAnnot.getKey() == ":forall" || varAnnot.getKey() == ":exists") && varAnnot.getValue() instanceof TermVariable[]);
        boolean isForall = varAnnot.getKey() == ":forall";
        TermVariable[] vars = (TermVariable[])varAnnot.getValue();
        Term subProof = annotatedTerm.getSubterm();
        Term proof = this.subproof((AnnotatedTerm)subProof);
        ApplicationTerm subEquality = (ApplicationTerm)this.provedTerm((AnnotatedTerm)subProof);
        assert (this.isApplication("=", subEquality));
        FormulaUnLet unletter = new FormulaUnLet();
        Term[] skolem = this.mProofRules.getSkolemVars(vars, subEquality, true);
        Term letEquality = unletter.unlet(theory.let(vars, skolem, (Term)subEquality));
        Term letProof = unletter.unlet(theory.let(vars, skolem, proof));
        QuantifiedFormula forallSubEquality = (QuantifiedFormula)theory.forall(vars, subEquality);
        Term forallProof = this.res(letEquality, letProof, this.mProofRules.forallIntro(forallSubEquality));
        Term lhs = subEquality.getParameters()[0];
        Term rhs = subEquality.getParameters()[1];
        Term[] skolem1 = this.mProofRules.getSkolemVars(vars, isForall ? lhs : rhs, isForall);
        Term let1Rhs = unletter.unlet(theory.let(vars, skolem1, rhs));
        Term let1Lhs = unletter.unlet(theory.let(vars, skolem1, lhs));
        Term let1Eq = theory.term("=", let1Lhs, let1Rhs);
        Term let1Proof = this.mProofRules.forallElim(skolem1, forallSubEquality);
        Term[] skolem2 = this.mProofRules.getSkolemVars(vars, isForall ? rhs : lhs, isForall);
        Term let2Lhs = unletter.unlet(theory.let(vars, skolem2, lhs));
        Term let2Rhs = unletter.unlet(theory.let(vars, skolem2, rhs));
        Term let2Eq = theory.term("=", let2Lhs, let2Rhs);
        Term let2Proof = this.mProofRules.forallElim(skolem2, forallSubEquality);
        QuantifiedFormula quLhs = (QuantifiedFormula)(isForall ? theory.forall(vars, lhs) : theory.exists(vars, lhs));
        QuantifiedFormula quRhs = (QuantifiedFormula)(isForall ? theory.forall(vars, rhs) : theory.exists(vars, rhs));
        Term newEquality = theory.term("=", quLhs, quRhs);
        Term proof1 = this.mProofRules.resolutionRule(let1Rhs, isForall ? this.mProofRules.forallElim(skolem1, quRhs) : this.mProofRules.existsElim(quRhs), this.mProofRules.resolutionRule(let1Lhs, this.mProofRules.resolutionRule(let1Eq, let1Proof, this.mProofRules.iffElim1(let1Eq)), isForall ? this.mProofRules.forallIntro(quLhs) : this.mProofRules.existsIntro(skolem1, quLhs)));
        Term proof2 = this.mProofRules.resolutionRule(let2Lhs, isForall ? this.mProofRules.forallElim(skolem2, quLhs) : this.mProofRules.existsElim(quLhs), this.mProofRules.resolutionRule(let2Rhs, this.mProofRules.resolutionRule(let2Eq, let2Proof, this.mProofRules.iffElim2(let2Eq)), isForall ? this.mProofRules.forallIntro(quRhs) : this.mProofRules.existsIntro(skolem2, quRhs)));
        proof = this.proveIff(newEquality, proof2, proof1);
        proof = this.res(forallSubEquality, forallProof, proof);
        assert (this.checkProof(proof, this.termToProofLiterals(newEquality)));
        return this.annotateProved(newEquality, proof);
    }

    public Term convertLemma(ProofLiteral[] clause, Annotation annot) {
        Term result;
        String name = annot.getKey();
        Object annotValue = annot.getValue();
        switch (name) {
            case ":trans": 
            case ":cong": {
                result = this.convertCCLemma(clause, name, (Term[])annotValue);
                break;
            }
            case ":read-over-weakeq": {
                result = this.convertArraySelectWeakEqLemma(clause, (Object[])annotValue);
                break;
            }
            case ":weakeq-ext": {
                result = this.convertArrayWeakEqExtLemma(clause, (Object[])annotValue);
                break;
            }
            case ":read-const-weakeq": {
                result = this.convertArraySelectConstWeakEqLemma(clause, (Object[])annotValue);
                break;
            }
            case ":dt-project": {
                result = this.convertDTProject(clause, (Object[])annotValue);
                break;
            }
            case ":dt-tester": {
                result = this.convertDTTester(clause, (Object[])annotValue);
                break;
            }
            case ":dt-constructor": {
                result = this.convertDTConstructor(clause, (Object[])annotValue);
                break;
            }
            case ":dt-cases": {
                result = this.convertDTCases(clause, (Object[])annotValue);
                break;
            }
            case ":dt-unique": {
                result = this.convertDTUnique(clause, (Object[])annotValue);
                break;
            }
            case ":dt-injective": {
                result = this.convertDTInjective(clause, (Object[])annotValue);
                break;
            }
            case ":dt-disjoint": {
                result = this.convertDTDisjoint(clause, (Object[])annotValue);
                break;
            }
            case ":dt-cycle": {
                result = this.convertDTCycle(clause, (Object[])annotValue);
                break;
            }
            case ":EQ": {
                result = this.convertEQLemma(clause);
                break;
            }
            case ":LA": {
                result = this.convertLALemma(clause, (Term[])annotValue);
                break;
            }
            case ":trichotomy": {
                result = this.convertTrichotomy(clause);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Lemma");
            }
        }
        assert (this.checkProof(result, clause));
        result = this.annotateProvedClause(result, annot, clause);
        return result;
    }

    private void convertMP(ProofLiteral[] clause) {
        AnnotatedTerm rewrite = (AnnotatedTerm)this.getConverted();
        ApplicationTerm provedEq = (ApplicationTerm)this.provedTerm(rewrite);
        assert (this.isApplication("=", provedEq));
        Term[] eqParams = provedEq.getParameters();
        Term proof = this.res(provedEq, this.subproof(rewrite), this.mProofRules.iffElim2(provedEq));
        proof = this.removeNot(proof, eqParams[0], false);
        proof = this.removeNot(proof, eqParams[1], true);
        assert (this.checkProof(proof, clause));
        this.setResult(proof);
    }

    public void convertOracle(AnnotatedTerm oracle) {
        Annotation[] annots = oracle.getAnnotations();
        assert (annots.length >= 2);
        Object[] lits = (Object[])annots[0].getValue();
        assert (lits.length % 2 == 0);
        ProofLiteral[] clause = new ProofLiteral[lits.length / 2];
        for (int i = 0; i < clause.length; ++i) {
            assert (lits[2 * i].equals("+") || lits[2 * i].equals("-"));
            clause[i] = new ProofLiteral((Term)lits[2 * i + 1], lits[2 * i].equals("+"));
        }
        switch (annots[1].getKey()) {
            case ":trans": 
            case ":cong": 
            case ":read-over-weakeq": 
            case ":weakeq-ext": 
            case ":read-const-weakeq": 
            case ":dt-project": 
            case ":dt-tester": 
            case ":dt-constructor": 
            case ":dt-cases": 
            case ":dt-unique": 
            case ":dt-injective": 
            case ":dt-disjoint": 
            case ":dt-cycle": 
            case ":EQ": 
            case ":LA": 
            case ":trichotomy": {
                this.setResult(this.convertLemma(clause, annots[1]));
                break;
            }
            case ":true+": 
            case ":false-": 
            case ":or+": 
            case ":or-": 
            case ":and+": 
            case ":and-": 
            case ":=>+": 
            case ":=>-": 
            case ":xor+1": 
            case ":xor+2": 
            case ":xor-1": 
            case ":xor-2": 
            case ":ite+1": 
            case ":ite+2": 
            case ":ite+red": 
            case ":ite-1": 
            case ":ite-2": 
            case ":ite-red": 
            case ":=+1": 
            case ":=+2": 
            case ":=-1": 
            case ":=-2": 
            case ":exists-": 
            case ":forall+": 
            case ":exists+": 
            case ":forall-": 
            case ":termITE": 
            case ":termITEBound": 
            case ":trueNotFalse": 
            case ":excludedMiddle1": 
            case ":excludedMiddle2": 
            case ":divHigh": 
            case ":divLow": 
            case ":toIntHigh": 
            case ":toIntLow": 
            case ":store": 
            case ":diff": 
            case ":matchCase": 
            case ":matchDefault": {
                this.setResult(this.convertTautology(clause, annots[1]));
                break;
            }
            case ":rewrite": {
                this.enqueueWalker(engine -> ((ProofSimplifier)engine).convertMP(clause));
                this.convert((Term)annots[1].getValue());
                break;
            }
            case ":inst": {
                Object[] instAnnot = (Object[])annots[1].getValue();
                assert (instAnnot[3] == ":subproof");
                this.enqueueWalker(engine -> ((ProofSimplifier)engine).convertInstLemma(clause, instAnnot));
                this.convert((Term)instAnnot[4]);
                break;
            }
            default: {
                this.setResult(oracle);
                return;
            }
        }
    }

    @Override
    public void convertApplicationTerm(ApplicationTerm old, Term[] newParams) {
        if (old.getSort().getName() == ".EqProof") {
            switch (old.getFunction().getName()) {
                case ".trans": {
                    this.setResult(this.convertTrans(newParams));
                    return;
                }
                case ".cong": {
                    this.setResult(this.convertCong(old.getFunction(), newParams));
                    return;
                }
                case ".match": {
                    this.setResult(this.convertMatch(newParams));
                    return;
                }
                case ".quant": {
                    this.setResult(this.convertQuant(newParams));
                    return;
                }
            }
            throw new AssertionError((Object)("Cannot translate proof rule: " + old.getFunction()));
        }
        assert (ProofRules.isProof(old));
        super.convertApplicationTerm(old, newParams);
    }

    @Override
    public void convert(Term term) {
        if (term.getSort() == term.getTheory().getBooleanSort()) {
            this.setResult(term);
        } else if (term.getSort().getName() == ".EqProof" && term instanceof ApplicationTerm) {
            ApplicationTerm rewriteProof = (ApplicationTerm)term;
            switch (rewriteProof.getFunction().getName()) {
                case ".refl": {
                    Term t = rewriteProof.getParameters()[0];
                    this.setResult(this.annotateProved(t.getTheory().term("=", t, t), this.mProofRules.refl(t)));
                    return;
                }
                case ".rewrite": {
                    AnnotatedTerm lhsAnnot = (AnnotatedTerm)rewriteProof.getParameters()[0];
                    Annotation annot = lhsAnnot.getAnnotations()[0];
                    Term lhs = lhsAnnot.getSubterm();
                    Term rhs = rewriteProof.getParameters()[1];
                    this.setResult(this.convertRewrite(lhs, rhs, annot));
                    return;
                }
            }
            super.convert(term);
        } else if (ProofRules.isOracle(term)) {
            this.convertOracle((AnnotatedTerm)term);
        } else {
            super.convert(term);
        }
    }

    private Term expandAux(ApplicationTerm auxTerm) {
        FunctionSymbol auxFunc = auxTerm.getFunction();
        return new FormulaUnLet().unlet(this.mSkript.let(auxFunc.getDefinitionVars(), auxTerm.getParameters(), auxFunc.getDefinition()));
    }

    private Term expandAuxDef(ApplicationTerm auxEqTerm) {
        ApplicationTerm auxTerm = (ApplicationTerm)auxEqTerm.getParameters()[0];
        return this.expandAux(auxTerm);
    }

    private Term negate(Term formula) {
        if (this.isApplication("not", formula)) {
            return ((ApplicationTerm)formula).getParameters()[0];
        }
        return formula.getTheory().term("not", formula);
    }

    private Rational parseConstant(Term term) {
        return Polynomial.parseConstant(term);
    }

    private boolean isApplication(String funcSym, Term term) {
        ApplicationTerm appTerm;
        FunctionSymbol func;
        return term instanceof ApplicationTerm && (func = (appTerm = (ApplicationTerm)term).getFunction()).isIntern() && func.getName().equals(funcSym);
    }

    private boolean isZero(Term zero) {
        return zero == Rational.ZERO.toTerm(zero.getSort());
    }

    private AnnotatedTerm substituteInQuantInst(Term[] subst, QuantifiedFormula qf) {
        FormulaUnLet unletter = new FormulaUnLet();
        Term rhs = unletter.unlet(qf.getTheory().let(qf.getVariables(), subst, qf.getSubformula()));
        Term proof = this.mProofRules.forallElim(subst, qf);
        return (AnnotatedTerm)this.annotateProved(rhs, proof);
    }

    private Term proveTrivialEquality(Term first, Term second) {
        if (first == second) {
            return this.mProofRules.refl(first);
        }
        if (!first.getSort().isNumericSort()) {
            return null;
        }
        SMTAffineTerm diff = new SMTAffineTerm(second);
        diff.negate();
        diff.add(new SMTAffineTerm(first));
        if (diff.isConstant() && diff.getConstant().equals(Rational.ZERO)) {
            Theory theory = first.getTheory();
            Term ltTerm = theory.term("<", first, second);
            Term gtTerm = theory.term("<", second, first);
            BigInteger[] one = new BigInteger[]{BigInteger.ONE};
            return this.res(ltTerm, this.res(gtTerm, this.mProofRules.trichotomy(first, second), this.mProofRules.farkas(new Term[]{gtTerm}, one)), this.mProofRules.farkas(new Term[]{ltTerm}, one));
        }
        return null;
    }

    private Term proveTrivialDisequality(Term first, Term second) {
        Theory theory = first.getTheory();
        SMTAffineTerm diff = new SMTAffineTerm(first);
        diff.add(Rational.MONE, second);
        if (diff.isConstant()) {
            if (diff.getConstant().signum() > 0) {
                Term eqLhs = theory.term("=", first, second);
                return this.mProofRules.farkas(new Term[]{eqLhs}, new BigInteger[]{BigInteger.ONE});
            }
            if (diff.getConstant().signum() < 0) {
                Term eqSwapped = theory.term("=", second, first);
                return this.mProofRules.resolutionRule(eqSwapped, this.mProofRules.symm(second, first), this.mProofRules.farkas(new Term[]{eqSwapped}, new BigInteger[]{BigInteger.ONE}));
            }
            return null;
        }
        Rational gcd = diff.getGcd();
        diff.div(gcd);
        Rational bound = diff.getConstant().negate();
        if (!diff.isAllIntSummands() || bound.isIntegral()) {
            return null;
        }
        Sort intSort = theory.getSort("Int", new Sort[0]);
        diff.add(bound);
        Term intVar = diff.toTerm(intSort);
        Term floorBound = bound.floor().toTerm(intSort);
        Term ceilBound = bound.ceil().toTerm(intSort);
        assert (ceilBound != floorBound);
        Term geqCeil = theory.term("<=", ceilBound, intVar);
        Term leqFloor = theory.term("<=", intVar, floorBound);
        Term proofIntCase = this.mProofRules.totalInt(intVar, bound.floor().numerator());
        Term eqLhs = theory.term("=", first, second);
        Term eqSwapped = theory.term("=", second, first);
        Term caseCeil = this.mProofRules.farkas(new Term[]{eqLhs, geqCeil}, new BigInteger[]{gcd.denominator(), gcd.numerator()});
        Term caseFloor = this.mProofRules.resolutionRule(eqSwapped, this.mProofRules.symm(second, first), this.mProofRules.farkas(new Term[]{eqSwapped, leqFloor}, new BigInteger[]{gcd.denominator(), gcd.numerator()}));
        return this.mProofRules.resolutionRule(leqFloor, this.mProofRules.resolutionRule(geqCeil, proofIntCase, caseCeil), caseFloor);
    }

    private Term proveAbsConstant(Rational rat, Sort sort) {
        Term proof;
        Theory theory = sort.getTheory();
        Term x = rat.toTerm(sort);
        Term absx = theory.term("abs", x);
        Term zero = Rational.ZERO.toTerm(sort);
        Term ltXZero = theory.term("<", x, zero);
        Term absxDef = theory.term("ite", ltXZero, theory.term("-", x), x);
        if (rat.signum() >= 0) {
            proof = this.mProofRules.trans(absx, absxDef, x);
            proof = this.res(theory.term("=", absxDef, x), this.mProofRules.ite2(absxDef), proof);
            proof = this.res(ltXZero, proof, this.mProofRules.farkas(new Term[]{ltXZero}, new BigInteger[]{BigInteger.ONE}));
        } else {
            Term minusX = theory.term("-", x);
            proof = this.mProofRules.trans(absx, absxDef, minusX, rat.abs().toTerm(sort));
            proof = this.res(theory.term("=", absxDef, minusX), this.mProofRules.ite1(absxDef), proof);
            proof = this.res(ltXZero, this.mProofRules.total(zero, x), proof);
            Term leqZeroX = theory.term("<=", zero, x);
            proof = this.res(leqZeroX, proof, this.mProofRules.farkas(new Term[]{leqZeroX}, new BigInteger[]{BigInteger.ONE}));
            Term eqMinusX = theory.term("=", minusX, rat.abs().toTerm(sort));
            proof = this.res(eqMinusX, this.convertRewriteCanonicalSum(minusX, rat.abs().toTerm(sort)), proof);
        }
        proof = this.res(theory.term("=", absx, absxDef), this.mProofRules.expand(absx), proof);
        return proof;
    }

    private Term resolveNeededEqualities(Term proof, Map<SymmetricPair<Term>, Term> allEqualities, Map<SymmetricPair<Term>, Term> allDisequalities, Set<Term> neededEqualities, Set<Term> neededDisequalities) {
        Term proofEq;
        Term clauseEq;
        Term[] eqParam;
        for (Term eq : neededEqualities) {
            assert (this.isApplication("=", eq));
            eqParam = ((ApplicationTerm)eq).getParameters();
            clauseEq = allEqualities.get(new SymmetricPair<Term>(eqParam[0], eqParam[1]));
            if (clauseEq != null) {
                if (clauseEq == eq) continue;
                proof = this.res(eq, this.mProofRules.symm(eqParam[0], eqParam[1]), proof);
                continue;
            }
            proofEq = this.proveTrivialEquality(eqParam[0], eqParam[1]);
            assert (proofEq != null);
            proof = this.res(eq, proofEq, proof);
        }
        for (Term eq : neededDisequalities) {
            assert (this.isApplication("=", eq));
            eqParam = ((ApplicationTerm)eq).getParameters();
            clauseEq = allDisequalities.get(new SymmetricPair<Term>(eqParam[0], eqParam[1]));
            if (clauseEq != null) {
                if (clauseEq == eq) continue;
                proof = this.res(eq, proof, this.mProofRules.symm(eqParam[1], eqParam[0]));
                continue;
            }
            proofEq = this.proveTrivialDisequality(eqParam[0], eqParam[1]);
            assert (proofEq != null);
            proof = this.res(eq, proof, proofEq);
        }
        return proof;
    }

    private Term[] termToClause(Term clauseTerm) {
        assert (clauseTerm != null && clauseTerm.getSort().getName() == "Bool");
        if (this.isApplication("or", clauseTerm)) {
            return ((ApplicationTerm)clauseTerm).getParameters();
        }
        if (this.isApplication("false", clauseTerm)) {
            return new Term[0];
        }
        return new Term[]{clauseTerm};
    }

    private ProofLiteral[] termArrayToProofLiterals(Term[] clauseLits) {
        ProofLiteral[] proofLits = new ProofLiteral[clauseLits.length];
        for (int i = 0; i < proofLits.length; ++i) {
            Term lit = clauseLits[i];
            boolean polarity = true;
            while (this.isApplication("not", lit)) {
                lit = ((ApplicationTerm)lit).getParameters()[0];
                polarity = !polarity;
            }
            proofLits[i] = new ProofLiteral(lit, polarity);
        }
        return proofLits;
    }

    private ProofLiteral[] termToProofLiterals(Term clauseTerm) {
        return this.termArrayToProofLiterals(this.termToClause(clauseTerm));
    }

    private Term proveIffTrue(Term equality, Term proofLeftTrue) {
        assert (this.isApplication("=", equality));
        Term[] sides = ((ApplicationTerm)equality).getParameters();
        assert (this.isApplication("true", sides[1]));
        return this.res(sides[1], this.mProofRules.trueIntro(), this.res(sides[0], proofLeftTrue, this.mProofRules.iffIntro2(equality)));
    }

    private Term proveIffFalse(Term equality, Term proofLeftFalse) {
        assert (this.isApplication("=", equality));
        Term[] sides = ((ApplicationTerm)equality).getParameters();
        assert (this.isApplication("false", sides[1]));
        return this.res(sides[1], this.res(sides[0], this.mProofRules.iffIntro1(equality), proofLeftFalse), this.mProofRules.falseElim());
    }

    private Term proveIff(Term equality, Term proofLeftToRight, Term proofRightToLeft) {
        assert (this.isApplication("=", equality));
        Term[] sides = ((ApplicationTerm)equality).getParameters();
        assert (sides.length == 2);
        if (this.isApplication("true", sides[1])) {
            return this.proveIffTrue(equality, proofRightToLeft);
        }
        if (this.isApplication("false", sides[1])) {
            return this.proveIffFalse(equality, proofLeftToRight);
        }
        return this.mProofRules.resolutionRule(sides[1], this.mProofRules.resolutionRule(sides[0], this.mProofRules.iffIntro1(equality), proofLeftToRight), this.mProofRules.resolutionRule(sides[0], proofRightToLeft, this.mProofRules.iffIntro2(equality)));
    }

    private Term res(Term pivot, Term proofPos, Term proofNeg) {
        return proofPos == null ? proofNeg : (proofNeg == null ? proofPos : this.mProofRules.resolutionRule(pivot, proofPos, proofNeg));
    }

    private Term proveAuxElim(ApplicationTerm auxEqAtom, Term expanded) {
        ApplicationTerm auxTerm = (ApplicationTerm)auxEqAtom.getParameters()[0];
        Term falseTerm = this.mSkript.term("false", new Term[0]);
        Term expandEq = this.mSkript.term("=", auxTerm, expanded);
        return this.res(auxTerm, this.res(falseTerm, this.mProofRules.iffIntro1(auxEqAtom), this.mProofRules.falseElim()), this.res(expandEq, this.mProofRules.expand(auxTerm), this.mProofRules.iffElim2(expandEq)));
    }

    private Term proveAuxExpand(ApplicationTerm auxEqAtom, Term expanded) {
        ApplicationTerm auxTerm = (ApplicationTerm)auxEqAtom.getParameters()[0];
        Term trueTerm = this.mSkript.term("true", new Term[0]);
        Term firstEq = this.mSkript.term("=", auxEqAtom, auxTerm);
        Term secondEq = this.mSkript.term("=", auxTerm, expanded);
        return this.mProofRules.resolutionRule(firstEq, this.mProofRules.resolutionRule(trueTerm, this.mProofRules.trueIntro(), this.proveIff(firstEq, this.mProofRules.iffElim1(auxEqAtom), this.mProofRules.iffIntro2(auxEqAtom))), this.mProofRules.resolutionRule(secondEq, this.mProofRules.expand(auxTerm), this.mProofRules.trans(auxEqAtom, auxTerm, expanded)));
    }

    private Term proveEqWithMultiplier(Term[] lhs, Term[] rhs, Rational multiplier) {
        Theory theory = lhs[0].getTheory();
        Term eqLhs = theory.term("=", lhs[0], lhs[1]);
        Term eqSwapped = theory.term("=", lhs[1], lhs[0]);
        Term ltRhs1 = theory.term("<", rhs[0], rhs[1]);
        Term ltRhs2 = theory.term("<", rhs[1], rhs[0]);
        boolean isSwapped2 = multiplier.signum() < 0;
        BigInteger[] coeffs = new BigInteger[]{multiplier.numerator().abs(), multiplier.denominator()};
        Term proof1 = this.mProofRules.farkas(new Term[]{isSwapped2 ? eqLhs : eqSwapped, ltRhs1}, coeffs);
        Term proof2 = this.mProofRules.farkas(new Term[]{isSwapped2 ? eqSwapped : eqLhs, ltRhs2}, coeffs);
        Term proof = this.res(ltRhs1, this.res(ltRhs2, this.mProofRules.trichotomy(rhs[0], rhs[1]), proof2), proof1);
        proof = this.res(eqSwapped, this.mProofRules.symm(lhs[1], lhs[0]), proof);
        return proof;
    }

    private Term proveRewriteWithLinEq(Term lhs, Term rhs) {
        boolean swapSides;
        Theory theory = lhs.getTheory();
        assert (this.isApplication("=", lhs) && this.isApplication("=", rhs));
        Term[] lhsParams = ((ApplicationTerm)lhs).getParameters();
        Term[] rhsParams = ((ApplicationTerm)rhs).getParameters();
        SMTAffineTerm lhsAffine = new SMTAffineTerm(lhsParams[0]);
        lhsAffine.add(Rational.MONE, lhsParams[1]);
        SMTAffineTerm rhsAffine = new SMTAffineTerm(rhsParams[0]);
        rhsAffine.add(Rational.MONE, rhsParams[1]);
        assert (!lhsAffine.isConstant() && !rhsAffine.isConstant()) : "A trivial equality was created";
        Rational multiplier = lhsAffine.getGcd().div(rhsAffine.getGcd());
        rhsAffine.mul(multiplier);
        boolean bl = swapSides = !lhsAffine.equals(rhsAffine);
        if (swapSides) {
            rhsAffine.negate();
            multiplier = multiplier.negate();
        }
        assert (lhsAffine.equals(rhsAffine));
        return this.proveIff(theory.term("=", lhs, rhs), this.proveEqWithMultiplier(lhsParams, rhsParams, multiplier.inverse()), this.proveEqWithMultiplier(rhsParams, lhsParams, multiplier));
    }

    private Term proveRewriteWithLeq(Term lhs, Term rhs, boolean allowFactor) {
        Term rhsTotality;
        Term negRhsAtom;
        Theory theory = lhs.getTheory();
        boolean isGreater = this.isApplication(">", lhs) || this.isApplication(">=", lhs);
        boolean rhsIsNegated = this.isApplication("not", rhs);
        Term rhsAtom = rhsIsNegated ? this.negate(rhs) : rhs;
        Term[] lhsParam = ((ApplicationTerm)lhs).getParameters();
        Term[] rhsAtomParam = ((ApplicationTerm)rhsAtom).getParameters();
        boolean isStrictLhs = this.isApplication("<", lhs) || this.isApplication(">", lhs);
        boolean isStrictRhsAtom = this.isApplication("<", rhsAtom);
        if (isGreater) {
            lhsParam = new Term[]{lhsParam[1], lhsParam[0]};
        }
        Term posLhs = theory.term(isStrictLhs ? "<" : "<=", lhsParam[0], lhsParam[1]);
        Term negLhs = theory.term(isStrictLhs ? "<=" : "<", lhsParam[1], lhsParam[0]);
        Rational factor = Rational.ONE;
        boolean needsIntReasoning = false;
        if (allowFactor) {
            SMTAffineTerm lhsAffine = new SMTAffineTerm(lhsParam[0]);
            lhsAffine.add(Rational.MONE, lhsParam[1]);
            SMTAffineTerm rhsAffine = new SMTAffineTerm(rhsAtomParam[0]);
            rhsAffine.add(Rational.MONE, rhsAtomParam[1]);
            assert (!lhsAffine.isConstant() && !rhsAffine.isConstant());
            Term someTerm = lhsAffine.getSummands().keySet().iterator().next();
            factor = lhsAffine.getSummands().get(someTerm).div(rhsAffine.getSummands().get(someTerm)).abs();
            if (lhsParam[0].getSort().getName().equals("Int")) {
                boolean bl = needsIntReasoning = !lhsAffine.getConstant().div(factor).isIntegral() || rhsIsNegated;
            }
        }
        if (needsIntReasoning) {
            assert (this.isZero(rhsAtomParam[1]));
            assert (!isStrictLhs && !isStrictRhsAtom);
            Term one = Rational.ONE.toTerm(rhsAtomParam[1].getSort());
            negRhsAtom = theory.term("<=", one, rhsAtomParam[0]);
            rhsTotality = this.mProofRules.totalInt(rhsAtomParam[0], BigInteger.ZERO);
        } else {
            negRhsAtom = theory.term(isStrictRhsAtom ? "<=" : "<", rhsAtomParam[1], rhsAtomParam[0]);
            rhsTotality = this.mProofRules.total(rhsAtomParam[isStrictRhsAtom ? 1 : 0], rhsAtomParam[isStrictRhsAtom ? 0 : 1]);
        }
        Term proofToRhsAtom = this.mProofRules.farkas(new Term[]{rhsIsNegated ? negLhs : posLhs, negRhsAtom}, new BigInteger[]{factor.denominator(), factor.numerator()});
        proofToRhsAtom = this.mProofRules.resolutionRule(negRhsAtom, rhsTotality, proofToRhsAtom);
        Term proofFromRhsAtom = this.mProofRules.farkas(new Term[]{rhsIsNegated ? posLhs : negLhs, rhsAtom}, new BigInteger[]{factor.denominator(), factor.numerator()});
        Term proofLhsToRhs = rhsIsNegated ? this.mProofRules.resolutionRule(rhsAtom, this.mProofRules.notIntro(rhs), proofFromRhsAtom) : proofToRhsAtom;
        Term proofRhsToLhs = rhsIsNegated ? this.mProofRules.resolutionRule(rhsAtom, proofToRhsAtom, this.mProofRules.notElim(rhs)) : proofFromRhsAtom;
        proofRhsToLhs = this.mProofRules.resolutionRule(negLhs, this.mProofRules.total(lhsParam[isStrictLhs ? 1 : 0], lhsParam[isStrictLhs ? 0 : 1]), proofRhsToLhs);
        Term greaterEq = null;
        if (isGreater) {
            greaterEq = theory.term("=", lhs, posLhs);
            proofLhsToRhs = this.mProofRules.resolutionRule(posLhs, this.mProofRules.iffElim2(greaterEq), proofLhsToRhs);
            proofRhsToLhs = this.mProofRules.resolutionRule(posLhs, proofRhsToLhs, this.mProofRules.iffElim1(greaterEq));
        }
        Term proof = this.proveIff(theory.term("=", lhs, rhs), proofLhsToRhs, proofRhsToLhs);
        if (isGreater) {
            proof = this.mProofRules.resolutionRule(greaterEq, isStrictLhs ? this.mProofRules.gtDef(lhs) : this.mProofRules.geqDef(lhs), proof);
        }
        return proof;
    }

    public Term transformProof(Term proof) {
        CollectSkolemAux collector = new CollectSkolemAux();
        proof = collector.transform(proof);
        this.mAuxDefs = collector.getAuxDef();
        TermVariable[] freeVars = (proof = super.transform(proof)).getFreeVars();
        if (freeVars.length > 0) {
            Theory theory = proof.getTheory();
            Term[] values = new Term[freeVars.length];
            for (int i = 0; i < freeVars.length; ++i) {
                values[i] = this.mProofRules.choose(freeVars[i], theory.mTrue);
            }
            proof = new FormulaUnLet().unlet(theory.let(freeVars, values, proof));
        }
        ArrayDeque<FunctionSymbol> reversedOrder = new ArrayDeque<FunctionSymbol>();
        for (FunctionSymbol function : this.mAuxDefs.keySet()) {
            reversedOrder.addFirst(function);
        }
        for (FunctionSymbol function : reversedOrder) {
            proof = this.mProofRules.defineFun(function, this.mAuxDefs.get(function), proof);
        }
        return proof;
    }

    class CollectSkolemAux
    extends TermTransformer {
        private final HashMap<FunctionSymbol, LambdaTerm> mQuantDefinedTerms = new LinkedHashMap<FunctionSymbol, LambdaTerm>();

        CollectSkolemAux() {
        }

        public HashMap<FunctionSymbol, LambdaTerm> getAuxDef() {
            return this.mQuantDefinedTerms;
        }

        @Override
        public void convert(Term term) {
            FunctionSymbol func;
            if ((ProofSimplifier.this.isAuxApplication(term) || ProofSimplifier.this.isSkolem(term)) && !this.mQuantDefinedTerms.containsKey(func = ((ApplicationTerm)term).getFunction())) {
                this.enqueueWalker(engine -> {
                    ((CollectSkolemAux)engine).getConverted();
                    if (!this.mQuantDefinedTerms.containsKey(func)) {
                        this.mQuantDefinedTerms.put(func, (LambdaTerm)func.getTheory().lambda(func.getDefinitionVars(), func.getDefinition()));
                    }
                });
                super.convert(func.getDefinition());
            }
            super.convert(term);
        }
    }
}

