/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class ProofTermGenerator
extends NonRecursive {
    private final Deque<Term> mConverted = new ArrayDeque<Term>();
    private final Map<Clause, Term> mNodes = new HashMap<Clause, Term>();
    ProofRules mProofRules;

    public ProofTermGenerator(ProofRules proofRules) {
        this.mProofRules = proofRules;
    }

    public Theory getTheory() {
        return this.mProofRules.getTheory();
    }

    Term getTerm(Clause cls) {
        return this.mNodes.get(cls);
    }

    Term getConverted() {
        return this.mConverted.pop();
    }

    void pushConverted(Term res) {
        assert (ProofRules.isProof(res));
        this.mConverted.push(res);
    }

    void setResult(Clause cls, Term res) {
        this.mNodes.put(cls, res);
    }

    public Term convert(Clause cls) {
        assert (cls.getProof() != null);
        this.run(new Expander(cls));
        Term res = this.mConverted.pop();
        return res;
    }

    private static class Expander
    implements NonRecursive.Walker {
        private final Clause mCls;

        public Expander(Clause cls) {
            this.mCls = cls;
        }

        @Override
        public void walk(NonRecursive nr) {
            ProofTermGenerator engine = (ProofTermGenerator)nr;
            Term known = engine.getTerm(this.mCls);
            if (known != null) {
                engine.pushConverted(known);
                return;
            }
            ProofNode pn = this.mCls.getProof();
            if (pn.isLeaf()) {
                Term res;
                LeafNode ln = (LeafNode)pn;
                Theory t = engine.getTheory();
                IAnnotation annot = ln.getTheoryAnnotation();
                if (annot == null) {
                    assert (ln.getLeafKind() == -7);
                    res = engine.mProofRules.asserted(this.mCls.toTerm(t));
                } else {
                    res = annot.toTerm(this.mCls, engine.mProofRules);
                }
                engine.setResult(this.mCls, res);
                engine.pushConverted(res);
            } else {
                ResolutionNode.Antecedent[] antes;
                ResolutionNode rn = (ResolutionNode)pn;
                engine.enqueueWalker(new GenerateTerm(this.mCls));
                engine.enqueueWalker(new Expander(rn.getPrimary()));
                for (ResolutionNode.Antecedent ante : antes = rn.getAntecedents()) {
                    engine.enqueueWalker(new Expander(ante.mAntecedent));
                }
            }
        }
    }

    private static class GenerateTerm
    implements NonRecursive.Walker {
        private final Clause mCls;

        public GenerateTerm(Clause cls) {
            assert (cls.getProof() instanceof ResolutionNode);
            this.mCls = cls;
        }

        @Override
        public void walk(NonRecursive nr) {
            ProofTermGenerator engine = (ProofTermGenerator)nr;
            Theory t = engine.getTheory();
            ResolutionNode.Antecedent[] antes = ((ResolutionNode)this.mCls.getProof()).getAntecedents();
            Term proof = engine.getConverted();
            for (int i = 0; i < antes.length; ++i) {
                Literal pivot = antes[i].mPivot;
                Term proofAnte = engine.getConverted();
                boolean anteIsPositive = pivot.getSign() > 0;
                proof = engine.mProofRules.resolutionRule(pivot.getAtom().getSMTFormula(t), anteIsPositive ? proofAnte : proof, anteIsPositive ? proof : proofAnte);
            }
            Object[] clause = ProofRules.convertProofLiteralsToAnnotation(this.mCls.toProofLiterals(engine.mProofRules));
            Annotation[] clauseAnnotation = new Annotation[]{new Annotation(":proves", clause), new Annotation(":rup", null)};
            proof = t.annotatedTerm(clauseAnnotation, proof);
            engine.setResult(this.mCls, proof);
            engine.pushConverted(proof);
        }
    }
}

