/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.CongRewriteFunctionFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.MatchRewriteFunctionFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import java.util.LinkedHashSet;

public class ProofTracker
implements IProofTracker {
    ProofRules mProofRules;

    public ProofTracker(Theory theory) {
        this.mProofRules = new ProofRules(theory);
        this.setupTheory(theory);
    }

    private void setupTheory(Theory theory) {
        if (theory.getDeclaredSorts().containsKey(".EqProof")) {
            return;
        }
        theory.declareInternalSort(".EqProof", 1, 0);
        Sort[] generic = theory.createSortVariables("X");
        Sort eqProofX = theory.getSort(".EqProof", generic[0]);
        Sort eqProofBool = theory.getSort(".EqProof", theory.getBooleanSort());
        Sort[] generic2 = new Sort[]{generic[0], generic[0]};
        Sort[] eqProofX2 = new Sort[]{eqProofX, eqProofX};
        theory.declareInternalPolymorphicFunction(".refl", generic, generic, eqProofX, 0);
        theory.declareInternalPolymorphicFunction(".rewrite", generic, generic2, eqProofX, 0);
        theory.declareInternalPolymorphicFunction(".trans", generic, eqProofX2, eqProofX, 2);
        theory.declareInternalFunctionFactory(new CongRewriteFunctionFactory());
        theory.declareInternalFunctionFactory(new MatchRewriteFunctionFactory());
        theory.declareInternalFunction(".quant", new Sort[]{eqProofBool}, eqProofBool, 0);
    }

    public Term getProof(Term t) {
        Annotation[] annot = ((AnnotatedTerm)t).getAnnotations();
        assert (annot.length == 1 && annot[0].getKey().equals(":proof"));
        return (Term)annot[0].getValue();
    }

    private Term buildProof(Term proof, Term term) {
        assert (proof != null);
        Theory theory = term.getTheory();
        Annotation[] annotions = new Annotation[]{new Annotation(":proof", proof)};
        return theory.annotatedTerm(annotions, term);
    }

    @Override
    public Term intern(Term term, Term intern) {
        return this.buildRewrite(term, intern, ProofConstants.RW_INTERN);
    }

    @Override
    public Term orSimpClause(Term rewrite) {
        Term result;
        Theory t = rewrite.getTheory();
        Term orig = this.getProvedTerm(rewrite);
        assert (orig instanceof ApplicationTerm && ((ApplicationTerm)orig).getFunction() == t.mOr);
        Term[] args = ((ApplicationTerm)orig).getParameters();
        LinkedHashSet<Term> simpParams = new LinkedHashSet<Term>();
        for (Term arg : args) {
            if (arg == t.mFalse) continue;
            simpParams.add(arg);
        }
        if (simpParams.size() == 0) {
            result = t.mFalse;
        } else if (simpParams.size() == 1) {
            result = (Term)simpParams.iterator().next();
        } else {
            Term[] newArgs = simpParams.toArray(new Term[simpParams.size()]);
            result = t.term("or", newArgs);
        }
        return this.transitivity(rewrite, this.buildRewrite(orig, result, ProofConstants.RW_OR_SIMP));
    }

    @Override
    public Term reflexivity(Term a) {
        Theory theory = a.getTheory();
        Term proof = theory.term(".refl", a);
        return this.buildProof(proof, a);
    }

    private boolean isReflexivity(Term proof) {
        return this.isApplication(".refl", proof);
    }

    @Override
    public Term transitivity(Term imp1, Term imp2) {
        Term proofImp1 = this.getProof(imp1);
        Term proofImp2 = this.getProof(imp2);
        if (this.isReflexivity(proofImp1)) {
            return imp2;
        }
        if (this.isReflexivity(proofImp2)) {
            return this.buildProof(proofImp1, this.getProvedTerm(imp2));
        }
        Theory theory = imp1.getTheory();
        Term proof = theory.term(".trans", proofImp1, proofImp2);
        return this.buildProof(proof, this.getProvedTerm(imp2));
    }

    @Override
    public Term congruence(Term a, Term[] b) {
        Term congProof;
        Term[] proofs = new Term[b.length];
        Term[] params = new Term[b.length];
        boolean isRefl = true;
        for (int i = 0; i < b.length; ++i) {
            proofs[i] = this.getProof(b[i]);
            params[i] = this.getProvedTerm(b[i]);
            if (this.isReflexivity(proofs[i])) continue;
            isRefl = false;
        }
        Theory theory = a.getTheory();
        ApplicationTerm aTerm = (ApplicationTerm)this.getProvedTerm(a);
        FunctionSymbol aFunc = aTerm.getFunction();
        Term provedTerm = theory.term(aFunc, params);
        if (isRefl) {
            congProof = this.reflexivity(provedTerm);
        } else {
            String[] aIndices = aFunc.getIndices();
            String[] indices = new String[aIndices == null ? 1 : 1 + aIndices.length];
            indices[0] = aFunc.getName();
            if (aIndices != null) {
                for (int i = 0; i < indices.length; ++i) {
                    aIndices[i + 1] = indices[i];
                }
            }
            Sort resultSort = aFunc.isReturnOverload() ? theory.getSort(".EqProof", aFunc.getReturnSort()) : null;
            congProof = this.buildProof(theory.term(".cong", indices, resultSort, proofs), provedTerm);
        }
        Term proof = this.transitivity(a, congProof);
        return proof;
    }

    @Override
    public Term rewriteToClause(Term lhs, Term rewrite) {
        if (this.isReflexivity(this.getProof(rewrite))) {
            return null;
        }
        ProofLiteral[] lits = new ProofLiteral[]{this.termToProofLiteral(lhs).negate(), this.termToProofLiteral(this.getProvedTerm(rewrite))};
        Annotation[] annots = new Annotation[]{new Annotation(":rewrite", this.getProof(rewrite))};
        return this.buildProof(this.mProofRules.oracle(lits, annots), this.getProvedTerm(rewrite));
    }

    public Term resolve(Term pivotLit, Term posClause, Term negClause) {
        boolean positive = true;
        while (this.isApplication("not", pivotLit)) {
            pivotLit = ((ApplicationTerm)pivotLit).getParameters()[0];
            positive = !positive;
        }
        return this.mProofRules.resolutionRule(pivotLit, positive ? posClause : negClause, positive ? negClause : posClause);
    }

    @Override
    public Term resolveBinaryTautology(Term asserted, Term conclusion, Annotation rule) {
        Term assertedTerm;
        Theory theory = asserted.getTheory();
        boolean isPositive = true;
        Term assertedAtom = assertedTerm = this.getProvedTerm(asserted);
        while (this.isApplication("not", assertedAtom)) {
            assertedAtom = ((ApplicationTerm)assertedAtom).getParameters()[0];
            isPositive = !isPositive;
        }
        Term negAsserted = isPositive ? theory.term("not", assertedAtom) : assertedAtom;
        Term taut = this.tautology(theory.term("or", negAsserted, conclusion), rule);
        Term proof = this.resolve(assertedTerm, this.getProof(asserted), this.getProof(taut));
        return this.buildProof(proof, conclusion);
    }

    @Override
    public Term modusPonens(Term asserted, Term rewrite) {
        if (this.isReflexivity(this.getProof(rewrite))) {
            return this.buildProof(this.getProof(asserted), this.getProvedTerm(rewrite));
        }
        Term assertedTerm = this.getProvedTerm(asserted);
        Term proof = this.resolve(assertedTerm, this.getProof(asserted), this.getProof(this.rewriteToClause(assertedTerm, rewrite)));
        return this.buildProof(proof, this.getProvedTerm(rewrite));
    }

    @Override
    public Term getClauseProof(Term term) {
        return this.getProof(term);
    }

    @Override
    public Term tautology(Term axiom, Annotation rule) {
        Term proof = this.mProofRules.oracle(this.termToProofLiterals(axiom), new Annotation[]{rule});
        return this.buildProof(proof, axiom);
    }

    @Override
    public Term getProvedTerm(Term t) {
        return ((AnnotatedTerm)t).getSubterm();
    }

    @Override
    public Term buildRewrite(Term orig, Term res, Annotation rule) {
        Theory theory = orig.getTheory();
        if (orig == res) {
            return this.reflexivity(res);
        }
        Annotation[] annot = new Annotation[]{rule};
        Term proof = theory.term(".rewrite", theory.annotatedTerm(annot, orig), res);
        return this.buildProof(proof, res);
    }

    @Override
    public Term asserted(Term formula) {
        Term proof = this.mProofRules.asserted(formula);
        boolean positive = true;
        while (this.isApplication("not", formula)) {
            proof = this.mProofRules.resolutionRule(formula, positive ? proof : this.mProofRules.notIntro(formula), positive ? this.mProofRules.notElim(formula) : proof);
            positive = !positive;
            formula = ((ApplicationTerm)formula).getParameters()[0];
        }
        return this.buildProof(proof, positive ? formula : formula.getTheory().term("not", formula));
    }

    @Override
    public Term quantCong(QuantifiedFormula quant, Term newBody) {
        Term formula;
        Theory theory = quant.getTheory();
        Term subProof = this.getProof(newBody);
        boolean isForall = quant.getQuantifier() == 1;
        Term term = formula = isForall ? theory.forall(quant.getVariables(), this.getProvedTerm(newBody)) : theory.exists(quant.getVariables(), this.getProvedTerm(newBody));
        if (this.isReflexivity(subProof)) {
            return this.reflexivity(formula);
        }
        String quantType = isForall ? ":forall" : ":exists";
        Annotation[] annot = new Annotation[]{new Annotation(quantType, quant.getVariables())};
        Term proof = theory.term(".quant", theory.annotatedTerm(annot, subProof));
        return this.buildProof(proof, formula);
    }

    @Override
    public Term match(MatchTerm oldMatch, Term newData, Term[] newCases) {
        Theory theory = oldMatch.getTheory();
        Term[] subProofs = new Term[newCases.length + 1];
        Term[] newCaseTerms = new Term[newCases.length];
        DataType.Constructor[] constrs = oldMatch.getConstructors();
        subProofs[0] = this.getProof(newData);
        boolean isReflexivity = this.isReflexivity(subProofs[0]);
        for (int i = 0; i < newCases.length; ++i) {
            String constructorName = constrs[i] == null ? null : constrs[i].getName();
            Annotation[] annot = new Annotation[]{new Annotation(":vars", oldMatch.getVariables()[i]), new Annotation(":constructor", constructorName)};
            Term caseProof = this.getProof(newCases[i]);
            subProofs[i + 1] = theory.annotatedTerm(annot, caseProof);
            isReflexivity &= this.isReflexivity(caseProof);
            newCaseTerms[i] = this.getProvedTerm(newCases[i]);
        }
        Term formula = theory.match(this.getProvedTerm(newData), oldMatch.getVariables(), newCaseTerms, oldMatch.getConstructors());
        if (isReflexivity) {
            return this.reflexivity(formula);
        }
        Term proof = theory.term(".match", subProofs);
        return this.buildProof(proof, formula);
    }

    @Override
    public Term allIntro(Term formula, TermVariable[] vars) {
        Theory theory = formula.getTheory();
        Term provedClause = this.getProvedTerm(formula);
        Term proof = this.getProof(formula);
        if (this.isApplication("not", provedClause)) {
            Term atom = ((ApplicationTerm)provedClause).getParameters()[0];
            proof = this.mProofRules.resolutionRule(atom, this.mProofRules.notIntro(provedClause), proof);
        }
        Term[] skolemTerms = this.mProofRules.getSkolemVars(vars, provedClause, true);
        proof = theory.let(vars, skolemTerms, proof);
        Term lettedClause = theory.let(vars, skolemTerms, provedClause);
        FormulaUnLet unletter = new FormulaUnLet();
        proof = unletter.unlet(proof);
        Term forallAtom = theory.forall(vars, provedClause);
        proof = this.mProofRules.resolutionRule(unletter.unlet(lettedClause), proof, this.mProofRules.forallIntro((QuantifiedFormula)forallAtom));
        return this.buildProof(proof, forallAtom);
    }

    private boolean isApplication(String funcSym, Term term) {
        ApplicationTerm appTerm;
        FunctionSymbol func;
        return term instanceof ApplicationTerm && (func = (appTerm = (ApplicationTerm)term).getFunction()).isIntern() && func.getName().equals(funcSym);
    }

    private ProofLiteral termToProofLiteral(Term term) {
        boolean isPositive = true;
        while (this.isApplication("not", term)) {
            term = ((ApplicationTerm)term).getParameters()[0];
            isPositive = !isPositive;
        }
        return new ProofLiteral(term, isPositive);
    }

    private Term[] termToClause(Term clauseTerm) {
        assert (clauseTerm != null && clauseTerm.getSort().getName() == "Bool");
        if (this.isApplication("or", clauseTerm)) {
            return ((ApplicationTerm)clauseTerm).getParameters();
        }
        if (this.isApplication("false", clauseTerm)) {
            return new Term[0];
        }
        return new Term[]{clauseTerm};
    }

    private ProofLiteral[] termArrayToProofLiterals(Term[] clauseLits) {
        ProofLiteral[] proofLits = new ProofLiteral[clauseLits.length];
        for (int i = 0; i < proofLits.length; ++i) {
            proofLits[i] = this.termToProofLiteral(clauseLits[i]);
        }
        return proofLits;
    }

    private ProofLiteral[] termToProofLiterals(Term clauseTerm) {
        return this.termArrayToProofLiterals(this.termToClause(clauseTerm));
    }
}

