/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;

public class PropProofChecker {
    private final ArrayDeque<Clause> mTodo = new ArrayDeque();
    private final HashSet<Clause> mVisited = new HashSet();

    public boolean check(Clause refutation) {
        this.mTodo.add(refutation);
        return this.run();
    }

    private boolean run() {
        int errors = 0;
        while (!this.mTodo.isEmpty()) {
            Clause clause = this.mTodo.removeLast();
            if (this.mVisited.contains(clause)) continue;
            ProofNode pn = clause.getProof();
            if (pn.isLeaf()) {
                this.mVisited.add(clause);
                continue;
            }
            ResolutionNode.Antecedent[] antes = ((ResolutionNode)pn).getAntecedents();
            Clause prim = ((ResolutionNode)pn).getPrimary();
            boolean unknownChild = false;
            if (!this.mVisited.contains(prim)) {
                if (!unknownChild) {
                    this.mTodo.addLast(clause);
                }
                unknownChild = true;
                this.mTodo.addLast(prim);
            }
            for (ResolutionNode.Antecedent ante : antes) {
                if (this.mVisited.contains(ante.mAntecedent)) continue;
                if (!unknownChild) {
                    this.mTodo.addLast(clause);
                }
                unknownChild = true;
                this.mTodo.addLast(ante.mAntecedent);
            }
            if (unknownChild) continue;
            HashSet<Literal> clauselits = new HashSet<Literal>();
            for (int i = 0; i < prim.getSize(); ++i) {
                clauselits.add(prim.getLiteral(i));
            }
            for (ResolutionNode.Antecedent ante : antes) {
                Clause antecls = ante.mAntecedent;
                if (!antecls.contains(ante.mPivot)) {
                    System.err.println("Pivot literal " + ante.mPivot + " not in antecedent");
                    return false;
                }
                if (!clauselits.remove(ante.mPivot.negate())) {
                    System.err.println("Negated pivot literal " + ante.mPivot.negate() + " not in primary");
                    return false;
                }
                for (int i = 0; i < antecls.getSize(); ++i) {
                    Literal lit = antecls.getLiteral(i);
                    if (lit == ante.mPivot) continue;
                    clauselits.add(lit);
                }
            }
            HashSet<Literal> clslits = new HashSet<Literal>();
            for (int i = 0; i < clause.getSize(); ++i) {
                clslits.add(clause.getLiteral(i));
            }
            if (!clauselits.equals(clslits)) {
                ++errors;
                System.err.println("Result of resolution incorrect for: " + clause);
                Set clauseremain = (Set)clauselits.clone();
                clauseremain.removeAll(clslits);
                if (!clauseremain.isEmpty()) {
                    System.err.println();
                    System.err.println("Result misses:");
                    System.err.println(clauseremain);
                }
                Set clsremain = (Set)clslits.clone();
                clsremain.removeAll(clauselits);
                if (!clsremain.isEmpty()) {
                    System.err.println();
                    System.err.println("Result additionally has:");
                    System.err.println(clsremain);
                }
            }
            this.mVisited.add(clause);
        }
        return errors == 0;
    }
}

