/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecyclePivots {
    private Map<Clause, Integer> mCounts;
    private final Deque<Worker> mTodo = new ArrayDeque<Worker>();
    private HashMap<Clause, Integer> mSeen;
    private HashMap<Object, Set<Literal>> mSafeLits;
    private Map<Clause, Set<Literal>> mDeleted;

    public Map<Clause, Set<Literal>> regularize(Clause proof, Map<Clause, Integer> counts) {
        this.mCounts = counts;
        this.mSafeLits = new HashMap();
        this.mDeleted = new HashMap<Clause, Set<Literal>>();
        this.mSeen = new HashMap();
        HashSet<Literal> safe = new HashSet<Literal>();
        for (int i = 0; i < proof.getSize(); ++i) {
            safe.add(proof.getLiteral(i));
        }
        this.mTodo.push(new SetAndExpand(proof, safe));
        this.run();
        return this.mDeleted;
    }

    private void run() {
        while (!this.mTodo.isEmpty()) {
            Worker w = this.mTodo.pop();
            w.work();
        }
    }

    private boolean seen(Clause cls) {
        Integer cnt = this.mSeen.get(cls);
        int newcnt = cnt == null ? 1 : cnt + 1;
        this.mSeen.put(cls, newcnt);
        int total = this.mCounts.get(cls);
        assert (newcnt <= total);
        return total == newcnt;
    }

    private class SetAndExpand
    implements Worker {
        final Clause mCls;
        Set<Literal> mSafes;

        public SetAndExpand(Clause cls, Set<Literal> safes) {
            this.mCls = cls;
            this.mSafes = safes;
        }

        @Override
        public void work() {
            if (RecyclePivots.this.seen(this.mCls)) {
                Set oldSafes = (Set)RecyclePivots.this.mSafeLits.get(this.mCls);
                if (this.mSafes == null) {
                    this.mSafes = oldSafes;
                } else if (oldSafes != null) {
                    this.mSafes.retainAll(oldSafes);
                }
                ProofNode pn = this.mCls.getProof();
                if (!pn.isLeaf()) {
                    HashSet<Literal> delLits = null;
                    ResolutionNode rn = (ResolutionNode)pn;
                    ResolutionNode.Antecedent[] antes = rn.getAntecedents();
                    for (int i = antes.length - 1; i >= 0; --i) {
                        HashSet<Literal> newSafes = null;
                        if (this.mSafes != null) {
                            if (this.mSafes.contains(antes[i].mPivot.negate())) {
                                if (delLits == null) {
                                    delLits = new HashSet<Literal>();
                                }
                                delLits.add(antes[i].mPivot);
                            } else if (!antes[i].mAntecedent.getProof().isLeaf()) {
                                newSafes = new HashSet<Literal>(this.mSafes);
                                newSafes.add(antes[i].mPivot);
                            }
                        }
                        if (!antes[i].mAntecedent.getProof().isLeaf()) {
                            RecyclePivots.this.mTodo.push(new SetAndExpand(antes[i].mAntecedent, newSafes));
                        }
                        if (this.mSafes != null && this.mSafes.contains(antes[i].mPivot)) {
                            if (delLits == null) {
                                delLits = new HashSet();
                            }
                            delLits.add(antes[i].mPivot.negate());
                            this.mSafes = null;
                        }
                        if (this.mSafes == null) continue;
                        this.mSafes.add(antes[i].mPivot.negate());
                    }
                    if (delLits != null) {
                        RecyclePivots.this.mDeleted.put(this.mCls, delLits);
                    }
                    if (!rn.getPrimary().getProof().isLeaf()) {
                        HashSet<Literal> newSafes = null;
                        if (this.mSafes != null) {
                            newSafes = new HashSet<Literal>(this.mSafes);
                        }
                        RecyclePivots.this.mTodo.push(new SetAndExpand(rn.getPrimary(), newSafes));
                    }
                }
            } else if (this.mSafes != null) {
                Set oldSafes = (Set)RecyclePivots.this.mSafeLits.get(this.mCls);
                if (oldSafes == null) {
                    RecyclePivots.this.mSafeLits.put(this.mCls, this.mSafes);
                } else {
                    oldSafes.retainAll(this.mSafes);
                }
            }
        }
    }

    private static interface Worker {
        public void work();
    }
}

