/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;

public class SourceAnnotation
implements IAnnotation {
    public static final SourceAnnotation EMPTY_SOURCE_ANNOT = new SourceAnnotation("", null);
    private final String mAnnot;
    private final Term mProof;
    private final boolean mFromQuantTheory;

    public SourceAnnotation(String annot, Term proof) {
        this.mAnnot = annot;
        this.mProof = proof;
        this.mFromQuantTheory = false;
    }

    public SourceAnnotation(SourceAnnotation orig, boolean fromQuantTheory) {
        this.mAnnot = orig.mAnnot;
        this.mProof = orig.mProof;
        this.mFromQuantTheory = fromQuantTheory;
    }

    public SourceAnnotation(SourceAnnotation orig, Term newProof) {
        this.mAnnot = orig.mAnnot;
        this.mProof = newProof;
        this.mFromQuantTheory = orig.mFromQuantTheory;
    }

    public String getAnnotation() {
        return this.mAnnot;
    }

    public Term getSource() {
        return this.mProof;
    }

    public boolean isFromQuantTheory() {
        return this.mFromQuantTheory;
    }

    public String toString() {
        return this.mAnnot;
    }

    @Override
    public Term toTerm(Clause cls, ProofRules proofRules) {
        ProofLiteral[] proofLits = cls.toProofLiterals(proofRules);
        if (this.mProof == null) {
            Annotation[] annots = new Annotation[]{new Annotation(":input", this.mAnnot.isEmpty() ? null : this.mAnnot)};
            return proofRules.oracle(proofLits, annots);
        }
        Annotation[] annots = new Annotation[]{new Annotation(":proves", ProofRules.convertProofLiteralsToAnnotation(proofLits)), new Annotation(":input", this.mAnnot.isEmpty() ? null : this.mAnnot)};
        return this.mProof.getTheory().annotatedTerm(annots, this.mProof);
    }
}

