/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class UnitCollector {
    private Map<Clause, Integer> mCounts;
    private Queue<ResolutionNode.Antecedent> mUnits;
    private final Deque<Clause> mTodo = new ArrayDeque<Clause>();
    private HashMap<Clause, Integer> mSeen;
    private HashMap<Clause, Set<Literal>> mDelUnits;

    public Queue<ResolutionNode.Antecedent> collectUnits(Clause unsat, Map<Clause, Integer> counts) {
        this.mCounts = counts;
        this.mDelUnits = new HashMap();
        this.mUnits = new ArrayDeque<ResolutionNode.Antecedent>();
        this.mSeen = new HashMap();
        this.mTodo.push(unsat);
        this.run();
        return this.mUnits;
    }

    private void run() {
        while (!this.mTodo.isEmpty()) {
            ProofNode pn;
            Clause cls = this.mTodo.pop();
            if (!this.seen(cls)) continue;
            if (cls.getSize() == 1 && this.mCounts.get(cls) > 1) {
                this.mUnits.add(new ResolutionNode.Antecedent(cls.getLiteral(0), cls));
            }
            if ((pn = cls.getProof()).isLeaf()) continue;
            HashSet<Literal> deletions = null;
            ResolutionNode rn = (ResolutionNode)pn;
            ResolutionNode.Antecedent[] antes = rn.getAntecedents();
            for (int i = antes.length - 1; i >= 0; --i) {
                if (antes[i].mAntecedent.getSize() == 1 && this.mCounts.get(antes[i].mAntecedent) > 1) {
                    if (deletions == null) {
                        deletions = new HashSet<Literal>();
                    }
                    deletions.add(antes[i].mPivot);
                }
                this.mTodo.push(antes[i].mAntecedent);
            }
            this.mTodo.push(rn.getPrimary());
            if (deletions == null) continue;
            this.mDelUnits.put(cls, deletions);
        }
    }

    private boolean seen(Clause cls) {
        Integer cnt = this.mSeen.get(cls);
        int newcnt = cnt == null ? 1 : cnt + 1;
        this.mSeen.put(cls, newcnt);
        int total = this.mCounts.get(cls);
        assert (newcnt <= total);
        return total == newcnt;
    }

    public Map<Clause, Set<Literal>> getDeletedNodes() {
        return this.mDelUnits;
    }
}

