/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker;

import com.github.jhoenicke.javacup.runtime.Scanner;
import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import com.github.jhoenicke.javacup.runtime.Symbol;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.MinimalProofChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker.ProofLexer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker.ProofParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;

public class CheckingScript
extends NoopScript {
    private final String mProofFile;
    private final LogProxy mLogger;
    private final ScopedArrayList<Term> mAssertions = new ScopedArrayList();
    final SimpleSymbolFactory mSymfactory = new SimpleSymbolFactory();
    private Script.LBool mLastCheckSat;
    private SExprLexer mLexer;

    public CheckingScript(LogProxy logger, String proofFile) {
        this.mLogger = logger;
        this.mProofFile = proofFile;
        this.setProofReader(this.openProofReader(proofFile));
    }

    public CheckingScript(LogProxy logger, String proofFile, Reader proofReader) {
        this.mLogger = logger;
        this.mProofFile = proofFile;
        this.setProofReader(proofReader);
    }

    public void setProofReader(Reader proofReader) {
        ProofLexer wrappedLexer = new ProofLexer(proofReader);
        wrappedLexer.setSymbolFactory(this.mSymfactory);
        this.mLexer = new SExprLexer(wrappedLexer);
    }

    @Override
    public Script.LBool assertTerm(Term assertion) {
        this.mAssertions.add(assertion);
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Term[] getAssertions() {
        return this.mAssertions.toArray(new Term[this.mAssertions.size()]);
    }

    @Override
    public void push(int n) throws SMTLIBException {
        super.push(n);
        while (n-- > 0) {
            this.mAssertions.beginScope();
        }
    }

    @Override
    public void pop(int n) throws SMTLIBException {
        super.pop(n);
        int i = n;
        while (i-- > 0) {
            this.mAssertions.endScope();
        }
    }

    private Reader openProofReader(String filename) {
        if (filename.equals("<stdin>")) {
            return new InputStreamReader(System.in);
        }
        File proofFile = new File(filename);
        try {
            if (filename.endsWith(".gz")) {
                return new InputStreamReader(new GZIPInputStream(new FileInputStream(proofFile)));
            }
            return new FileReader(proofFile);
        }
        catch (FileNotFoundException ex) {
            throw new SMTLIBException("File not found: " + filename, ex);
        }
        catch (IOException ex) {
            throw new SMTLIBException("Cannot read file: " + filename, ex);
        }
    }

    public void printError(String result) {
        this.mLogger.error(result);
    }

    public void printResult(Object result) {
        System.out.println(result.toString());
    }

    @Override
    public Script.LBool checkSat() {
        Symbol eof;
        Symbol result;
        this.mLexer.clearEOF();
        try {
            result = this.mLexer.next_token();
            eof = this.mLexer.next_token();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
        if (result.sym != 81) {
            this.mLastCheckSat = Script.LBool.UNKNOWN;
        } else {
            assert (result.sym == 81);
            assert (eof.sym == 1);
            try {
                this.mLastCheckSat = Script.LBool.valueOf(((String)result.value).toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                this.mLastCheckSat = Script.LBool.UNKNOWN;
            }
        }
        return this.mLastCheckSat;
    }

    @Override
    public Term getProof() {
        this.mLexer.clearEOF();
        if (this.mLastCheckSat == Script.LBool.UNSAT) {
            Term proof;
            ProofParser proofParser = new ProofParser(this.mLexer, this.mSymfactory);
            proofParser.setFileName(this.mProofFile);
            proofParser.setScript(this);
            try {
                proof = (Term)proofParser.parse().value;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unexpected exception", ex);
            }
            MinimalProofChecker checker = new MinimalProofChecker(this, this.mLogger);
            if (checker.check(proof)) {
                int numberOfHoles = checker.getNumberOfHoles();
                this.printResult(numberOfHoles > 0 ? "holey" : "valid");
                this.printResult("holes=" + numberOfHoles);
                this.printResult("assertions=" + checker.getNumberOfAssertions());
                this.printResult("definefuns=" + checker.getNumberOfDefineFun());
                this.printResult("axioms=" + checker.getNumberOfAxioms());
                this.printResult("resolutions=" + checker.getNumberOfResolutions());
            } else {
                this.printResult("invalid");
            }
        } else {
            this.printResult(this.mLastCheckSat.toString());
            try {
                while (this.mLexer.next_token().sym != 1) {
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Unexpected exception", ex);
            }
        }
        return null;
    }

    public class SExprLexer
    implements Scanner {
        private final Scanner mLexer;
        private Symbol mEOFSymbol;
        private int mParenLevel;

        public SExprLexer(Scanner wrappedLexer) {
            this.mLexer = wrappedLexer;
            this.mEOFSymbol = null;
        }

        @Override
        public Symbol next_token() throws Exception {
            if (this.mEOFSymbol != null) {
                return this.mEOFSymbol;
            }
            Symbol nextSymbol = this.mLexer.next_token();
            if (nextSymbol.sym == 88) {
                ++this.mParenLevel;
            }
            if (nextSymbol.sym == 89) {
                --this.mParenLevel;
            }
            if (this.mParenLevel == 0) {
                this.mEOFSymbol = CheckingScript.this.mSymfactory.newSymbol("", 1, nextSymbol, nextSymbol);
            }
            return nextSymbol;
        }

        public void clearEOF() {
            this.mEOFSymbol = null;
        }
    }
}

