/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker.CheckingScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ParseEnvironment;
import java.util.ArrayDeque;

public final class Main {
    private Main() {
    }

    private static void usage() {
        System.err.println("USAGE: smtinterpol.proof.checker.Main [OPTION]... [SCRIPTFILE] [PROOFFILE]");
        System.err.println("  -o <opt>=<value>     Set option :opt to value. The default value is true.");
        System.err.println("  -q                   Only print error messages.");
        System.err.println("  -w                   Don't print statistics and models.");
        System.err.println("  -v                   Print debugging messages.");
        System.err.println("  -t <num>             Set the timeout per check-sat call to <num> milliseconds.");
        System.err.println("  -r <num>             Use a different random seed.");
        System.err.println("  -version             Print version and exit.");
    }

    private static void version() {
        System.err.println("SMTInterpol Proof Checker 2.5-1242-g5c50fb6d");
    }

    public static void main(String[] param) throws Exception {
        int paramctr;
        DefaultLogger logger = new DefaultLogger();
        ArrayDeque<Option> optionList = new ArrayDeque<Option>();
        for (paramctr = 0; paramctr < param.length && param[paramctr].startsWith("-"); ++paramctr) {
            if (param[paramctr].equals("--")) {
                ++paramctr;
                break;
            }
            if (param[paramctr].equals("-no-success")) {
                optionList.add(new Option(":print-success", false));
                continue;
            }
            if (param[paramctr].equals("-v")) {
                optionList.add(new Option(":verbosity", 5));
                continue;
            }
            if (param[paramctr].equals("-w")) {
                optionList.add(new Option(":verbosity", 3));
                continue;
            }
            if (param[paramctr].equals("-q")) {
                optionList.add(new Option(":verbosity", 2));
                continue;
            }
            if (param[paramctr].equals("-t") && ++paramctr < param.length) {
                optionList.add(new Option(":timeout", param[paramctr]));
                continue;
            }
            if (param[paramctr].equals("-r") && ++paramctr < param.length) {
                optionList.add(new Option(":random-seed", param[paramctr]));
                continue;
            }
            if (param[paramctr].equals("-o") && paramctr + 1 < param.length) {
                Object value;
                String name;
                String opt;
                int eq;
                if ((eq = (opt = param[++paramctr]).indexOf(61)) == -1) {
                    name = opt;
                    value = Boolean.TRUE;
                } else {
                    name = opt.substring(0, eq);
                    value = opt.substring(eq + 1);
                }
                try {
                    optionList.add(new Option(":" + name, value));
                    continue;
                }
                catch (UnsupportedOperationException ex) {
                    System.err.println("Unknown option :" + name + ".");
                    return;
                }
                catch (SMTLIBException ex) {
                    System.err.println(ex.getMessage());
                    return;
                }
            }
            if (param[paramctr].equals("-trace")) {
                optionList.add(new Option(":verbosity", 6));
                continue;
            }
            if (param[paramctr].equals("-version")) {
                Main.version();
                return;
            }
            Main.usage();
            return;
        }
        if (paramctr + 2 != param.length) {
            Main.usage();
            return;
        }
        String scriptFilename = param[paramctr++];
        String proofFilename = param[paramctr++];
        OptionMap options = new OptionMap(logger, true);
        CheckingScript solver = new CheckingScript(logger, proofFilename);
        for (Option opt : optionList) {
            solver.setOption(opt.getName(), opt.getValue());
        }
        ParseEnvironment parseEnv = new ParseEnvironment(solver, options){

            @Override
            public void printResponse(Object response) {
            }
        };
        parseEnv.parseScript(scriptFilename);
        parseEnv.exit();
    }

    private static class Option {
        String mName;
        Object mValue;

        public Option(String name, Object value) {
            this.mName = name;
            this.mValue = value;
        }

        public String getName() {
            return this.mName;
        }

        public Object getValue() {
            return this.mValue;
        }
    }
}

