/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.scripts;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;

public class LinearArithmeticChecker
extends NoopScript {
    FormulaUnLet mUnletter = new FormulaUnLet();
    LinearChecker mChecker = new LinearChecker();
    long mNumProblems = 0L;
    String mEchoString = "";

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mChecker.transform(this.mUnletter.transform(term));
        return super.assertTerm(term);
    }

    @Override
    public QuotedObject echo(QuotedObject msg) {
        this.mEchoString = msg.getValue();
        return super.echo(msg);
    }

    @Override
    public void reset() {
        if (this.mNumProblems > 0L) {
            System.err.println("Found " + this.mNumProblems + " problems.");
            System.out.println(this.mEchoString);
            this.mNumProblems = 0L;
        }
        super.reset();
    }

    @Override
    public void exit() {
        if (this.mNumProblems > 0L) {
            System.err.println("Found " + this.mNumProblems + " problems.");
            System.exit(1);
        }
        super.exit();
    }

    class LinearChecker
    extends TermTransformer {
        LinearChecker() {
        }

        @Override
        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            FunctionSymbol fs = appTerm.getFunction();
            if (fs.isIntern()) {
                switch (fs.getName()) {
                    case "abs": 
                    case "mod": 
                    case "div": {
                        System.err.println("Non-linear function " + fs.getName() + " in benchmark");
                        ++LinearArithmeticChecker.this.mNumProblems;
                        break;
                    }
                    case "*": {
                        Term leftArg = SMTAffineTerm.parseConstant(newArgs[0]);
                        Term rightArg = SMTAffineTerm.parseConstant(newArgs[1]);
                        if (newArgs.length == 2 && (leftArg instanceof ConstantTerm || rightArg instanceof ConstantTerm)) break;
                        System.err.println("Non-linear term " + appTerm);
                        ++LinearArithmeticChecker.this.mNumProblems;
                        break;
                    }
                    case "/": {
                        Term constant = SMTAffineTerm.parseConstant(appTerm);
                        if (constant instanceof ConstantTerm) break;
                        System.err.println("Non-constant division: " + appTerm);
                        ++LinearArithmeticChecker.this.mNumProblems;
                        break;
                    }
                }
            }
            super.convertApplicationTerm(appTerm, newArgs);
        }
    }
}

