/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.scripts;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtcomp.Track;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class PrepareScript
extends LoggingScript {
    private final Track mTrack;

    public PrepareScript(Track track, String file) throws IOException {
        super(file, false);
        this.mTrack = track;
        if (track.hasInitalOption()) {
            this.setOption(track.getInitialOption(), track.getInitialOptionValue());
        }
    }

    @Override
    public void declareSort(String sort, int arity) throws SMTLIBException {
        if (arity != 0) {
            throw new IllegalArgumentException("Sorts with non-0 arity not allowed in SMTCOMP");
        }
        super.declareSort(sort, arity);
    }

    @Override
    public void push(int levels) throws SMTLIBException {
        if (!this.mTrack.isPushPopAllowed()) {
            throw new IllegalArgumentException("push not allowed in this track");
        }
        if (levels != 1) {
            throw new IllegalArgumentException("Only (push 1) allowed");
        }
        super.push(levels);
    }

    @Override
    public void pop(int levels) throws SMTLIBException {
        if (!this.mTrack.isPushPopAllowed()) {
            throw new IllegalArgumentException("pop not allowed in this track");
        }
        if (levels != 1) {
            throw new IllegalArgumentException("Only (pop 1) allowed");
        }
        super.pop(levels);
    }

    @Override
    public Term[] getAssertions() throws SMTLIBException {
        return new Term[0];
    }

    @Override
    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        if (this.mTrack == Track.PROOF_GEN) {
            return super.getProof();
        }
        throw new UnsupportedOperationException("Not allowed in this trace");
    }

    @Override
    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        if (this.mTrack == Track.UNSAT_CORE) {
            return super.getUnsatCore();
        }
        return new Term[0];
    }

    @Override
    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        return Collections.emptyMap();
    }

    @Override
    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        Map<String, Boolean> empty = Collections.emptyMap();
        return new Assignments(empty);
    }

    @Override
    public Term simplify(Term term) throws SMTLIBException {
        return term;
    }

    @Override
    public void reset() {
        throw new AssertionError((Object)"What?");
    }

    @Override
    public Term[] getInterpolants(Term[] partition) throws SMTLIBException, UnsupportedOperationException {
        return new Term[0];
    }

    @Override
    public Term annotate(Term t, Annotation ... annotations) throws SMTLIBException {
        ArrayList<Annotation> allowed = new ArrayList<Annotation>();
        for (Annotation annot : annotations) {
            if (annot.getKey().equals(":pattern")) {
                allowed.add(annot);
                continue;
            }
            if (!this.mTrack.isNamedAllowed() || !annot.getKey().equals(":named")) continue;
            allowed.add(annot);
        }
        return super.annotate(t, allowed.toArray(new Annotation[allowed.size()]));
    }

    @Override
    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        return new Model(){

            @Override
            public Term evaluate(Term input) {
                return input;
            }

            @Override
            public Map<Term, Term> evaluate(Term[] input) {
                return Collections.emptyMap();
            }

            @Override
            public Set<FunctionSymbol> getDefinedFunctions() {
                return Collections.emptySet();
            }

            @Override
            public Term getFunctionDefinition(String func, TermVariable[] args) {
                return null;
            }
        };
    }
}

