/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib;

import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.IParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib.Lexer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib.Parser;
import java.io.FileReader;
import java.io.InputStreamReader;

public class SMTLIBParser
implements IParser {
    @Override
    public int run(Script script, String filename, OptionMap options) {
        try {
            InputStreamReader reader;
            SimpleSymbolFactory symfactory = new SimpleSymbolFactory();
            if (filename == null) {
                filename = "<stdin>";
                reader = new InputStreamReader(System.in);
            } else {
                reader = new FileReader(filename);
            }
            Lexer lexer = new Lexer(reader);
            lexer.setSymbolFactory(symfactory);
            Parser parser = new Parser(lexer, symfactory);
            parser.setFileName(filename);
            parser.setSolver(script, false);
            parser.parse();
            Term[] interpolants = parser.benchmark.check();
            if (interpolants != null) {
                for (int i = 0; i < interpolants.length; ++i) {
                    System.out.println("Interpolant " + i + ": " + interpolants[i]);
                }
            }
            parser.benchmark.close();
            return 0;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return 1;
        }
    }
}

