/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;

import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.FrontEndOptions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Lexer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Parser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SExpression;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.zip.GZIPInputStream;

public class ParseEnvironment {
    final Script mScript;
    private File mCwd = null;
    private Deque<Long> mTiming;
    private final FrontEndOptions mOptions;
    private Lexer mLexer = null;
    private boolean mVersion25 = true;

    public ParseEnvironment(Script script, OptionMap options) {
        this.mScript = script;
        this.mOptions = options.getFrontEndOptions();
        if (!this.mOptions.isFrontEndActive()) {
            throw new IllegalArgumentException("Front End not active!");
        }
    }

    public boolean isSMTLIB25() {
        return this.mVersion25;
    }

    public Script getScript() {
        return this.mScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseScript(String filename) throws SMTLIBException {
        File oldcwd = this.mCwd;
        InputStreamReader reader = null;
        boolean closeReader = false;
        try {
            if (filename.equals("<stdin>")) {
                reader = new InputStreamReader(System.in);
            } else {
                File script = new File(filename);
                if (!script.isAbsolute()) {
                    script = new File(this.mCwd, filename);
                }
                this.mCwd = script.getParentFile();
                try {
                    reader = filename.endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(new FileInputStream(script))) : new FileReader(script);
                    closeReader = true;
                }
                catch (FileNotFoundException ex) {
                    throw new SMTLIBException("File not found: " + filename, ex);
                }
                catch (IOException ex) {
                    throw new SMTLIBException("Cannot read file: " + filename, ex);
                }
            }
            this.parseStream(reader, filename);
        }
        finally {
            this.mCwd = oldcwd;
            if (closeReader) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void parseStream(Reader reader, String streamname) throws SMTLIBException {
        SimpleSymbolFactory symfactory = new SimpleSymbolFactory();
        Lexer last = this.mLexer;
        this.mLexer = new Lexer(reader);
        this.mLexer.setSymbolFactory(symfactory);
        Parser parser = new Parser(this.mLexer, symfactory);
        parser.setFileName(streamname);
        parser.setParseEnvironment(this);
        try {
            parser.parse();
        }
        catch (Exception ex) {
            System.err.println("Unexpected Exception: " + ex);
            throw new SMTLIBException(ex);
        }
        finally {
            this.mLexer = last;
        }
    }

    public void include(String filename) throws SMTLIBException {
        this.parseScript(filename);
    }

    public void printSuccess() {
        if (this.mOptions.isPrintSuccess()) {
            this.printResponse("success");
        }
    }

    public void printError(String message) {
        this.printResponse(new SExpression(new Object[]{"error", new QuotedObject(message, this.mVersion25)}));
        if (!this.mOptions.continueOnError()) {
            this.exitWithStatus(1);
        }
    }

    public void printUnsupported() {
        this.printResponse("unsupported");
        if (!this.mOptions.continueOnError()) {
            this.exitWithStatus(1);
        }
    }

    public void printResponse(Object response) {
        PrintWriter out = this.mOptions.getOutChannel();
        if (response instanceof Term && ProofRules.isProof((Term)response)) {
            Term proof = (Term)response;
            if (this.mOptions.isPrintTermsCSE()) {
                proof = new FormulaLet().let(proof);
            }
            ProofRules.printProof(out, proof);
            out.println();
            out.flush();
            return;
        }
        if (!this.mOptions.isPrintTermsCSE()) {
            if (response instanceof Term) {
                new PrintTerm().append((Appendable)out, (Term)response);
                out.println();
                out.flush();
                return;
            }
            if (response instanceof SExpression && ((SExpression)response).getData() instanceof Term[]) {
                new PrintTerm().append((Appendable)out, (Term[])((SExpression)response).getData());
                out.println();
                out.flush();
                return;
            }
        }
        out.println(response);
        out.flush();
    }

    public void exitWithStatus(int statusCode) {
        System.exit(statusCode);
    }

    public void exit() {
        this.mScript.exit();
        this.exitWithStatus(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInfo(String info, Object value) {
        if (info.equals(":smt-lib-version")) {
            String svalue = String.valueOf(value);
            if ("2.5".equals(svalue) || "2.6".equals(svalue)) {
                this.mVersion25 = true;
                this.mLexer.setVersion25(true);
            } else {
                if (!"2.0".equals(svalue)) throw new SMTLIBException("Unknown SMT-LIB version");
                this.mVersion25 = false;
                this.mLexer.setVersion25(false);
            }
        } else if (info.equals(":error-behavior")) {
            switch ((String)value) {
                case "immediate-exit": {
                    this.mScript.setOption(":continue-on-error", false);
                    break;
                }
                case "continued-execution": {
                    this.mScript.setOption(":continue-on-error", true);
                    break;
                }
                default: {
                    throw new SMTLIBException("Value should be continued-execution or immediate-exit");
                }
            }
        }
        this.mScript.setInfo(info, value);
    }

    public Object getInfo(String info) {
        if (info.equals(":error-behavior")) {
            return this.mOptions.continueOnError() ? "continued-execution" : "immediate-exit";
        }
        return this.mScript.getInfo(info);
    }

    public void startTiming() {
        if (this.mTiming == null) {
            this.mTiming = new ArrayDeque<Long>();
        }
        this.printResponse("(");
        this.mTiming.push(System.nanoTime());
    }

    public void endTiming() {
        long old = this.mTiming.pop();
        long duration = System.nanoTime() - old;
        long msecs = duration / 1000000L;
        this.printResponse(String.format(" :time %d.%03d)", msecs / 1000L, msecs % 1000L));
    }

    public boolean isContinueOnError() {
        return this.mOptions.continueOnError();
    }
}

