/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ModelBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.WeakCongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedLinkedHashSet;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayTheory
implements ITheory {
    private final Clausifier mClausifier;
    private final CClosure mCClosure;
    private final ScopedArrayList<CCTerm> mArrays = new ScopedArrayList();
    private final ScopedLinkedHashSet<CCAppTerm> mStores = new ScopedLinkedHashSet();
    private final ScopedLinkedHashSet<CCAppTerm> mDiffs = new ScopedLinkedHashSet();
    private final ScopedLinkedHashSet<CCAppTerm> mConsts = new ScopedLinkedHashSet();
    private final ArrayDeque<ArrayLemma> mPropClauses = new ArrayDeque();
    private final LogProxy mLogger;
    Map<CCTerm, ArrayNode> mCongRoots = null;
    Map<ArrayNode, Map<CCTerm, Object>> mArrayModels = null;
    private int mNumInstsSelect = 0;
    private int mNumInstsEq = 0;
    private int mNumBuildWeakEQ = 0;
    private int mNumAddStores = 0;
    private int mNumMerges = 0;
    private int mNumModuloEdges = 0;
    private long mTimeBuildWeakEq = 0L;
    private long mTimeBuildWeakEqi = 0L;
    private long mTimePropagation = 0L;
    private long mTimeExplanations = 0L;

    public ArrayTheory(Clausifier clausifier, CClosure cclosure) {
        this.mClausifier = clausifier;
        this.mCClosure = cclosure;
        this.mLogger = this.mCClosure.getLogger();
    }

    @Override
    public Clause startCheck() {
        this.cleanCaches();
        return null;
    }

    @Override
    public void endCheck() {
    }

    @Override
    public Clause setLiteral(Literal literal) {
        if (literal instanceof CCEquality) {
            this.cleanCaches();
        } else {
            for (ArrayLemma lemma : this.mPropClauses) {
                if (!lemma.mUndecidedLits.remove(literal.negate()) || !lemma.mUndecidedLits.isEmpty()) continue;
                return this.explainPropagation(lemma);
            }
        }
        return null;
    }

    @Override
    public void backtrackLiteral(Literal literal) {
        this.cleanCaches();
    }

    @Override
    public Clause checkpoint() {
        if (this.mCongRoots == null && this.buildWeakEq()) {
            for (ArrayLemma lemma : this.mPropClauses) {
                if (!lemma.mUndecidedLits.isEmpty()) continue;
                return this.explainPropagation(lemma);
            }
        }
        return null;
    }

    @Override
    public Clause computeConflictClause() {
        boolean foundLemma;
        Clause conflict = this.checkpoint();
        if (conflict != null) {
            return conflict;
        }
        if (this.mPropClauses.isEmpty() && (foundLemma = this.computeWeakeqExt())) {
            this.mArrayModels = null;
        }
        return null;
    }

    @Override
    public Literal getPropagatedLiteral() {
        long start = System.nanoTime();
        for (ArrayLemma lemma : this.mPropClauses) {
            if (lemma.mUndecidedLits.size() != 1) continue;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("AL prop: " + lemma);
            }
            Literal lit = lemma.mUndecidedLits.iterator().next();
            this.mTimePropagation += System.nanoTime() - start;
            lit.getAtom().mExplanation = this.explainPropagation(lemma);
            return lit;
        }
        return null;
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        assert (literal instanceof CCEquality);
        if (this.mCongRoots == null) {
            this.buildWeakEq();
        }
        for (ArrayLemma lemma : this.mPropClauses) {
            Set<CCEquality> lits = lemma.mUndecidedLits;
            if (!lits.isEmpty() && (lits.size() != 1 || !lits.contains(literal))) continue;
            return this.explainPropagation(lemma);
        }
        throw new AssertionError((Object)"Cannot explain unit literal!");
    }

    @Override
    public int checkCompleteness() {
        return 0;
    }

    private Clause explainPropagation(ArrayLemma lemma) {
        Clause clause;
        SymmetricPair<CCTerm> equality = lemma.getEquality();
        long start = System.nanoTime();
        ++this.mNumInstsSelect;
        WeakCongruencePath path = new WeakCongruencePath(this);
        switch (lemma.getRule()) {
            case READ_OVER_WEAKEQ: {
                clause = path.computeSelectOverWeakEQ((CCAppTerm)equality.getFirst(), (CCAppTerm)equality.getSecond(), this.mCClosure.isProofGenerationEnabled());
                break;
            }
            case CONST_WEAKEQ: {
                clause = path.computeConstOverWeakEQ(this.findConst(equality.getFirst()), this.findConst(equality.getSecond()), this.mCClosure.isProofGenerationEnabled());
                break;
            }
            case READ_CONST_WEAKEQ: {
                clause = path.computeSelectConstOverWeakEQ((CCAppTerm)equality.getFirst(), this.findConst(equality.getSecond()), this.mCClosure.isProofGenerationEnabled());
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown Lemma");
            }
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("AL sw: " + clause);
        }
        this.mTimeExplanations += System.nanoTime() - start;
        return clause;
    }

    @Override
    public Literal getSuggestion() {
        return null;
    }

    @Override
    public void printStatistics(LogProxy logger) {
        if (logger.isInfoEnabled()) {
            logger.info("Array: #Arrays: %d, #BuildWeakEQ: %d, #ModEdges: %d, #addStores: %d, #merges: %d", this.mArrays.size(), this.mNumBuildWeakEQ, this.mNumModuloEdges, this.mNumAddStores, this.mNumMerges);
            logger.info("Insts: ReadOverWeakEQ: %d, WeakeqExt: %d", this.mNumInstsSelect, this.mNumInstsEq);
            logger.info("Time: BuildWeakEq: %d.%03d ms, BuildWeakEqi: %d.%03d ms", this.mTimeBuildWeakEq / 1000000L, this.mTimeBuildWeakEq / 1000L % 1000L, this.mTimeBuildWeakEqi / 1000000L, this.mTimeBuildWeakEqi / 1000L % 1000L);
            logger.info("Time: Propagation %d.%03d ms, Explanations: %d.%03d ms", this.mTimePropagation / 1000000L, this.mTimePropagation / 1000L % 1000L, this.mTimeExplanations / 1000000L, this.mTimeExplanations / 1000L % 1000L);
        }
    }

    @Override
    public void dumpModel(LogProxy logger) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        for (Map.Entry<ArrayNode, Map<CCTerm, Object>> entry : this.mArrayModels.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getKey().mTerm).append(" = store[");
            sb.append(((ArrayNode)entry.getValue().get(null)).mTerm);
            for (Map.Entry<CCTerm, Object> storeEntry : entry.getValue().entrySet()) {
                if (storeEntry.getKey() == null) continue;
                sb.append(",(").append(storeEntry.getKey()).append(":=").append(storeEntry.getValue()).append(')');
            }
            sb.append(']');
            logger.info(sb.toString());
        }
    }

    @Override
    public void increasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void decreasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void backtrackAll() {
        this.mPropClauses.clear();
    }

    @Override
    public void backtrackStart() {
        this.mPropClauses.clear();
    }

    @Override
    public Clause backtrackComplete() {
        return null;
    }

    @Override
    public void restart(int iteration) {
    }

    @Override
    public void removeAtom(DPLLAtom atom) {
    }

    @Override
    public void push() {
        this.mArrays.beginScope();
        this.mStores.beginScope();
        this.mConsts.beginScope();
        this.mDiffs.beginScope();
    }

    @Override
    public void pop() {
        this.mArrays.endScope();
        this.mStores.endScope();
        this.mConsts.endScope();
        this.mDiffs.endScope();
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":Array", new Object[][]{{"NumArrays", this.mArrays.size()}, {"BuildWeakEQ", this.mNumBuildWeakEQ}, {"AddStores", this.mNumAddStores}, {"Merges", this.mNumMerges}, {"ModuloEdges", this.mNumModuloEdges}, {"ReadOverWeakeq", this.mNumInstsSelect}, {"WeakeqExt", this.mNumInstsEq}, {"Times", new Object[][]{{"BuildWeakEq", this.mTimeBuildWeakEq}, {"BuildWeakEqi", this.mTimeBuildWeakEqi}, {"Propagation", this.mTimePropagation}, {"Explanations", this.mTimeExplanations}}}}};
    }

    public void fillInModel(ModelBuilder builder, List<CCTerm> ccArrayTerms) {
        Sort arraySort = ccArrayTerms.get(0).getFlatTerm().getSort();
        assert (arraySort.isArraySort());
        Sort valueSort = arraySort.getArguments()[1];
        Model model = builder.getModel();
        Theory t = builder.getTheory();
        ArraySortInterpretation arraySortInterpretation = (ArraySortInterpretation)model.provideSortInterpretation(arraySort);
        ArrayList<ArrayNode> arraysTerms = new ArrayList<ArrayNode>(ccArrayTerms.size());
        for (CCTerm ccterm : ccArrayTerms) {
            arraysTerms.add(this.mCongRoots.get(ccterm));
        }
        ArrayDeque<ArrayNode> todoQueue = new ArrayDeque<ArrayNode>(arraysTerms);
        while (!todoQueue.isEmpty()) {
            Object value;
            Object index;
            ArrayNode node = (ArrayNode)todoQueue.removeFirst();
            if (builder.getModelValue(node.mTerm) != null) continue;
            ArrayNode parent = node.mPrimaryEdge;
            if (parent == null) {
                if (node.mConstTerm != null) {
                    Term value2 = builder.getModelValue(ArrayTheory.getValueFromConst(node.mConstTerm).getRepresentative());
                    if (value2 == null) {
                        assert (ArrayTheory.getValueFromConst(node.mConstTerm).getFlatTerm().getSort().isArraySort());
                        todoQueue.addLast(node);
                        continue;
                    }
                    FunctionSymbol constFunc = t.getFunctionWithResult("const", null, arraySort, valueSort);
                    Term nodeValue = t.term(constFunc, value2);
                    builder.setModelValue(node.mTerm, nodeValue);
                    continue;
                }
                Term nodeValue = model.extendFresh(arraySort);
                for (Map.Entry<CCTerm, CCAppTerm> indexValuePairs : node.mSelects.entrySet()) {
                    index = indexValuePairs.getKey();
                    value = indexValuePairs.getValue().getRepresentative();
                    nodeValue = t.term("store", nodeValue, builder.getModelValue((CCTerm)index), builder.getModelValue((CCTerm)value));
                }
                for (ArrayNode other : arraysTerms) {
                    if (other.getWeakRepresentative() != node || other == node || other.mSelects.isEmpty() || other.mSecondaryEdge != null) continue;
                    assert (other.mSelects.size() == 1);
                    index = other.mSelects.keySet().iterator().next();
                    if (node.mSelects.containsKey(index)) continue;
                    Term freshValue = model.extendFresh(valueSort);
                    nodeValue = t.term("store", nodeValue, builder.getModelValue((CCTerm)index), freshValue);
                }
                nodeValue = arraySortInterpretation.normalizeStoreTerm(nodeValue);
                builder.setModelValue(node.mTerm, nodeValue);
                continue;
            }
            Term parentTerm = builder.getModelValue(parent.mTerm);
            if (parentTerm == null) {
                todoQueue.addFirst(node);
                todoQueue.addFirst(parent);
                continue;
            }
            CCTerm ccIndex = ArrayTheory.getIndexFromStore(node.mPrimaryStore).getRepresentative();
            CCTerm ccValue = node.mSelects.get(ccIndex);
            index = builder.getModelValue(ccIndex);
            value = ccValue == null ? model.extendFresh(valueSort) : builder.getModelValue(ccValue);
            Term nodeValue = t.term("store", new Term[]{parentTerm, index, value});
            nodeValue = arraySortInterpretation.normalizeStoreTerm(nodeValue);
            builder.setModelValue(node.mTerm, nodeValue);
        }
    }

    public void notifyArray(CCTerm array, boolean isStore, boolean isConst) {
        if (isStore) {
            this.mStores.add((CCAppTerm)array);
            ++this.mNumAddStores;
        }
        if (isConst) {
            this.mConsts.add((CCAppTerm)array);
        }
        this.mArrays.add(array);
        this.cleanCaches();
    }

    public void notifyDiff(CCAppTerm diff) {
        this.mDiffs.add(diff);
    }

    public static boolean isStoreTerm(CCTerm term) {
        CCBaseTerm base = ArrayTheory.getBaseTerm(term);
        if (base.isFunctionSymbol()) {
            return base.getFunctionSymbol().getName().equals("store");
        }
        return false;
    }

    public static boolean isSelectTerm(CCTerm term) {
        CCBaseTerm base = ArrayTheory.getBaseTerm(term);
        if (base.isFunctionSymbol()) {
            return base.getFunctionSymbol().getName().equals("select");
        }
        return false;
    }

    public static boolean isConstTerm(CCTerm term) {
        CCBaseTerm base = ArrayTheory.getBaseTerm(term);
        if (base.isFunctionSymbol()) {
            return base.getFunctionSymbol().getName().equals("const");
        }
        return false;
    }

    public static boolean isDiffTerm(CCTerm term) {
        CCBaseTerm base = ArrayTheory.getBaseTerm(term);
        if (base.isFunctionSymbol()) {
            return base.getFunctionSymbol().getName().equals("@diff");
        }
        return false;
    }

    public static CCTerm getArrayFromSelect(CCAppTerm select) {
        assert (ArrayTheory.isSelectTerm(select));
        return ArrayTheory.getSecondToLastArgument(select);
    }

    public static CCTerm getIndexFromSelect(CCAppTerm select) {
        assert (ArrayTheory.isSelectTerm(select));
        return select.getArg();
    }

    public static CCTerm getArrayFromStore(CCAppTerm store) {
        assert (ArrayTheory.isStoreTerm(store));
        return ArrayTheory.getThirdToLastArgument(store);
    }

    public static CCTerm getIndexFromStore(CCAppTerm store) {
        assert (ArrayTheory.isStoreTerm(store));
        return ArrayTheory.getSecondToLastArgument(store);
    }

    public static CCTerm getValueFromStore(CCAppTerm store) {
        assert (ArrayTheory.isStoreTerm(store));
        return store.getArg();
    }

    public static CCTerm getValueFromConst(CCAppTerm constArr) {
        assert (ArrayTheory.isConstTerm(constArr));
        return constArr.getArg();
    }

    public static CCTerm getLeftFromDiff(CCAppTerm diff) {
        assert (ArrayTheory.isDiffTerm(diff));
        return ArrayTheory.getSecondToLastArgument(diff);
    }

    public static CCTerm getRightFromDiff(CCAppTerm diff) {
        assert (ArrayTheory.isDiffTerm(diff));
        return diff.getArg();
    }

    public static Sort getArraySortFromSelect(CCAppTerm select) {
        assert (ArrayTheory.isSelectTerm(select));
        return ArrayTheory.getBaseTerm(select).getFunctionSymbol().getParameterSorts()[0];
    }

    public static Sort getArraySortFromStore(CCAppTerm store) {
        assert (ArrayTheory.isStoreTerm(store));
        return ArrayTheory.getBaseTerm(store).getFunctionSymbol().getParameterSorts()[0];
    }

    private static CCBaseTerm getBaseTerm(CCTerm term) {
        if (term instanceof CCBaseTerm) {
            return (CCBaseTerm)term;
        }
        CCTerm func = term;
        while (func instanceof CCAppTerm) {
            func = ((CCAppTerm)func).getFunc();
        }
        assert (func instanceof CCBaseTerm);
        return (CCBaseTerm)func;
    }

    private static CCTerm getSecondToLastArgument(CCTerm term) {
        assert (term instanceof CCAppTerm);
        CCTerm func = ((CCAppTerm)term).getFunc();
        assert (func instanceof CCAppTerm);
        return ((CCAppTerm)func).getArg();
    }

    private static CCTerm getThirdToLastArgument(CCTerm term) {
        assert (term instanceof CCAppTerm);
        return ArrayTheory.getSecondToLastArgument(((CCAppTerm)term).getFunc());
    }

    CCAppTerm findConst(CCTerm value) {
        for (CCAppTerm constTerm : this.mConsts) {
            if (value != ArrayTheory.getValueFromConst(constTerm)) continue;
            return constTerm;
        }
        throw new AssertionError((Object)("Constant term not found for " + value));
    }

    private void setConst(CCAppTerm term) {
        CCTerm const1 = ArrayTheory.getValueFromConst(term);
        CCTerm rep = term.getRepresentative();
        ArrayNode node = this.mCongRoots.get(rep);
        if (node.mConstTerm != null) {
            CCTerm const2 = ArrayTheory.getValueFromConst(node.mConstTerm);
            if (const1.getRepresentative() != const2.getRepresentative()) {
                this.mPropClauses.add(new ArrayLemma(CCAnnotation.RuleKind.CONST_WEAKEQ, const1, const2));
            }
        } else {
            node.mConstTerm = term;
            for (CCAppTerm select : node.mSelects.values()) {
                if (select.getRepresentative() == const1.getRepresentative()) continue;
                this.mPropClauses.add(new ArrayLemma(CCAnnotation.RuleKind.READ_CONST_WEAKEQ, select, const1));
            }
        }
    }

    private void merge(CCAppTerm store) {
        ArrayNode storeNode;
        CCTerm array = ArrayTheory.getArrayFromStore(store);
        ArrayNode arrayNode = this.mCongRoots.get(array.getRepresentative());
        if (arrayNode == (storeNode = this.mCongRoots.get(store.getRepresentative()))) {
            return;
        }
        ++this.mNumMerges;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Merge: [" + ArrayTheory.getIndexFromStore(store).getRepresentative() + "] " + arrayNode + " and " + storeNode);
        }
        arrayNode.makeWeakRepresentative();
        storeNode.makeWeakRepresentative();
        if (arrayNode.mPrimaryEdge == null) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("  PrimaryEdge");
            }
            arrayNode.mergeWith(storeNode, store, this.mPropClauses);
        } else {
            HashSet<CCTerm> seenIndices = new HashSet<CCTerm>();
            CCTerm storeIndex = ArrayTheory.getIndexFromStore(store).getRepresentative();
            seenIndices.add(storeIndex);
            ArrayNode node = arrayNode;
            while (node.mPrimaryEdge != null) {
                CCTerm index = ArrayTheory.getIndexFromStore(node.mPrimaryStore).getRepresentative();
                if (seenIndices.add(index) && node.getWeakIRepresentative(index) != storeNode) {
                    ++this.mNumModuloEdges;
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug("  SecondaryEdge: [" + index + "] " + node + " to " + storeNode);
                    }
                    node.mergeSecondary(storeNode, store, this.mPropClauses);
                }
                node = node.mPrimaryEdge;
            }
        }
    }

    private void computeStoreIndices(CCTerm index, CCTerm array1, CCTerm array2, Set<CCTerm> storeIndices) {
        ArrayNode node1 = this.mCongRoots.get(array1.getRepresentative());
        ArrayNode node2 = this.mCongRoots.get(array2.getRepresentative());
        Cursor cursor1 = new Cursor(array1, node1);
        Cursor cursor2 = new Cursor(array2, node2);
        assert (index == index.getRepresentative());
        cursor1.collect(index, cursor2, storeIndices);
    }

    private void createPropagatedClauses() {
        block5: for (ArrayLemma lemma : this.mPropClauses) {
            CCTerm lhs = lemma.getEquality().getFirst();
            CCTerm rhs = lemma.getEquality().getSecond();
            assert (lhs.getRepresentative() != rhs.getRepresentative());
            switch (lemma.getRule()) {
                case READ_OVER_WEAKEQ: {
                    CCAppTerm select1 = (CCAppTerm)lhs;
                    CCAppTerm select2 = (CCAppTerm)rhs;
                    CCTerm index1 = ArrayTheory.getIndexFromSelect(select1);
                    CCTerm array1 = ArrayTheory.getArrayFromSelect(select1);
                    CCTerm array2 = ArrayTheory.getArrayFromSelect(select2);
                    LinkedHashSet<CCTerm> storeIndices = new LinkedHashSet<CCTerm>();
                    this.computeStoreIndices(index1.getRepresentative(), array1, array2, storeIndices);
                    LinkedHashSet propClause = new LinkedHashSet();
                    for (CCTerm idx : storeIndices) {
                        assert (index1.getRepresentative() != idx.getRepresentative());
                        CCEquality lit = this.getCClosure().createEquality(index1, idx, false);
                        if (lit == null) continue;
                        assert (lit.getDecideStatus() != lit);
                        if (lit.getDecideStatus() != null) continue;
                        propClause.add(lit);
                    }
                    CCEquality lit = this.getCClosure().createEquality(select1, select2, false);
                    if (lit != null) {
                        assert (lit.getDecideStatus() != lit);
                        if (lit.getDecideStatus() == null) {
                            propClause.add(lit);
                        }
                    }
                    lemma.mUndecidedLits = propClause;
                    continue block5;
                }
                case CONST_WEAKEQ: {
                    CCEquality lit = this.getCClosure().createEquality(lhs, rhs, false);
                    assert (lit == null || lit.getDecideStatus() != lit);
                    LinkedHashSet<CCEquality> propClause = new LinkedHashSet<CCEquality>();
                    if (lit != null && lit.getDecideStatus() == null) {
                        propClause.add(lit);
                    }
                    lemma.mUndecidedLits = propClause;
                    continue block5;
                }
                case READ_CONST_WEAKEQ: {
                    CCAppTerm select1 = (CCAppTerm)lhs;
                    CCTerm index1 = ArrayTheory.getIndexFromSelect(select1);
                    CCTerm array1 = ArrayTheory.getArrayFromSelect(select1);
                    CCAppTerm array2 = this.findConst(rhs);
                    LinkedHashSet<CCTerm> storeIndices = new LinkedHashSet<CCTerm>();
                    this.computeStoreIndices(index1.getRepresentative(), array1, array2, storeIndices);
                    LinkedHashSet<CCEquality> propClause = new LinkedHashSet<CCEquality>();
                    for (CCTerm idx : storeIndices) {
                        assert (index1.getRepresentative() != idx.getRepresentative());
                        CCEquality lit = this.getCClosure().createEquality(index1, idx, false);
                        if (lit == null) continue;
                        assert (lit.getDecideStatus() != lit);
                        if (lit.getDecideStatus() != null) continue;
                        propClause.add(lit);
                    }
                    CCEquality lit = this.getCClosure().createEquality(lhs, rhs, false);
                    if (lit != null) {
                        assert (lit.getDecideStatus() != lit);
                        if (lit.getDecideStatus() == null) {
                            propClause.add(lit);
                        }
                    }
                    lemma.mUndecidedLits = propClause;
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unknown Array Rule: " + (Object)((Object)lemma.getRule())));
        }
    }

    private boolean buildWeakEq() {
        ++this.mNumBuildWeakEQ;
        long startTime = System.nanoTime();
        this.mCongRoots = new LinkedHashMap<CCTerm, ArrayNode>();
        for (CCTerm array : this.mArrays) {
            CCTerm rep = array.getRepresentative();
            if (this.mCongRoots.containsKey(rep)) continue;
            ArrayNode node = new ArrayNode(rep);
            node.computeSelects();
            this.mCongRoots.put(rep, node);
        }
        for (CCAppTerm term : this.mConsts) {
            this.setConst(term);
        }
        for (CCAppTerm store : this.mStores) {
            this.merge(store);
        }
        this.createPropagatedClauses();
        this.mTimeBuildWeakEq += System.nanoTime() - startTime;
        return !this.mPropClauses.isEmpty();
    }

    private void makeConstReps() {
        for (CCTerm cCTerm : this.mConsts) {
            ArrayNode node = this.mCongRoots.get(cCTerm.getRepresentative());
            node.makeWeakRepresentative();
        }
    }

    private boolean computeWeakeqExt() {
        long startTime = System.nanoTime();
        this.makeConstReps();
        this.mArrayModels = new LinkedHashMap<ArrayNode, Map<CCTerm, Object>>();
        HashMap inverse = new HashMap();
        LinkedHashSet<SymmetricPair<ArrayNode>> propEqualities = new LinkedHashSet<SymmetricPair<ArrayNode>>();
        ArrayDeque<ArrayNode> todoQueue = new ArrayDeque<ArrayNode>(this.mCongRoots.values());
        while (!todoQueue.isEmpty()) {
            CCTerm value;
            ArrayNode node = todoQueue.getFirst();
            if (this.mArrayModels.containsKey(node)) {
                todoQueue.removeFirst();
                continue;
            }
            if (node.mPrimaryEdge != null && !this.mArrayModels.containsKey(node.mPrimaryEdge)) {
                todoQueue.addFirst(node.mPrimaryEdge);
                continue;
            }
            todoQueue.removeFirst();
            LinkedHashMap<CCTerm, Object> linkedHashMap = new LinkedHashMap<CCTerm, Object>();
            CCTerm constRep = null;
            ArrayNode weakRep = node.getWeakRepresentative();
            if (weakRep.mConstTerm != null) {
                constRep = ArrayTheory.getValueFromConst(weakRep.mConstTerm).getRepresentative();
            }
            if (node == weakRep) {
                linkedHashMap.put(null, node);
                for (Map.Entry<CCTerm, CCAppTerm> e : node.mSelects.entrySet()) {
                    value = e.getValue().getRepresentative();
                    assert (constRep == null || value == constRep);
                    if (value == constRep) continue;
                    linkedHashMap.put(e.getKey(), value);
                }
            } else {
                CCTerm storeIndex = ArrayTheory.getIndexFromStore(node.mPrimaryStore).getRepresentative();
                linkedHashMap.putAll(this.mArrayModels.get(node.mPrimaryEdge));
                linkedHashMap.remove(storeIndex);
                ArrayNode weakiRep = node.getWeakIRepresentative(storeIndex);
                value = weakiRep.mSelects.get(storeIndex);
                if (value != null) {
                    if (value.getRepresentative() != constRep) {
                        linkedHashMap.put(storeIndex, value.getRepresentative());
                    }
                } else if (weakiRep != weakRep) {
                    linkedHashMap.put(storeIndex, weakiRep);
                }
            }
            this.mArrayModels.put(node, linkedHashMap);
            ArrayNode prev = inverse.put(linkedHashMap, node);
            if (prev == null) continue;
            propEqualities.add(new SymmetricPair<ArrayNode>(prev, node));
        }
        for (SymmetricPair symmetricPair : propEqualities) {
            ++this.mNumInstsEq;
            WeakCongruencePath path = new WeakCongruencePath(this);
            Clause lemma = path.computeWeakeqExt(((ArrayNode)symmetricPair.getFirst()).mTerm, ((ArrayNode)symmetricPair.getSecond()).mTerm, this.mCClosure.isProofGenerationEnabled());
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("AL sw: " + lemma);
            }
            this.mCClosure.getEngine().learnClause(lemma);
        }
        this.mTimeBuildWeakEqi += System.nanoTime() - startTime;
        return !propEqualities.isEmpty();
    }

    CClosure getCClosure() {
        return this.mCClosure;
    }

    Clausifier getClausifier() {
        return this.mClausifier;
    }

    public void cleanCaches() {
        this.mCongRoots = null;
        this.mPropClauses.clear();
    }

    public CCTerm getWeakRep(CCTerm array) {
        assert (array != null && array.getFlatTerm().getSort().isArraySort());
        if (this.mCongRoots == null) {
            this.buildWeakEq();
        }
        ArrayNode weakRep = this.mCongRoots.get(array.getRepresentative()).getWeakRepresentative();
        assert (weakRep != null);
        return weakRep.mTerm;
    }

    private class Cursor {
        ArrayNode mNode;

        public Cursor(CCTerm term, ArrayNode node) {
            this.mNode = node;
        }

        public void collectOverPrimaries(ArrayNode destNode, Set<CCTerm> storeIndices) {
            int steps1;
            int steps2 = destNode.countPrimaryEdges();
            for (steps1 = this.mNode.countPrimaryEdges(); steps1 > steps2; --steps1) {
                storeIndices.add(ArrayTheory.getIndexFromStore(this.mNode.mPrimaryStore));
                this.mNode = this.mNode.mPrimaryEdge;
            }
            while (steps2 > steps1) {
                storeIndices.add(ArrayTheory.getIndexFromStore(destNode.mPrimaryStore));
                destNode = destNode.mPrimaryEdge;
                --steps2;
            }
            while (this.mNode != destNode) {
                storeIndices.add(ArrayTheory.getIndexFromStore(this.mNode.mPrimaryStore));
                storeIndices.add(ArrayTheory.getIndexFromStore(destNode.mPrimaryStore));
                this.mNode = this.mNode.mPrimaryEdge;
                destNode = destNode.mPrimaryEdge;
            }
        }

        private void collectOneSecondary(CCTerm index, Set<CCTerm> storeIndices) {
            ArrayNode selectNode = this.mNode.findSecondaryNode(index);
            CCAppTerm store = selectNode.mSecondaryStore;
            CCTerm array = ArrayTheory.getArrayFromStore(store);
            ArrayNode arrayNode = ArrayTheory.this.mCongRoots.get(array.getRepresentative());
            ArrayNode storeNode = ArrayTheory.this.mCongRoots.get(store.getRepresentative());
            if (arrayNode.findSecondaryNode(index) == selectNode) {
                this.collectOverPrimaries(arrayNode, storeIndices);
                this.mNode = storeNode;
            } else {
                assert (storeNode.findSecondaryNode(index) == selectNode);
                this.collectOverPrimaries(storeNode, storeIndices);
                this.mNode = arrayNode;
            }
            storeIndices.add(ArrayTheory.getIndexFromStore(store));
        }

        public void collect(CCTerm index, Cursor dest, Set<CCTerm> storeIndices) {
            int steps1;
            int steps2 = dest.mNode.countSecondaryEdges(index);
            for (steps1 = this.mNode.countSecondaryEdges(index); steps1 > steps2; --steps1) {
                this.collectOneSecondary(index, storeIndices);
            }
            while (steps2 > steps1) {
                dest.collectOneSecondary(index, storeIndices);
                --steps2;
            }
            while (this.mNode.findSecondaryNode(index) != dest.mNode.findSecondaryNode(index)) {
                this.collectOneSecondary(index, storeIndices);
                dest.collectOneSecondary(index, storeIndices);
            }
            this.collectOverPrimaries(dest.mNode, storeIndices);
        }
    }

    private static class ArrayLemma {
        CCAnnotation.RuleKind mRule;
        SymmetricPair<CCTerm> mPropagatedEq;
        Set<CCEquality> mUndecidedLits;

        public ArrayLemma(CCAnnotation.RuleKind rule, CCTerm lhs, CCTerm rhs) {
            this.mRule = rule;
            this.mPropagatedEq = new SymmetricPair<CCTerm>(lhs, rhs);
        }

        public CCAnnotation.RuleKind getRule() {
            return this.mRule;
        }

        public SymmetricPair<CCTerm> getEquality() {
            return this.mPropagatedEq;
        }

        public int hashCode() {
            return HashUtils.hashJenkins(this.mRule.hashCode(), this.mPropagatedEq);
        }

        public boolean equals(Object other) {
            if (other instanceof ArrayLemma) {
                ArrayLemma o = (ArrayLemma)other;
                return this.mRule == o.mRule && this.mPropagatedEq.equals(o.mPropagatedEq);
            }
            return false;
        }

        public String toString() {
            return "ArrayLemma[" + this.mPropagatedEq + " ; " + this.mUndecidedLits + "]";
        }
    }

    class ArrayNode {
        CCTerm mTerm;
        ArrayNode mPrimaryEdge;
        CCAppTerm mPrimaryStore;
        ArrayNode mSecondaryEdge;
        CCAppTerm mSecondaryStore;
        Map<CCTerm, CCAppTerm> mSelects;
        CCAppTerm mConstTerm;

        public ArrayNode(CCTerm ccterm) {
            assert (ccterm.isRepresentative());
            this.mTerm = ccterm;
            this.mSecondaryEdge = null;
            this.mPrimaryEdge = null;
            this.mPrimaryStore = null;
        }

        public void computeSelects() {
            this.mSelects = new LinkedHashMap<CCTerm, CCAppTerm>();
            CCParentInfo info = this.mTerm.mCCPars;
            while (info != null) {
                CCTerm funcTerm;
                if (info.mCCParents != null && !info.mCCParents.isEmpty() && (funcTerm = info.mCCParents.iterator().next().getData().getFunc()) instanceof CCBaseTerm && ((CCBaseTerm)funcTerm).getFunctionSymbol().getName() == "select") {
                    for (CCAppTerm.Parent pa : info.mCCParents) {
                        CCParentInfo selectas = pa.getData().getRepresentative().mCCPars.getExistingParentInfo(0);
                        for (CCAppTerm.Parent spa : selectas.mCCParents) {
                            CCAppTerm select = spa.getData();
                            assert (ArrayTheory.getArrayFromSelect(select).getRepresentative() == this.mTerm);
                            assert (select != null);
                            this.mSelects.put(select.mArg.getRepresentative(), select);
                        }
                    }
                }
                info = info.mNext;
            }
        }

        public ArrayNode getWeakRepresentative() {
            ArrayNode node = this;
            while (node.mPrimaryEdge != null) {
                node = node.mPrimaryEdge;
            }
            return node;
        }

        public ArrayNode getWeakIRepresentative(CCTerm index) {
            index = index.getRepresentative();
            ArrayNode node = this;
            while (node.mPrimaryEdge != null) {
                if (ArrayTheory.getIndexFromStore(node.mPrimaryStore).getRepresentative() == index) {
                    if (node.mSecondaryEdge == null) break;
                    node = node.mSecondaryEdge;
                    continue;
                }
                node = node.mPrimaryEdge;
            }
            return node;
        }

        public void makeWeakIRepresentative() {
            assert (this.mPrimaryEdge != null);
            assert (this.mSecondaryEdge != null);
            CCTerm index = ArrayTheory.getIndexFromStore(this.mPrimaryStore).getRepresentative();
            assert (this.getWeakIRepresentative(index) != this.getWeakRepresentative());
            ArrayNode prev = this;
            ArrayNode next = prev.mSecondaryEdge;
            CCAppTerm prevReason = prev.mSecondaryStore;
            while (next != null) {
                next = next.findSecondaryNode(index);
                ArrayNode nextEdge = next.mSecondaryEdge;
                CCAppTerm nextReason = next.mSecondaryStore;
                next.mSecondaryEdge = prev;
                next.mSecondaryStore = prevReason;
                prev = next;
                prevReason = nextReason;
                next = nextEdge;
            }
            this.mSecondaryEdge = null;
            this.mSecondaryStore = null;
            this.mSelects = prev.mSelects;
            prev.mSelects = Collections.emptyMap();
        }

        public void makeWeakRepresentative() {
            CCTerm index;
            if (this.mPrimaryEdge == null) {
                return;
            }
            LinkedHashMap<CCTerm, ArrayNode> seenStores = new LinkedHashMap<CCTerm, ArrayNode>();
            LinkedHashMap<CCTerm, ArrayNode> todoSecondary = new LinkedHashMap<CCTerm, ArrayNode>();
            LinkedHashMap<CCTerm, CCAppTerm> todoSecondaryStores = new LinkedHashMap<CCTerm, CCAppTerm>();
            LinkedHashMap<CCTerm, CCAppTerm> newSelectMap = new LinkedHashMap<CCTerm, CCAppTerm>();
            ArrayNode node = this;
            ArrayNode prev = null;
            CCAppTerm prevStore = null;
            while (node.mPrimaryEdge != null) {
                ArrayNode next = node.mPrimaryEdge;
                CCAppTerm nextStore = node.mPrimaryStore;
                node.mPrimaryEdge = prev;
                node.mPrimaryStore = prevStore;
                CCTerm index2 = ArrayTheory.getIndexFromStore(nextStore).getRepresentative();
                ArrayNode old = seenStores.put(index2, next);
                if (old != node) {
                    if (node.mSecondaryEdge != null) {
                        if (old == null) {
                            todoSecondary.put(index2, node.mSecondaryEdge);
                            todoSecondaryStores.put(index2, node.mSecondaryStore);
                        } else {
                            assert (ArrayTheory.getIndexFromStore(old.mPrimaryStore).getRepresentative() == index2);
                            assert (old.mSecondaryEdge == null);
                            old.mSecondaryEdge = node.mSecondaryEdge;
                            old.mSecondaryStore = node.mSecondaryStore;
                        }
                        node.mSecondaryEdge = null;
                        node.mSecondaryStore = null;
                    } else if (!node.mSelects.isEmpty()) {
                        if (old == null) {
                            assert (node.mSelects.get(index2) != null);
                            newSelectMap.put(index2, node.mSelects.get(index2));
                        } else {
                            old.mSelects = node.mSelects;
                        }
                        node.mSelects = Collections.emptyMap();
                    }
                }
                prev = node;
                node = next;
                prevStore = nextStore;
            }
            node.mPrimaryEdge = prev;
            node.mPrimaryStore = prevStore;
            this.mConstTerm = node.mConstTerm;
            node.mConstTerm = null;
            Map<CCTerm, CCAppTerm> rootSelects = node.mSelects;
            node.mSelects = Collections.emptyMap();
            for (Map.Entry entry : seenStores.entrySet()) {
                index = (CCTerm)entry.getKey();
                CCAppTerm select = rootSelects.remove(index);
                if (select == null) continue;
                ((ArrayNode)entry.getValue()).mSelects = Collections.singletonMap(index, select);
            }
            for (Map.Entry entry : todoSecondary.entrySet()) {
                index = (CCTerm)entry.getKey();
                ArrayNode dest = (ArrayNode)entry.getValue();
                dest = dest.findSecondaryNode(index);
                if (dest.mSecondaryEdge != null) {
                    dest.makeWeakIRepresentative();
                }
                dest.mSecondaryEdge = this;
                dest.mSecondaryStore = (CCAppTerm)todoSecondaryStores.get(index);
                newSelectMap.putAll(dest.mSelects);
                dest.mSelects = Collections.emptyMap();
            }
            newSelectMap.putAll(rootSelects);
            this.mSelects = newSelectMap;
        }

        public void mergeWith(ArrayNode storeNode, CCAppTerm store, Collection<ArrayLemma> propLemmas) {
            assert (this.mPrimaryEdge == null && storeNode.mPrimaryEdge == null);
            this.mPrimaryEdge = storeNode;
            this.mPrimaryStore = store;
            LinkedHashMap<CCTerm, CCAppTerm> mergeConstSelects = new LinkedHashMap<CCTerm, CCAppTerm>();
            if (this.mConstTerm != null) {
                if (storeNode.mConstTerm == null) {
                    storeNode.mConstTerm = this.mConstTerm;
                    this.mConstTerm = null;
                    mergeConstSelects.putAll(storeNode.mSelects);
                } else {
                    CCTerm const1 = ArrayTheory.getValueFromConst(this.mConstTerm);
                    CCTerm const2 = ArrayTheory.getValueFromConst(storeNode.mConstTerm);
                    if (const1.getRepresentative() != const2.getRepresentative()) {
                        propLemmas.add(new ArrayLemma(CCAnnotation.RuleKind.CONST_WEAKEQ, const1, const2));
                    }
                }
            } else if (storeNode.mConstTerm != null) {
                mergeConstSelects.putAll(this.mSelects);
            }
            mergeConstSelects.remove(ArrayTheory.getIndexFromStore(store).getRepresentative());
            Map<Object, Object> newSelects = Collections.emptyMap();
            for (Map.Entry entry : this.mSelects.entrySet()) {
                CCTerm index = (CCTerm)entry.getKey();
                CCAppTerm select = (CCAppTerm)entry.getValue();
                assert (select != null);
                if (index == ArrayTheory.getIndexFromStore(store).getRepresentative()) {
                    newSelects = Collections.singletonMap(index, select);
                    continue;
                }
                CCAppTerm otherSelect = storeNode.mSelects.get(index);
                if (otherSelect == null) {
                    storeNode.mSelects.put(index, select);
                    continue;
                }
                mergeConstSelects.remove(index);
                if (select.getRepresentative() == otherSelect.getRepresentative()) continue;
                propLemmas.add(new ArrayLemma(CCAnnotation.RuleKind.READ_OVER_WEAKEQ, select, otherSelect));
            }
            this.mSelects = newSelects;
            if (storeNode.mConstTerm != null) {
                CCTerm const1 = ArrayTheory.getValueFromConst(storeNode.mConstTerm);
                ArrayNode arrayNode = ArrayTheory.this.mCongRoots.get(storeNode.mConstTerm.getRepresentative());
                for (Map.Entry entry : mergeConstSelects.entrySet()) {
                    CCTerm index = (CCTerm)entry.getKey();
                    CCAppTerm select = (CCAppTerm)entry.getValue();
                    if (arrayNode.getWeakIRepresentative(index) != storeNode) continue;
                    storeNode.mSelects.remove(index);
                    if (select.getRepresentative() == const1.getRepresentative()) continue;
                    propLemmas.add(new ArrayLemma(CCAnnotation.RuleKind.READ_CONST_WEAKEQ, select, const1));
                }
            }
        }

        public void mergeSecondary(ArrayNode storeNode, CCAppTerm store, Collection<ArrayLemma> propEqualities) {
            ArrayNode constNode;
            assert (storeNode.mPrimaryEdge == null);
            assert (this.mPrimaryEdge != null);
            assert (ArrayTheory.getIndexFromStore(this.mPrimaryStore).getRepresentative() != ArrayTheory.getIndexFromStore(store).getRepresentative());
            if (this.mSecondaryEdge != null) {
                this.makeWeakIRepresentative();
            }
            this.mSecondaryEdge = storeNode;
            this.mSecondaryStore = store;
            CCTerm storeIndex = ArrayTheory.getIndexFromStore(this.mPrimaryStore).getRepresentative();
            if (!this.mSelects.isEmpty()) {
                CCAppTerm select = this.mSelects.get(storeIndex);
                assert (select != null);
                CCAppTerm otherSelect = storeNode.mSelects.get(storeIndex);
                if (otherSelect == null) {
                    storeNode.mSelects.put(storeIndex, select);
                } else if (select.getRepresentative() != otherSelect.getRepresentative()) {
                    propEqualities.add(new ArrayLemma(CCAnnotation.RuleKind.READ_OVER_WEAKEQ, select, otherSelect));
                }
                this.mSelects = Collections.emptyMap();
            }
            if (storeNode.mConstTerm != null && (constNode = ArrayTheory.this.mCongRoots.get(storeNode.mConstTerm.getRepresentative())).getWeakIRepresentative(storeIndex) == storeNode) {
                CCAppTerm select = storeNode.mSelects.remove(storeIndex);
                CCTerm const1 = ArrayTheory.getValueFromConst(storeNode.mConstTerm);
                if (select != null && select.getRepresentative() != const1.getRepresentative()) {
                    propEqualities.add(new ArrayLemma(CCAnnotation.RuleKind.READ_CONST_WEAKEQ, select, const1));
                }
            }
        }

        public int countSecondaryEdges(CCTerm index) {
            assert (index.isRepresentative());
            int count = 0;
            ArrayNode node = this;
            while (node.mPrimaryEdge != null) {
                if (ArrayTheory.getIndexFromStore(node.mPrimaryStore).getRepresentative() == index) {
                    if (node.mSecondaryEdge == null) break;
                    node = node.mSecondaryEdge;
                    ++count;
                    continue;
                }
                node = node.mPrimaryEdge;
            }
            return count;
        }

        public ArrayNode findSecondaryNode(CCTerm index) {
            assert (index.isRepresentative());
            ArrayNode node = this;
            while (node.mPrimaryEdge != null && ArrayTheory.getIndexFromStore(node.mPrimaryStore).getRepresentative() != index) {
                node = node.mPrimaryEdge;
            }
            return node;
        }

        public int countPrimaryEdges() {
            int count = 0;
            ArrayNode node = this;
            while (node.mPrimaryEdge != null) {
                node = node.mPrimaryEdge;
                ++count;
            }
            return count;
        }

        public int hashCode() {
            return this.mTerm.hashCode();
        }

        public String toString() {
            return "ArrayNode[" + this.mTerm + "]";
        }
    }
}

