/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCProofGenerator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeLemma;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.WeakCongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.Collection;

public class CCAnnotation
implements IAnnotation {
    final RuleKind mRule;
    final SymmetricPair<CCTerm> mDiseq;
    final CCTerm[][] mPaths;
    final CCTerm[] mWeakIndices;
    final DataTypeLemma mDTLemma;

    public CCAnnotation(SymmetricPair<CCTerm> diseq, Collection<CongruencePath.SubPath> paths, RuleKind rule) {
        this.mDiseq = diseq;
        this.mPaths = new CCTerm[paths.size()][];
        this.mWeakIndices = new CCTerm[this.mPaths.length];
        int i = 0;
        for (CongruencePath.SubPath p : paths) {
            this.mPaths[i] = p.getTerms();
            this.mWeakIndices[i] = p instanceof WeakCongruencePath.WeakSubPath ? ((WeakCongruencePath.WeakSubPath)p).getIndex() : null;
            ++i;
        }
        this.mRule = rule;
        this.mDTLemma = null;
    }

    public CCAnnotation(SymmetricPair<CCTerm> diseq, Collection<CongruencePath.SubPath> paths, DataTypeLemma lemma) {
        this.mDiseq = diseq;
        this.mPaths = new CCTerm[paths.size()][];
        this.mWeakIndices = new CCTerm[this.mPaths.length];
        int i = 0;
        for (CongruencePath.SubPath p : paths) {
            this.mPaths[i] = p.getTerms();
            this.mWeakIndices[i] = p instanceof WeakCongruencePath.WeakSubPath ? ((WeakCongruencePath.WeakSubPath)p).getIndex() : null;
            ++i;
        }
        this.mRule = lemma.getRule();
        this.mDTLemma = lemma;
    }

    public SymmetricPair<CCTerm> getDiseq() {
        return this.mDiseq;
    }

    public CCTerm[][] getPaths() {
        return this.mPaths;
    }

    public CCTerm[] getWeakIndices() {
        return this.mWeakIndices;
    }

    @Override
    public Term toTerm(Clause clause, ProofRules proofRules) {
        return new CCProofGenerator(this).toTerm(clause, proofRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.mDiseq);
        for (int i = 0; i < this.mPaths.length; ++i) {
            if (this.mWeakIndices[i] != null) {
                sb.append(" :weak ").append(this.mWeakIndices[i]).append(' ');
            } else {
                sb.append(" :strong ");
            }
            sb.append("(");
            String comma = "";
            for (CCTerm term : this.mPaths[i]) {
                sb.append(comma).append(term);
                comma = " ";
            }
            sb.append(")");
        }
        sb.append(')');
        return sb.toString();
    }

    public static enum RuleKind {
        TRANS(":trans"),
        CONG(":cong"),
        READ_OVER_WEAKEQ(":read-over-weakeq"),
        WEAKEQ_EXT(":weakeq-ext"),
        READ_CONST_WEAKEQ(":read-const-weakeq"),
        CONST_WEAKEQ(":const-weakeq"),
        DT_PROJECT(":dt-project"),
        DT_TESTER(":dt-tester"),
        DT_CONSTRUCTOR(":dt-constructor"),
        DT_CASES(":dt-cases"),
        DT_UNIQUE(":dt-unique"),
        DT_DISJOINT(":dt-disjoint"),
        DT_INJECTIVE(":dt-injective"),
        DT_CYCLE(":dt-cycle");

        String mKind;

        private RuleKind(String kind) {
            this.mKind = kind;
        }

        public String getKind() {
            return this.mKind;
        }
    }
}

