/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;
import java.util.HashMap;

public class CCAppTerm
extends CCTerm {
    final CCTerm mFunc;
    final CCTerm mArg;
    final Parent mLeftParInfo;
    final Parent mRightParInfo;
    Term mSmtTerm;

    public CCAppTerm(boolean isFunc, int parentPos, CCTerm func, CCTerm arg, CClosure engine, boolean isFromQuant) {
        super(isFunc, parentPos, HashUtils.hashJenkins(func.hashCode(), (Object)arg), !isFromQuant ? 0 : Math.max(func.mAge, arg.mAge + 1));
        this.mFunc = func;
        this.mArg = arg;
        this.mLeftParInfo = new Parent();
        this.mRightParInfo = new Parent();
    }

    public CCTerm getFunc() {
        return this.mFunc;
    }

    public CCTerm getArg() {
        return this.mArg;
    }

    public void addParentInfo(CClosure engine) {
        CCTerm func = this.mFunc;
        CCTerm arg = this.mArg;
        while (func.mRep != func || arg.mRep != arg) {
            if (arg.mMergeTime < func.mMergeTime) {
                arg.mCCPars.addParentInfo(func.mParentPosition, this.mRightParInfo, false, null);
                arg = arg.mRep;
                continue;
            }
            func.mCCPars.addParentInfo(0, this.mLeftParInfo, false, null);
            func = func.mRep;
        }
        func.mCCPars.addParentInfo(0, this.mLeftParInfo, true, engine);
        arg.mCCPars.addParentInfo(func.mParentPosition, this.mRightParInfo, true, engine);
        assert (this.invariant());
        assert (func.invariant());
        assert (arg.invariant());
    }

    public void unlinkParentInfos() {
        this.mLeftParInfo.removeFromList();
        this.mRightParInfo.removeFromList();
    }

    public void markParentInfos() {
        this.mLeftParInfo.mMark = (this.mRightParInfo.mMark = true);
    }

    public void unmarkParentInfos() {
        this.mLeftParInfo.mMark = (this.mRightParInfo.mMark = false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        HashMap<CCAppTerm, Integer> visited = new HashMap<CCAppTerm, Integer>();
        ArrayDeque<Object> todo = new ArrayDeque<Object>();
        todo.add(")");
        todo.add(this);
        todo.add("(");
        while (!todo.isEmpty()) {
            Object item = todo.removeLast();
            if (item instanceof String) {
                sb.append(item);
                continue;
            }
            if (item instanceof CCAppTerm) {
                CCAppTerm app = (CCAppTerm)item;
                Integer id = (Integer)visited.get(item);
                if (id != null) {
                    sb.append("@" + id);
                    continue;
                }
                visited.put(app, visited.size());
                if (app.mArg instanceof CCAppTerm) {
                    todo.add(")");
                    todo.add(app.mArg);
                    todo.add("(");
                } else {
                    todo.add(app.mArg);
                }
                todo.add(" ");
                todo.add(app.mFunc);
                continue;
            }
            if (item instanceof CCBaseTerm) {
                sb.append(item);
                continue;
            }
            throw new AssertionError((Object)("Unknown CCTerm " + item));
        }
        return sb.toString();
    }

    class Parent
    extends SimpleListable<Parent> {
        private boolean mMark = false;

        Parent() {
        }

        CCAppTerm getData() {
            return CCAppTerm.this;
        }

        public final boolean isMarked() {
            assert (!this.mMark || CCAppTerm.this.mRepStar.mNumMembers > 1);
            return this.mMark;
        }

        public String toString() {
            return CCAppTerm.this.toString();
        }
    }
}

