/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;

public class CCParentInfo {
    int mFuncSymbNr;
    SimpleList<CCAppTerm.Parent> mCCParents;
    CCParentInfo mNext;
    SimpleList<ReverseTrigger> mReverseTriggers;

    public CCParentInfo() {
        this.mFuncSymbNr = -1;
    }

    private CCParentInfo(int funcSymbNr, CCParentInfo next) {
        this.mFuncSymbNr = funcSymbNr;
        this.mCCParents = new SimpleList();
        this.mNext = next;
        this.mReverseTriggers = new SimpleList();
    }

    private CCParentInfo(CCParentInfo other, CCParentInfo next) {
        this(other.mFuncSymbNr, next);
        this.mCCParents.joinList(other.mCCParents);
        this.mReverseTriggers.joinList(other.mReverseTriggers);
    }

    public void addParentInfo(int funcSymbNr, CCAppTerm.Parent parent, boolean isLast, CClosure engine) {
        CCParentInfo info = this;
        while (info.mNext != null && info.mNext.mFuncSymbNr <= funcSymbNr) {
            info = info.mNext;
            if (info.mFuncSymbNr != funcSymbNr) continue;
            info.mCCParents.prependIntoJoined(parent, isLast);
            return;
        }
        info.mNext = new CCParentInfo(funcSymbNr, info.mNext);
        info.mNext.mCCParents.prependIntoJoined(parent, isLast);
    }

    public void mergeParentInfo(CCParentInfo other) {
        CCParentInfo myInfo = this;
        other = other.mNext;
        while (other != null) {
            int funcSymbNr = other.mFuncSymbNr;
            while (myInfo.mNext != null && myInfo.mNext.mFuncSymbNr < funcSymbNr) {
                myInfo = myInfo.mNext;
            }
            if (myInfo.mNext != null && myInfo.mNext.mFuncSymbNr == funcSymbNr) {
                myInfo = myInfo.mNext;
                myInfo.mCCParents.joinList(other.mCCParents);
                myInfo.mReverseTriggers.joinList(other.mReverseTriggers);
            } else {
                myInfo = myInfo.mNext = new CCParentInfo(other, myInfo.mNext);
            }
            other = other.mNext;
        }
    }

    public void unmergeParentInfo(CCParentInfo other) {
        CCParentInfo myInfo = this;
        other = other.mNext;
        while (other != null) {
            int funcSymbNr = other.mFuncSymbNr;
            while (myInfo.mNext.mFuncSymbNr < funcSymbNr) {
                myInfo = myInfo.mNext;
            }
            CCParentInfo next = myInfo.mNext;
            assert (next.mFuncSymbNr == funcSymbNr);
            next.mCCParents.unjoinList(other.mCCParents);
            next.mReverseTriggers.unjoinList(other.mReverseTriggers);
            if (!next.mCCParents.isEmpty() || !next.mReverseTriggers.isEmpty()) {
                myInfo = next;
            }
            other = other.mNext;
        }
    }

    CCParentInfo getInfo(int funcSymbNr) {
        CCParentInfo info = this;
        while (info.mNext != null && info.mNext.mFuncSymbNr <= funcSymbNr) {
            info = info.mNext;
            if (info.mFuncSymbNr != funcSymbNr) continue;
            return info;
        }
        return null;
    }

    CCParentInfo createInfo(int funcSymbNr) {
        CCParentInfo info = this;
        while (info.mNext != null && info.mNext.mFuncSymbNr <= funcSymbNr) {
            info = info.mNext;
            if (info.mFuncSymbNr != funcSymbNr) continue;
            return info;
        }
        info.mNext = new CCParentInfo(funcSymbNr, info.mNext);
        return info.mNext;
    }

    CCParentInfo getExistingParentInfo(int funcSymbNr) {
        CCParentInfo info = this;
        while (info.mNext != null && info.mNext.mFuncSymbNr <= funcSymbNr) {
            info = info.mNext;
            if (info.mFuncSymbNr != funcSymbNr) continue;
            return info;
        }
        return null;
    }

    public SimpleList<CCAppTerm.Parent> getParentInfo(int funcSymbNr) {
        CCParentInfo info = this.mNext;
        while (info != null && info.mFuncSymbNr < funcSymbNr) {
            info = info.mNext;
        }
        if (info != null && info.mFuncSymbNr == funcSymbNr) {
            return info.mCCParents;
        }
        return new SimpleList<CCAppTerm.Parent>();
    }
}

