/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class CCProofGenerator {
    final CCAnnotation mAnnot;
    final CCAnnotation.RuleKind mRule;
    final IndexedPath[] mIndexedPaths;
    private HashMap<SymmetricPair<CCTerm>, Literal> mEqualityLiterals;
    private HashMap<SymmetricPair<CCTerm>, ProofInfo> mPathProofMap;
    private LinkedHashSet<SymmetricPair<CCTerm>> mAllEqualities;

    public CCProofGenerator(CCAnnotation arrayAnnot) {
        this.mAnnot = arrayAnnot;
        this.mRule = arrayAnnot.mRule;
        this.mIndexedPaths = new IndexedPath[arrayAnnot.getPaths().length];
        for (int i = 0; i < this.mIndexedPaths.length; ++i) {
            this.mIndexedPaths[i] = new IndexedPath(arrayAnnot.getWeakIndices()[i], arrayAnnot.getPaths()[i]);
        }
    }

    public Term toTerm(Clause clause, ProofRules proofRules) {
        this.mAllEqualities = new LinkedHashSet();
        this.collectClauseLiterals(clause);
        this.collectStrongEqualities();
        ProofInfo mainInfo = this.findMainPaths();
        if (this.mAnnot.mDiseq != null) {
            SymmetricPair<CCTerm> mainDiseq = this.mAnnot.mDiseq;
            assert (this.isDisequalityLiteral(mainDiseq) || this.isTrivialDisequality(mainDiseq));
            mainInfo.mLemmaDiseq = mainDiseq;
            this.mPathProofMap.put(mainDiseq, mainInfo);
        } else assert (this.mAnnot.mRule == CCAnnotation.RuleKind.DT_CASES || this.mAnnot.mRule == CCAnnotation.RuleKind.DT_UNIQUE || this.mAnnot.mRule == CCAnnotation.RuleKind.DT_DISJOINT || this.mAnnot.mRule == CCAnnotation.RuleKind.DT_CYCLE) : "Rule needs a disequality";
        this.determineAllNumParents(mainInfo);
        ArrayList<ProofInfo> proofOrder = this.determineProofOrder(mainInfo);
        return this.buildProofTerm(clause, proofRules, proofOrder);
    }

    private void collectClauseLiterals(Clause clause) {
        this.mEqualityLiterals = new HashMap();
        for (int i = 0; i < clause.getSize(); ++i) {
            Literal literal = clause.getLiteral(i);
            CCEquality atom = (CCEquality)literal.getAtom();
            SymmetricPair<CCTerm> pair = new SymmetricPair<CCTerm>(atom.getLhs(), atom.getRhs());
            this.mEqualityLiterals.put(pair, literal);
            if (literal.getSign() >= 0) continue;
            this.mAllEqualities.add(pair);
        }
    }

    private void collectStrongEqualities() {
        this.mPathProofMap = new HashMap();
        for (int i = this.mIndexedPaths.length - 1; i >= 0; --i) {
            CCTerm[] path;
            SymmetricPair<CCTerm> pathEnds;
            IndexedPath indexedPath = this.mIndexedPaths[i];
            if (indexedPath.getIndex() != null || (this.mRule == CCAnnotation.RuleKind.WEAKEQ_EXT || this.mRule == CCAnnotation.RuleKind.CONST_WEAKEQ) && i <= 0 || !this.mAllEqualities.add(pathEnds = new SymmetricPair<CCTerm>((path = indexedPath.getPath())[0], path[path.length - 1])) || this.mPathProofMap.containsKey(pathEnds)) continue;
            if (path.length == 2) {
                ProofInfo congruence = this.findCongruencePaths(path[0], path[1]);
                this.mPathProofMap.put(pathEnds, congruence);
                continue;
            }
            ProofInfo pathInfo = new ProofInfo();
            pathInfo.mLemmaDiseq = pathEnds;
            ProofInfo.access$902(pathInfo, new IndexedPath[]{indexedPath});
            pathInfo.collectStrongPath(indexedPath);
            this.mPathProofMap.put(pathEnds, pathInfo);
        }
    }

    private ProofInfo findMainPaths() {
        ProofInfo mainProof = new ProofInfo();
        switch (this.mRule) {
            case TRANS: 
            case CONG: {
                return this.mPathProofMap.get(this.mIndexedPaths[0].getPathEnds());
            }
            case READ_OVER_WEAKEQ: {
                CCTerm idx2;
                SymmetricPair<CCTerm> selectEquality = this.mAnnot.mDiseq;
                assert (ArrayTheory.isSelectTerm(selectEquality.getFirst()) && ArrayTheory.isSelectTerm(selectEquality.getSecond()));
                CCTerm idx1 = ArrayTheory.getIndexFromSelect((CCAppTerm)selectEquality.getFirst());
                if (idx1 != (idx2 = ArrayTheory.getIndexFromSelect((CCAppTerm)selectEquality.getSecond()))) {
                    mainProof.collectEquality(new SymmetricPair<CCTerm>(idx1, idx2));
                }
                assert (this.mIndexedPaths[0].getIndex() != null);
                mainProof.collectWeakPath(this.mIndexedPaths[0]);
                ProofInfo.access$902(mainProof, new IndexedPath[]{this.mIndexedPaths[0]});
                break;
            }
            case READ_CONST_WEAKEQ: {
                assert (this.mIndexedPaths[0].getIndex() != null);
                mainProof.collectWeakPath(this.mIndexedPaths[0]);
                ProofInfo.access$902(mainProof, new IndexedPath[]{this.mIndexedPaths[0]});
                break;
            }
            case CONST_WEAKEQ: {
                assert (this.mIndexedPaths[0].getIndex() == null);
                mainProof.collectWeakPath(this.mIndexedPaths[0]);
                ProofInfo.access$902(mainProof, new IndexedPath[]{this.mIndexedPaths[0]});
                break;
            }
            case WEAKEQ_EXT: {
                ArrayList<IndexedPath> mPaths = new ArrayList<IndexedPath>();
                assert (this.mIndexedPaths[0].getIndex() == null);
                mainProof.collectWeakPath(this.mIndexedPaths[0]);
                mPaths.add(this.mIndexedPaths[0]);
                for (int i = 0; i < this.mIndexedPaths.length; ++i) {
                    if (this.mIndexedPaths[i].getIndex() == null) continue;
                    mainProof.collectWeakPath(this.mIndexedPaths[i]);
                    mPaths.add(this.mIndexedPaths[i]);
                }
                ProofInfo.access$902(mainProof, mPaths.toArray(new IndexedPath[mPaths.size()]));
                break;
            }
            case DT_CASES: 
            case DT_CONSTRUCTOR: 
            case DT_CYCLE: 
            case DT_DISJOINT: 
            case DT_INJECTIVE: 
            case DT_PROJECT: 
            case DT_TESTER: 
            case DT_UNIQUE: {
                for (SymmetricPair<CCTerm> dependentEq : this.mAnnot.mDTLemma.getReason()) {
                    mainProof.collectEquality(dependentEq);
                }
                ProofInfo.access$902(mainProof, new IndexedPath[0]);
            }
        }
        return mainProof;
    }

    private void determineAllNumParents(ProofInfo mainInfo) {
        ArrayDeque<ProofInfo> todo = new ArrayDeque<ProofInfo>();
        todo.add(mainInfo);
        while (!todo.isEmpty()) {
            ProofInfo proofInfo = (ProofInfo)todo.removeFirst();
            if (proofInfo.getNumParents() == 0) {
                todo.addAll(proofInfo.mSubProofs);
            }
            proofInfo.increaseNumParents();
        }
    }

    private ArrayList<ProofInfo> determineProofOrder(ProofInfo mainInfo) {
        ArrayList<ProofInfo> proofOrder = new ArrayList<ProofInfo>();
        ArrayDeque<ProofInfo> todo = new ArrayDeque<ProofInfo>();
        todo.add(mainInfo);
        while (!todo.isEmpty()) {
            ProofInfo nodeInfo = (ProofInfo)todo.removeFirst();
            nodeInfo.increaseVisitedParentsCounter();
            if (!nodeInfo.haveVisitedAllParents()) continue;
            proofOrder.add(nodeInfo);
            todo.addAll(nodeInfo.getSubProofs());
        }
        return proofOrder;
    }

    /*
     * WARNING - void declaration
     */
    private Term buildLemma(ProofRules proofRules, CCAnnotation.RuleKind rule, ProofInfo info, Term mainEq, HashMap<SymmetricPair<CCTerm>, Term> auxLiterals) {
        void var9_14;
        Theory theory = proofRules.getTheory();
        LinkedHashSet<ProofLiteral> clause = new LinkedHashSet<ProofLiteral>(info.getLiterals().size() + 1 + info.getSubProofs().size());
        if (mainEq != null) {
            clause.add(new ProofLiteral(mainEq, true));
        }
        for (Literal literal : info.getLiterals()) {
            clause.add(new ProofLiteral(literal.getAtom().getSMTFormula(theory), literal.getSign() > 0));
        }
        for (ProofInfo proofInfo : info.getSubProofs()) {
            if (!auxLiterals.containsKey(proofInfo.getDiseq())) {
                Term lhs = proofInfo.getDiseq().getFirst().getFlatTerm();
                Term rhs = proofInfo.getDiseq().getSecond().getFlatTerm();
                auxLiterals.put(proofInfo.getDiseq(), theory.term("=", lhs, rhs));
            }
            clause.add(new ProofLiteral(auxLiterals.get(proofInfo.getDiseq()), false));
        }
        assert (clause.size() == info.getLiterals().size() + (mainEq != null ? 1 : 0) + info.getSubProofs().size());
        ProofLiteral[] args = clause.toArray(new ProofLiteral[clause.size()]);
        if (rule == CCAnnotation.RuleKind.CONG) {
            assert (info.getPaths().length == 1);
            CCTerm[] path = info.getPaths()[0].getPath();
            Term[] subs = new Term[path.length];
            for (int j = 0; j < path.length; ++j) {
                subs[j] = path[j].getFlatTerm();
            }
            rule = subs.length == 2 ? CCAnnotation.RuleKind.CONG : CCAnnotation.RuleKind.TRANS;
            Term[] termArray = subs;
        } else {
            IndexedPath[] paths = info.getPaths();
            SymmetricPair<CCTerm> infoDiseq = info.getDiseq();
            Object[] lemmaAnnot = new Object[]{};
            if (this.mAnnot.mDTLemma != null && this.mAnnot.mDTLemma.getAnnotation() != null) {
                lemmaAnnot = this.mAnnot.mDTLemma.getAnnotation();
            }
            Object[] objectArray = new Object[2 * paths.length + (infoDiseq == null ? 0 : 1) + lemmaAnnot.length];
            int k = 0;
            if (infoDiseq != null) {
                Term diseqTerm = theory.term("=", infoDiseq.getFirst().getFlatTerm(), infoDiseq.getSecond().getFlatTerm());
                objectArray[k++] = diseqTerm;
            }
            for (Object annot : lemmaAnnot) {
                objectArray[k++] = annot;
            }
            for (IndexedPath p : paths) {
                CCTerm index = p.getIndex();
                CCTerm[] path = p.getPath();
                Term[] subs = new Term[path.length];
                for (int j = 0; j < path.length; ++j) {
                    subs[j] = path[j].getFlatTerm();
                }
                if (index == null) {
                    objectArray[k++] = ":subpath";
                    objectArray[k++] = subs;
                    continue;
                }
                objectArray[k++] = ":weakpath";
                objectArray[k++] = new Object[]{index.getFlatTerm(), subs};
            }
        }
        Annotation[] annots = new Annotation[]{new Annotation(rule.getKind(), var9_14)};
        return proofRules.oracle(args, annots);
    }

    private Term buildProofTerm(Clause clause, ProofRules proofRules, ArrayList<ProofInfo> proofOrder) {
        Theory theory = proofRules.getTheory();
        HashMap<SymmetricPair<CCTerm>, Term> auxLiterals = new HashMap<SymmetricPair<CCTerm>, Term>();
        ProofInfo mainInfo = proofOrder.get(0);
        assert (mainInfo.getDiseq() == this.mAnnot.getDiseq());
        Term mainEq = mainInfo.getDiseq() == null || !this.isDisequalityLiteral(mainInfo.getDiseq()) ? null : this.mEqualityLiterals.get(mainInfo.getDiseq()).getSMTFormula(theory);
        Term proof = this.buildLemma(proofRules, this.mRule, mainInfo, mainEq, auxLiterals);
        for (int lemmaNo = 1; lemmaNo < proofOrder.size(); ++lemmaNo) {
            ProofInfo info = proofOrder.get(lemmaNo);
            assert (auxLiterals.containsKey(info.getDiseq()));
            Term provedEq = auxLiterals.get(info.getDiseq());
            Term lemma = this.buildLemma(proofRules, CCAnnotation.RuleKind.CONG, info, provedEq, auxLiterals);
            proof = proofRules.resolutionRule(provedEq, lemma, proof);
        }
        return proof;
    }

    private boolean isEqualityLiteral(SymmetricPair<CCTerm> termPair) {
        return this.mEqualityLiterals.containsKey(termPair) && this.mEqualityLiterals.get(termPair).getSign() < 0;
    }

    private boolean isDisequalityLiteral(SymmetricPair<CCTerm> termPair) {
        return this.mEqualityLiterals.containsKey(termPair) && this.mEqualityLiterals.get(termPair).getSign() > 0;
    }

    private boolean isTrivialDisequality(SymmetricPair<CCTerm> termPair) {
        CCTerm first = termPair.getFirst();
        CCTerm second = termPair.getSecond();
        SMTAffineTerm smtAffine = SMTAffineTerm.create(first.getFlatTerm());
        smtAffine.add(Rational.MONE, second.getFlatTerm());
        if (smtAffine.isConstant()) {
            return smtAffine.getConstant() != Rational.ZERO;
        }
        return smtAffine.isAllIntSummands() && !smtAffine.getConstant().div(smtAffine.getGcd()).isIntegral();
    }

    private ProofInfo findCongruencePaths(CCTerm first, CCTerm second) {
        ProofInfo proofInfo = new ProofInfo();
        proofInfo.mLemmaDiseq = new SymmetricPair<CCTerm>(first, second);
        ProofInfo.access$902(proofInfo, new IndexedPath[]{new IndexedPath(null, new CCTerm[]{first, second})});
        while (first != second) {
            if (!(first instanceof CCAppTerm) || !(second instanceof CCAppTerm)) {
                return null;
            }
            CCTerm firstArg = ((CCAppTerm)first).getArg();
            CCTerm secondArg = ((CCAppTerm)second).getArg();
            SymmetricPair<CCTerm> argPair = new SymmetricPair<CCTerm>(firstArg, secondArg);
            if (firstArg != secondArg) {
                if (this.isEqualityLiteral(argPair)) {
                    proofInfo.mProofLiterals.add(this.mEqualityLiterals.get(argPair));
                } else if (this.mPathProofMap.containsKey(argPair)) {
                    proofInfo.mSubProofs.add(this.mPathProofMap.get(argPair));
                } else {
                    return null;
                }
            }
            first = ((CCAppTerm)first).getFunc();
            second = ((CCAppTerm)second).getFunc();
        }
        return proofInfo;
    }

    private SelectEdge findSelectPath(SymmetricPair<CCTerm> termPair, CCTerm weakpathindex) {
        CCTerm value;
        if (ArrayTheory.isConstTerm(termPair.getFirst()) && this.isSelect(value = ArrayTheory.getValueFromConst((CCAppTerm)termPair.getFirst()), termPair.getSecond(), weakpathindex)) {
            return new SelectEdge(value, value);
        }
        if (ArrayTheory.isConstTerm(termPair.getSecond()) && this.isSelect(value = ArrayTheory.getValueFromConst((CCAppTerm)termPair.getSecond()), termPair.getFirst(), weakpathindex)) {
            return new SelectEdge(value, value);
        }
        for (SymmetricPair symmetricPair : this.mAllEqualities) {
            CCTerm end;
            CCTerm start = (CCTerm)symmetricPair.getFirst();
            if (this.isGoodSelectStep(start, end = (CCTerm)symmetricPair.getSecond(), termPair, weakpathindex)) {
                return new SelectEdge(start, end);
            }
            if (!this.isGoodSelectStep(end, start, termPair, weakpathindex)) continue;
            return new SelectEdge(end, start);
        }
        return null;
    }

    private boolean isGoodSelectStep(CCTerm sel1, CCTerm sel2, SymmetricPair<CCTerm> termPair, CCTerm weakpathindex) {
        return !(!this.isSelect(sel1, termPair.getFirst(), weakpathindex) && !this.isConst(termPair.getFirst(), sel1) || !this.isSelect(sel2, termPair.getSecond(), weakpathindex) && !this.isConst(termPair.getSecond(), sel2));
    }

    private boolean isSelect(CCTerm select, CCTerm array, CCTerm weakpathindex) {
        if (!ArrayTheory.isSelectTerm(select) || ArrayTheory.getArrayFromSelect((CCAppTerm)select) != array) {
            return false;
        }
        CCTerm index = ArrayTheory.getIndexFromSelect((CCAppTerm)select);
        return index == weakpathindex || this.mAllEqualities.contains(new SymmetricPair<CCTerm>(weakpathindex, index));
    }

    private boolean isConst(CCTerm array, CCTerm value) {
        return ArrayTheory.isConstTerm(array) && ArrayTheory.getValueFromConst((CCAppTerm)array) == value;
    }

    private class ProofInfo {
        private SymmetricPair<CCTerm> mLemmaDiseq = null;
        private final Collection<Literal> mProofLiterals = new LinkedHashSet<Literal>();
        private IndexedPath[] mProofPaths;
        private final Set<ProofInfo> mSubProofs = new LinkedHashSet<ProofInfo>();
        private int mNumParents = 0;
        private int mNumVisitedParents = 0;

        public SymmetricPair<CCTerm> getDiseq() {
            return this.mLemmaDiseq;
        }

        public Collection<Literal> getLiterals() {
            return this.mProofLiterals;
        }

        public IndexedPath[] getPaths() {
            return this.mProofPaths;
        }

        public Collection<ProofInfo> getSubProofs() {
            return this.mSubProofs;
        }

        public int getNumParents() {
            return this.mNumParents;
        }

        public void increaseNumParents() {
            ++this.mNumParents;
        }

        public void increaseVisitedParentsCounter() {
            ++this.mNumVisitedParents;
        }

        public boolean haveVisitedAllParents() {
            return this.mNumParents == this.mNumVisitedParents;
        }

        private boolean collectEquality(SymmetricPair<CCTerm> termPair) {
            if (CCProofGenerator.this.isEqualityLiteral(termPair)) {
                this.mProofLiterals.add((Literal)CCProofGenerator.this.mEqualityLiterals.get(termPair));
                return true;
            }
            if (CCProofGenerator.this.mPathProofMap.containsKey(termPair)) {
                this.mSubProofs.add((ProofInfo)CCProofGenerator.this.mPathProofMap.get(termPair));
                return true;
            }
            ProofInfo congruence = CCProofGenerator.this.findCongruencePaths(termPair.getFirst(), termPair.getSecond());
            if (congruence == null) {
                return false;
            }
            CCProofGenerator.this.mPathProofMap.put(termPair, congruence);
            this.mSubProofs.add(congruence);
            return true;
        }

        private void collectStrongPath(IndexedPath indexedPath) {
            assert (indexedPath.getIndex() == null);
            CCTerm[] path = indexedPath.getPath();
            for (int i = 0; i < path.length - 1; ++i) {
                CCTerm firstTerm = path[i];
                CCTerm secondTerm = path[i + 1];
                SymmetricPair<CCTerm> termPair = new SymmetricPair<CCTerm>(firstTerm, secondTerm);
                if (this.collectEquality(termPair)) continue;
                throw new IllegalArgumentException("Cannot explain term pair " + termPair.toString());
            }
        }

        private void collectSelectIndexEquality(CCTerm select, CCTerm pathIndex) {
            CCTerm index;
            if (ArrayTheory.isSelectTerm(select) && (index = ArrayTheory.getIndexFromSelect((CCAppTerm)select)) != pathIndex && !this.collectEquality(new SymmetricPair<CCTerm>(pathIndex, index))) {
                throw new AssertionError((Object)("Cannot find select index equality " + pathIndex + " = " + index));
            }
        }

        private void collectWeakPath(IndexedPath indexedPath) {
            assert (indexedPath.getIndex() != null || CCProofGenerator.this.mRule == CCAnnotation.RuleKind.WEAKEQ_EXT || CCProofGenerator.this.mRule == CCAnnotation.RuleKind.CONST_WEAKEQ);
            CCTerm pathIndex = indexedPath.getIndex();
            CCTerm[] path = indexedPath.getPath();
            for (int i = 0; i < path.length - 1; ++i) {
                SelectEdge selectEdge;
                CCTerm firstTerm = path[i];
                CCTerm secondTerm = path[i + 1];
                SymmetricPair<CCTerm> termPair = new SymmetricPair<CCTerm>(firstTerm, secondTerm);
                if (this.collectEquality(termPair)) continue;
                CCTerm storeTerm = null;
                if (ArrayTheory.isStoreTerm(firstTerm) && ArrayTheory.getArrayFromStore((CCAppTerm)firstTerm) == secondTerm) {
                    storeTerm = firstTerm;
                } else if (ArrayTheory.isStoreTerm(secondTerm) && ArrayTheory.getArrayFromStore((CCAppTerm)secondTerm) == firstTerm) {
                    storeTerm = secondTerm;
                }
                if (storeTerm != null) {
                    if (pathIndex == null) continue;
                    CCTerm storeIndex = ArrayTheory.getIndexFromStore((CCAppTerm)storeTerm);
                    SymmetricPair<CCTerm> indexPair = new SymmetricPair<CCTerm>(pathIndex, storeIndex);
                    if (CCProofGenerator.this.isDisequalityLiteral(indexPair)) {
                        this.mProofLiterals.add((Literal)CCProofGenerator.this.mEqualityLiterals.get(indexPair));
                        continue;
                    }
                    if (CCProofGenerator.this.isTrivialDisequality(indexPair)) continue;
                }
                if (CCProofGenerator.this.mRule == CCAnnotation.RuleKind.WEAKEQ_EXT && pathIndex != null && (selectEdge = CCProofGenerator.this.findSelectPath(termPair, pathIndex)) != null) {
                    if (selectEdge.getLeft() != selectEdge.getRight() && !this.collectEquality(selectEdge.toSymmetricPair())) {
                        throw new AssertionError((Object)("Cannot find select edge " + selectEdge));
                    }
                    if (!CCProofGenerator.this.isConst(firstTerm, selectEdge.getLeft())) {
                        this.collectSelectIndexEquality(selectEdge.getLeft(), pathIndex);
                    }
                    if (CCProofGenerator.this.isConst(secondTerm, selectEdge.getRight())) continue;
                    this.collectSelectIndexEquality(selectEdge.getRight(), pathIndex);
                    continue;
                }
                throw new IllegalArgumentException("Cannot explain term pair " + termPair.toString());
            }
        }

        public String toString() {
            return "Proof[" + this.mLemmaDiseq + "]";
        }

        static /* synthetic */ IndexedPath[] access$902(ProofInfo x0, IndexedPath[] x1) {
            x0.mProofPaths = x1;
            return x1;
        }
    }

    private static class SelectEdge {
        private final CCTerm mLeft;
        private final CCTerm mRight;

        public SelectEdge(CCTerm left, CCTerm right) {
            this.mLeft = left;
            this.mRight = right;
        }

        public SymmetricPair<CCTerm> toSymmetricPair() {
            return new SymmetricPair<CCTerm>(this.mLeft, this.mRight);
        }

        public CCTerm getLeft() {
            return this.mLeft;
        }

        public CCTerm getRight() {
            return this.mRight;
        }

        public String toString() {
            return this.mLeft + " <-> " + this.mRight;
        }
    }

    private static class IndexedPath {
        private final CCTerm mIndex;
        private final CCTerm[] mPath;

        public IndexedPath(CCTerm index, CCTerm[] path) {
            this.mIndex = index;
            this.mPath = path;
        }

        public CCTerm getIndex() {
            return this.mIndex;
        }

        public CCTerm[] getPath() {
            return this.mPath;
        }

        public SymmetricPair<CCTerm> getPathEnds() {
            return new SymmetricPair<CCTerm>(this.mPath[0], this.mPath[this.mPath.length - 1]);
        }

        public String toString() {
            return this.mIndex + ": " + Arrays.toString(this.mPath);
        }
    }
}

