/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTermPairHash;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CompareTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;
import java.util.Collections;
import java.util.List;

public abstract class CCTerm
extends SimpleListable<CCTerm> {
    CCTerm mEqualEdge;
    CCTerm mRepStar;
    CCTerm mRep;
    CCTerm mOldRep;
    CCEquality mReasonLiteral;
    int mMergeTime = Integer.MAX_VALUE;
    CCParentInfo mCCPars;
    SimpleList<CCTerm> mMembers;
    int mNumMembers;
    SimpleList<CCTermPairHash.Info.Entry> mPairInfos;
    CCTerm mSharedTerm;
    Term mFlatTerm;
    int mHashCode;
    final int mAge;
    boolean mIsFunc;
    int mParentPosition;

    protected CCTerm(boolean isFunc, int parentPos, int hash, int age) {
        this.mIsFunc = isFunc;
        this.mCCPars = null;
        if (isFunc) {
            this.mParentPosition = parentPos;
        }
        this.mCCPars = new CCParentInfo();
        this.mRep = this.mRepStar = this;
        this.mMembers = new SimpleList();
        this.mPairInfos = new SimpleList();
        this.mMembers.append(this);
        this.mNumMembers = 1;
        assert (this.invariant());
        this.mHashCode = hash;
        this.mAge = age;
    }

    public boolean isFunc() {
        return this.mIsFunc;
    }

    boolean pairHashValid(CClosure engine) {
        return true;
    }

    final boolean invariant() {
        return true;
    }

    public final CCTerm getRepresentative() {
        return this.mRepStar;
    }

    public final boolean isRepresentative() {
        return this.mRep == this;
    }

    public void share(CClosure engine) {
        boolean weWin;
        CCTerm oldShared;
        assert (this.mSharedTerm != this);
        engine.getLogger().debug("CC-Share %s", this);
        CCTerm term = this;
        if (this.mSharedTerm != null) {
            oldShared = this.mSharedTerm;
            weWin = true;
        } else {
            term.mSharedTerm = this;
            while (term.mRep.mSharedTerm == null) {
                term = term.mRep;
                term.mSharedTerm = this;
            }
            if (term != term.mRep) {
                CCTerm rep = term.mRep;
                assert (rep.mSharedTerm != null);
                oldShared = rep.mSharedTerm;
                if (oldShared == rep) {
                    weWin = false;
                } else {
                    CCTerm otherTerm = oldShared;
                    while (otherTerm.mRep != rep) {
                        otherTerm = otherTerm.mRep;
                    }
                    assert (otherTerm.mRep == rep && term.mRep == rep);
                    assert (otherTerm != term);
                    weWin = term.mMergeTime < otherTerm.mMergeTime;
                }
                term = rep;
            } else {
                oldShared = null;
                weWin = true;
            }
        }
        if (oldShared != null) {
            if (weWin) {
                while (term.mSharedTerm == oldShared) {
                    term.mSharedTerm = this;
                    term = term.mRep;
                }
            }
            this.propagateSharedEquality(engine, oldShared);
        }
    }

    public void unshare() {
        assert (this.mSharedTerm == this);
        assert (this.isRepresentative());
        this.mSharedTerm = null;
    }

    private void propagateSharedEquality(CClosure engine, CCTerm otherSharedTerm) {
        assert (this.mRepStar == otherSharedTerm.mRepStar);
        CCEquality cceq = engine.createEquality(this, otherSharedTerm, true);
        assert (cceq != null);
        if (engine.getLogger().isDebugEnabled()) {
            engine.getLogger().debug("PL: %s", cceq);
        }
        if (cceq.getDecideStatus() == null) {
            assert (engine.mPendingLits.contains(cceq));
        } else if (cceq.getLASharedData().getDecideStatus() == null) {
            assert (cceq.getDecideStatus() == cceq);
            engine.addPending(cceq.getLASharedData());
            engine.mRecheckOnBacktrackLits.add(cceq);
        }
    }

    public void invertEqualEdges(CClosure engine) {
        if (this.mEqualEdge == null) {
            return;
        }
        long time = System.nanoTime();
        CCTerm last = null;
        CCTerm lastRep = null;
        CCTerm next = this;
        while (next != null) {
            CCTerm t = next;
            next = next.mEqualEdge;
            t.mEqualEdge = last;
            CCTerm nextRep = t.mOldRep;
            t.mOldRep = lastRep;
            last = t;
            lastRep = nextRep;
        }
        engine.addInvertEdgeTime(System.nanoTime() - time);
    }

    public Clause merge(CClosure engine, CCTerm lhs, CCEquality reason) {
        Clause res;
        assert (reason != null || this instanceof CCAppTerm && lhs instanceof CCAppTerm);
        CCTerm src = lhs.mRepStar;
        CCTerm dest = this.mRepStar;
        assert (src.invariant());
        assert (src.pairHashValid(engine));
        assert (dest.invariant());
        assert (dest.pairHashValid(engine));
        if (src == dest) {
            return null;
        }
        engine.incMergeCount();
        if (src.mNumMembers > dest.mNumMembers) {
            res = lhs.mergeInternal(engine, this, reason);
            if (res == null && reason == null) {
                ((CCAppTerm)this).markParentInfos();
            }
        } else {
            res = this.mergeInternal(engine, lhs, reason);
            if (res == null && reason == null) {
                ((CCAppTerm)lhs).markParentInfos();
            }
        }
        assert (this.invariant());
        assert (lhs.invariant());
        assert (this.mRepStar.pairHashValid(engine));
        return res;
    }

    private Clause mergeInternal(CClosure engine, CCTerm lhs, CCEquality reason) {
        CCAppTerm t;
        CCParentInfo destParentInfo;
        CCParentInfo srcParentInfo;
        CCTerm src = lhs.mRepStar;
        CCTerm dest = this.mRepStar;
        CCEquality diseq = null;
        CCTermPairHash.Info diseqInfo = engine.mPairHash.getInfo(src, dest);
        if (diseqInfo != null) {
            diseq = diseqInfo.mDiseq;
        }
        boolean sharedTermConflict = false;
        if (diseq == null && src.mSharedTerm != null) {
            if (dest.mSharedTerm == null) {
                dest.mSharedTerm = src.mSharedTerm;
            } else {
                boolean createInLA = dest.mSharedTerm.mFlatTerm.getSort().isNumericSort();
                CCEquality cceq = engine.createEquality(src.mSharedTerm, dest.mSharedTerm, createInLA);
                sharedTermConflict = cceq == null;
            }
        }
        lhs.invertEqualEdges(engine);
        lhs.mEqualEdge = this;
        lhs.mOldRep = src;
        src.mReasonLiteral = reason;
        if (sharedTermConflict || diseq != null) {
            Clause conflict = sharedTermConflict ? engine.computeCycle(src.mSharedTerm, dest.mSharedTerm) : engine.computeCycle(diseq);
            lhs.mEqualEdge = null;
            lhs.mOldRep = null;
            src.mReasonLiteral = null;
            return conflict;
        }
        src.mMergeTime = engine.getMergeDepth();
        engine.recordMerge(lhs);
        engine.getLogger().debug("M %s %s", this, lhs);
        long time = System.nanoTime();
        src.mRep = dest;
        for (CCTerm t2 : src.mMembers) {
            t2.mRepStar = dest;
        }
        engine.addSetRepTime(System.nanoTime() - time);
        dest.mMembers.joinList(src.mMembers);
        dest.mNumMembers += src.mNumMembers;
        time = System.nanoTime();
        for (CCTermPairHash.Info.Entry pentry : src.mPairInfos) {
            CCTermPairHash.Info info = pentry.getInfo();
            assert (pentry.getOtherEntry().mOther == src);
            CCTerm other = pentry.mOther;
            assert (other.mRepStar == other);
            if (other == dest) {
                assert (info.mDiseq == null);
                for (CCEquality.Entry eq : info.mEqlits) {
                    engine.addPending(eq.getCCEquality());
                }
                for (CompareTrigger trigger : info.mCompareTriggers) {
                    trigger.activate();
                }
            } else {
                CCTermPairHash.Info destInfo = engine.mPairHash.getInfo(dest, other);
                if (destInfo == null) {
                    destInfo = new CCTermPairHash.Info(dest, other);
                    engine.mPairHash.add(destInfo);
                }
                if (destInfo.mDiseq == null && info.mDiseq != null) {
                    destInfo.mDiseq = info.mDiseq;
                    for (CCEquality.Entry eq : destInfo.mEqlits) {
                        assert (eq.getCCEquality().getDecideStatus() != eq.getCCEquality());
                        if (eq.getCCEquality().getDecideStatus() != null) continue;
                        eq.getCCEquality().mDiseqReason = info.mDiseq;
                        engine.addPending(eq.getCCEquality().negate());
                    }
                } else if (destInfo.mDiseq != null && info.mDiseq == null) {
                    for (CCEquality.Entry eq : info.mEqlits) {
                        assert (eq.getCCEquality().getDecideStatus() != eq.getCCEquality());
                        if (eq.getCCEquality().getDecideStatus() != null) continue;
                        eq.getCCEquality().mDiseqReason = destInfo.mDiseq;
                        engine.addPending(eq.getCCEquality().negate());
                    }
                }
                destInfo.mEqlits.joinList(info.mEqlits);
                destInfo.mCompareTriggers.joinList(info.mCompareTriggers);
            }
            pentry.getOtherEntry().unlink();
            assert (other.mPairInfos.wellformed());
            engine.removePairHash(info);
        }
        engine.addEqTime(System.nanoTime() - time);
        time = System.nanoTime();
        if (this.mIsFunc) {
            srcParentInfo = src.mCCPars.mNext;
            destParentInfo = dest.mCCPars.mNext;
            if (srcParentInfo != null) {
                assert (srcParentInfo.mFuncSymbNr == destParentInfo.mFuncSymbNr);
                assert (srcParentInfo.mReverseTriggers.isEmpty());
                block6: for (CCAppTerm.Parent t1 : srcParentInfo.mCCParents) {
                    if (t1.isMarked()) continue;
                    t = t1.getData();
                    for (CCAppTerm.Parent u1 : destParentInfo.mCCParents) {
                        if (u1.isMarked()) continue;
                        engine.incCcCount();
                        if (t.mArg.mRepStar != u1.getData().mArg.mRepStar) continue;
                        engine.addPendingCongruence(t, u1.getData());
                        continue block6;
                    }
                }
                destParentInfo.mCCParents.joinList(srcParentInfo.mCCParents);
            }
        } else {
            srcParentInfo = src.mCCPars.mNext;
            destParentInfo = dest.mCCPars.mNext;
            while (srcParentInfo != null && destParentInfo != null) {
                List<CCTerm> appTerms;
                if (srcParentInfo.mFuncSymbNr < destParentInfo.mFuncSymbNr) {
                    srcParentInfo = srcParentInfo.mNext;
                    continue;
                }
                if (srcParentInfo.mFuncSymbNr > destParentInfo.mFuncSymbNr) {
                    destParentInfo = destParentInfo.mNext;
                    continue;
                }
                assert (srcParentInfo.mFuncSymbNr == destParentInfo.mFuncSymbNr);
                block9: for (CCAppTerm.Parent t1 : srcParentInfo.mCCParents) {
                    if (t1.isMarked()) continue;
                    t = t1.getData();
                    for (CCAppTerm.Parent u1 : destParentInfo.mCCParents) {
                        if (u1.isMarked()) continue;
                        engine.incCcCount();
                        if (t.mFunc.mRepStar != u1.getData().mFunc.mRepStar) continue;
                        engine.addPendingCongruence(t, u1.getData());
                        continue block9;
                    }
                }
                if (!srcParentInfo.mReverseTriggers.isEmpty()) {
                    for (CCAppTerm.Parent parent : destParentInfo.mCCParents) {
                        if (parent.isMarked()) continue;
                        appTerms = Collections.singletonList(parent.getData());
                        while (((CCTerm)appTerms.get((int)0)).mIsFunc) {
                            appTerms = CClosure.getApplications(appTerms);
                        }
                        for (CCTerm appTerm : appTerms) {
                            for (ReverseTrigger trigger : srcParentInfo.mReverseTriggers) {
                                trigger.activate((CCAppTerm)appTerm, false);
                            }
                        }
                    }
                }
                if (!destParentInfo.mReverseTriggers.isEmpty()) {
                    for (CCAppTerm.Parent parent : srcParentInfo.mCCParents) {
                        if (parent.isMarked()) continue;
                        appTerms = Collections.singletonList(parent.getData());
                        while (((CCTerm)appTerms.get((int)0)).mIsFunc) {
                            appTerms = CClosure.getApplications(appTerms);
                        }
                        for (CCTerm appTerm : appTerms) {
                            for (ReverseTrigger trigger : destParentInfo.mReverseTriggers) {
                                trigger.activate((CCAppTerm)appTerm, false);
                            }
                        }
                    }
                }
                srcParentInfo = srcParentInfo.mNext;
                destParentInfo = destParentInfo.mNext;
            }
            dest.mCCPars.mergeParentInfo(src.mCCPars);
        }
        engine.addCcTime(System.nanoTime() - time);
        assert (this.invariant());
        assert (lhs.invariant());
        assert (src.invariant());
        assert (dest.invariant());
        return null;
    }

    public void undoMerge(CClosure engine, CCTerm lhs) {
        engine.getLogger().debug("U %s %s", lhs, this);
        assert (this.invariant());
        assert (lhs.invariant());
        assert (this.mRepStar.pairHashValid(engine));
        assert (this.mEqualEdge == lhs);
        assert (this.mRepStar == lhs.mRepStar);
        CCTerm src = this.mOldRep;
        this.mEqualEdge = null;
        this.mOldRep = null;
        CCTerm dest = this.mRepStar;
        assert (src.mRep == dest);
        dest.mCCPars.unmergeParentInfo(src.mCCPars);
        if (src.mReasonLiteral == null) {
            ((CCAppTerm)this).unmarkParentInfos();
        }
        src.mReasonLiteral = null;
        for (CCTermPairHash.Info.Entry pentry : src.mPairInfos.reverse()) {
            CCTermPairHash.Info destInfo;
            CCTermPairHash.Info info = pentry.getInfo();
            assert (pentry.getOtherEntry().mOther == src);
            engine.mPairHash.add(pentry.getInfo());
            assert (pentry.mOther.mPairInfos.wellformed());
            pentry.mOther.mPairInfos.append(pentry.getOtherEntry());
            assert (pentry.mOther.mPairInfos.wellformed());
            CCTerm other = pentry.mOther;
            assert (other.mRepStar == other);
            if (other == dest || (destInfo = engine.mPairHash.getInfo(dest, other)) == null) continue;
            destInfo.mCompareTriggers.unjoinList(info.mCompareTriggers);
            assert (destInfo.mEqlits.wellformed());
            destInfo.mEqlits.unjoinList(info.mEqlits);
            assert (info.mEqlits.wellformed() && destInfo.mEqlits.wellformed());
            if (destInfo.mDiseq == info.mDiseq) {
                destInfo.mDiseq = null;
            }
            if (destInfo.mDiseq != null || !destInfo.mEqlits.isEmpty() || !destInfo.mCompareTriggers.isEmpty()) continue;
            destInfo.mLhsEntry.unlink();
            destInfo.mRhsEntry.unlink();
            engine.removePairHash(destInfo);
        }
        dest.mNumMembers -= src.mNumMembers;
        long time = System.nanoTime();
        dest.mMembers.unjoinList(src.mMembers);
        for (CCTerm t : src.mMembers) {
            t.mRepStar = src;
        }
        src.mRep = src;
        assert (src.mMergeTime == engine.getMergeDepth());
        src.mMergeTime = Integer.MAX_VALUE;
        engine.addSetRepTime(System.nanoTime() - time);
        if (dest.mSharedTerm == src.mSharedTerm) {
            dest.mSharedTerm = null;
        }
        assert (this.invariant());
        assert (lhs.invariant());
        assert (src.invariant());
        assert (dest.invariant());
        assert (src.pairHashValid(engine));
        assert (dest.pairHashValid(engine));
    }

    public CCTerm getSharedTerm() {
        return this.mSharedTerm;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public Term getFlatTerm() {
        return this.mFlatTerm;
    }

    public int getNumMembers() {
        return this.mNumMembers;
    }

    public int getAge() {
        return this.mAge;
    }

    static class CongruenceInfo {
        CCAppTerm mAppTerm1;
        CCAppTerm mAppTerm2;
        boolean mMerged;
        CongruenceInfo mNext;

        public CongruenceInfo(CCAppTerm app1, CCAppTerm app2, CongruenceInfo next) {
            this.mAppTerm1 = app1;
            this.mAppTerm2 = app2;
            this.mNext = next;
        }
    }

    static class TermPairMergeInfo {
        CCTermPairHash.Info.Entry mInfo;
        TermPairMergeInfo mNext;

        public TermPairMergeInfo(CCTermPairHash.Info.Entry i, TermPairMergeInfo n) {
            this.mInfo = i;
            this.mNext = n;
        }
    }
}

