/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTermPairHash;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CompareTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ModelBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.EQAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ArrayQueue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CClosure
implements ITheory {
    final Clausifier mClausifier;
    final Map<Term, CCTerm> mAnonTerms = new HashMap<Term, CCTerm>();
    final ScopedArrayList<CCTerm> mAllTerms = new ScopedArrayList();
    final CCTermPairHash mPairHash = new CCTermPairHash();
    final ArrayQueue<Literal> mPendingLits = new ArrayQueue();
    ArrayQueue<Literal> mRecheckOnBacktrackLits = new ArrayQueue();
    ArrayQueue<SymmetricPair<CCAppTerm>> mRecheckOnBacktrackCongs = new ArrayQueue();
    final ScopedHashMap<Object, CCBaseTerm> mSymbolicTerms = new ScopedHashMap();
    final ArrayList<Integer> mNumFunctionPositionsStack = new ArrayList();
    int mNumFunctionPositions;
    final ArrayDeque<UndoInfo> mUndoStack = new ArrayDeque();
    final ArrayDeque<Integer> mDecideLevelToUndoStackSize = new ArrayDeque();
    final ArrayDeque<SymmetricPair<CCAppTerm>> mPendingCongruences = new ArrayDeque();
    private long mInvertEdgeTime;
    private long mEqTime;
    private long mCcTime;
    private long mSetRepTime;
    private long mCcCount;
    private long mMergeCount;

    public CClosure(Clausifier clausifier) {
        this.mClausifier = clausifier;
    }

    public DPLLEngine getEngine() {
        return this.mClausifier.getEngine();
    }

    public LogProxy getLogger() {
        return this.mClausifier.getLogger();
    }

    public boolean isProofGenerationEnabled() {
        return this.getEngine().isProofGenerationEnabled();
    }

    public CCTerm createAnonTerm(Term term) {
        CCBaseTerm ccTerm = new CCBaseTerm(false, this.mNumFunctionPositions, term);
        this.mAllTerms.add(ccTerm);
        this.mAnonTerms.put(term, ccTerm);
        return ccTerm;
    }

    private int getMergeStackDepth(CCTerm t1, CCTerm t2) {
        assert (t1.getRepresentative() == t2.getRepresentative()) : "terms were never merged";
        if (t1 == t2) {
            return -1;
        }
        int depth1 = 0;
        int depth2 = 0;
        CCTerm t = t1;
        while (t != t.mRep) {
            ++depth1;
            t = t.mRep;
        }
        t = t2;
        while (t != t.mRep) {
            ++depth2;
            t = t.mRep;
        }
        while (depth1 > depth2) {
            if (t1.mRep == t2) {
                return t1.mMergeTime;
            }
            t1 = t1.mRep;
            --depth1;
        }
        assert (t1 != t2);
        while (depth2 > depth1) {
            if (t2.mRep == t1) {
                return t2.mMergeTime;
            }
            t2 = t2.mRep;
            --depth2;
        }
        assert (t1 != t2);
        assert (depth2 == depth1);
        while (true) {
            assert (t1 != t2);
            assert (t1 != t1.mRep);
            assert (t2 != t2.mRep);
            if (t1.mRep == t2.mRep) {
                return Math.max(t1.mMergeTime, t2.mMergeTime);
            }
            t1 = t1.mRep;
            t2 = t2.mRep;
        }
    }

    private CCAppTerm findCongruentAppTerm(CCTerm func, CCTerm arg) {
        CCParentInfo argInfo = arg.getRepresentative().mCCPars.getInfo(func.mParentPosition);
        int congruenceLevel = Integer.MAX_VALUE;
        CCAppTerm congruentTerm = null;
        for (CCAppTerm.Parent p : argInfo.mCCParents) {
            int level;
            CCAppTerm papp = p.getData();
            CCTerm pfunc = papp.getFunc();
            CCTerm parg = papp.getArg();
            assert (parg.getRepresentative() == arg.getRepresentative());
            if (pfunc.getRepresentative() != func.getRepresentative() || pfunc == func && parg == arg || (level = Math.max(this.getMergeStackDepth(pfunc, func), this.getMergeStackDepth(parg, arg))) >= congruenceLevel) continue;
            congruenceLevel = level;
            congruentTerm = papp;
        }
        return congruentTerm;
    }

    public CCAppTerm createAppTerm(boolean isFunc, CCTerm func, CCTerm arg, SourceAnnotation source) {
        assert (func.mIsFunc);
        CCParentInfo info = arg.mRepStar.mCCPars.getExistingParentInfo(func.mParentPosition);
        if (info != null) {
            SimpleList<CCAppTerm.Parent> prevParents = info.mCCParents;
            assert (prevParents.wellformed());
            for (CCAppTerm.Parent termpar : prevParents) {
                CCAppTerm term = termpar.getData();
                if (term.mFunc != func || term.mArg != arg) continue;
                return term;
            }
        }
        CCAppTerm term = new CCAppTerm(isFunc, isFunc ? func.mParentPosition + 1 : 0, func, arg, this, source.isFromQuantTheory());
        if (!isFunc && term.getAge() > 0) {
            this.getLogger().debug("Create new AppTerm %s of age %d", term, term.getAge());
        }
        this.mAllTerms.add(term);
        term.addParentInfo(this);
        CCAppTerm congruentTerm = this.findCongruentAppTerm(func, arg);
        this.getLogger().debug("createAppTerm %s congruent: %s", term, congruentTerm);
        if (congruentTerm != null) {
            this.mRecheckOnBacktrackCongs.add(new SymmetricPair<CCAppTerm>(term, congruentTerm));
            this.addPendingCongruence(term, congruentTerm);
        }
        if (!isFunc) {
            CCTerm partialApp = term;
            while (partialApp instanceof CCAppTerm) {
                CCAppTerm app = partialApp;
                CCTerm appArg = app.getArg();
                int parentpos = app.getFunc().mParentPosition;
                CCParentInfo argInfo = appArg.getRepresentative().mCCPars.getInfo(parentpos);
                if (argInfo != null) {
                    for (ReverseTrigger trigger : argInfo.mReverseTriggers) {
                        trigger.activate(term, true);
                    }
                }
                partialApp = app.getFunc();
            }
            CCParentInfo funcInfo = partialApp.mCCPars.getInfo(0);
            if (funcInfo != null) {
                for (ReverseTrigger trigger : funcInfo.mReverseTriggers) {
                    trigger.activate(term, true);
                }
            }
        }
        return term;
    }

    public CCTerm getFuncTerm(FunctionSymbol sym) {
        CCBaseTerm term = this.mSymbolicTerms.get(sym);
        if (term == null) {
            term = new CCBaseTerm(sym.getParameterSorts().length > 0, this.mNumFunctionPositions, sym);
            this.mAllTerms.add(term);
            this.mNumFunctionPositions += sym.getParameterSorts().length;
            this.mSymbolicTerms.put(sym, term);
        }
        return term;
    }

    public Collection<CCTerm> getArgTermsForFunc(FunctionSymbol sym, int argPos) {
        assert (sym.getParameterSorts().length > argPos);
        ArrayList<CCTerm> args = new ArrayList<CCTerm>();
        List<CCTerm> parents = new ArrayList<CCTerm>();
        parents.add(this.getFuncTerm(sym));
        for (int i = 0; i <= argPos; ++i) {
            parents = CClosure.getApplications(parents);
        }
        for (CCTerm par : parents) {
            assert (par instanceof CCAppTerm);
            args.add(((CCAppTerm)par).getArg());
        }
        return args;
    }

    public List<CCTerm> getAllFuncApps(FunctionSymbol sym) {
        List<CCTerm> parents = Collections.singletonList(this.getFuncTerm(sym));
        for (int i = 0; i < sym.getParameterSorts().length; ++i) {
            parents = CClosure.getApplications(parents);
        }
        return parents;
    }

    static List<CCTerm> getApplications(List<CCTerm> partialFunctions) {
        ArrayList<CCTerm> applications = new ArrayList<CCTerm>();
        for (CCTerm funcTerm : partialFunctions) {
            CCParentInfo info = funcTerm.getRepresentative().mCCPars.getInfo(0);
            if (info == null) continue;
            for (CCAppTerm.Parent grandparent : info.mCCParents) {
                applications.add(grandparent.getData());
            }
        }
        return applications;
    }

    public List<CCTerm> getAllFuncAppsForArg(FunctionSymbol sym, CCTerm arg, int argPos) {
        CCTerm funcTerm = this.getFuncTerm(sym);
        int parentPosition = funcTerm.mParentPosition + argPos;
        CCParentInfo info = arg.getRepresentative().mCCPars.getInfo(parentPosition);
        List<CCTerm> funcApps = new ArrayList<CCTerm>();
        if (info != null) {
            for (CCAppTerm.Parent parent : info.mCCParents) {
                if (parent.isMarked()) continue;
                funcApps.add(parent.getData());
            }
            for (int i = argPos + 1; i < sym.getParameterSorts().length; ++i) {
                funcApps = CClosure.getApplications(funcApps);
            }
        }
        return funcApps;
    }

    public void insertCompareTrigger(CCTerm t1, CCTerm t2, CompareTrigger trigger) {
        CCTermPairHash.Info info;
        assert (t1.getRepresentative() != t2.getRepresentative());
        assert (!trigger.inList());
        while (true) {
            if (t1.mMergeTime > t2.mMergeTime) {
                CCTerm tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if (t1.mRep == t1) {
                assert (t2.mRep == t2);
                info = this.mPairHash.getInfo(t1, t2);
                if (info == null) {
                    info = new CCTermPairHash.Info(t1, t2);
                    this.mPairHash.add(info);
                }
                break;
            }
            assert (t1.mRep != t2);
            boolean found = false;
            for (CCTermPairHash.Info.Entry pentry : t1.mPairInfos) {
                CCTermPairHash.Info info2 = pentry.getInfo();
                if (pentry.mOther != t2) continue;
                info2.mCompareTriggers.prependIntoJoined(trigger, false);
                found = true;
                break;
            }
            if (!found) {
                CCTermPairHash.Info info3 = new CCTermPairHash.Info(t1, t2);
                info3.mRhsEntry.unlink();
                info3.mCompareTriggers.prependIntoJoined(trigger, false);
            }
            t1 = t1.mRep;
        }
        info.mCompareTriggers.prependIntoJoined(trigger, true);
    }

    public void removeCompareTrigger(CompareTrigger trigger) {
        CCTermPairHash.Info info;
        CCTerm t1 = trigger.getLhs();
        CCTerm t2 = trigger.getRhs();
        if (!this.mAllTerms.contains(t1) || !this.mAllTerms.contains(t2)) {
            return;
        }
        while (true) {
            if (t1.mMergeTime > t2.mMergeTime) {
                CCTerm tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if (t1.mRep == t1) {
                assert (t2.mRep == t2);
                info = this.mPairHash.getInfo(t1, t2);
                assert (info != null);
                break;
            }
            assert (t1.mRep != t2);
            boolean found = false;
            for (CCTermPairHash.Info.Entry pentry : t1.mPairInfos) {
                CCTermPairHash.Info info2 = pentry.getInfo();
                if (pentry.mOther != t2) continue;
                info2.mCompareTriggers.undoPrependIntoJoined(trigger, false);
                found = true;
                break;
            }
            assert (found);
            t1 = t1.mRep;
        }
        info.mCompareTriggers.undoPrependIntoJoined(trigger, true);
    }

    public void insertReverseTrigger(FunctionSymbol sym, CCTerm arg, int argPos, ReverseTrigger trigger) {
        CCParentInfo info;
        CCTerm func = this.getFuncTerm(sym);
        int parentPos = func.mParentPosition + argPos;
        while (arg != arg.mRep) {
            info = arg.mCCPars.createInfo(parentPos);
            info.mReverseTriggers.prependIntoJoined(trigger, false);
            arg = arg.mRep;
        }
        info = arg.mCCPars.createInfo(parentPos);
        info.mReverseTriggers.prependIntoJoined(trigger, true);
    }

    public void insertReverseTrigger(FunctionSymbol sym, ReverseTrigger trigger) {
        CCTerm func = this.getFuncTerm(sym);
        CCParentInfo info = func.mCCPars.createInfo(0);
        info.mReverseTriggers.append(trigger);
    }

    public void removeReverseTrigger(ReverseTrigger trigger) {
        CCParentInfo info;
        int parentPos;
        CCTerm termWithTrigger;
        CCTerm func = this.getFuncTerm(trigger.getFunctionSymbol());
        if (trigger.getArgPosition() < 0) {
            assert (func == func.mRep);
            termWithTrigger = func;
            parentPos = 0;
        } else {
            termWithTrigger = trigger.getArgument();
            parentPos = func.mParentPosition + trigger.getArgPosition();
        }
        if (!this.mAllTerms.contains(termWithTrigger)) {
            return;
        }
        while (termWithTrigger != termWithTrigger.mRep) {
            info = termWithTrigger.mCCPars.createInfo(parentPos);
            info.mReverseTriggers.undoPrependIntoJoined(trigger, false);
            termWithTrigger = termWithTrigger.mRep;
        }
        info = termWithTrigger.mCCPars.createInfo(parentPos);
        info.mReverseTriggers.undoPrependIntoJoined(trigger, true);
    }

    public CCTerm getCCTermRep(Term term) {
        if (this.mAnonTerms.containsKey(term)) {
            return this.mAnonTerms.get(term).getRepresentative();
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)term;
            CCTerm func = this.getFuncTerm(at.getFunction()).getRepresentative();
            for (Term argTerm : at.getParameters()) {
                CCTerm arg = this.getCCTermRep(argTerm);
                if (arg == null) {
                    return null;
                }
                if ((func = this.findCCAppTermRep(func, arg)) != null) continue;
                return null;
            }
            return func;
        }
        return null;
    }

    private CCTerm findCCAppTermRep(CCTerm funcRep, CCTerm argRep) {
        CCParentInfo info = funcRep.mCCPars.getInfo(0);
        if (info == null) {
            return null;
        }
        for (CCAppTerm.Parent parent : info.mCCParents) {
            if (parent.getData().getArg().getRepresentative() != argRep) continue;
            return parent.getData().getRepresentative();
        }
        return null;
    }

    public boolean isEqSet(CCTerm first, CCTerm second) {
        return first.getRepresentative() == second.getRepresentative();
    }

    public boolean isDiseqSet(CCTerm first, CCTerm second) {
        CCTerm secondRep;
        CCTerm firstRep = first.getRepresentative();
        CCTermPairHash.Info diseqInfo = this.mPairHash.getInfo(firstRep, secondRep = second.getRepresentative());
        return diseqInfo != null && diseqInfo.mDiseq != null;
    }

    public void insertEqualityEntry(CCTerm t1, CCTerm t2, CCEquality.Entry eqentry) {
        while (true) {
            if (t1.mMergeTime > t2.mMergeTime) {
                CCTerm tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if (t1.mRep == t1) {
                assert (t2.mRep == t2);
                CCTermPairHash.Info info = this.mPairHash.getInfo(t1, t2);
                if (info == null) {
                    info = new CCTermPairHash.Info(t1, t2);
                    this.mPairHash.add(info);
                }
                info.mEqlits.prependIntoJoined(eqentry, true);
                break;
            }
            boolean isLast = t1.mRep == t2;
            boolean found = false;
            for (CCTermPairHash.Info.Entry pentry : t1.mPairInfos) {
                CCTermPairHash.Info info = pentry.getInfo();
                if (pentry.mOther != t2) continue;
                info.mEqlits.prependIntoJoined(eqentry, isLast);
                found = true;
                break;
            }
            if (!found) {
                CCTermPairHash.Info info = new CCTermPairHash.Info(t1, t2);
                info.mRhsEntry.unlink();
                info.mEqlits.prependIntoJoined(eqentry, isLast);
            }
            if (isLast) break;
            t1 = t1.mRep;
        }
    }

    public CCEquality createCCEquality(int stackLevel, CCTerm t1, CCTerm t2) {
        assert (t1 != t2);
        CCEquality eq = null;
        assert (t1.invariant());
        assert (t2.invariant());
        if (t2.getFlatTerm().getSort().isNumericSort() && t2.getFlatTerm() instanceof ConstantTerm) {
            CCTerm tmp = t2;
            t2 = t1;
            t1 = tmp;
        }
        eq = new CCEquality(stackLevel, t1, t2);
        this.insertEqualityEntry(t1, t2, eq.getEntry());
        this.getEngine().addAtom(eq);
        assert (t1.invariant());
        assert (t2.invariant());
        assert (t1.pairHashValid(this));
        assert (t2.pairHashValid(this));
        if (t1.mRepStar == t2.mRepStar) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("CC-Prop: " + eq + " repStar: " + t1.mRepStar);
            }
            this.mPendingLits.add(eq);
            this.mRecheckOnBacktrackLits.add(eq);
        } else {
            CCEquality diseq = this.mPairHash.getInfo((CCTerm)t1.mRepStar, (CCTerm)t2.mRepStar).mDiseq;
            if (diseq != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("CC-Prop: " + eq.negate() + " diseq: " + diseq);
                }
                eq.mDiseqReason = diseq;
                this.mPendingLits.add(eq.negate());
                this.mRecheckOnBacktrackLits.add(eq.negate());
            }
        }
        return eq;
    }

    public void addTerm(CCTerm ccterm, Term term) {
        ccterm.mFlatTerm = term;
    }

    public void addSharedTerm(CCTerm ccterm) {
        ccterm.share(this);
    }

    @Override
    public Clause computeConflictClause() {
        Clause res = this.checkpoint();
        if (res == null) {
            res = this.checkpoint();
        }
        assert (this.mPendingCongruences.isEmpty());
        return res;
    }

    @Override
    public Literal getPropagatedLiteral() {
        Literal lit = this.mPendingLits.poll();
        assert (lit == null || this.checkPending(lit));
        return lit;
    }

    @Override
    public Clause getUnitClause(Literal lit) {
        if (lit.getAtom() instanceof LAEquality) {
            LAEquality laeq = (LAEquality)lit.getAtom();
            for (CCEquality eq : laeq.getDependentEqualities()) {
                if (eq.getStackPosition() < 0 || eq.getStackPosition() >= laeq.getStackPosition() || eq.getDecideStatus().getSign() != lit.getSign()) continue;
                return new Clause(new Literal[]{eq.getDecideStatus().negate(), lit}, new LeafNode(-6, EQAnnotation.EQ));
            }
            throw new AssertionError((Object)("Cannot find explanation for " + laeq));
        }
        if (lit instanceof CCEquality) {
            CCEquality eq = (CCEquality)lit;
            return this.computeCycle(eq);
        }
        CCEquality eq = (CCEquality)lit.negate();
        return this.computeAntiCycle(eq);
    }

    @Override
    public int checkCompleteness() {
        return 0;
    }

    void recordMerge(CCTerm oldRep) {
        this.mUndoStack.push(new MergeUndoInfo(oldRep));
    }

    int getMergeDepth() {
        return this.mUndoStack.size();
    }

    @Override
    public Clause setLiteral(Literal literal) {
        LAEquality laeq;
        if (!(literal.getAtom() instanceof CCEquality)) {
            return null;
        }
        CCEquality eq = (CCEquality)literal.getAtom();
        if (literal == eq) {
            Clause conflict;
            if (eq.getLhs().mRepStar != eq.getRhs().mRepStar && (conflict = eq.getLhs().merge(this, eq.getRhs(), eq)) != null) {
                return conflict;
            }
        } else {
            Clause conflict;
            CCTerm left = eq.getLhs().mRepStar;
            CCTerm right = eq.getRhs().mRepStar;
            if (left == right && (conflict = this.computeCycle(eq)) != null) {
                return conflict;
            }
            this.separate(left, right, eq);
        }
        if ((laeq = eq.getLASharedData()) != null) {
            assert (((List)laeq.getDependentEqualities()).contains(eq));
            if (laeq.getDecideStatus() != null && laeq.getDecideStatus().getSign() != literal.getSign()) {
                return new Clause(new Literal[]{laeq.getDecideStatus().negate(), literal.negate()}, new LeafNode(-6, EQAnnotation.EQ));
            }
            this.mPendingLits.add(literal == eq ? laeq : laeq.negate());
        }
        return null;
    }

    @Override
    public void backtrackLiteral(Literal literal) {
    }

    void removePairHash(CCTermPairHash.Info info) {
        this.mPairHash.remove(info);
    }

    private void separate(CCTerm lhs, CCTerm rhs, CCEquality diseq) {
        CCEquality reason = diseq.mDiseqReason;
        if (reason != null && reason.getDecideStatus() == reason.negate()) {
            if (reason.getLhs().getRepresentative() == lhs && reason.getRhs().getRepresentative() == rhs) {
                return;
            }
            if (reason.getLhs().getRepresentative() == rhs && reason.getRhs().getRepresentative() == lhs) {
                return;
            }
        }
        CCTermPairHash.Info info = this.mPairHash.getInfo(lhs, rhs);
        assert (info.mDiseq == null);
        this.mUndoStack.push(new SepUndoInfo(diseq));
        info.mDiseq = diseq;
        for (CCEquality.Entry eqentry : info.mEqlits) {
            CCEquality eq = eqentry.getCCEquality();
            assert (eq.getDecideStatus() == null || eq == diseq);
            if (eq.getDecideStatus() != null) continue;
            eq.mDiseqReason = diseq;
            this.addPending(eq.negate());
        }
    }

    private void undoSep(CCEquality atom) {
        CCTermPairHash.Info destInfo = this.mPairHash.getInfo(atom.getLhs().mRepStar, atom.getRhs().mRepStar);
        assert (destInfo != null && destInfo.mDiseq == atom);
        destInfo.mDiseq = null;
    }

    public Clause computeCycle(CCEquality eq) {
        CongruencePath congPath = new CongruencePath(this);
        Clause res = congPath.computeCycle(eq, this.isProofGenerationEnabled());
        assert (res.getSize() != 2 || res.getLiteral(0).negate() != res.getLiteral(1));
        return res;
    }

    public Clause computeCycle(CCTerm lconstant, CCTerm rconstant) {
        CongruencePath congPath = new CongruencePath(this);
        return congPath.computeCycle(lconstant, rconstant, this.isProofGenerationEnabled());
    }

    public Clause computeAntiCycle(CCEquality eq) {
        CCTerm left = eq.getLhs();
        CCTerm right = eq.getRhs();
        CCEquality diseq = eq.mDiseqReason;
        assert (left.mRepStar != right.mRepStar);
        assert (diseq.getLhs().mRepStar == left.mRepStar || diseq.getLhs().mRepStar == right.mRepStar);
        assert (diseq.getRhs().mRepStar == left.mRepStar || diseq.getRhs().mRepStar == right.mRepStar);
        left.invertEqualEdges(this);
        left.mEqualEdge = right;
        left.mOldRep = left.mRepStar;
        assert (left.mOldRep.mReasonLiteral == null);
        left.mOldRep.mReasonLiteral = eq;
        Clause c = this.computeCycle(diseq);
        assert (left.mEqualEdge == right && left.mOldRep == left.mRepStar);
        left.mOldRep.mReasonLiteral = null;
        left.mOldRep = null;
        left.mEqualEdge = null;
        return c;
    }

    public int getDecideLevelForPath(CCTerm lhs, CCTerm rhs) {
        CongruencePath congPath = new CongruencePath(this);
        return congPath.computeDecideLevel(lhs, rhs);
    }

    public void addPending(Literal eq) {
        assert (this.checkPending(eq));
        this.mPendingLits.add(eq);
    }

    private boolean checkPending(Literal literal) {
        if (literal.negate() instanceof CCEquality) {
            CCEquality eq = (CCEquality)literal.negate();
            CCTerm left = eq.getLhs();
            CCTerm right = eq.getRhs();
            CCEquality diseq = eq.mDiseqReason;
            assert (left.mRepStar != right.mRepStar);
            assert (diseq.getLhs().mRepStar == left.mRepStar || diseq.getLhs().mRepStar == right.mRepStar);
            assert (diseq.getRhs().mRepStar == left.mRepStar || diseq.getRhs().mRepStar == right.mRepStar);
            return true;
        }
        if (literal instanceof CCEquality) {
            CCEquality eq = (CCEquality)literal;
            return eq.getLhs().mRepStar == eq.getRhs().mRepStar;
        }
        if (literal.getAtom() instanceof LAEquality) {
            LAEquality laeq = (LAEquality)literal.getAtom();
            for (CCEquality eq : laeq.getDependentEqualities()) {
                if (eq.getDecideStatus() == null || eq.getDecideStatus().getSign() != literal.getSign()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Clause checkpoint() {
        return this.buildCongruence();
    }

    public CCEquality createEquality(CCTerm t1, CCTerm t2, boolean createLAEquality) {
        CCEquality eq;
        DPLLAtom res;
        assert (t1 != t2);
        EqualityProxy ep = this.mClausifier.createEqualityProxy(t1.getFlatTerm(), t2.getFlatTerm(), null);
        if (ep == EqualityProxy.getFalseProxy()) {
            return null;
        }
        if (!createLAEquality && (res = ep.getLiteral(null)) instanceof CCEquality && ((eq = (CCEquality)res).getLhs() == t1 && eq.getRhs() == t2 || eq.getLhs() == t2 && eq.getRhs() == t1)) {
            return eq;
        }
        return ep.createCCEquality(t1.getFlatTerm(), t2.getFlatTerm());
    }

    @Override
    public void dumpModel(LogProxy logger) {
        logger.info("Equivalence Classes:");
        for (CCTerm t : this.mAllTerms) {
            if (t != t.mRepStar || t.isFunc()) continue;
            StringBuilder sb = new StringBuilder();
            String comma = "";
            for (CCTerm t2 : t.mMembers) {
                sb.append(comma).append(t2);
                comma = "=";
            }
            logger.info(sb.toString());
        }
    }

    private boolean checkCongruence() {
        for (CCTerm t1 : this.mAllTerms) {
            assert (t1.invariant());
            if (!(t1 instanceof CCAppTerm)) continue;
            CCAppTerm a1 = (CCAppTerm)t1;
            boolean skip = true;
            for (CCTerm t2 : this.mAllTerms) {
                if (skip) {
                    if (t1 != t2) continue;
                    skip = false;
                    continue;
                }
                if (t1.getRepresentative() == t2.getRepresentative() || !(t2 instanceof CCAppTerm)) continue;
                CCAppTerm a2 = (CCAppTerm)t2;
                if (a1.getFunc().getRepresentative() != a2.getFunc().getRepresentative() || a1.getArg().getRepresentative() != a2.getArg().getRepresentative()) continue;
                this.getLogger().fatal("Should be congruent: " + t1 + " and " + t2);
                return false;
            }
        }
        return true;
    }

    @Override
    public void printStatistics(LogProxy logger) {
        logger.info("CCTimes: iE " + this.mInvertEdgeTime + " eq " + this.mEqTime + " cc " + this.mCcTime + " setRep " + this.mSetRepTime);
        logger.info("Merges: " + this.mMergeCount + ", cc:" + this.mCcCount);
    }

    @Override
    public Literal getSuggestion() {
        return null;
    }

    @Override
    public void decreasedDecideLevel(int currentDecideLevel) {
        int mergeStackLevel = this.mDecideLevelToUndoStackSize.pop();
        assert (this.mDecideLevelToUndoStackSize.size() == currentDecideLevel);
        this.backtrackStack(mergeStackLevel);
    }

    @Override
    public void increasedDecideLevel(int currentDecideLevel) {
        this.mDecideLevelToUndoStackSize.push(this.mUndoStack.size());
        assert (this.mDecideLevelToUndoStackSize.size() == currentDecideLevel);
    }

    @Override
    public void backtrackStart() {
        this.mPendingLits.clear();
        this.mPendingCongruences.clear();
    }

    @Override
    public Clause backtrackComplete() {
        CCTerm rhs;
        CCTerm lhs;
        ArrayQueue<Literal> newRecheckOnBacktrackLits = new ArrayQueue<Literal>();
        for (Literal l : this.mRecheckOnBacktrackLits) {
            CCEquality eq = (CCEquality)l.getAtom();
            if (eq.getDecideStatus() != null) {
                newRecheckOnBacktrackLits.add(l);
                LAEquality laeq = eq.getLASharedData();
                if (laeq == null || laeq.getDecideStatus() != null) continue;
                this.getLogger().debug("repropagating LAEQ: %s -> %s", eq, laeq);
                this.mPendingLits.add(l == eq ? laeq : laeq.negate());
                continue;
            }
            lhs = eq.getLhs().getRepresentative();
            rhs = eq.getRhs().getRepresentative();
            boolean repropagate = false;
            if (l.getSign() > 0) {
                repropagate = lhs == rhs;
            } else {
                CCEquality diseq = this.mPairHash.getInfo((CCTerm)lhs, (CCTerm)rhs).mDiseq;
                if (diseq != null) {
                    eq.mDiseqReason = diseq;
                    repropagate = true;
                }
            }
            if (!repropagate) continue;
            this.getLogger().debug("CC-ReProp: %s", l);
            this.mPendingLits.add(l);
            newRecheckOnBacktrackLits.add(l);
        }
        this.mRecheckOnBacktrackLits = newRecheckOnBacktrackLits;
        ArrayQueue<SymmetricPair<CCAppTerm>> newRecheckOnBacktrackCongs = new ArrayQueue<SymmetricPair<CCAppTerm>>();
        for (SymmetricPair<CCAppTerm> cong : this.mRecheckOnBacktrackCongs) {
            lhs = cong.getFirst();
            rhs = cong.getSecond();
            if (((CCAppTerm)lhs).mArg.mRepStar == ((CCAppTerm)rhs).mArg.mRepStar && ((CCAppTerm)lhs).mFunc.mRepStar == ((CCAppTerm)rhs).mFunc.mRepStar) {
                this.getLogger().debug("Still congruent: %s and %s", lhs, rhs);
                this.addPendingCongruence((CCAppTerm)lhs, (CCAppTerm)rhs);
                newRecheckOnBacktrackCongs.add(cong);
                continue;
            }
            this.getLogger().debug("No longer congruent: %s and %s", lhs, rhs);
        }
        this.mRecheckOnBacktrackCongs = newRecheckOnBacktrackCongs;
        return this.buildCongruence();
    }

    @Override
    public void restart(int iteration) {
    }

    @Override
    public Clause startCheck() {
        return null;
    }

    @Override
    public void endCheck() {
    }

    void addPendingCongruence(CCAppTerm first, CCAppTerm second) {
        assert (first.mLeftParInfo.inList() && second.mLeftParInfo.inList());
        assert (first.mRightParInfo.inList() && second.mRightParInfo.inList());
        this.getLogger().debug("addPendingCongruence: %s %s", first, second);
        this.mPendingCongruences.add(new SymmetricPair<CCAppTerm>(first, second));
    }

    private Clause buildCongruence() {
        SymmetricPair<CCAppTerm> cong;
        while ((cong = this.mPendingCongruences.poll()) != null) {
            this.getLogger().debug("PC %s", cong);
            CCAppTerm lhs = cong.getFirst();
            CCAppTerm rhs = cong.getSecond();
            assert (lhs.mArg.mRepStar == rhs.mArg.mRepStar && lhs.mFunc.mRepStar == rhs.mFunc.mRepStar) : "Unchecked buildCongruence with non-holding congruence!";
            Clause res = lhs.merge(this, rhs, null);
            if (res == null) continue;
            this.getLogger().debug("buildCongruence: conflict %s", res);
            return res;
        }
        return null;
    }

    private void backtrackStack(int todepth) {
        while (this.mUndoStack.size() > todepth) {
            UndoInfo top = this.mUndoStack.pop();
            if (top instanceof MergeUndoInfo) {
                CCTerm oldRep = ((MergeUndoInfo)top).getOldRep();
                oldRep.mRepStar.invertEqualEdges(this);
                oldRep.undoMerge(this, oldRep.mEqualEdge);
                continue;
            }
            CCEquality diseq = ((SepUndoInfo)top).getDiseq();
            this.undoSep(diseq);
        }
    }

    public int getStackDepth() {
        return this.mUndoStack.size();
    }

    @Override
    public void removeAtom(DPLLAtom atom) {
        if (atom instanceof CCEquality) {
            CCEquality cceq = (CCEquality)atom;
            this.removeCCEquality(cceq.getLhs(), cceq.getRhs(), cceq);
        }
    }

    private void removeCCEquality(CCTerm t1, CCTerm t2, CCEquality eq) {
        if (t1.mMergeTime > t2.mMergeTime) {
            CCTerm tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        if (t1.mRep == t1) {
            assert (t2.mRep == t2);
            CCTermPairHash.Info info = this.mPairHash.getInfo(t1, t2);
            if (info != null) {
                info.mEqlits.prepareRemove(eq.getEntry());
                eq.getEntry().removeFromList();
                if (info.isEmpty()) {
                    this.mPairHash.removePairInfo(info);
                }
            }
        } else {
            boolean isLast = t1.mRep == t2;
            boolean found = false;
            for (CCTermPairHash.Info.Entry pentry : t1.mPairInfos) {
                CCTermPairHash.Info info = pentry.getInfo();
                if (pentry.mOther != t2) continue;
                info.mEqlits.prepareRemove(eq.getEntry());
                found = true;
                break;
            }
            assert (found);
            if (isLast) {
                eq.getEntry().removeFromList();
            } else {
                this.removeCCEquality(t1.mRep, t2, eq);
            }
        }
        if (eq.getLASharedData() != null) {
            eq.getLASharedData().removeDependentAtom(eq);
        }
    }

    private void removeTerm(CCTerm t) {
        assert (t.mRepStar == t);
        assert (this.mPendingCongruences.isEmpty());
        while (!t.mPairInfos.isEmpty()) {
            CCTermPairHash.Info info = t.mPairInfos.iterator().next().getInfo();
            this.mPairHash.removePairInfo(info);
        }
        if (t.mSharedTerm != null) {
            t.mSharedTerm = null;
        }
        if (t instanceof CCAppTerm) {
            CCAppTerm at = (CCAppTerm)t;
            at.unlinkParentInfos();
        }
    }

    @Override
    public void backtrackAll() {
        assert (this.mDecideLevelToUndoStackSize.isEmpty());
        this.backtrackStack(0);
        this.mPendingLits.clear();
        this.mRecheckOnBacktrackCongs.clear();
        this.mRecheckOnBacktrackLits.clear();
        this.mPendingCongruences.clear();
    }

    @Override
    public void pop() {
        assert (this.mDecideLevelToUndoStackSize.isEmpty());
        assert (this.mUndoStack.isEmpty());
        assert (this.mRecheckOnBacktrackCongs.isEmpty());
        assert (this.mRecheckOnBacktrackLits.isEmpty());
        assert (this.mPendingCongruences.isEmpty());
        this.mNumFunctionPositions = this.mNumFunctionPositionsStack.remove(this.mNumFunctionPositionsStack.size() - 1);
        for (CCTerm t : this.mAllTerms.currentScope()) {
            this.removeTerm(t);
        }
        this.mAllTerms.endScope();
        this.mSymbolicTerms.endScope();
    }

    @Override
    public void push() {
        this.mSymbolicTerms.beginScope();
        this.mAllTerms.beginScope();
        this.mNumFunctionPositionsStack.add(this.mNumFunctionPositions);
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":CC", new Object[][]{{"Merges", this.mMergeCount}, {"Closure", this.mCcCount}, {"Times", new Object[][]{{"Invert", this.mInvertEdgeTime}, {"Eq", this.mEqTime}, {"Closure", this.mCcTime}, {"SetRep", this.mSetRepTime}}}}};
    }

    public void fillInModel(Model model, Theory t, SharedTermEvaluator ste, ArrayTheory arrayTheory, DataTypeTheory datatypeTheory) {
        CCTerm trueNode = this.mClausifier.getCCTerm(t.mTrue);
        CCTerm falseNode = this.mClausifier.getCCTerm(t.mFalse);
        new ModelBuilder(this, this.mAllTerms, model, t, ste, arrayTheory, datatypeTheory, trueNode, falseNode);
    }

    void addInvertEdgeTime(long time) {
        this.mInvertEdgeTime += time;
    }

    void addEqTime(long time) {
        this.mEqTime += time;
    }

    void addCcTime(long time) {
        this.mCcTime += time;
    }

    void addSetRepTime(long time) {
        this.mSetRepTime += time;
    }

    void incCcCount() {
        ++this.mCcCount;
    }

    void incMergeCount() {
        ++this.mMergeCount;
    }

    private static class SepUndoInfo
    extends UndoInfo {
        CCEquality mDiseq;

        public SepUndoInfo(CCEquality diseq) {
            this.mDiseq = diseq;
        }

        public CCEquality getDiseq() {
            return this.mDiseq;
        }
    }

    private static class MergeUndoInfo
    extends UndoInfo {
        final CCTerm mOldRep;

        public MergeUndoInfo(CCTerm oldRep) {
            this.mOldRep = oldRep;
        }

        public CCTerm getOldRep() {
            return this.mOldRep;
        }
    }

    private static class UndoInfo {
        private UndoInfo() {
        }
    }
}

