/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeLemma;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class CongruencePath {
    final CClosure mClosure;
    final HashMap<SymmetricPair<CCTerm>, SubPath> mVisited;
    final ArrayDeque<SubPath> mAllPaths;
    final ArrayDeque<SymmetricPair<CCTerm>> mTodo;
    final Set<Literal> mAllLiterals;

    public CongruencePath(CClosure closure) {
        this.mClosure = closure;
        this.mVisited = new HashMap();
        this.mAllLiterals = new LinkedHashSet<Literal>();
        this.mTodo = new ArrayDeque();
        this.mAllPaths = new ArrayDeque();
    }

    private CCAnnotation createAnnotation(SymmetricPair<CCTerm> diseq) {
        return new CCAnnotation(diseq, this.mAllPaths, CCAnnotation.RuleKind.CONG);
    }

    private int computeDepth(CCTerm t) {
        int depth = 0;
        while (t.mEqualEdge != null) {
            t = t.mEqualEdge;
            ++depth;
        }
        return depth;
    }

    private void computeCCPath(CCAppTerm start, CCAppTerm end) {
        while (true) {
            this.mTodo.addFirst(new SymmetricPair<CCTerm>(start.mArg, end.mArg));
            if (start.mFunc == end.mFunc) break;
            start = (CCAppTerm)start.mFunc;
            end = (CCAppTerm)end.mFunc;
        }
    }

    private SubPath computePathTo(CCTerm t, CCTerm end) {
        SubPath path = new SubPath(t, this.mClosure.isProofGenerationEnabled());
        CCTerm startCongruence = t;
        while (t != end) {
            if (t.mOldRep.mReasonLiteral != null) {
                if (startCongruence != t) {
                    this.computeCCPath((CCAppTerm)startCongruence, (CCAppTerm)t);
                    path.addEntry(t, null);
                }
                path.addEntry(t.mEqualEdge, t.mOldRep.mReasonLiteral);
                this.mAllLiterals.add(t.mOldRep.mReasonLiteral);
                startCongruence = t.mEqualEdge;
            }
            t = t.mEqualEdge;
        }
        assert (startCongruence == t);
        return path;
    }

    SubPath computePathNonRecursive(CCTerm left, CCTerm right) {
        int leftDepth;
        if (left == right) {
            return null;
        }
        SymmetricPair<CCTerm> key = new SymmetricPair<CCTerm>(left, right);
        if (this.mVisited.containsKey(key)) {
            return this.mVisited.get(key);
        }
        int rightDepth = this.computeDepth(right);
        CCTerm ll = left;
        CCTerm rr = right;
        CCTerm llWithReason = ll;
        CCTerm rrWithReason = rr;
        for (leftDepth = this.computeDepth(left); leftDepth > rightDepth; --leftDepth) {
            if (ll.mOldRep.mReasonLiteral != null) {
                llWithReason = ll.mEqualEdge;
            }
            ll = ll.mEqualEdge;
        }
        while (rightDepth > leftDepth) {
            if (rr.mOldRep.mReasonLiteral != null) {
                rrWithReason = rr.mEqualEdge;
            }
            rr = rr.mEqualEdge;
            --rightDepth;
        }
        while (ll != rr) {
            if (ll.mOldRep.mReasonLiteral != null) {
                llWithReason = ll.mEqualEdge;
            }
            if (rr.mOldRep.mReasonLiteral != null) {
                rrWithReason = rr.mEqualEdge;
            }
            ll = ll.mEqualEdge;
            rr = rr.mEqualEdge;
        }
        assert (ll != null);
        SubPath path = this.computePathTo(left, llWithReason);
        if (llWithReason != rrWithReason) {
            this.computeCCPath((CCAppTerm)llWithReason, (CCAppTerm)rrWithReason);
            path.addEntry(rrWithReason, null);
        }
        SubPath pathBack = this.computePathTo(right, rrWithReason);
        path.addSubPath(pathBack);
        this.mVisited.put(key, path);
        return path;
    }

    public void computePath(CCTerm left, CCTerm right) {
        HashSet<SymmetricPair<CCTerm>> added = new HashSet<SymmetricPair<CCTerm>>();
        this.mTodo.add(new SymmetricPair<CCTerm>(left, right));
        while (!this.mTodo.isEmpty()) {
            SymmetricPair<CCTerm> pathEnds = this.mTodo.removeFirst();
            if (pathEnds.getFirst() == pathEnds.getSecond()) continue;
            SubPath path = this.mVisited.get(pathEnds);
            if (path == null) {
                this.mTodo.addFirst(pathEnds);
                this.computePathNonRecursive(pathEnds.getFirst(), pathEnds.getSecond());
                continue;
            }
            if (!added.add(pathEnds)) continue;
            this.mAllPaths.addFirst(path);
        }
    }

    public Clause computeCycle(CCEquality eq, boolean produceProofs) {
        CCTerm lhs = eq.getLhs();
        CCTerm rhs = eq.getRhs();
        this.computePath(eq.getLhs(), eq.getRhs());
        Literal[] cycle = new Literal[this.mAllLiterals.size() + 1];
        int i = 0;
        cycle[i++] = eq;
        for (Literal l : this.mAllLiterals) {
            cycle[i++] = l.negate();
        }
        Clause c = new Clause(cycle);
        if (produceProofs) {
            c.setProof(new LeafNode(-3, this.createAnnotation(new SymmetricPair<CCTerm>(lhs, rhs))));
        }
        return c;
    }

    public Clause computeCycle(CCTerm lconstant, CCTerm rconstant, boolean produceProofs) {
        this.mClosure.getLogger().debug("computeCycle for Constants");
        this.computePath(lconstant, rconstant);
        Literal[] cycle = new Literal[this.mAllLiterals.size()];
        int i = 0;
        for (Literal l : this.mAllLiterals) {
            cycle[i++] = l.negate();
        }
        Clause c = new Clause(cycle);
        if (produceProofs) {
            c.setProof(new LeafNode(-3, this.createAnnotation(new SymmetricPair<CCTerm>(lconstant, rconstant))));
        }
        return c;
    }

    public Clause computeDTLemma(CCEquality propagatedEq, DataTypeLemma lemma, boolean produceProofs) {
        for (SymmetricPair<CCTerm> reason : lemma.getReason()) {
            this.computePath(reason.getFirst(), reason.getSecond());
        }
        Literal[] negLits = new Literal[this.mAllLiterals.size() + (propagatedEq != null ? 1 : 0)];
        int i = 0;
        if (propagatedEq != null) {
            negLits[i++] = propagatedEq;
        }
        for (Literal l : this.mAllLiterals) {
            negLits[i++] = l.negate();
        }
        Clause c = new Clause(negLits);
        if (produceProofs) {
            SymmetricPair<CCTerm> diseq = lemma.getMainEquality();
            c.setProof(new LeafNode(-8, new CCAnnotation(diseq, this.mAllPaths, lemma)));
        }
        return c;
    }

    public int computeDecideLevel(CCTerm lhs, CCTerm rhs) {
        this.computePath(lhs, rhs);
        int depth = 0;
        for (Literal l : this.mAllLiterals) {
            depth = Math.max(depth, l.getAtom().getDecideLevel());
        }
        return depth;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CongruencePath[");
        sb.append(this.mAllLiterals.toString());
        sb.append(']');
        return sb.toString();
    }

    public static class SubPath {
        ArrayList<CCTerm> mTermsOnPath;

        public SubPath(CCTerm start) {
            this(start, true);
        }

        public SubPath(CCTerm start, boolean produceProofs) {
            if (produceProofs) {
                this.mTermsOnPath = new ArrayList();
                this.mTermsOnPath.add(start);
            }
        }

        public CCTerm[] getTerms() {
            return this.mTermsOnPath.toArray(new CCTerm[this.mTermsOnPath.size()]);
        }

        public void addEntry(CCTerm term, CCEquality reason) {
            if (this.mTermsOnPath != null) {
                this.mTermsOnPath.add(term);
            }
        }

        public void addSubPath(SubPath second) {
            block5: {
                if (this.mTermsOnPath == null || second == null) break block5;
                if (second.mTermsOnPath.get(0) == this.mTermsOnPath.get(this.mTermsOnPath.size() - 1)) {
                    for (int i = 1; i < second.mTermsOnPath.size(); ++i) {
                        this.mTermsOnPath.add(second.mTermsOnPath.get(i));
                    }
                } else {
                    assert (second.mTermsOnPath.get(second.mTermsOnPath.size() - 1) == this.mTermsOnPath.get(this.mTermsOnPath.size() - 1));
                    for (int i = second.mTermsOnPath.size() - 2; i >= 0; --i) {
                        this.mTermsOnPath.add(second.mTermsOnPath.get(i));
                    }
                }
            }
        }

        public String toString() {
            return this.mTermsOnPath.toString();
        }
    }
}

