/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeLemma;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;

public class DTReverseTrigger
extends ReverseTrigger {
    final CCTerm mArg;
    int mArgPos;
    final FunctionSymbol mFunctionSymbol;
    final Clausifier mClausifier;
    final DataTypeTheory mDTTheory;

    public DTReverseTrigger(DataTypeTheory dtTheory, Clausifier clausifier, FunctionSymbol fs, CCTerm arg) {
        this.mDTTheory = dtTheory;
        this.mClausifier = clausifier;
        this.mFunctionSymbol = fs;
        this.mArg = arg;
    }

    @Override
    public CCTerm getArgument() {
        return this.mArg;
    }

    @Override
    public int getArgPosition() {
        return 0;
    }

    @Override
    public FunctionSymbol getFunctionSymbol() {
        return this.mFunctionSymbol;
    }

    @Override
    public void activate(CCAppTerm appTerm, boolean isFresh) {
        this.mClausifier.getLogger().info("DTReverseTrigger: %s on %s", appTerm, this.mArg);
        ApplicationTerm argAT = (ApplicationTerm)this.mArg.mFlatTerm;
        SymmetricPair[] reason = appTerm.getArg() != this.mArg ? new SymmetricPair[]{new SymmetricPair<CCTerm>(appTerm.getArg(), this.mArg)} : new SymmetricPair[]{};
        if (this.mFunctionSymbol.getName() == "is") {
            FunctionSymbol fs = ((CCBaseTerm)appTerm.mFunc).getFunctionSymbol();
            ApplicationTerm truthValue = fs.getIndices()[0].equals(argAT.getFunction().getName()) ? this.mClausifier.getTheory().mTrue : this.mClausifier.getTheory().mFalse;
            SymmetricPair<CCTerm> mainEq = new SymmetricPair<CCTerm>(appTerm, this.mClausifier.getCCTerm(truthValue));
            DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_TESTER, mainEq, reason, this.mArg);
            this.mDTTheory.addPendingLemma(lemma);
            if (isFresh) {
                this.mDTTheory.addRecheckOnBacktrack(appTerm);
            }
        } else {
            FunctionSymbol fs = argAT.getFunction();
            DataType argDT = (DataType)fs.getReturnSort().getSortSymbol();
            DataType.Constructor c = argDT.getConstructor(argAT.getFunction().getName());
            for (int i = 0; i < c.getSelectors().length; ++i) {
                if (this.mFunctionSymbol.getName() != c.getSelectors()[i]) continue;
                SymmetricPair<CCTerm> mainEq = new SymmetricPair<CCTerm>(appTerm, this.mClausifier.getCCTerm(argAT.getParameters()[i]));
                DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_PROJECT, mainEq, reason, this.mArg);
                this.mDTTheory.addPendingLemma(lemma);
                if (isFresh) {
                    this.mDTTheory.addRecheckOnBacktrack(appTerm);
                }
                return;
            }
            assert (false) : "selector function not part of constructor";
        }
    }
}

