/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.Arrays;

public class DataTypeLemma {
    private final CCAnnotation.RuleKind mRule;
    private final SymmetricPair<CCTerm> mMainEquality;
    private final SymmetricPair<CCTerm>[] mReason;
    private final Object[] mAnnotation;

    public DataTypeLemma(CCAnnotation.RuleKind rule, SymmetricPair<CCTerm> mainEquality, SymmetricPair<CCTerm>[] reason) {
        this.mRule = rule;
        this.mReason = reason;
        this.mMainEquality = mainEquality;
        this.mAnnotation = null;
    }

    public DataTypeLemma(CCAnnotation.RuleKind rule, SymmetricPair<CCTerm> mainEquality, SymmetricPair<CCTerm>[] reason, CCTerm consTerm) {
        assert (rule == CCAnnotation.RuleKind.DT_PROJECT || rule == CCAnnotation.RuleKind.DT_TESTER);
        this.mRule = rule;
        this.mReason = reason;
        this.mMainEquality = mainEquality;
        this.mAnnotation = new Object[]{":cons", consTerm.getFlatTerm()};
    }

    public DataTypeLemma(CCAnnotation.RuleKind rule, SymmetricPair<CCTerm> mainEquality, SymmetricPair<CCTerm>[] reason, CCTerm consTerm1, CCTerm consTerm2) {
        assert (rule == CCAnnotation.RuleKind.DT_INJECTIVE);
        this.mRule = rule;
        this.mReason = reason;
        this.mMainEquality = mainEquality;
        this.mAnnotation = new Object[]{":cons", consTerm1.getFlatTerm(), consTerm2.getFlatTerm()};
    }

    public DataTypeLemma(CCAnnotation.RuleKind rule, SymmetricPair<CCTerm>[] reason, CCTerm consTerm1, CCTerm consTerm2) {
        assert (rule == CCAnnotation.RuleKind.DT_DISJOINT);
        this.mRule = rule;
        this.mReason = reason;
        this.mMainEquality = null;
        this.mAnnotation = new Object[]{":cons", consTerm1.getFlatTerm(), consTerm2.getFlatTerm()};
    }

    public DataTypeLemma(CCAnnotation.RuleKind rule, SymmetricPair<CCTerm>[] reason, Term[] testerTerms) {
        assert (rule == CCAnnotation.RuleKind.DT_CASES || rule == CCAnnotation.RuleKind.DT_UNIQUE);
        this.mRule = rule;
        this.mReason = reason;
        this.mMainEquality = null;
        this.mAnnotation = testerTerms;
    }

    public DataTypeLemma(CCAnnotation.RuleKind rule, SymmetricPair<CCTerm>[] reason, CCTerm[] cycle) {
        assert (rule == CCAnnotation.RuleKind.DT_CYCLE);
        this.mRule = rule;
        this.mReason = reason;
        this.mMainEquality = null;
        this.mAnnotation = new Object[]{":cycle", this.getCycleTerms(cycle)};
    }

    public CCAnnotation.RuleKind getRule() {
        return this.mRule;
    }

    public SymmetricPair<CCTerm> getMainEquality() {
        return this.mMainEquality;
    }

    public SymmetricPair<CCTerm>[] getReason() {
        return this.mReason;
    }

    public Object[] getAnnotation() {
        return this.mAnnotation == null ? new Object[]{} : this.mAnnotation;
    }

    private Term[] getCycleTerms(CCTerm[] cycle) {
        Term[] cycleTerms = new Term[cycle.length];
        int i = 0;
        for (CCTerm ccTerm : cycle) {
            cycleTerms[i++] = ccTerm.getFlatTerm();
        }
        return cycleTerms;
    }

    public String toString() {
        return "DataTypeLemma[" + (Object)((Object)this.mRule) + "," + this.mMainEquality + "," + Arrays.toString(this.mAnnotation) + "]";
    }
}

