/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeLemma;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ModelBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ArrayQueue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class DataTypeTheory
implements ITheory {
    private final Clausifier mClausifier;
    private final CClosure mCClosure;
    private final Theory mTheory;
    private final ArrayDeque<CCEquality> mPendingEqualities = new ArrayDeque();
    private final ArrayDeque<DataTypeLemma> mPendingLemmas = new ArrayDeque();
    private final LinkedHashMap<String, DataType.Constructor> mSelectorMap = new LinkedHashMap();
    private ArrayQueue<CCAppTerm> mRecheckOnBacktrack = new ArrayQueue();
    private final LinkedHashMap<Sort, Boolean> mInfinityMap = new LinkedHashMap();
    private final LinkedHashMap<CCEquality, DataTypeLemma> mEqualityReasons = new LinkedHashMap();

    public DataTypeTheory(Clausifier clausifier, Theory theory, CClosure cclosure) {
        this.mClausifier = clausifier;
        this.mCClosure = cclosure;
        this.mTheory = theory;
    }

    public void addPendingLemma(DataTypeLemma lemma) {
        this.mPendingLemmas.add(lemma);
    }

    private Clause processPendingLemmas() {
        for (DataTypeLemma lemma : this.mPendingLemmas) {
            SymmetricPair<CCTerm> eq = lemma.getMainEquality();
            if (eq == null) {
                return this.computeClause(null, lemma);
            }
            if (eq.getFirst().mRepStar == eq.getSecond().mRepStar) continue;
            CCEquality eqAtom = this.mCClosure.createEquality(eq.getFirst(), eq.getSecond(), false);
            if (eqAtom == null) {
                return this.computeClause(null, lemma);
            }
            if (eqAtom.getDecideStatus() == eqAtom.negate()) {
                return this.computeClause(eqAtom, lemma);
            }
            this.mPendingEqualities.add(eqAtom);
            this.mEqualityReasons.put(eqAtom, lemma);
        }
        this.mPendingLemmas.clear();
        return null;
    }

    @Override
    public Clause startCheck() {
        return null;
    }

    @Override
    public void endCheck() {
    }

    @Override
    public Clause setLiteral(Literal literal) {
        if (literal instanceof CCEquality) {
            CCEquality cceq = (CCEquality)literal;
            this.computeInjectiveDisjointLemmas(cceq.getLhs(), cceq.getRhs());
        }
        return this.processPendingLemmas();
    }

    private void computeInjectiveDisjointLemmas(CCTerm lhs, CCTerm rhs) {
        if (DataTypeTheory.isConstructorApp(lhs.mFlatTerm) && DataTypeTheory.isConstructorApp(rhs.mFlatTerm)) {
            ApplicationTerm lhsApp = (ApplicationTerm)lhs.getFlatTerm();
            ApplicationTerm rhsApp = (ApplicationTerm)rhs.getFlatTerm();
            SymmetricPair[] reason = new SymmetricPair[]{new SymmetricPair<CCTerm>(lhs, rhs)};
            if (lhsApp.getFunction() == rhsApp.getFunction()) {
                for (int i = 0; i < lhsApp.getParameters().length; ++i) {
                    CCTerm lhsArg = this.mClausifier.getCCTerm(lhsApp.getParameters()[i]);
                    CCTerm rhsArg = this.mClausifier.getCCTerm(rhsApp.getParameters()[i]);
                    if (rhsArg.mRepStar == lhsArg.mRepStar) continue;
                    SymmetricPair<CCTerm> eqPair = new SymmetricPair<CCTerm>(lhsArg, rhsArg);
                    this.addPendingLemma(new DataTypeLemma(CCAnnotation.RuleKind.DT_INJECTIVE, eqPair, reason, lhs, rhs));
                }
            } else {
                this.addPendingLemma(new DataTypeLemma(CCAnnotation.RuleKind.DT_DISJOINT, reason, lhs, rhs));
            }
        }
    }

    @Override
    public void backtrackLiteral(Literal literal) {
    }

    @Override
    public Clause checkpoint() {
        Clause conflict = this.processPendingLemmas();
        if (conflict != null) {
            return conflict;
        }
        CCTerm trueCC = this.mClausifier.getCCTerm(this.mTheory.mTrue);
        LinkedHashMap<CCTerm, CCAppTerm> visited = new LinkedHashMap<CCTerm, CCAppTerm>();
        for (CCTerm t : trueCC.getRepresentative().mMembers) {
            if (!(t instanceof CCAppTerm) || !(t.mFlatTerm instanceof ApplicationTerm)) continue;
            ApplicationTerm at = (ApplicationTerm)t.mFlatTerm;
            CCAppTerm trueIsApp = (CCAppTerm)t;
            if (at.getFunction().getName() != "is") continue;
            CCTerm argRep = trueIsApp.getArg().getRepresentative();
            if (!visited.containsKey(argRep)) {
                visited.put(argRep, trueIsApp);
                this.addConstructorLemma(trueIsApp);
                continue;
            }
            CCAppTerm prevIsApp = (CCAppTerm)visited.get(argRep);
            if (prevIsApp.getFunc() == trueIsApp.getFunc()) continue;
            ArrayList<SymmetricPair<CCTerm>> reason = new ArrayList<SymmetricPair<CCTerm>>();
            reason.add(new SymmetricPair<CCTerm>(prevIsApp, trueCC));
            reason.add(new SymmetricPair<CCTerm>(trueIsApp, trueCC));
            if (prevIsApp.getArg() != trueIsApp.getArg()) {
                reason.add(new SymmetricPair<CCTerm>(prevIsApp.getArg(), trueIsApp.getArg()));
            }
            Term[] testers = new Term[]{prevIsApp.mFlatTerm, trueIsApp.mFlatTerm};
            DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_UNIQUE, reason.toArray(new SymmetricPair[reason.size()]), testers);
            this.mClausifier.getLogger().debug("Conflict: Rule 9");
            return this.computeClause(null, lemma);
        }
        LinkedHashMap falseIsFuns = new LinkedHashMap();
        CCTerm falseCC = this.mClausifier.getCCTerm(this.mTheory.mFalse);
        for (CCTerm cct : falseCC.getRepresentative().mMembers) {
            if (!(cct.mFlatTerm instanceof ApplicationTerm) || !((ApplicationTerm)cct.mFlatTerm).getFunction().getName().equals("is")) continue;
            falseIsFuns.putIfAbsent(((CCAppTerm)cct).mArg.mRepStar, new LinkedHashSet());
            ((LinkedHashSet)falseIsFuns.get(((CCAppTerm)cct).mArg.mRepStar)).add(cct);
        }
        for (CCTerm cct : falseIsFuns.keySet()) {
            DataType dt = (DataType)cct.mFlatTerm.getSort().getSortSymbol();
            if (((LinkedHashSet)falseIsFuns.get(cct)).size() < dt.getConstructors().length) continue;
            LinkedHashMap<String, CCTerm> isIndices = new LinkedHashMap<String, CCTerm>();
            for (CCTerm isFun : (LinkedHashSet)falseIsFuns.get(cct)) {
                isIndices.put(((ApplicationTerm)isFun.mFlatTerm).getFunction().getIndices()[0], isFun);
            }
            if (isIndices.size() != dt.getConstructors().length) continue;
            ArrayList reason = new ArrayList();
            Term[] testers = new Term[dt.getConstructors().length];
            int i = 0;
            CCTerm firstArg = null;
            for (DataType.Constructor consName : dt.getConstructors()) {
                CCTerm isFun = (CCTerm)isIndices.get(consName.getName());
                testers[i++] = isFun.mFlatTerm;
                CCTerm arg = ((CCAppTerm)isFun).mArg;
                reason.add(new SymmetricPair<CCTerm>(isFun, falseCC));
                if (firstArg == null) {
                    firstArg = arg;
                    continue;
                }
                if (firstArg == arg) continue;
                reason.add(new SymmetricPair<CCTerm>(firstArg, arg));
            }
            DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_CASES, reason.toArray(new SymmetricPair[reason.size()]), testers);
            this.mClausifier.getLogger().debug("Conflict: Rule 6");
            return this.computeClause(null, lemma);
        }
        return this.processPendingLemmas();
    }

    private Clause checkDTCycles() {
        HashSet<CCTerm> visited = new HashSet<CCTerm>();
        ArrayDeque<CCTerm> path = new ArrayDeque<CCTerm>();
        HashSet<CCTerm> visitedOnPath = new HashSet<CCTerm>();
        ArrayDeque<CCTerm> todo = new ArrayDeque<CCTerm>();
        HashMap<CCTerm, CCAppTerm> trueTesters = new HashMap<CCTerm, CCAppTerm>();
        for (CCTerm start : this.mCClosure.mAllTerms) {
            if (start.mFlatTerm == null || !start.mFlatTerm.getSort().getSortSymbol().isDatatype()) continue;
            todo.push(start);
            while (!todo.isEmpty()) {
                CCTerm ct = (CCTerm)todo.pop();
                CCTerm rep = ct.getRepresentative();
                if (visited.contains(rep)) {
                    if (path.peek() == ct) {
                        path.pop();
                        visitedOnPath.remove(rep);
                        continue;
                    }
                    assert (!visitedOnPath.contains(rep));
                    continue;
                }
                List<CCTerm> children = this.getAllDataTypeChildren(rep, trueTesters);
                if (!children.isEmpty()) {
                    path.push(ct);
                    visitedOnPath.add(rep);
                    todo.push(ct);
                    for (CCTerm c : children) {
                        if (visitedOnPath.contains(c.getRepresentative())) {
                            return this.buildCycleConflict(c, path, trueTesters);
                        }
                        todo.push(c);
                    }
                }
                visited.add(rep);
            }
        }
        return null;
    }

    @Override
    public Clause computeConflictClause() {
        CCTerm consTerm;
        ArrayList<CCTerm> dataTypeTerms = new ArrayList<CCTerm>();
        for (CCTerm ct : this.mCClosure.mAllTerms) {
            if (ct != ct.mRep || ct.mFlatTerm == null || !ct.mFlatTerm.getSort().getSortSymbol().isDatatype()) continue;
            dataTypeTerms.add(ct);
        }
        for (CCTerm ct : dataTypeTerms) {
            this.createIsApplications(ct);
        }
        Clause conflict = this.checkDTCycles();
        if (conflict != null) {
            return conflict;
        }
        if (!this.mPendingLemmas.isEmpty()) {
            return this.processPendingLemmas();
        }
        for (CCTerm rep : this.mCClosure.mAllTerms) {
            if (rep.getRepresentative() != rep) continue;
            for (CCTerm member : rep.mMembers) {
                if (!DataTypeTheory.isConstructorApp(member.mFlatTerm)) continue;
                ApplicationTerm memberAt = (ApplicationTerm)member.mFlatTerm;
                assert (rep.getSharedTerm() != null);
                if (member == rep.getSharedTerm()) continue;
                consTerm = rep.getSharedTerm();
                ApplicationTerm consAt = (ApplicationTerm)consTerm.mFlatTerm;
                if (((ApplicationTerm)member.mFlatTerm).getFunction() != ((ApplicationTerm)consTerm.mFlatTerm).getFunction()) {
                    this.mCClosure.getLogger().error("Unpropagated equality on different conses");
                    this.computeInjectiveDisjointLemmas(consTerm, member);
                    continue;
                }
                for (int i = 0; i < memberAt.getParameters().length; ++i) {
                    CCTerm consArg = this.mClausifier.getCCTerm(consAt.getParameters()[i]);
                    CCTerm memArg = this.mClausifier.getCCTerm(memberAt.getParameters()[i]);
                    if (memArg.mRepStar == consArg.mRepStar) continue;
                    this.mCClosure.getLogger().error("Unpropagated constructor argument equality");
                    this.computeInjectiveDisjointLemmas(consTerm, member);
                }
            }
        }
        for (CCTerm ccTerm : this.mCClosure.mAllTerms) {
            CCTerm argTerm;
            if (!(ccTerm.getFlatTerm() instanceof ApplicationTerm)) continue;
            ApplicationTerm appTerm = (ApplicationTerm)ccTerm.getFlatTerm();
            FunctionSymbol fs = appTerm.getFunction();
            if (!appTerm.getFunction().isSelector() && !appTerm.getFunction().getName().equals("is") || (consTerm = (argTerm = ((CCAppTerm)ccTerm).getArg()).getRepresentative().getSharedTerm()) == null) continue;
            ApplicationTerm consApp = (ApplicationTerm)consTerm.getFlatTerm();
            DataType datatype = (DataType)consApp.getSort().getSortSymbol();
            DataType.Constructor constructor = datatype.getConstructor(consApp.getFunction().getName());
            if (appTerm.getFunction().getName().equals("is")) {
                ApplicationTerm truthValue = fs.getIndices()[0].equals(constructor.getName()) ? this.mClausifier.getTheory().mTrue : this.mClausifier.getTheory().mFalse;
                CCTerm truthCC = this.mClausifier.getCCTerm(truthValue);
                if (ccTerm.getRepresentative() == truthCC.getRepresentative()) continue;
                this.mCClosure.getLogger().error("Unpropagated is of constructor");
                SymmetricPair[] reason = new SymmetricPair[]{new SymmetricPair<CCTerm>(consTerm, argTerm)};
                SymmetricPair<CCTerm> mainEq = new SymmetricPair<CCTerm>(ccTerm, truthCC);
                DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_TESTER, mainEq, reason, consTerm);
                this.addPendingLemma(lemma);
                continue;
            }
            if (!appTerm.getFunction().isSelector()) continue;
            String[] allSelectorNames = constructor.getSelectors();
            for (int i = 0; i < allSelectorNames.length; ++i) {
                if (!allSelectorNames[i].equals(appTerm.getFunction().getName())) continue;
                CCTerm consArg = this.mClausifier.getCCTerm(consApp.getParameters()[i]);
                if (ccTerm.getRepresentative() == consArg.getRepresentative()) continue;
                this.mCClosure.getLogger().error("Unpropagated selector of constructor");
                SymmetricPair[] reason = new SymmetricPair[]{new SymmetricPair<CCTerm>(consTerm, argTerm)};
                SymmetricPair<CCTerm> mainEq = new SymmetricPair<CCTerm>(ccTerm, consArg);
                DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_PROJECT, mainEq, reason, consTerm);
                this.addPendingLemma(lemma);
            }
        }
        return this.processPendingLemmas();
    }

    private Map<FunctionSymbol, CCAppTerm> getSelectorsAndTesters(CCTerm ccTerm) {
        assert (ccTerm == ccTerm.getRepresentative());
        LinkedHashMap<FunctionSymbol, CCAppTerm> map = new LinkedHashMap<FunctionSymbol, CCAppTerm>();
        CCParentInfo pInfo = ccTerm.mCCPars;
        while (pInfo != null) {
            if (pInfo.mCCParents != null && !pInfo.mCCParents.isEmpty()) {
                FunctionSymbol pFun;
                CCAppTerm p = pInfo.mCCParents.iterator().next().getData();
                if (p.mFlatTerm instanceof ApplicationTerm && ((pFun = ((ApplicationTerm)p.mFlatTerm).getFunction()).isSelector() || pFun.getName().equals("is"))) {
                    map.put(pFun, p);
                }
            }
            pInfo = pInfo.mNext;
        }
        return map;
    }

    private List<CCTerm> getAllDataTypeChildren(CCTerm ccTerm, Map<CCTerm, CCAppTerm> trueTesters) {
        ArrayList<CCTerm> children = new ArrayList<CCTerm>();
        CCTerm rep = ccTerm.getRepresentative();
        CCTerm sharedTerm = rep.getSharedTerm();
        if (sharedTerm != null) {
            CCTerm func = sharedTerm;
            while (func instanceof CCAppTerm) {
                CCAppTerm appTerm = (CCAppTerm)func;
                CCTerm arg = appTerm.getArg();
                if (arg.getFlatTerm().getSort().getSortSymbol().isDatatype()) {
                    children.add(arg);
                }
                func = appTerm.getFunc();
            }
            return children;
        }
        DataType datatype = (DataType)rep.mFlatTerm.getSort().getSortSymbol();
        CCTerm trueRep = this.mClausifier.getCCTerm((Term)this.mTheory.mTrue).mRepStar;
        LinkedHashSet<CCAppTerm> selectors = new LinkedHashSet<CCAppTerm>();
        FunctionSymbol trueTester = null;
        LinkedHashSet<FunctionSymbol> falseTesters = new LinkedHashSet<FunctionSymbol>();
        for (Map.Entry<FunctionSymbol, CCAppTerm> entry : this.getSelectorsAndTesters(rep).entrySet()) {
            FunctionSymbol func = entry.getKey();
            if (func.isSelector()) {
                if (!func.getReturnSort().getSortSymbol().isDatatype()) continue;
                selectors.add(entry.getValue());
                continue;
            }
            CCAppTerm tester = entry.getValue();
            if (tester.getRepresentative() == trueRep) {
                assert (trueTester == null);
                trueTester = func;
                trueTesters.put(rep, tester);
                continue;
            }
            falseTesters.add(func);
        }
        if (trueTester != null) {
            DataType.Constructor c = datatype.getConstructor(trueTester.getIndices()[0]);
            HashSet<String> validSelectors = new HashSet<String>();
            validSelectors.addAll(Arrays.asList(c.getSelectors()));
            for (CCAppTerm s : selectors) {
                if (!validSelectors.contains(((ApplicationTerm)s.mFlatTerm).getFunction().getName())) continue;
                children.add(s);
            }
        } else {
            HashSet<String> invalidSelectors = new HashSet<String>();
            for (FunctionSymbol falseTester : falseTesters) {
                DataType.Constructor c = datatype.getConstructor(falseTester.getIndices()[0]);
                invalidSelectors.addAll(Arrays.asList(c.getSelectors()));
            }
            for (CCAppTerm s : selectors) {
                if (invalidSelectors.contains(((ApplicationTerm)s.mFlatTerm).getFunction().getName())) continue;
                children.add(s);
            }
        }
        return children;
    }

    private Clause buildCycleConflict(CCTerm currentTerm, Deque<CCTerm> path, Map<CCTerm, CCAppTerm> trueTesters) {
        ArrayList<SymmetricPair<CCTerm>> reason = new ArrayList<SymmetricPair<CCTerm>>();
        ArrayDeque<CCTerm> cycle = new ArrayDeque<CCTerm>();
        CCTerm trueCC = this.mClausifier.getCCTerm(this.mTheory.mTrue);
        CCTerm currentTermRep = currentTerm.mRepStar;
        CCTerm currentAsChild = currentTerm;
        cycle.addFirst(currentTerm);
        while (true) {
            CCTerm prevAsChild;
            CCTerm prevAsParent;
            if ((prevAsParent = (prevAsChild = path.pop()).getRepresentative().getSharedTerm()) == null) {
                CCAppTerm trueTester = trueTesters.get(prevAsChild.getRepresentative());
                if (trueTester != null) {
                    reason.add(new SymmetricPair<CCTerm>(trueTester, trueCC));
                    CCTerm testerArg = trueTester.getArg();
                    assert (prevAsChild.getRepresentative() == testerArg.getRepresentative());
                    if (testerArg != prevAsChild) {
                        reason.add(new SymmetricPair<CCTerm>(prevAsChild, testerArg));
                    }
                } else {
                    ApplicationTerm selectorApp = (ApplicationTerm)currentAsChild.mFlatTerm;
                    FunctionSymbol selectorFunc = selectorApp.getFunction();
                    DataType.Constructor cons = this.getConstructor(selectorFunc);
                    Term isTerm = this.mTheory.term(this.mTheory.getFunctionWithResult("is", new String[]{cons.getName()}, null, selectorFunc.getParameterSorts()[0]), selectorApp.getParameters()[0]);
                    this.mClausifier.createCCTerm(isTerm, SourceAnnotation.EMPTY_SOURCE_ANNOT);
                    return null;
                }
                prevAsParent = ((CCAppTerm)currentAsChild).getArg();
            }
            cycle.addFirst(prevAsParent);
            assert (prevAsChild.getRepresentative() == prevAsParent.getRepresentative());
            if (prevAsChild.getRepresentative() == currentTermRep) {
                cycle.addFirst(currentTerm);
                if (currentTerm == prevAsParent) break;
                reason.add(new SymmetricPair<CCTerm>(currentTerm, prevAsParent));
                break;
            }
            cycle.addFirst(prevAsChild);
            if (prevAsChild != prevAsParent) {
                reason.add(new SymmetricPair<CCTerm>(prevAsChild, prevAsParent));
            }
            currentAsChild = prevAsChild;
        }
        DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_CYCLE, reason.toArray(new SymmetricPair[reason.size()]), cycle.toArray(new CCTerm[cycle.size()]));
        this.mClausifier.getLogger().debug("Found Cycle: %s", cycle);
        return this.computeClause(null, lemma);
    }

    public Clause computeClause(CCEquality eq, DataTypeLemma lemma) {
        boolean isProofEnabled = this.mClausifier.getEngine().isProofGenerationEnabled();
        CongruencePath cp = new CongruencePath(this.mCClosure);
        return cp.computeDTLemma(eq, lemma, isProofEnabled);
    }

    @Override
    public Literal getPropagatedLiteral() {
        if (!this.mPendingEqualities.isEmpty()) {
            return this.mPendingEqualities.poll();
        }
        return null;
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        CCEquality eq = (CCEquality)literal;
        return this.computeClause(eq, this.mEqualityReasons.get(eq));
    }

    @Override
    public Literal getSuggestion() {
        return null;
    }

    @Override
    public int checkCompleteness() {
        return 0;
    }

    @Override
    public void printStatistics(LogProxy logger) {
    }

    @Override
    public void dumpModel(LogProxy logger) {
    }

    @Override
    public void increasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void decreasedDecideLevel(int currentDecideLevel) {
    }

    public void addRecheckOnBacktrack(CCAppTerm newAppTerm) {
        this.mRecheckOnBacktrack.add(newAppTerm);
    }

    @Override
    public void backtrackStart() {
        this.mPendingLemmas.clear();
        this.mPendingEqualities.clear();
    }

    @Override
    public Clause backtrackComplete() {
        ArrayQueue<CCAppTerm> newRecheckOnBacktrack = new ArrayQueue<CCAppTerm>();
        while (!this.mRecheckOnBacktrack.isEmpty()) {
            CCTerm constructorCCTerm = null;
            ApplicationTerm constructor = null;
            CCAppTerm checkTerm = this.mRecheckOnBacktrack.poll();
            ApplicationTerm selectOrIsTerm = (ApplicationTerm)checkTerm.mFlatTerm;
            FunctionSymbol selectorOrTester = selectOrIsTerm.getFunction();
            CCTerm selectOrIsArg = checkTerm.getArg();
            assert (selectorOrTester.isSelector() || selectorOrTester.getName().equals("is"));
            for (CCTerm ct : selectOrIsArg.getRepresentative().mMembers) {
                if (!(ct.mFlatTerm instanceof ApplicationTerm) || !((ApplicationTerm)ct.mFlatTerm).getFunction().isConstructor()) continue;
                constructorCCTerm = ct;
                constructor = (ApplicationTerm)ct.mFlatTerm;
                break;
            }
            if (constructor == null) continue;
            SymmetricPair[] reason = selectOrIsArg != constructorCCTerm ? new SymmetricPair[]{new SymmetricPair<Object>(selectOrIsArg, constructorCCTerm)} : new SymmetricPair[]{};
            if (selectorOrTester.isSelector()) {
                String selName = selectorOrTester.getName();
                DataType.Constructor c = this.getConstructor(selectorOrTester);
                if (!c.getName().equals(constructor.getFunction().getName())) continue;
                for (int i = 0; i < c.getSelectors().length; ++i) {
                    if (!selName.equals(c.getSelectors()[i])) continue;
                    CCTerm arg = this.mClausifier.getCCTerm(constructor.getParameters()[i]);
                    if (arg.mRepStar != checkTerm.mRepStar) {
                        SymmetricPair<CCTerm> provedEq = new SymmetricPair<CCTerm>(checkTerm, arg);
                        DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_PROJECT, provedEq, reason, constructorCCTerm);
                        this.addPendingLemma(lemma);
                    }
                    newRecheckOnBacktrack.add(checkTerm);
                }
                continue;
            }
            if (!constructor.getFunction().getName().equals(selectorOrTester.getIndices()[0])) continue;
            CCTerm ccTrue = this.mClausifier.getCCTerm(this.mTheory.mTrue);
            if (ccTrue.mRepStar != checkTerm.mRepStar) {
                SymmetricPair<CCTerm> provedEq = new SymmetricPair<CCTerm>(checkTerm, this.mClausifier.getCCTerm(this.mTheory.mTrue));
                DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_TESTER, provedEq, reason, constructorCCTerm);
                this.addPendingLemma(lemma);
            }
            newRecheckOnBacktrack.add(checkTerm);
        }
        this.mRecheckOnBacktrack = newRecheckOnBacktrack;
        return this.processPendingLemmas();
    }

    @Override
    public void backtrackAll() {
    }

    @Override
    public void restart(int iteration) {
    }

    @Override
    public void removeAtom(DPLLAtom atom) {
    }

    @Override
    public void push() {
    }

    @Override
    public void pop() {
        this.mInfinityMap.clear();
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":DT"};
    }

    private void addConstructorLemma(CCAppTerm isTerm) {
        CCTerm arg = isTerm.mArg;
        if (arg.getRepresentative().getSharedTerm() != null) {
            return;
        }
        ApplicationTerm at = (ApplicationTerm)isTerm.mFlatTerm;
        String consName = at.getFunction().getIndices()[0];
        Term dtTerm = arg.mFlatTerm;
        DataType dt = (DataType)dtTerm.getSort().getSortSymbol();
        DataType.Constructor c = dt.getConstructor(consName);
        if (this.checkMissingInfiniteSelector(arg, c)) {
            return;
        }
        Term[] selectorTerms = new Term[c.getSelectors().length];
        for (int i = 0; i < selectorTerms.length; ++i) {
            selectorTerms[i] = this.mTheory.term(c.getSelectors()[i], dtTerm);
        }
        Sort consType = c.needsReturnOverload() ? dtTerm.getSort() : null;
        Term consTerm = this.mTheory.term(consName, null, consType, selectorTerms);
        CCTerm consCCTerm = this.mClausifier.createCCTerm(consTerm, SourceAnnotation.EMPTY_SOURCE_ANNOT);
        SymmetricPair<CCTerm> eq = new SymmetricPair<CCTerm>(arg, consCCTerm);
        DataTypeLemma lemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_CONSTRUCTOR, eq, new SymmetricPair[]{new SymmetricPair<CCTerm>(isTerm, this.mClausifier.getCCTerm(this.mTheory.mTrue))});
        this.mClausifier.getLogger().info("New DT_CONSTRUCTOR lemma for %s", dtTerm);
        this.addPendingLemma(lemma);
    }

    private boolean checkMissingInfiniteSelector(CCTerm ccterm, DataType.Constructor constr) {
        Sort dataTypeSort = ccterm.mFlatTerm.getSort();
        for (int i = 0; i < constr.getArgumentSorts().length; ++i) {
            FunctionSymbol selector;
            if (!this.isInfinite(constr.getArgumentSorts()[i]) || !this.mCClosure.getAllFuncAppsForArg(selector = this.mTheory.getFunction(constr.getSelectors()[i], dataTypeSort), ccterm, 0).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void createIsApplications(CCTerm ccterm) {
        SortSymbol sym = ccterm.mFlatTerm.getSort().getSortSymbol();
        if (ccterm.getSharedTerm() != null) {
            return;
        }
        for (DataType.Constructor c : ((DataType)sym).getConstructors()) {
            if (this.checkMissingInfiniteSelector(ccterm, c)) continue;
            FunctionSymbol isFs = this.mTheory.getFunctionWithResult("is", new String[]{c.getName()}, null, ccterm.getFlatTerm().getSort());
            Term isTerm = this.mTheory.term(isFs, ccterm.mFlatTerm);
            if (this.mClausifier.getCCTerm(isTerm) != null) continue;
            this.mClausifier.createCCTerm(isTerm, SourceAnnotation.EMPTY_SOURCE_ANNOT);
        }
    }

    private boolean isInfinite(Sort sort) {
        Boolean cacheVal = this.mInfinityMap.get(sort);
        if (cacheVal != null) {
            return cacheVal;
        }
        ArrayDeque<Sort> todo = new ArrayDeque<Sort>();
        LinkedHashSet<Sort> dependent = new LinkedHashSet<Sort>();
        todo.push(sort);
        block0: while (!todo.isEmpty()) {
            Sort currSort = (Sort)todo.pop();
            if (currSort.getSortSymbol().isDatatype() || currSort.isArraySort()) {
                LinkedHashSet<Sort> subSorts = new LinkedHashSet<Sort>();
                if (currSort.getSortSymbol().isDatatype()) {
                    for (DataType.Constructor c : ((DataType)currSort.getSortSymbol()).getConstructors()) {
                        subSorts.addAll(Arrays.asList(c.getArgumentSorts()));
                    }
                } else {
                    subSorts.addAll(Arrays.asList(currSort.getArguments()));
                }
                Iterator iterator = subSorts.iterator();
                while (iterator.hasNext()) {
                    Sort argSort = (Sort)iterator.next();
                    Boolean cv = this.mInfinityMap.get(argSort);
                    if (cv != null) {
                        iterator.remove();
                        if (!cv.booleanValue()) continue;
                        this.mInfinityMap.put(currSort, true);
                        dependent.remove(currSort);
                        continue block0;
                    }
                    if (!dependent.contains(argSort)) continue;
                    this.mInfinityMap.put(currSort, true);
                    dependent.remove(currSort);
                    continue block0;
                }
                if (!subSorts.isEmpty()) {
                    todo.push(currSort);
                    dependent.add(currSort);
                    for (Sort s : subSorts) {
                        todo.push(s);
                    }
                    continue;
                }
                this.mInfinityMap.put(currSort, false);
                dependent.remove(currSort);
                continue;
            }
            if (currSort.isNumericSort()) {
                this.mInfinityMap.put(currSort, true);
                continue;
            }
            this.mInfinityMap.put(currSort, false);
        }
        return this.mInfinityMap.get(sort);
    }

    private DataType.Constructor getConstructor(FunctionSymbol selector) {
        assert (selector.isSelector()) : "Not a selector";
        String selName = selector.getName();
        DataType.Constructor cons = this.mSelectorMap.get(selName);
        if (cons != null) {
            return cons;
        }
        for (DataType.Constructor c : ((DataType)selector.getParameterSorts()[0].getSortSymbol()).getConstructors()) {
            if (!Arrays.asList(c.getSelectors()).contains(selName)) continue;
            this.mSelectorMap.put(selName, c);
            return c;
        }
        throw new AssertionError((Object)("No constructor for selector " + selector));
    }

    private static boolean isConstructorApp(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().isConstructor();
    }

    private Term createUniqueValue(ModelBuilder modelBuilder, FunctionSymbol constr, Term[] args) {
        boolean foundInfinite = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            Sort sort = constr.getParameterSorts()[i];
            if (this.isInfinite(sort) && !foundInfinite) {
                args[i] = modelBuilder.getModel().extendFresh(sort);
                foundInfinite = true;
                continue;
            }
            args[i] = modelBuilder.getModel().getSomeValue(sort);
        }
        return this.mTheory.term(constr, args);
    }

    public void fillInModel(ModelBuilder modelBuilder, List<Sort> sorts, LinkedHashMap<Sort, List<CCTerm>> repsBySort) {
        LinkedHashMap<CCTerm, ConstrTerm> valueMap = new LinkedHashMap<CCTerm, ConstrTerm>();
        for (Sort sort : sorts) {
            assert (sort.getSortSymbol().isDatatype());
            List<CCTerm> ccTerms = repsBySort.get(sort);
            if (ccTerms == null) continue;
            for (CCTerm ct : ccTerms) {
                CCTerm sharedTerm = ct.getSharedTerm();
                if (sharedTerm != null) {
                    FunctionSymbol constr = ((ApplicationTerm)sharedTerm.getFlatTerm()).getFunction();
                    CCTerm[] args = new CCTerm[constr.getParameterSorts().length];
                    for (int i = constr.getParameterSorts().length - 1; i >= 0; --i) {
                        CCAppTerm app = (CCAppTerm)sharedTerm;
                        args[i] = app.getArg();
                        sharedTerm = app.getFunc();
                    }
                    valueMap.put(ct, new ConstrTerm(constr, args));
                    continue;
                }
                Map<FunctionSymbol, CCAppTerm> selectorsAndTester = this.getSelectorsAndTesters(ct);
                DataType.Constructor constr = this.findConstructorFromTester(ct, selectorsAndTester, modelBuilder);
                String[] selectors = constr.getSelectors();
                Sort[] argSorts = new Sort[selectors.length];
                CCTerm[] args = new CCTerm[selectors.length];
                for (int i = 0; i < selectors.length; ++i) {
                    FunctionSymbol selector = this.mTheory.getFunction(selectors[i], sort);
                    argSorts[i] = selector.getReturnSort();
                    args[i] = selectorsAndTester.get(selector);
                }
                Sort consType = constr.needsReturnOverload() ? sort : null;
                FunctionSymbol constrFunc = this.mTheory.getFunctionWithResult(constr.getName(), null, consType, argSorts);
                valueMap.put(ct, new ConstrTerm(constrFunc, args));
            }
        }
        ArrayDeque todoStack = new ArrayDeque(valueMap.keySet());
        ArrayDeque<CCTerm> path = new ArrayDeque<CCTerm>();
        HashSet<CCTerm> visited = new HashSet<CCTerm>();
        while (!todoStack.isEmpty()) {
            ArrayDeque<CCTerm> delayed = new ArrayDeque<CCTerm>();
            CCTerm nextHole = null;
            Term[] nextHoleArgs = null;
            visited.clear();
            while (!todoStack.isEmpty()) {
                CCTerm ct = (CCTerm)todoStack.removeLast();
                if (modelBuilder.getModelValue(ct) != null) continue;
                if (!visited.add(ct)) {
                    delayed.addAll(path);
                    path.clear();
                    continue;
                }
                ConstrTerm constrTerm = (ConstrTerm)valueMap.get(ct);
                Term[] argModels = new Term[constrTerm.mArguments.length];
                boolean undefined = false;
                boolean hasHole = false;
                for (int i = 0; i < argModels.length; ++i) {
                    CCTerm arg = constrTerm.mArguments[i];
                    if (arg != null) {
                        arg = arg.getRepresentative();
                        argModels[i] = modelBuilder.getModelValue(arg);
                        if (argModels[i] != null) continue;
                        assert (valueMap.containsKey(arg));
                        path.add(ct);
                        todoStack.addLast(arg);
                        undefined = true;
                        break;
                    }
                    hasHole = true;
                }
                if (undefined) continue;
                if (hasHole) {
                    delayed.addAll(path);
                    if (nextHole == null) {
                        nextHole = ct;
                        nextHoleArgs = argModels;
                    } else {
                        delayed.add(ct);
                    }
                    path.clear();
                    continue;
                }
                Term modelTerm = this.mTheory.term(constrTerm.mConstr, argModels);
                modelBuilder.setModelValue(ct, modelTerm);
                if (path.isEmpty()) continue;
                CCTerm nextFromPath = (CCTerm)path.removeLast();
                visited.remove(nextFromPath);
                todoStack.addLast(nextFromPath);
            }
            if (nextHole != null) {
                ConstrTerm constrTerm = (ConstrTerm)valueMap.get(nextHole);
                Term modelTerm = this.createUniqueValue(modelBuilder, constrTerm.mConstr, nextHoleArgs);
                modelBuilder.setModelValue(nextHole, modelTerm);
                todoStack.addAll(delayed);
                continue;
            }
            assert (delayed.isEmpty());
        }
    }

    private DataType.Constructor findConstructorFromTester(CCTerm ct, Map<FunctionSymbol, CCAppTerm> selectorsAndTesters, ModelBuilder modelBuilder) {
        Sort sort = ct.getFlatTerm().getSort();
        DataType datatype = (DataType)sort.getSortSymbol();
        DataType.Constructor suitableConstructor = null;
        for (DataType.Constructor constr : datatype.getConstructors()) {
            FunctionSymbol tester = this.mTheory.getFunctionWithResult("is", new String[]{constr.getName()}, null, sort);
            CCAppTerm testerApp = selectorsAndTesters.get(tester);
            if (testerApp == null) {
                if (suitableConstructor != null) continue;
                suitableConstructor = constr;
                continue;
            }
            if (modelBuilder.getModelValue(testerApp.getRepresentative()) != this.mTheory.mTrue) continue;
            return constr;
        }
        assert (suitableConstructor != null) : "Unpropagated dt_cases lemma";
        return suitableConstructor;
    }

    private class ConstrTerm {
        FunctionSymbol mConstr;
        CCTerm[] mArguments;

        public ConstrTerm(FunctionSymbol constr, CCTerm[] args) {
            this.mConstr = constr;
            this.mArguments = args;
        }
    }
}

