/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.NumericSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ComputeSCC;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModelBuilder {
    Model mModel;
    SharedTermEvaluator mEvaluator;
    Map<CCTerm, Term> mModelValues = new HashMap<CCTerm, Term>();
    Theory mTheory;

    public ModelBuilder(CClosure closure, List<CCTerm> terms, Model model, final Theory t, SharedTermEvaluator ste, ArrayTheory arrayTheory, DataTypeTheory datatypeTheory, CCTerm trueNode, CCTerm falseNode) {
        this.mModel = model;
        this.mEvaluator = ste;
        this.mTheory = t;
        LinkedHashMap<Sort, List<CCTerm>> repsBySort = new LinkedHashMap<Sort, List<CCTerm>>();
        for (CCTerm term : terms) {
            if (term.getRepresentative() != term || term.getFlatTerm() == null) continue;
            Sort sort2 = term.getFlatTerm().getSort();
            ArrayList<CCTerm> reps = (ArrayList<CCTerm>)repsBySort.get(sort2);
            if (reps == null) {
                reps = new ArrayList<CCTerm>();
                repsBySort.put(sort2, reps);
            }
            reps.add(term);
        }
        ComputeSCC.ComputeSuccessor<Sort> dependencies = sort -> {
            if (sort.isArraySort()) {
                return Arrays.asList(sort.getArguments()).iterator();
            }
            if (sort.getSortSymbol().isDatatype()) {
                final Sort[] datatypeParameters = sort.getArguments();
                final DataType.Constructor[] constrs = ((DataType)sort.getSortSymbol()).getConstructors();
                return new Iterator<Sort>(){
                    int mConstructorIdx = 0;
                    int mSortIdx = 0;
                    Sort[] mSorts = new Sort[]{t.getBooleanSort()};

                    @Override
                    public boolean hasNext() {
                        while (this.mSortIdx >= this.mSorts.length) {
                            if (this.mConstructorIdx == constrs.length) {
                                return false;
                            }
                            this.mSorts = constrs[this.mConstructorIdx++].getArgumentSorts();
                            this.mSortIdx = 0;
                        }
                        return true;
                    }

                    @Override
                    public Sort next() {
                        while (this.mSortIdx >= this.mSorts.length) {
                            this.mSorts = constrs[this.mConstructorIdx++].getArgumentSorts();
                            this.mSortIdx = 0;
                        }
                        Sort dependentSort = this.mSorts[this.mSortIdx++];
                        return datatypeParameters == null ? dependentSort : dependentSort.mapSort(datatypeParameters);
                    }
                };
            }
            return Collections.emptyListIterator();
        };
        List<List<Sort>> sortSCCs = new ComputeSCC<Sort>(dependencies).getSCCs(repsBySort.keySet().iterator());
        for (List<Sort> scc : sortSCCs) {
            if (scc.get(0).getSortSymbol().isDatatype()) {
                datatypeTheory.fillInModel(this, scc, repsBySort);
                continue;
            }
            assert (scc.size() == 1);
            Sort sort3 = scc.get(0);
            if (!repsBySort.containsKey(sort3)) continue;
            if (sort3.isArraySort()) {
                arrayTheory.fillInModel(this, repsBySort.get(sort3));
                continue;
            }
            this.fillInTermValues(repsBySort.get(sort3), trueNode, falseNode);
        }
        this.fillInFunctions(terms, model, t);
    }

    public Model getModel() {
        return this.mModel;
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    public SharedTermEvaluator getEvaluator() {
        return this.mEvaluator;
    }

    public Term getModelValue(CCTerm term) {
        return this.mModelValues.get(term.getRepresentative());
    }

    public void setModelValue(CCTerm term, Term value) {
        assert (term == term.getRepresentative());
        Term old = this.mModelValues.put(term, value);
        this.mModel.provideSortInterpretation(value.getSort()).register(value);
        assert (old == null || old == value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fillInTermValues(List<CCTerm> terms, CCTerm trueNode, CCTerm falseNode) {
        Term value;
        HashSet<CCTerm> delayed = new HashSet<CCTerm>();
        for (CCTerm ccterm : terms) {
            block12: {
                if (ccterm != ccterm.mRepStar || ccterm.isFunc()) continue;
                Term smtterm = ccterm.getFlatTerm();
                Sort sort = smtterm.getSort();
                if (sort.isNumericSort()) {
                    if (ccterm.getSharedTerm() != null) {
                        Rational v = this.mEvaluator.evaluate(ccterm.getSharedTerm().getFlatTerm(), this.mTheory);
                        if (smtterm.getSort().getName().equals("Int") && !v.isIntegral()) {
                            throw new AssertionError((Object)"Int term has non-integral value");
                        }
                        value = v.toTerm(sort);
                        break block12;
                    } else {
                        delayed.add(ccterm);
                        continue;
                    }
                }
                if (ccterm == trueNode.mRepStar) {
                    value = sort.getTheory().mTrue;
                } else if (sort.isInternal() && sort.getName().equals("Bool")) {
                    value = sort.getTheory().mFalse;
                } else {
                    assert (!sort.isArraySort() && !sort.getSortSymbol().isDatatype());
                    value = this.mModel.extendFresh(sort);
                }
            }
            this.setModelValue(ccterm, value);
        }
        Iterator<CCTerm> iterator = delayed.iterator();
        while (iterator.hasNext()) {
            CCTerm ccterm;
            ccterm = iterator.next();
            value = this.mModel.extendFresh(ccterm.getFlatTerm().getSort());
            this.setModelValue(ccterm, value);
        }
        return;
    }

    public void fillInFunctions(List<CCTerm> terms, Model model, Theory t) {
        for (CCTerm term : terms) {
            if (term.isFunc()) continue;
            this.add(model, term, this.mModelValues.get(term.getRepresentative()), t);
        }
    }

    private void add(Model model, CCTerm term, Term value, Theory t) {
        assert (!term.isFunc());
        if (term instanceof CCBaseTerm) {
            ApplicationTerm appTerm;
            FunctionSymbol symb;
            CCBaseTerm bt = (CCBaseTerm)term;
            Term btTerm = bt.getFlatTerm();
            if (btTerm instanceof ApplicationTerm && !(symb = (appTerm = (ApplicationTerm)btTerm).getFunction()).isIntern() && appTerm.getParameters().length == 0) {
                model.map(symb, value);
            }
        } else {
            CCAppTerm app = (CCAppTerm)term;
            this.addApp(model, app, value, t);
        }
    }

    private static boolean isDivision(FunctionSymbol fs) {
        String name = fs.getName();
        return name == "/" || name == "div" || name == "mod";
    }

    private boolean isUndefinedFor(FunctionSymbol fs, ArrayDeque<Term> args) {
        if (fs.isSelector()) {
            ApplicationTerm arg;
            DataType datatype = (DataType)fs.getParameterSorts()[0].getSortSymbol();
            DataType.Constructor c = datatype.getConstructor((arg = (ApplicationTerm)args.getFirst()).getFunction().getName());
            return !Arrays.asList(c.getSelectors()).contains(fs.getName());
        }
        if (ModelBuilder.isDivision(fs)) {
            return NumericSortInterpretation.toRational(args.getLast()) == Rational.ZERO;
        }
        return false;
    }

    private void addApp(Model model, CCAppTerm app, Term value, Theory t) {
        FunctionSymbol fs;
        ArrayDeque<Term> args = new ArrayDeque<Term>();
        CCTerm walk = app;
        while (walk instanceof CCAppTerm) {
            CCAppTerm appwalk = walk;
            args.addFirst(this.mModelValues.get(appwalk.getArg().getRepresentative()));
            walk = appwalk.getFunc();
        }
        CCBaseTerm base = (CCBaseTerm)walk;
        if (base.isFunctionSymbol() && (!(fs = base.getFunctionSymbol()).isIntern() || this.isUndefinedFor(fs, args))) {
            model.map(fs, args.toArray(new Term[args.size()]), value);
        }
    }
}

