/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class WeakCongruencePath
extends CongruencePath {
    final ArrayTheory mArrayTheory;

    public WeakCongruencePath(ArrayTheory arrayTheory) {
        super(arrayTheory.getCClosure());
        this.mArrayTheory = arrayTheory;
    }

    public Clause computeSelectOverWeakEQ(CCAppTerm select1, CCAppTerm select2, boolean produceProofs) {
        CCTerm i1 = select1.getArg();
        CCTerm i2 = select2.getArg();
        CCTerm a = ((CCAppTerm)select1.getFunc()).getArg();
        CCTerm b = ((CCAppTerm)select2.getFunc()).getArg();
        this.computePath(i1, i2);
        WeakSubPath weakPath = this.computeWeakPath(a, b, i1, produceProofs);
        this.mAllPaths.addFirst(weakPath);
        return this.generateClause(new SymmetricPair<CCTerm>(select1, select2), produceProofs, CCAnnotation.RuleKind.READ_OVER_WEAKEQ);
    }

    public Clause computeSelectConstOverWeakEQ(CCAppTerm select1, CCAppTerm const2, boolean produceProofs) {
        CCTerm value2 = const2.getArg();
        CCTerm i1 = select1.getArg();
        CCTerm a = ((CCAppTerm)select1.getFunc()).getArg();
        WeakSubPath weakPath = this.computeWeakPath(a, const2, i1, produceProofs);
        this.mAllPaths.addFirst(weakPath);
        return this.generateClause(new SymmetricPair<CCTerm>(select1, value2), produceProofs, CCAnnotation.RuleKind.READ_CONST_WEAKEQ);
    }

    public Clause computeConstOverWeakEQ(CCAppTerm const1, CCAppTerm const2, boolean produceProofs) {
        CCTerm value1 = const1.getArg();
        CCTerm value2 = const2.getArg();
        HashSet<CCTerm> storeIndices = new HashSet<CCTerm>();
        Cursor start = new Cursor(const1, this.mArrayTheory.mCongRoots.get(const1.getRepresentative()));
        Cursor dest = new Cursor(const2, this.mArrayTheory.mCongRoots.get(const2.getRepresentative()));
        CongruencePath.SubPath path = this.collectPathPrimary(start, dest, storeIndices, produceProofs);
        this.mAllPaths.addFirst(path);
        return this.generateClause(new SymmetricPair<CCTerm>(value1, value2), produceProofs, CCAnnotation.RuleKind.CONST_WEAKEQ);
    }

    public Clause computeWeakeqExt(CCTerm a, CCTerm b, boolean produceProofs) {
        assert (a != b);
        LinkedHashSet<CCTerm> storeIndices = new LinkedHashSet<CCTerm>();
        Cursor start = new Cursor(a, this.mArrayTheory.mCongRoots.get(a.getRepresentative()));
        Cursor dest = new Cursor(b, this.mArrayTheory.mCongRoots.get(b.getRepresentative()));
        CongruencePath.SubPath path = this.collectPathPrimary(start, dest, storeIndices, produceProofs);
        for (CCTerm idx : storeIndices) {
            WeakSubPath weakpath = this.computeWeakCongruencePath(a, b, idx, produceProofs);
            this.mAllPaths.addFirst(weakpath);
        }
        this.mAllPaths.addFirst(path);
        return this.generateClause(new SymmetricPair<CCTerm>(a, b), produceProofs, CCAnnotation.RuleKind.WEAKEQ_EXT);
    }

    private WeakSubPath computeWeakPath(CCTerm array1, CCTerm array2, CCTerm index, boolean produceProofs) {
        int count1;
        LinkedHashSet<CCTerm> storeIndices = new LinkedHashSet<CCTerm>();
        CCTerm indexRep = index.getRepresentative();
        Cursor cursor1 = new Cursor(array1, this.mArrayTheory.mCongRoots.get(array1.getRepresentative()));
        Cursor cursor2 = new Cursor(array2, this.mArrayTheory.mCongRoots.get(array2.getRepresentative()));
        WeakSubPath sub1 = new WeakSubPath(index, array1, produceProofs);
        WeakSubPath sub2 = new WeakSubPath(index, array2, produceProofs);
        assert (cursor1.mArrayNode.getWeakIRepresentative(indexRep) == cursor2.mArrayNode.getWeakIRepresentative(indexRep));
        int count2 = cursor2.mArrayNode.countSecondaryEdges(indexRep);
        for (count1 = cursor1.mArrayNode.countSecondaryEdges(indexRep); count1 > count2; --count1) {
            this.collectPathOneSecondary(cursor1, sub1, storeIndices, produceProofs);
        }
        while (count2 > count1) {
            this.collectPathOneSecondary(cursor2, sub2, storeIndices, produceProofs);
            --count2;
        }
        while (cursor1.mArrayNode.findSecondaryNode(indexRep) != cursor2.mArrayNode.findSecondaryNode(indexRep)) {
            this.collectPathOneSecondary(cursor1, sub1, storeIndices, produceProofs);
            this.collectPathOneSecondary(cursor2, sub2, storeIndices, produceProofs);
        }
        sub1.addSubPath(this.collectPathPrimary(cursor1, cursor2, storeIndices, produceProofs));
        sub1.addSubPath(sub2);
        for (CCTerm storeIdx : storeIndices) {
            this.computeIndexDiseq(index, storeIdx);
        }
        return sub1;
    }

    private WeakSubPath computeWeakCongruencePath(CCTerm array1, CCTerm array2, CCTerm index, boolean produceProofs) {
        CCTerm select2;
        CCTerm selectArray;
        CCAppTerm select;
        CCTerm select1;
        WeakSubPath path;
        ArrayTheory.ArrayNode rep2;
        CCTerm indexRep = index.getRepresentative();
        ArrayTheory.ArrayNode node1 = this.mArrayTheory.mCongRoots.get(array1.getRepresentative());
        ArrayTheory.ArrayNode node2 = this.mArrayTheory.mCongRoots.get(array2.getRepresentative());
        ArrayTheory.ArrayNode rep1 = node1.getWeakIRepresentative(indexRep);
        if (rep1 == (rep2 = node2.getWeakIRepresentative(indexRep))) {
            return this.computeWeakPath(array1, array2, index, produceProofs);
        }
        if (rep1.mConstTerm != null) {
            path = this.computeWeakPath(array1, rep1.mConstTerm, index, produceProofs);
            select1 = ArrayTheory.getValueFromConst(rep1.mConstTerm);
        } else {
            select = rep1.mSelects.get(indexRep);
            selectArray = ArrayTheory.getArrayFromSelect(select);
            this.computePath(index, ArrayTheory.getIndexFromSelect(select));
            path = this.computeWeakPath(array1, selectArray, index, produceProofs);
            select1 = select;
        }
        if (rep2.mConstTerm != null) {
            path.addEntry(rep2.mConstTerm, null);
            path.addSubPath(this.computeWeakPath(rep2.mConstTerm, array2, index, produceProofs));
            select2 = ArrayTheory.getValueFromConst(rep2.mConstTerm);
        } else {
            select = rep2.mSelects.get(indexRep);
            selectArray = ArrayTheory.getArrayFromSelect(select);
            this.computePath(index, ArrayTheory.getIndexFromSelect(select));
            path.addEntry(selectArray, null);
            path.addSubPath(this.computeWeakPath(selectArray, array2, index, produceProofs));
            select2 = select;
        }
        assert (select1.getRepresentative() == select2.getRepresentative());
        if (select1 != select2) {
            this.computePath(select1, select2);
        }
        return path;
    }

    public void collectPathOnePrimary(Cursor cursor, CongruencePath.SubPath path, HashSet<CCTerm> storeIndices) {
        CCAppTerm store;
        ArrayTheory.ArrayNode node = cursor.mArrayNode;
        CCTerm t1 = store = node.mPrimaryStore;
        CCTerm t2 = ArrayTheory.getArrayFromStore(store);
        if (t2.mRepStar == cursor.mArrayNode.mTerm) {
            CCTerm t = t2;
            t2 = t1;
            t1 = t;
        }
        assert (t1.mRepStar == node.mTerm);
        assert (t2.mRepStar == node.mPrimaryEdge.mTerm);
        if (cursor.mTerm != t1) {
            this.computePath(cursor.mTerm, t1);
            CongruencePath.SubPath subpath = (CongruencePath.SubPath)this.mAllPaths.removeFirst();
            path.addSubPath(subpath);
        }
        path.addEntry(t2, null);
        cursor.update(t2, node.mPrimaryEdge);
        storeIndices.add(ArrayTheory.getIndexFromStore(store));
    }

    private CongruencePath.SubPath collectPathPrimary(Cursor start, Cursor dest, HashSet<CCTerm> storeIndices, boolean produceProofs) {
        int count1;
        CongruencePath.SubPath path1 = new CongruencePath.SubPath(start.mTerm, produceProofs);
        CongruencePath.SubPath path2 = new CongruencePath.SubPath(dest.mTerm, produceProofs);
        int count2 = dest.mArrayNode.countPrimaryEdges();
        for (count1 = start.mArrayNode.countPrimaryEdges(); count1 > count2; --count1) {
            this.collectPathOnePrimary(start, path1, storeIndices);
        }
        while (count2 > count1) {
            this.collectPathOnePrimary(dest, path2, storeIndices);
            --count2;
        }
        while (start.mArrayNode != dest.mArrayNode) {
            this.collectPathOnePrimary(start, path1, storeIndices);
            this.collectPathOnePrimary(dest, path2, storeIndices);
        }
        if (start.mTerm != dest.mTerm) {
            this.computePath(start.mTerm, dest.mTerm);
            CongruencePath.SubPath subpath = (CongruencePath.SubPath)this.mAllPaths.removeFirst();
            path1.addSubPath(subpath);
        }
        path1.addSubPath(path2);
        return path1;
    }

    private void collectPathOneSecondary(Cursor cursor, WeakSubPath path, HashSet<CCTerm> storeIndices, boolean produceProofs) {
        CCAppTerm store;
        ArrayTheory.ArrayNode selector = cursor.mArrayNode.findSecondaryNode(path.mIdxRep);
        CCTerm t1 = store = selector.mSecondaryStore;
        CCTerm t2 = ArrayTheory.getArrayFromStore(store);
        ArrayTheory.ArrayNode n1 = this.mArrayTheory.mCongRoots.get(t1.mRepStar);
        ArrayTheory.ArrayNode n2 = this.mArrayTheory.mCongRoots.get(t2.mRepStar);
        if (n2.findSecondaryNode(path.mIdxRep) == selector) {
            ArrayTheory.ArrayNode n = n2;
            n2 = n1;
            n1 = n;
            CCTerm t = t2;
            t2 = t1;
            t1 = t;
        }
        assert (n1.findSecondaryNode(path.mIdxRep) == selector);
        path.addSubPath(this.collectPathPrimary(cursor, new Cursor(t1, n1), storeIndices, produceProofs));
        path.addEntry(t2, null);
        cursor.update(t2, n2);
        storeIndices.add(ArrayTheory.getIndexFromStore(store));
    }

    private void computeIndexDiseq(CCTerm idx, CCTerm idxFromStore) {
        CCEquality eqlit = this.mArrayTheory.getCClosure().createEquality(idx, idxFromStore, false);
        if (eqlit != null) {
            this.mAllLiterals.add(eqlit.negate());
        }
    }

    private Clause generateClause(SymmetricPair<CCTerm> diseq, boolean produceProofs, CCAnnotation.RuleKind rule) {
        CCEquality eq;
        if (diseq != null && (eq = this.mArrayTheory.getCClosure().createEquality(diseq.getFirst(), diseq.getSecond(), false)) != null) {
            this.mAllLiterals.add(eq.negate());
        }
        Literal[] lemma = new Literal[this.mAllLiterals.size()];
        int i = 0;
        for (Literal l : this.mAllLiterals) {
            lemma[i++] = l.negate();
        }
        Clause c = new Clause(lemma);
        if (produceProofs) {
            c.setProof(new LeafNode(-5, this.createAnnotation(diseq, rule)));
        }
        return c;
    }

    private CCAnnotation createAnnotation(SymmetricPair<CCTerm> diseq, CCAnnotation.RuleKind rule) {
        return new CCAnnotation(diseq, (Collection<CongruencePath.SubPath>)this.mAllPaths, rule);
    }

    static class WeakSubPath
    extends CongruencePath.SubPath {
        private final CCTerm mIdx;
        private final CCTerm mIdxRep;

        public WeakSubPath(CCTerm idx, CCTerm start, boolean produceProofs) {
            super(start, produceProofs);
            this.mIdx = idx;
            this.mIdxRep = idx.getRepresentative();
        }

        @Override
        public String toString() {
            return "Weakpath " + this.mIdx + (this.mTermsOnPath == null ? "" : " " + this.mTermsOnPath.toString());
        }

        public CCTerm getIndex() {
            return this.mIdx;
        }
    }

    private static class Cursor {
        public CCTerm mTerm;
        public ArrayTheory.ArrayNode mArrayNode;

        public Cursor(CCTerm term, ArrayTheory.ArrayNode arrayNode) {
            this.mTerm = term;
            this.mArrayNode = arrayNode;
        }

        public void update(CCTerm term, ArrayTheory.ArrayNode arrayNode) {
            this.mTerm = term;
            this.mArrayNode = arrayNode;
        }
    }
}

