/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ApplyConstructiveEqualityReasoning {
    final EprTheory mEprTheory;
    final Set<Literal> mResult;

    public ApplyConstructiveEqualityReasoning(EprTheory eprTheory, Set<Literal> inputLiterals) {
        this.mEprTheory = eprTheory;
        this.mEprTheory.getLogger().debug("ApplyConstructiveEqualityReasoning: starting");
        HashSet<Literal> newLiterals = new HashSet<Literal>();
        for (Literal inputLit : inputLiterals) {
            if (!(inputLit.getAtom() instanceof EprQuantifiedPredicateAtom)) {
                newLiterals.add(inputLit);
                continue;
            }
            ApplicationTerm atomFormula = (ApplicationTerm)inputLit.getAtom().getSMTFormula(this.mEprTheory.getTheory());
            BinaryRelation<TermVariable, Integer> variableOccurences = this.getOccurrences(atomFormula.getParameters());
            HashMap<Integer, TermVariable> positionToNewTv = new HashMap<Integer, TermVariable>();
            for (TermVariable tv : variableOccurences.getDomain()) {
                Set<Integer> occurences = variableOccurences.getImage(tv);
                Integer firstOccurrence = occurences.iterator().next();
                positionToNewTv.put(firstOccurrence, tv);
                HashSet<Integer> otherOccurrences = new HashSet<Integer>(occurences);
                otherOccurrences.remove(firstOccurrence);
                for (Integer otherOc : otherOccurrences) {
                    TermVariable freshTv = this.mEprTheory.getTheory().createFreshTermVariable("CER", tv.getSort());
                    ApplicationTerm newEquality = (ApplicationTerm)this.mEprTheory.getTheory().term("=", tv, freshTv);
                    newLiterals.add(this.mEprTheory.getEprAtom(newEquality, 0, this.mEprTheory.getClausifier().getStackLevel(), SourceAnnotation.EMPTY_SOURCE_ANNOT).negate());
                    this.mEprTheory.getLogger().debug("ApplyConstructiveEqualityReasoning: introducing equality: " + newEquality);
                    positionToNewTv.put(otherOc, freshTv);
                }
            }
            Term[] newParameters = new Term[atomFormula.getParameters().length];
            for (int i = 0; i < newParameters.length; ++i) {
                Term term = newParameters[i] = atomFormula.getParameters()[i] instanceof ApplicationTerm ? atomFormula.getParameters()[i] : (Term)positionToNewTv.get(i);
                assert (newParameters[i] != null);
            }
            ApplicationTerm newTerm = (ApplicationTerm)this.mEprTheory.getTheory().term(atomFormula.getFunction(), newParameters);
            EprAtom newAtom = this.mEprTheory.getEprAtom(newTerm, 0, this.mEprTheory.getClausifier().getStackLevel(), SourceAnnotation.EMPTY_SOURCE_ANNOT);
            newLiterals.add(inputLit.getSign() == 1 ? newAtom : newAtom.negate());
        }
        this.mResult = newLiterals;
    }

    private BinaryRelation<TermVariable, Integer> getOccurrences(Term[] parameters) {
        BinaryRelation<TermVariable, Integer> result = new BinaryRelation<TermVariable, Integer>();
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof TermVariable)) continue;
            result.addPair((TermVariable)parameters[i], i);
        }
        return result;
    }

    public Set<Literal> getResult() {
        return this.mResult;
    }
}

