/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class ApplyDestructiveEqualityReasoning {
    HashSet<Literal> mResult;
    boolean mIsResultGround = true;
    private final EprTheory mEprTheory;

    public ApplyDestructiveEqualityReasoning(EprTheory eprTheory, Literal[] literals) {
        assert (eprTheory != null);
        this.mEprTheory = eprTheory;
        this.applyDER(new HashSet<Literal>(Arrays.asList(literals)));
    }

    private void applyDER(HashSet<Literal> literals) {
        HashSet<Literal> currentClause = new HashSet<Literal>(literals);
        Literal disEquality = this.findDisequality(currentClause);
        this.mResult = currentClause;
        this.mIsResultGround = false;
        while (disEquality != null) {
            currentClause.remove(disEquality);
            TTSubstitution sub = this.extractSubstitutionFromEquality((EprQuantifiedEqualityAtom)disEquality.getAtom());
            this.mResult = new HashSet();
            this.mIsResultGround = true;
            for (Literal l : currentClause) {
                Literal sl = EprHelpers.applySubstitution(sub, l, this.mEprTheory, true);
                if (sl.getAtom() instanceof DPLLAtom.TrueAtom) {
                    if (sl.getSign() != 1) continue;
                } else if (sl.getAtom() instanceof EprQuantifiedEqualityAtom || sl.getAtom() instanceof EprQuantifiedPredicateAtom) {
                    this.mIsResultGround = false;
                } else if (sl.getAtom() instanceof EprGroundPredicateAtom || sl.getAtom() instanceof CCEquality) {
                    this.mEprTheory.addAtomToDPLLEngine(sl.getAtom());
                } else if (!(sl.getAtom() instanceof NamedAtom)) assert (false) : "case not forseen..";
                this.mResult.add(sl);
            }
            currentClause = this.mResult;
            disEquality = this.findDisequality(currentClause);
        }
    }

    public TTSubstitution extractSubstitutionFromEquality(EprQuantifiedEqualityAtom eea) {
        TermTuple tt = eea.getArgumentsAsTermTuple();
        TermVariable tv = null;
        Term t = null;
        if (tt.terms[0] instanceof TermVariable) {
            tv = (TermVariable)tt.terms[0];
            t = tt.terms[1];
        } else {
            tv = (TermVariable)tt.terms[1];
            t = tt.terms[0];
        }
        return new TTSubstitution(tv, t);
    }

    private Literal findDisequality(HashSet<Literal> literals) {
        for (Literal l : literals) {
            if (l.getSign() == 1 || !(l.getAtom() instanceof EprQuantifiedEqualityAtom)) continue;
            return l;
        }
        return null;
    }

    public Literal getSubstitutedLiteral(TTSubstitution sub, Literal li) {
        if (li.getAtom() instanceof EprQuantifiedPredicateAtom || li.getAtom() instanceof EprQuantifiedEqualityAtom) {
            boolean liPositive = li.getSign() == 1;
            TermTuple liTT = ((EprAtom)li.getAtom()).getArgumentsAsTermTuple();
            SourceAnnotation source = ((EprAtom)li.getAtom()).getSourceAnnotation();
            TermTuple newTT = sub.apply(liTT);
            if (newTT.equals(liTT)) {
                return li;
            }
            if (li.getAtom() instanceof EprQuantifiedEqualityAtom) {
                if (newTT.isGround()) {
                    if (newTT.terms[0] == newTT.terms[1] && liPositive) {
                        return new DPLLAtom.TrueAtom();
                    }
                    if (newTT.terms[0] == newTT.terms[1] && !liPositive) {
                        return new DPLLAtom.TrueAtom().negate();
                    }
                    throw new UnsupportedOperationException();
                }
                EprQuantifiedEqualityAtom eea = new EprQuantifiedEqualityAtom((ApplicationTerm)this.mEprTheory.getTheory().term("=", newTT.terms), 0, li.getAtom().getAssertionStackLevel(), this.mEprTheory.getEqualityEprPredicate(newTT.terms[0].getSort()), source);
                return liPositive ? eea : eea.negate();
            }
            EprPredicate liPred = ((EprQuantifiedPredicateAtom)li.getAtom()).getEprPredicate();
            EprPredicateAtom ea = null;
            ea = newTT.isGround() ? liPred.getAtomForTermTuple(newTT, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), source) : liPred.getAtomForTermTuple(newTT, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), source);
            return liPositive ? ea : ea.negate();
        }
        return li;
    }

    public Set<Literal> getResult() {
        return this.mResult;
    }

    public boolean isResultGround() {
        return this.mIsResultGround;
    }
}

