/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BinaryRelation<T, U> {
    private final Map<T, Set<U>> mBacking = new HashMap<T, Set<U>>();

    public BinaryRelation() {
    }

    public BinaryRelation(Map<T, U> map) {
        for (Map.Entry<T, U> en : map.entrySet()) {
            this.mBacking.put(en.getKey(), Collections.singleton(en.getValue()));
        }
    }

    public void addPair(T t, U u) {
        Set<U> set = this.mBacking.get(t);
        if (set == null) {
            set = new HashSet<U>();
            this.mBacking.put(t, set);
        }
        set.add(u);
    }

    public Set<T> getDomain() {
        return this.mBacking.keySet();
    }

    public Set<U> getImage(T t) {
        return this.mBacking.get(t);
    }

    public boolean isFunction() {
        for (Map.Entry<T, Set<U>> en : this.mBacking.entrySet()) {
            if (en.getValue().size() <= 1) continue;
            return false;
        }
        return true;
    }

    public Map<T, U> getFunction() {
        assert (this.isFunction());
        HashMap<T, U> result = new HashMap<T, U>();
        for (Map.Entry<T, Set<U>> en : this.mBacking.entrySet()) {
            assert (en.getValue().size() == 1) : "no function";
            result.put(en.getKey(), en.getValue().iterator().next());
        }
        return result;
    }

    public Set<T> getPreImage(U u) {
        HashSet<T> result = new HashSet<T>();
        for (T d : this.getDomain()) {
            if (!this.getImage(d).contains(u)) continue;
            result.add(d);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<T, Set<U>> en : this.mBacking.entrySet()) {
            for (U el : en.getValue()) {
                sb.append("(" + en.getKey() + ", " + el + ")\n");
            }
        }
        return sb.toString();
    }

    public void removePair(T t, U u) {
        Set<U> image = this.mBacking.get(t);
        if (image != null) {
            image.remove(u);
        }
    }

    public boolean isInjective() {
        for (Map.Entry<T, Set<U>> en1 : this.mBacking.entrySet()) {
            for (Map.Entry<T, Set<U>> en2 : this.mBacking.entrySet()) {
                if (en1.equals(en2)) continue;
                HashSet intersection = new HashSet(en1.getValue());
                intersection.retainAll((Collection)en2.getValue());
                if (intersection.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

