/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class EprHelpers {
    public static HashSet<ApplicationTerm> collectAppearingConstants(Literal[] literals, Theory theory) {
        HashSet<ApplicationTerm> result = new HashSet<ApplicationTerm>();
        for (Literal l : literals) {
            DPLLAtom atom = l.getAtom();
            Term t = atom.getSMTFormula(theory);
            if (!(t instanceof ApplicationTerm) || !(atom instanceof EprAtom) && !(atom instanceof CCEquality)) continue;
            for (Term p : ((ApplicationTerm)t).getParameters()) {
                if (!(p instanceof ApplicationTerm)) continue;
                assert (((ApplicationTerm)p).getFunction().getParameterSorts().length == 0);
                result.add((ApplicationTerm)p);
            }
        }
        return result;
    }

    public static Literal applySubstitution(TTSubstitution sub, Literal l, EprTheory eprTheory) {
        return EprHelpers.applySubstitution(sub, l, eprTheory, false);
    }

    public static Literal applySubstitution(TTSubstitution sub, Literal l, EprTheory eprTheory, boolean calledFromDER) {
        boolean isPositive = l.getSign() == 1;
        DPLLAtom atom = l.getAtom();
        Theory theory = eprTheory.getTheory();
        Literal resultLit = null;
        EprPredicateAtom resultAtom = null;
        if (atom instanceof EprQuantifiedPredicateAtom) {
            EprQuantifiedPredicateAtom eqpa = (EprQuantifiedPredicateAtom)atom;
            TermTuple newTT = sub.apply(eqpa.getArgumentsAsTermTuple());
            resultAtom = eqpa.getEprPredicate().getAtomForTermTuple(newTT, theory, eprTheory.getClausifier().getStackLevel(), eqpa.getSourceAnnotation());
        } else if (atom instanceof EprQuantifiedEqualityAtom) {
            EprQuantifiedEqualityAtom eea = (EprQuantifiedEqualityAtom)atom;
            TermTuple newTT = sub.apply(eea.getArgumentsAsTermTuple());
            ApplicationTerm newTerm = (ApplicationTerm)theory.term("=", newTT.terms);
            if (newTerm.getFreeVars().length > 0 ? !$assertionsDisabled : !$assertionsDisabled) {
                throw new AssertionError((Object)"TODO: reactivate below code?");
            }
        } else {
            return l;
        }
        resultLit = isPositive ? resultAtom : resultAtom.negate();
        return resultLit;
    }

    public static Literal[] applyUnifierToEqualities(EprQuantifiedEqualityAtom[] eprEqualityAtoms1, EprQuantifiedEqualityAtom[] eprEqualityAtoms2, TTSubstitution sub, EprTheory eprTheory) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (EprQuantifiedEqualityAtom eea : eprEqualityAtoms1) {
            result.add(EprHelpers.applySubstitution(sub, eea, eprTheory));
        }
        for (EprQuantifiedEqualityAtom eea : eprEqualityAtoms2) {
            result.add(EprHelpers.applySubstitution(sub, eea, eprTheory));
        }
        return result.toArray(new Literal[result.size()]);
    }

    public static ArrayList<DPLLAtom> substituteInExceptions(EprQuantifiedEqualityAtom[] equalities, TTSubstitution sub, EprTheory eprTheory) {
        ArrayList<DPLLAtom> result = new ArrayList<DPLLAtom>();
        for (EprQuantifiedEqualityAtom eea : equalities) {
            result.add((DPLLAtom)EprHelpers.applySubstitution(sub, eea, eprTheory));
        }
        return result;
    }

    public static ApplicationTerm[] castTermsToConstants(Term[] arguments) {
        ApplicationTerm[] ats = new ApplicationTerm[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            assert (arguments[i] instanceof ApplicationTerm && ((ApplicationTerm)arguments[i]).getParameters().length == 0) : "This method should only be called on arrays of constants";
            ats[i] = (ApplicationTerm)arguments[i];
        }
        return ats;
    }

    public static <LETTER> Set<List<LETTER>> computeNCrossproduct(Set<LETTER> baseSet, int n, LogProxy logger) {
        HashSet<List<Object>> result = new HashSet<List<LETTER>>();
        result.add(new ArrayList());
        for (int i = 0; i < n; ++i) {
            HashSet newResult = new HashSet();
            for (List list : result) {
                for (LETTER ltr : baseSet) {
                    ArrayList<LETTER> newTuple = new ArrayList<LETTER>(list);
                    newTuple.add(ltr);
                    newResult.add(newTuple);
                }
            }
            result = newResult;
        }
        return result;
    }

    public static <COLNAMES> COLNAMES[] applyMapping(COLNAMES[] colnames, Map<COLNAMES, COLNAMES> translation) {
        assert (colnames.length > 0);
        Object[] result = (Object[])colnames.clone();
        for (int i = 0; i < colnames.length; ++i) {
            COLNAMES newEntry = translation.get(colnames[i]);
            if (newEntry == null) continue;
            result[i] = newEntry;
        }
        return result;
    }

    public static <COLNAMES> List<COLNAMES> applyMapping(List<COLNAMES> colnames, Map<COLNAMES, COLNAMES> translation) {
        assert (colnames.size() > 0);
        ArrayList<COLNAMES> result = new ArrayList<COLNAMES>();
        for (COLNAMES cn : colnames) {
            COLNAMES newEntry = translation.get(cn);
            if (newEntry != null) {
                result.add(newEntry);
                continue;
            }
            result.add(cn);
        }
        return result;
    }

    public static <COLNAMES> SortedSet<COLNAMES> applyMapping(SortedSet<COLNAMES> colnames, Map<COLNAMES, COLNAMES> translation) {
        assert (colnames.size() > 0);
        TreeSet<COLNAMES> result = new TreeSet<COLNAMES>(EprHelpers.getColumnNamesComparator());
        for (Object cn : colnames) {
            COLNAMES newEntry = translation.get(cn);
            if (newEntry != null) {
                result.add(newEntry);
                continue;
            }
            result.add(cn);
        }
        return result;
    }

    public static List<ApplicationTerm> convertTermListToConstantList(List<Term> constants) {
        ArrayList<ApplicationTerm> result = new ArrayList<ApplicationTerm>(constants.size());
        for (Term t : constants) {
            result.add((ApplicationTerm)t);
        }
        return result;
    }

    public static List<ApplicationTerm> convertTermArrayToConstantList(Term[] constants) {
        ArrayList<ApplicationTerm> result = new ArrayList<ApplicationTerm>(constants.length);
        for (int i = 0; i < constants.length; ++i) {
            result.add((ApplicationTerm)constants[i]);
        }
        return result;
    }

    public static <COLNAMES> Comparator<COLNAMES> getColumnNamesComparator() {
        return ColNameComparator.getInstance();
    }

    public static <COLNAMES> Map<COLNAMES, Integer> computeColnamesToIndex(SortedSet<COLNAMES> sortedSet) {
        HashMap result = new HashMap();
        Iterator sortedSetIt = sortedSet.iterator();
        for (int i = 0; i < sortedSet.size(); ++i) {
            Object ithElement = sortedSetIt.next();
            result.put(ithElement, i);
        }
        return result;
    }

    public static ArrayList<TTSubstitution> getAllInstantiationsForNewConstant(Set<TermVariable> freeVars, Set<ApplicationTerm> newConstants, Set<ApplicationTerm> oldConstants) {
        ArrayList<TTSubstitution> instsWithNewConstant = new ArrayList<TTSubstitution>();
        ArrayList<TTSubstitution> instsWithOutNewConstant = new ArrayList<TTSubstitution>();
        HashSet<ApplicationTerm> allConstants = new HashSet<ApplicationTerm>(oldConstants);
        allConstants.addAll(newConstants);
        instsWithNewConstant.add(new TTSubstitution());
        instsWithOutNewConstant.add(new TTSubstitution());
        for (TermVariable tv : freeVars) {
            TTSubstitution newSub;
            ArrayList<TTSubstitution> instsNewWNC = new ArrayList<TTSubstitution>();
            ArrayList<TTSubstitution> instsNewWONC = new ArrayList<TTSubstitution>();
            for (TTSubstitution sub : instsWithNewConstant) {
                for (ApplicationTerm con : allConstants) {
                    if (con.getSort().getRealSort() != tv.getSort().getRealSort()) continue;
                    newSub = new TTSubstitution(sub);
                    newSub.addSubs(con, tv);
                    instsNewWNC.add(newSub);
                }
            }
            for (TTSubstitution sub : instsWithOutNewConstant) {
                for (ApplicationTerm con : oldConstants) {
                    if (!con.getSort().equals(tv.getSort())) continue;
                    newSub = new TTSubstitution(sub);
                    newSub.addSubs(con, tv);
                    instsNewWONC.add(newSub);
                }
                for (ApplicationTerm newConstant : newConstants) {
                    if (!newConstant.getSort().equals(tv.getSort())) continue;
                    newSub = new TTSubstitution(sub);
                    newSub.addSubs(newConstant, tv);
                    instsNewWNC.add(newSub);
                }
            }
            instsWithNewConstant = instsNewWNC;
            instsWithOutNewConstant = instsNewWONC;
        }
        return instsWithNewConstant;
    }

    public static ArrayList<TTSubstitution> getAllInstantiations(Set<TermVariable> freeVars, Set<ApplicationTerm> constants) {
        ArrayList<TTSubstitution> insts = new ArrayList<TTSubstitution>();
        insts.add(new TTSubstitution());
        for (TermVariable tv : freeVars) {
            ArrayList<TTSubstitution> instsNew = new ArrayList<TTSubstitution>();
            for (TTSubstitution sub : insts) {
                for (ApplicationTerm con : constants) {
                    if (con.getSort().getRealSort() != tv.getSort().getRealSort()) continue;
                    TTSubstitution newSub = new TTSubstitution(sub);
                    newSub.addSubs(con, tv);
                    instsNew.add(newSub);
                }
            }
            insts = instsNew;
        }
        return insts;
    }

    public static <LETTER, COLNAMES> boolean verifySortsOfPoints(Iterable<List<LETTER>> points, SortedSet<COLNAMES> colnames) {
        return true;
    }

    public static <LETTER, COLNAMES> boolean verifySortsOfPoint(List<LETTER> point, SortedSet<COLNAMES> colnames) {
        if (point.size() == 0) {
            return true;
        }
        if (!(point.get(0) instanceof ApplicationTerm) || !(colnames.iterator().next() instanceof TermVariable)) {
            return true;
        }
        Iterator colnamesIt = colnames.iterator();
        for (int i = 0; i < point.size(); ++i) {
            ApplicationTerm pointAtI = (ApplicationTerm)point.get(i);
            TermVariable colnameTvI = (TermVariable)colnamesIt.next();
            if (pointAtI.getSort().getRealSort() == colnameTvI.getSort().getRealSort()) continue;
            return false;
        }
        return true;
    }

    public static boolean verifyUnitClauseAfterPropagation(Clause reason, Literal l, LogProxy logger) {
        return EprHelpers.verifyUnitClause(reason, l, true, null, logger);
    }

    public static boolean verifyUnitClauseBeforePropagation(Clause reason, Literal l, LogProxy logger) {
        return EprHelpers.verifyUnitClause(reason, l, false, null, logger);
    }

    private static boolean verifyUnitClause(Clause reason, Literal l, boolean afterPropagation, Deque<Literal> literalsWaitingToBePropagated, LogProxy logger) {
        for (int i = 0; i < reason.getSize(); ++i) {
            boolean refutationQueuedForPropagation;
            Literal curLit = reason.getLiteral(i);
            if (curLit == l) {
                if (afterPropagation && curLit.getAtom().getDecideStatus() != curLit) {
                    logger.error("EPRDEBUG: (EprHelpers.verifyUnitClause): The unit literal " + l + " is not set.");
                    return false;
                }
                if (afterPropagation || curLit.getAtom().getDecideStatus() == null) continue;
                logger.error("EPRDEBUG: (EprHelpers.verifyUnitClause): The unit literal " + l + " is not undecided.");
                return false;
            }
            boolean refutedInDPLLEngine = curLit.getAtom().getDecideStatus() == curLit.negate();
            boolean bl = refutationQueuedForPropagation = literalsWaitingToBePropagated != null && literalsWaitingToBePropagated.contains(curLit.negate());
            if (refutedInDPLLEngine || refutationQueuedForPropagation) continue;
            logger.error("EPRDEBUG: (EprHelpers.verifyUnitClause): Literal " + curLit + " is not the unit literal but is not currently refuted");
            return false;
        }
        return true;
    }

    public static boolean verifyConflictClause(Clause conflict, LogProxy logger) {
        if (conflict == null) {
            return true;
        }
        for (int i = 0; i < conflict.getSize(); ++i) {
            Literal curLit = conflict.getLiteral(i);
            assert (!(curLit.getAtom() instanceof EprGroundEqualityAtom)) : "TODO: deal with this case";
            if (curLit.getAtom().getDecideStatus() == curLit.negate()) continue;
            logger.error("EPRDEBUG: (EprHelpers.verifyConflictClause): Literal " + curLit + " is not currently refuted");
            return false;
        }
        return true;
    }

    public static boolean verifyUnitClauseAtEnqueue(Literal l, Clause reason, Deque<Literal> mLiteralsWaitingToBePropagated, LogProxy logger) {
        return EprHelpers.verifyUnitClause(reason, l, false, mLiteralsWaitingToBePropagated, logger);
    }

    public static <COLNAMES> SortedSet<COLNAMES> transformSignature(SortedSet<COLNAMES> colNames, BinaryRelation<COLNAMES, COLNAMES> renaming) {
        TreeSet<COLNAMES> result = new TreeSet<COLNAMES>(EprHelpers.getColumnNamesComparator());
        for (Object oldCol : colNames) {
            Set<COLNAMES> newCols = renaming.getImage(oldCol);
            if (newCols == null) {
                result.add(oldCol);
            }
            for (COLNAMES newCol : newCols) {
                result.add(newCol);
            }
        }
        return result;
    }

    public static <COLNAMES> Object extractSortFromColname(COLNAMES cn) {
        if (TermVariable.class.isInstance(cn)) {
            TermVariable at = (TermVariable)cn;
            return at.getSort();
        }
        return EprHelpers.getDummySortId();
    }

    public static Object getDummySortId() {
        return "dummySort";
    }

    public static Clause sanitizeGroundConflict(Clausifier clausif, LogProxy logger, Clause conflict) {
        Clause result = EprHelpers.replaceEprGroundEqualityAtoms(clausif, conflict);
        assert (EprHelpers.verifyConflictClause(result, logger));
        return result;
    }

    public static Clause sanitizeReasonUnitClauseBeforeEnqueue(Clausifier clausif, LogProxy logger, Literal l, Clause reason, Deque<Literal> literalsWaitingToBePropagated) {
        Clause result = EprHelpers.replaceEprGroundEqualityAtoms(clausif, reason);
        assert (EprHelpers.verifyUnitClauseAtEnqueue(l, result, literalsWaitingToBePropagated, logger));
        return result;
    }

    private static Clause replaceEprGroundEqualityAtoms(Clausifier clausif, Clause conflict) {
        if (conflict == null) {
            return null;
        }
        ArrayList<Literal> newLits = new ArrayList<Literal>(conflict.getSize());
        for (int i = 0; i < conflict.getSize(); ++i) {
            Literal lit = conflict.getLiteral(i);
            if (lit.getAtom() instanceof EprGroundEqualityAtom) {
                EprGroundEqualityAtom egea = (EprGroundEqualityAtom)lit.getAtom();
                if (egea.getArguments()[0] == egea.getArguments()[1] && lit.getSign() != 1) continue;
                if (egea.getArguments()[0] == egea.getArguments()[1] && lit.getSign() == 1) {
                    assert (false) : "the given clause is equivalent to true; does this make sense??";
                    continue;
                }
                CCEquality cceq = ((EprGroundEqualityAtom)lit.getAtom()).getCCEquality(clausif);
                newLits.add(lit.getSign() == 1 ? cceq : cceq.negate());
                continue;
            }
            newLits.add(lit);
        }
        Clause result = new Clause(newLits.toArray(new Literal[newLits.size()]));
        return result;
    }

    public static boolean containsBooleanTerm(Term[] parameters) {
        for (Term t : parameters) {
            if (!"Bool".equals(t.getSort().getRealSort().getName())) continue;
            return true;
        }
        return false;
    }

    static class ColNameComparator<COLNAMES>
    implements Comparator<COLNAMES> {
        private static ColNameComparator instance = new ColNameComparator();

        private ColNameComparator() {
        }

        public static <COLNAMES> ColNameComparator<COLNAMES> getInstance() {
            return instance;
        }

        @Override
        public int compare(COLNAMES o1, COLNAMES o2) {
            if (o1 instanceof TermVariable) {
                TermVariable tv1 = (TermVariable)o1;
                TermVariable tv2 = (TermVariable)o2;
                return tv1.getName().compareTo(tv2.getName());
            }
            if (o1 instanceof String) {
                return ((String)o1).compareTo((String)o2);
            }
            if (o1 instanceof Integer) {
                return ((Integer)o1).compareTo((Integer)o2);
            }
            throw new UnsupportedOperationException("unexpected comparator call");
        }
    }
}

