/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprEqualityPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprGroundLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprQuantifiedLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackDecisionLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class EprPredicate {
    private final int mArity;
    private final FunctionSymbol mFunctionSymbol;
    protected final SortedSet<TermVariable> mSignature;
    final EprTheory mEprTheory;
    private final HashMap<EprClause, HashSet<ClauseEprLiteral>> mQuantifiedOccurences = new HashMap();
    private final HashMap<EprClause, HashSet<ClauseEprLiteral>> mGroundOccurences = new HashMap();
    private final HashSet<EprGroundPredicateAtom> mDPLLAtoms = new HashSet();
    private final HashMap<TermTuple, EprGroundPredicateAtom> mPointToAtom = new HashMap();
    private final HashMap<TermTuple, EprQuantifiedPredicateAtom> mTermTupleToAtom = new HashMap();
    private DawgState<ApplicationTerm, EprTheory.TriBool> mCurrentDecision;

    public EprPredicate(FunctionSymbol fs, EprTheory eprTheory) {
        this.mFunctionSymbol = fs;
        this.mArity = fs.getParameterSorts().length;
        this.mEprTheory = eprTheory;
        TreeSet tva = new TreeSet(EprHelpers.getColumnNamesComparator());
        for (int i = 0; i < this.mArity; ++i) {
            String tvName = this.mFunctionSymbol.getName() + "_" + i;
            tva.add(this.mEprTheory.getTheory().createFreshTermVariable(tvName, fs.getParameterSorts()[i]));
        }
        this.mSignature = tva;
        this.mCurrentDecision = this.mEprTheory.getDawgFactory().createConstantDawg(this.mSignature, EprTheory.TriBool.UNKNOWN);
    }

    public void addQuantifiedOccurence(ClauseEprQuantifiedLiteral l, EprClause eprClause) {
        HashSet<ClauseEprLiteral> val = this.mQuantifiedOccurences.get(eprClause);
        if (val == null) {
            val = new HashSet();
            this.mQuantifiedOccurences.put(eprClause, val);
        }
        val.add(l);
    }

    private HashMap<EprClause, HashSet<ClauseEprLiteral>> getQuantifiedOccurences() {
        return this.mQuantifiedOccurences;
    }

    public EprTheory getEprTheory() {
        return this.mEprTheory;
    }

    public DawgState<ApplicationTerm, EprTheory.TriBool> getDawg() {
        return this.mCurrentDecision;
    }

    public SortedSet<TermVariable> getSignature() {
        return this.mSignature;
    }

    public void setDawg(DawgState<ApplicationTerm, EprTheory.TriBool> decision) {
        this.mCurrentDecision = decision;
    }

    public void addGroundOccurence(ClauseEprGroundLiteral l, EprClause eprClause) {
        HashSet<ClauseEprLiteral> val = this.mGroundOccurences.get(eprClause);
        if (val == null) {
            val = new HashSet();
            this.mGroundOccurences.put(eprClause, val);
        }
        val.add(l);
    }

    private HashMap<EprClause, HashSet<ClauseEprLiteral>> getGroundOccurences() {
        return this.mGroundOccurences;
    }

    public HashMap<EprClause, HashSet<ClauseEprLiteral>> getAllEprClauseOccurences() {
        HashMap<EprClause, HashSet<ClauseEprLiteral>> quantifiedOccurences = this.getQuantifiedOccurences();
        HashMap<EprClause, HashSet<ClauseEprLiteral>> groundOccurences = this.getGroundOccurences();
        HashMap<EprClause, HashSet<ClauseEprLiteral>> allOccurences = new HashMap<EprClause, HashSet<ClauseEprLiteral>>(quantifiedOccurences);
        for (Map.Entry<EprClause, HashSet<ClauseEprLiteral>> en : groundOccurences.entrySet()) {
            if (allOccurences.containsKey(en.getKey())) {
                allOccurences.get(en.getKey()).addAll((Collection<ClauseEprLiteral>)en.getValue());
                continue;
            }
            allOccurences.put(en.getKey(), en.getValue());
        }
        return allOccurences;
    }

    public void addDPLLAtom(EprGroundPredicateAtom egpa) {
        this.mDPLLAtoms.add(egpa);
    }

    public HashSet<EprGroundPredicateAtom> getDPLLAtoms() {
        return this.mDPLLAtoms;
    }

    private EprGroundPredicateAtom getAtomForPoint(TermTuple point, Theory mTheory, int assertionStackLevel, SourceAnnotation source) {
        assert (point.getFreeVars().size() == 0) : "Use getAtomForTermTuple, if tt is quantified";
        EprGroundPredicateAtom result = this.mPointToAtom.get(point);
        if (result == null) {
            ApplicationTerm newTerm = (ApplicationTerm)mTheory.term(this.mFunctionSymbol, point.terms);
            int hash = newTerm.hashCode();
            result = this instanceof EprEqualityPredicate ? new EprGroundEqualityAtom(newTerm, hash, assertionStackLevel, (EprEqualityPredicate)this, source) : new EprGroundPredicateAtom(newTerm, hash, assertionStackLevel, this, source);
            this.mPointToAtom.put(point, result);
            this.addDPLLAtom(result);
        }
        return result;
    }

    private EprQuantifiedPredicateAtom getAtomForQuantifiedTermTuple(TermTuple tt, Theory mTheory, int assertionStackLevel, SourceAnnotation source) {
        assert (tt.getFreeVars().size() > 0) : "Use getAtomForPoint, if tt is ground";
        EprQuantifiedPredicateAtom result = this.mTermTupleToAtom.get(tt);
        if (result == null) {
            ApplicationTerm newTerm = (ApplicationTerm)mTheory.term(this.mFunctionSymbol, tt.terms);
            result = this instanceof EprEqualityPredicate ? new EprQuantifiedEqualityAtom(newTerm, 0, assertionStackLevel, (EprEqualityPredicate)this, source) : new EprQuantifiedPredicateAtom(newTerm, 0, assertionStackLevel, this, source);
            this.mTermTupleToAtom.put(tt, result);
        }
        return result;
    }

    public EprPredicateAtom getAtomForTermTuple(TermTuple tt, Theory mTheory, int assertionStackLevel, SourceAnnotation source) {
        if (tt.getFreeVars().size() > 0) {
            return this.getAtomForQuantifiedTermTuple(tt, mTheory, assertionStackLevel, source);
        }
        return this.getAtomForPoint(tt, mTheory, assertionStackLevel, source);
    }

    public String toString() {
        String res = "EprPred: " + this.mFunctionSymbol.getName();
        if (res.contains("AUX")) {
            return "EprPred: (AUX " + this.hashCode() + ")";
        }
        return res;
    }

    public DecideStackEntry getNextDecision() {
        EprTheory.TriBool newDecision = this instanceof EprEqualityPredicate ? EprTheory.TriBool.TRUE : EprTheory.TriBool.FALSE;
        DawgState<ApplicationTerm, EprTheory.TriBool> undecidedPoints = this.mEprTheory.getDawgFactory().createMapped(this.getDawg(), val -> val == EprTheory.TriBool.UNKNOWN ? newDecision : EprTheory.TriBool.UNKNOWN);
        if (DawgFactory.isConstantValue(undecidedPoints, EprTheory.TriBool.UNKNOWN)) {
            return null;
        }
        return new DecideStackDecisionLiteral(this, undecidedPoints);
    }

    public void notifyAboutClauseDisposal(EprClause eprClause) {
        this.mQuantifiedOccurences.remove(eprClause);
        this.mGroundOccurences.remove(eprClause);
    }

    public int getArity() {
        return this.mArity;
    }

    public FunctionSymbol getFunctionSymbol() {
        return this.mFunctionSymbol;
    }

    public SortedSet<TermVariable> getTermVariablesForArguments() {
        return this.mSignature;
    }

    public Sort[] getSorts() {
        return this.mFunctionSymbol.getParameterSorts();
    }
}

