/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ClauseDeletionHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.ApplyConstructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.ApplyDestructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprEqualityPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EqualityManager;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClauseFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.EprDecideStack;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.GroundPropagationInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EprTheory
implements ITheory {
    Map<FunctionSymbol, EprPredicate> mFunctionSymbolToEprPredicate = new HashMap<FunctionSymbol, EprPredicate>();
    Map<Literal, GroundPropagationInfo> mGroundLiteralsToPropagateToReason = new HashMap<Literal, GroundPropagationInfo>();
    ScopedHashSet<DPLLAtom> mAtomsAddedToDPLLEngine = new ScopedHashSet();
    EqualityManager mEqualityManager;
    private ArrayList<Literal[]> mAllGroundingsOfLastAddedEprClause;
    private EprDecideStack mEprStack;
    private DawgFactory<ApplicationTerm, TermVariable> mDawgFactory;
    private EprClauseFactory mClauseFactory;
    private CClosure mCClosure;
    private Clausifier mClausifier;
    private final LogProxy mLogger;
    private Theory mTheory;
    private DPLLEngine mEngine;
    private final ArrayDeque<Literal> mGroundDecisionSuggestions = new ArrayDeque();
    private Clause mStoredConflict;
    private final Deque<Literal> mLiteralsWaitingToBePropagated = new ArrayDeque<Literal>();
    private final Set<Literal> mLiteralsThatAreCurrentlySet = new HashSet<Literal>();
    private Map<Sort, EprEqualityPredicate> mSortToEqualityEprPredicate;

    public EprTheory(LogProxy logger) {
        this.mLogger = logger;
    }

    public EprTheory(Theory th, DPLLEngine engine, CClosure cClosure, Clausifier clausifier) {
        this.mTheory = th;
        this.mEngine = engine;
        this.mClausifier = clausifier;
        this.mLogger = clausifier.getLogger();
        this.mDawgFactory = new DawgFactory(this);
        this.mClauseFactory = new EprClauseFactory(this);
        this.mEqualityManager = new EqualityManager();
        this.mEprStack = new EprDecideStack(this);
        this.mSortToEqualityEprPredicate = new HashMap<Sort, EprEqualityPredicate>();
    }

    @Override
    public Clause startCheck() {
        this.mLogger.debug("EPRDEBUG: startCheck");
        return null;
    }

    @Override
    public void endCheck() {
        this.mLogger.debug("EPRDEBUG: endCheck");
    }

    @Override
    public Clause setLiteral(Literal literal) {
        this.mLogger.debug("EPRDEBUG: setLiteral " + literal);
        this.mLiteralsThatAreCurrentlySet.add(literal);
        DPLLAtom atom = literal.getAtom();
        if (atom instanceof EprGroundPredicateAtom) {
            Clause conflictOrNull = this.mEprStack.setEprGroundLiteral(literal);
            conflictOrNull = EprHelpers.sanitizeGroundConflict(this.mClausifier, this.mLogger, conflictOrNull);
            return conflictOrNull;
        }
        if (atom instanceof EprQuantifiedEqualityAtom || atom instanceof EprQuantifiedPredicateAtom) {
            assert (false) : "DPLLEngine is setting a quantified EprAtom --> this cannot be..";
        } else if (atom instanceof CCEquality) {
            Clause conflictOrNull = this.mEprStack.setGroundEquality((CCEquality)atom, literal.getSign() == 1);
            conflictOrNull = EprHelpers.sanitizeGroundConflict(this.mClausifier, this.mLogger, conflictOrNull);
            return conflictOrNull;
        }
        return null;
    }

    @Override
    public void backtrackLiteral(Literal literal) {
        this.mLogger.debug("EPRDEBUG: backtrackLiteral " + literal);
        boolean success = this.mLiteralsThatAreCurrentlySet.remove(literal);
        assert (success);
        this.mGroundLiteralsToPropagateToReason.remove(literal);
        DPLLAtom atom = literal.getAtom();
        if (atom instanceof EprGroundPredicateAtom) {
            this.mEprStack.backtrackToLiteral(literal);
        } else if (atom instanceof EprQuantifiedEqualityAtom || atom instanceof EprQuantifiedPredicateAtom) {
            assert (false) : "DPLLEngine is unsetting a quantified EprAtom --> this cannot be..";
        } else if (atom instanceof CCEquality) {
            this.mEprStack.backtrackToLiteral(literal);
        }
    }

    @Override
    public Clause checkpoint() {
        if (this.isTerminationRequested()) {
            return null;
        }
        this.mLogger.debug("EPRDEBUG: checkpoint");
        assert (this.mLiteralsWaitingToBePropagated.isEmpty()) : "have all propagations been done at this point??";
        if (this.mStoredConflict != null) {
            Clause conflict = this.mStoredConflict;
            this.mStoredConflict = null;
            conflict = EprHelpers.sanitizeGroundConflict(this.mClausifier, this.mLogger, conflict);
            return conflict;
        }
        return this.mEprStack.doPropagations();
    }

    @Override
    public Clause computeConflictClause() {
        this.mLogger.debug("EPRDEBUG: computeConflictClause");
        Clause conflict = this.mEprStack.eprDpllLoop();
        conflict = EprHelpers.sanitizeGroundConflict(this.mClausifier, this.mLogger, conflict);
        return conflict;
    }

    @Override
    public int checkCompleteness() {
        return 0;
    }

    @Override
    public Literal getPropagatedLiteral() {
        Literal lit = this.mLiteralsWaitingToBePropagated.poll();
        assert (lit == null || !(lit.getAtom() instanceof EprGroundEqualityAtom)) : "should have been caught/converted to CCEquality before";
        if (lit == null) {
            this.mLogger.debug("EPRDEBUG: getPropagatedLiteral -- nothing to propagate");
            return null;
        }
        this.mLogger.debug("EPRDEBUG: getPropagatedLiteral propagating: " + lit);
        return lit;
    }

    public void addGroundLiteralToPropagate(Literal l, GroundPropagationInfo reason) {
        CCEquality cceq;
        if (this.mGroundLiteralsToPropagateToReason.keySet().contains(l)) {
            this.mLogger.debug("EPRDEBUG: EprTheory.addGroundLiteralToPropagate: already added: " + l);
            return;
        }
        if (l.getAtom() instanceof EprGroundEqualityAtom && (cceq = ((EprGroundEqualityAtom)l.getAtom()).getCCEquality(this.mClausifier)) == null && l.getSign() == 1) {
            return;
        }
        if (l.getAtom() instanceof EprAtom) {
            this.addAtomToDPLLEngine(l.getAtom());
        }
        this.mLogger.debug("EPRDEBUG: EprTheory.addGroundLiteralToPropagate(..): literal: " + l + " reason: " + reason);
        this.mLiteralsWaitingToBePropagated.add(l);
        this.mGroundLiteralsToPropagateToReason.put(l, reason);
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        return this.mEprStack.explainGroundUnit(literal, this.mGroundLiteralsToPropagateToReason.get(literal));
    }

    @Override
    public Literal getSuggestion() {
        Literal sug = this.mGroundDecisionSuggestions.poll();
        if (sug == null) {
            this.mLogger.debug("EPRDEBUG: (EprTheory): getSuggestion -- no literal to suggest");
        } else {
            this.mLogger.debug("EPRDEBUG: (EprTheory): getSuggestion, suggesting " + sug);
        }
        return sug;
    }

    public void addGroundDecisionSuggestion(Literal l) {
        this.mGroundDecisionSuggestions.add(l);
    }

    @Override
    public void increasedDecideLevel(int currentDecideLevel) {
        this.mLogger.debug("EPRDEBUG: increasedDecideLevel");
    }

    @Override
    public void decreasedDecideLevel(int currentDecideLevel) {
        this.mLogger.debug("EPRDEBUG: decreasedDecideLevel");
    }

    @Override
    public void backtrackAll() {
        for (Literal lit : this.mLiteralsWaitingToBePropagated) {
            this.mGroundLiteralsToPropagateToReason.remove(lit);
        }
        this.mLiteralsWaitingToBePropagated.clear();
    }

    @Override
    public void backtrackStart() {
        for (Literal lit : this.mLiteralsWaitingToBePropagated) {
            this.mGroundLiteralsToPropagateToReason.remove(lit);
        }
        this.mLiteralsWaitingToBePropagated.clear();
        this.mLogger.debug("EPRDEBUG: backtrackStart");
    }

    @Override
    public Clause backtrackComplete() {
        this.mLogger.debug("EPRDEBUG: backtrackComplete");
        return null;
    }

    @Override
    public void restart(int iteration) {
        this.mLogger.info("EPRDEBUG: restart");
    }

    @Override
    public void removeAtom(DPLLAtom atom) {
        this.mLogger.debug("EPRDEBUG: removeAtom" + atom);
    }

    @Override
    public void push() {
        this.mLogger.debug("EPRDEBUG: (EprTheory) PUSH");
        this.mAtomsAddedToDPLLEngine.beginScope();
    }

    @Override
    public void pop() {
        this.mLogger.debug("EPRDEBUG: (EprTheory) POP");
        this.mAtomsAddedToDPLLEngine.endScope();
    }

    @Override
    public Object[] getStatistics() {
        return null;
    }

    public void addAtomToDPLLEngine(DPLLAtom atom) {
        assert (!(atom instanceof EprQuantifiedEqualityAtom) && !(atom instanceof EprQuantifiedPredicateAtom));
        if (atom instanceof CCEquality) {
            return;
        }
        if (!this.mAtomsAddedToDPLLEngine.contains(atom)) {
            this.mEngine.addAtom(atom);
            this.mAtomsAddedToDPLLEngine.add(atom);
        }
    }

    public Literal[] addEprClause(Literal[] lits, ClauseDeletionHook hook, ProofNode proof) {
        this.addConstants(EprHelpers.collectAppearingConstants(lits, this.mTheory));
        ApplyDestructiveEqualityReasoning ader = new ApplyDestructiveEqualityReasoning(this, lits);
        if (ader.isResultGround()) {
            return ader.getResult().toArray(new Literal[ader.getResult().size()]);
        }
        Set<Literal> literalsWithDERApplied = ader.getResult();
        Set<Literal> preprocessedLiterals = new ApplyConstructiveEqualityReasoning(this, literalsWithDERApplied).getResult();
        Clause groundConflict = this.mEprStack.createEprClause(preprocessedLiterals);
        if (groundConflict != null) {
            assert (this.mStoredConflict == null) : "we'll probably need a queue for this..";
            this.mStoredConflict = groundConflict;
        }
        return null;
    }

    public static boolean isQuantifiedEprAtom(Term idx) {
        if (idx.getFreeVars().length > 0 && idx instanceof ApplicationTerm) {
            if (EprTheory.isEprPredicate(((ApplicationTerm)idx).getFunction())) {
                return true;
            }
            if (((ApplicationTerm)idx).getFunction().getName().equals("=") && !((ApplicationTerm)idx).getParameters()[0].getSort().getName().equals("Bool")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isEprPredicate(FunctionSymbol function) {
        return !function.isIntern();
    }

    public EprAtom getEprAtom(ApplicationTerm idx, int hash, int assertionStackLevel, SourceAnnotation source) {
        if (idx.getFunction().getName().equals("=")) {
            assert (idx.getFreeVars().length > 0);
            return new EprQuantifiedEqualityAtom(idx, hash, assertionStackLevel, this.getEqualityEprPredicate(idx.getParameters()[0].getSort()), source);
        }
        EprPredicate pred = this.getEprPredicate(idx.getFunction());
        if (idx.getFreeVars().length == 0) {
            EprGroundPredicateAtom egpa = (EprGroundPredicateAtom)pred.getAtomForTermTuple(new TermTuple(idx.getParameters()), this.mTheory, assertionStackLevel, source);
            pred.addDPLLAtom(egpa);
            return egpa;
        }
        return pred.getAtomForTermTuple(new TermTuple(idx.getParameters()), this.mTheory, assertionStackLevel, source);
    }

    private EprPredicate getEprPredicate(FunctionSymbol fs) {
        EprPredicate pred = this.mFunctionSymbolToEprPredicate.get(fs);
        if (pred == null) {
            pred = fs.getName().equals("=") ? new EprEqualityPredicate(fs, this) : new EprPredicate(fs, this);
            this.mFunctionSymbolToEprPredicate.put(fs, pred);
            this.mEprStack.addNewEprPredicate(pred);
        }
        return pred;
    }

    public EprEqualityPredicate getEqualityEprPredicate(Sort sort) {
        EprEqualityPredicate result = this.mSortToEqualityEprPredicate.get(sort);
        if (result == null) {
            FunctionSymbol fs = this.mTheory.getFunction("=", sort, sort);
            result = (EprEqualityPredicate)this.getEprPredicate(fs);
            this.mSortToEqualityEprPredicate.put(sort, result);
        }
        return result;
    }

    public void addConstants(HashSet<ApplicationTerm> constants) {
    }

    public ArrayList<Literal[]> getAllGroundingsOfLastAddedEprClause() {
        return this.mAllGroundingsOfLastAddedEprClause;
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    public CClosure getCClosure() {
        return this.mCClosure;
    }

    public EprDecideStack getStateManager() {
        return this.mEprStack;
    }

    public DawgFactory<ApplicationTerm, TermVariable> getDawgFactory() {
        return this.mDawgFactory;
    }

    public EprClauseFactory getEprClauseFactory() {
        return this.mClauseFactory;
    }

    public EqualityManager getEqualityManager() {
        return this.mEqualityManager;
    }

    public Clausifier getClausifier() {
        return this.mClausifier;
    }

    public void addSkolemConstants(Term[] skolems) {
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    @Override
    public void printStatistics(LogProxy logger) {
    }

    @Override
    public void dumpModel(LogProxy logger) {
    }

    public boolean isTerminationRequested() {
        boolean result = this.mEngine.isTerminationRequested();
        if (result) {
            this.mLogger.info("EPRDEBUG: timeout received!");
        }
        return result;
    }

    public static enum TriBool {
        FALSE,
        UNKNOWN,
        TRUE;


        public TriBool negate() {
            return this == UNKNOWN ? UNKNOWN : (this == TRUE ? FALSE : TRUE);
        }
    }
}

