/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class EqualityManager {
    HashMap<ApplicationTerm, HashSet<ApplicationTerm>> eqGraph = new HashMap();
    HashMap<ApplicationTerm, HashMap<ApplicationTerm, CCEquality>> termPairToEquality = new HashMap();

    public void addEquality(ApplicationTerm a, ApplicationTerm b, CCEquality e) {
        this.updateTermPairToEquality(a, b, e);
        HashSet<ApplicationTerm> aTargets = this.eqGraph.get(a);
        if (aTargets == null) {
            aTargets = new HashSet();
            this.eqGraph.put(a, aTargets);
        }
        aTargets.add(b);
        HashSet<ApplicationTerm> bTargets = this.eqGraph.get(b);
        if (bTargets == null) {
            bTargets = new HashSet();
            this.eqGraph.put(b, bTargets);
        }
        bTargets.add(a);
    }

    private void updateTermPairToEquality(ApplicationTerm a, ApplicationTerm b, CCEquality e) {
        HashMap<ApplicationTerm, CCEquality> termToEquality = this.termPairToEquality.get(a);
        if (termToEquality == null) {
            termToEquality = new HashMap();
            this.termPairToEquality.put(a, termToEquality);
        }
        termToEquality.put(b, e);
        termToEquality = this.termPairToEquality.get(b);
        if (termToEquality == null) {
            termToEquality = new HashMap();
            this.termPairToEquality.put(b, termToEquality);
        }
        termToEquality.put(a, e);
    }

    public void backtrackEquality(ApplicationTerm a, ApplicationTerm b) {
        this.eqGraph.get(a).remove(b);
        this.eqGraph.get(b).remove(a);
    }

    public ArrayList<CCEquality> isEqualRec(ApplicationTerm a, ApplicationTerm b, ArrayList<CCEquality> pathSoFar, HashSet<ApplicationTerm> visited) {
        if (a.equals(b)) {
            return pathSoFar;
        }
        if (this.eqGraph.get(a) == null) {
            return null;
        }
        for (ApplicationTerm trg : this.eqGraph.get(a)) {
            if (visited.contains(trg)) continue;
            visited.add(trg);
            ArrayList<CCEquality> newPath = new ArrayList<CCEquality>(pathSoFar);
            newPath.add(this.termPairToEquality.get(a).get(trg));
            ArrayList<CCEquality> res = this.isEqualRec(trg, b, newPath, visited);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public ArrayList<CCEquality> isEqual(ApplicationTerm a, ApplicationTerm b) {
        HashSet<ApplicationTerm> visited = new HashSet<ApplicationTerm>();
        ArrayList<CCEquality> path = new ArrayList<CCEquality>();
        return this.isEqualRec(a, b, path, visited);
    }
}

