/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

public class TTSubstitution {
    ArrayList<SubsPair> subs;
    HashSet<TermVariable> tvSet = new HashSet();

    public TTSubstitution() {
        this.subs = new ArrayList();
    }

    public TTSubstitution(TermVariable tv, Term t) {
        this();
        this.addSubs(t, tv);
    }

    public TTSubstitution(TTSubstitution substitution) {
        this();
        for (SubsPair tp : substitution.subs) {
            if (tp instanceof TPair) {
                this.addSubs(tp.top, (TermVariable)tp.bot);
                continue;
            }
            this.addEquality((EqPair)tp);
        }
    }

    public TTSubstitution(SortedSet<TermVariable> colnames, List<ApplicationTerm> point) {
        this();
        assert (colnames.size() == point.size());
        Iterator colIt = colnames.iterator();
        for (int i = 0; i < point.size(); ++i) {
            TermVariable colName = (TermVariable)colIt.next();
            this.addSubs(point.get(i), colName);
        }
    }

    public ArrayList<CCEquality> getEqPathForEquality(ApplicationTerm a, ApplicationTerm b) {
        for (SubsPair sp : this.subs) {
            if (!(sp instanceof EqPair)) continue;
            EqPair ep = (EqPair)sp;
            if ((!ep.bot.equals(a) || !ep.top.equals(b)) && (!ep.bot.equals(b) || !ep.top.equals(a))) continue;
            return ep.eqPath;
        }
        assert (false) : "should not happen..";
        return null;
    }

    public void addEquality(EqPair eqp) {
        this.addEquality(eqp.top, eqp.bot, eqp.eqPath);
    }

    public void addEquality(Term top, Term bot, ArrayList<CCEquality> eqPath) {
        this.subs.add(new EqPair(top, bot, eqPath));
    }

    public void addSubs(Term top, TermVariable bot) {
        this.tvSet.add(bot);
        this.subs.add(new TPair(top, bot));
    }

    public TermTuple apply(TermTuple tt) {
        int i;
        if (this.subs.isEmpty()) {
            return tt;
        }
        Term[] newTerms = new Term[tt.terms.length];
        for (i = 0; i < newTerms.length; ++i) {
            newTerms[i] = tt.terms[i];
        }
        for (i = 0; i < tt.terms.length; ++i) {
            for (int j = 0; j < this.subs.size(); ++j) {
                SubsPair tp = this.subs.get(j);
                if (!newTerms[i].equals(tp.bot)) continue;
                newTerms[i] = tp.top;
            }
        }
        return new TermTuple(newTerms);
    }

    public boolean isEmpty() {
        return this.subs.isEmpty();
    }

    public Set<TermVariable> tvSet() {
        return this.tvSet;
    }

    public String toString() {
        return this.subs.toString();
    }

    public ArrayList<SubsPair> getSubsPairs() {
        return this.subs;
    }

    public class TPair
    extends SubsPair {
        public final Term t;
        public final TermVariable tv;

        public TPair(Term top, TermVariable bot) {
            super(top, bot);
            this.t = top;
            this.tv = bot;
        }

        @Override
        public String toString() {
            return String.format("(%s,%s)", this.tv.toString(), this.t.toString());
        }
    }

    public class EqPair
    extends SubsPair {
        ArrayList<CCEquality> eqPath;

        public EqPair(Term top, Term bot, ArrayList<CCEquality> eqPath) {
            super(top, bot);
            this.eqPath = eqPath;
        }

        @Override
        public String toString() {
            return String.format("(%s,%s)", this.top.toString(), this.bot.toString());
        }
    }

    public abstract class SubsPair {
        public final Term top;
        public final Term bot;

        public SubsPair(Term top, Term bot) {
            this.top = top;
            this.bot = bot;
        }

        public String toString() {
            return String.format("(%s,%s)", this.top.toString(), this.bot.toString());
        }
    }
}

