/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EqualityManager;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class TermTuple {
    public final int arity;
    public final Term[] terms;

    private TermTuple(Term[] terms, int arity) {
        this.terms = terms;
        this.arity = arity;
    }

    public TermTuple(Term[] arguments) {
        this(arguments, arguments.length);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof TermTuple)) {
            return false;
        }
        TermTuple other = (TermTuple)arg0;
        if (other.arity != this.arity) {
            return false;
        }
        for (int i = 0; i < this.arity; ++i) {
            if (other.terms[i].equals(this.terms[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return HashUtils.hashJenkins(31, this.terms);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        String comma = "";
        for (Term t : this.terms) {
            sb.append(comma + t.toString());
            comma = ", ";
        }
        sb.append(")");
        return sb.toString();
    }

    public TTSubstitution match(TermTuple other, EqualityManager equalityManager) {
        return this.match(other, new TTSubstitution(), equalityManager);
    }

    public TTSubstitution match(TermTuple other, TTSubstitution subs, EqualityManager equalityManager) {
        assert (this.arity == other.arity);
        TermTuple thisTT = subs.apply(new TermTuple(this.terms));
        TermTuple otherTT = subs.apply(new TermTuple(other.terms));
        TTSubstitution resultSubs = subs;
        for (int i = 0; i < this.terms.length; ++i) {
            Term thisTerm = thisTT.terms[i];
            Term otherTerm = otherTT.terms[i];
            TermVariable tvTerm = null;
            Term termTerm = null;
            if (thisTerm.equals(otherTerm)) continue;
            if (otherTerm instanceof TermVariable) {
                tvTerm = (TermVariable)otherTerm;
                termTerm = thisTerm;
            } else if (thisTerm instanceof TermVariable) {
                tvTerm = (TermVariable)thisTerm;
                termTerm = otherTerm;
            }
            if (tvTerm == null) {
                ArrayList<CCEquality> eqPath = equalityManager.isEqual((ApplicationTerm)thisTerm, (ApplicationTerm)otherTerm);
                if (eqPath == null) {
                    return null;
                }
                resultSubs.addEquality(thisTerm, otherTerm, eqPath);
                assert (false) : "TODO: rework/rethink equality handling (now that we switched to CDCL..)";
            } else {
                resultSubs.addSubs(termTerm, tvTerm);
            }
            thisTT = resultSubs.apply(thisTT);
            otherTT = resultSubs.apply(otherTT);
        }
        assert (resultSubs.apply(this).equals(resultSubs.apply(other))) : "the returned substitution should be a unifier";
        return resultSubs;
    }

    public boolean onlyContainsConstants() {
        boolean result = true;
        for (Term t : this.terms) {
            result &= t.getFreeVars().length == 0;
        }
        return result;
    }

    public TermTuple applySubstitution(Map<TermVariable, Term> sub) {
        Term[] newTerms = new Term[this.terms.length];
        for (int i = 0; i < newTerms.length; ++i) {
            newTerms[i] = this.terms[i] instanceof TermVariable && sub.containsKey(this.terms[i]) ? sub.get(this.terms[i]) : this.terms[i];
        }
        assert (this.nonNull(newTerms)) : "substitution created a null-entry";
        return new TermTuple(newTerms);
    }

    private boolean nonNull(Term[] trms) {
        for (Term t : trms) {
            if (t != null) continue;
            return false;
        }
        return true;
    }

    public HashSet<TermVariable> getFreeVars() {
        HashSet<TermVariable> result = new HashSet<TermVariable>();
        for (Term t : this.terms) {
            if (!(t instanceof TermVariable)) continue;
            result.add((TermVariable)t);
        }
        return result;
    }

    public HashSet<ApplicationTerm> getConstants() {
        HashSet<ApplicationTerm> result = new HashSet<ApplicationTerm>();
        for (Term t : this.terms) {
            if (!(t instanceof ApplicationTerm)) continue;
            result.add((ApplicationTerm)t);
        }
        return result;
    }

    public boolean isGround() {
        return this.getFreeVars().size() == 0;
    }
}

